package com.jingdong.common.utils

import com.jd.jdsdk.security.DesCbcCrypto
import com.jingdong.common.entity.DesCommonUtils
import com.jingdong.common.utils.security.JDKeyStore
import com.jingdong.common.utils.security.JDKeyStore.KEY_TYPE_3DES
import com.jingdong.jdsdk.network.toolbox.ExceptionReporter

/**
 * 我京加解密工具类
 *
 * @author wangguowei1
 * @date 2019-09-02
 */
object PersonalDesCommonUtils : DesCbcCrypto() {

    /**
     * 通用加密方法
     * @param originalValue 原始字符串
     * @param enc 加密类型
     * @return 加密结果
     */
    @JvmStatic
    fun commonEncrypt(originalValue: String, enc: Int): String? {
        return commonEncrypt(originalValue, enc, null)
    }

    /**
     * 通用加密方法
     * @param originalValue 原始字符串
     * @param enc 加密类型
     * @param secretKey 秘钥
     * @return 加密结果
     */
    @JvmStatic
    fun commonEncrypt(originalValue: String?, enc: Int, secretKey: String?): String? {
        if (originalValue.isNullOrEmpty()) {
            return null
        }
        return when (enc) {
            1 -> {
                try {
                    DesCommonUtils.encryptThreeDESECB(originalValue, getSecretKey(secretKey))
                } catch (e: Throwable) {
                    ExceptionReporter.reportExceptionToBugly(IllegalArgumentException("PersonalDesCommonUtils commonEncrypt enc:$enc error massage:$e"))
                    null
                }
            }
            2 -> {
                try {
                    encrypt(originalValue, getSecretKey(), null)
                } catch (e: Throwable) {
                    ExceptionReporter.reportExceptionToBugly(IllegalArgumentException("PersonalDesCommonUtils commonEncrypt enc:$enc error massage:$e"))
                    null
                }
            }
            else -> originalValue
        }
    }

    /**
     * 通用解密方法
     * @param originalValue 原始字符串
     * @param enc 加密类型
     * @return 解密结果
     */
    @JvmStatic
    fun commonDecrypt(originalValue: String?, enc: Int): String? {
        return commonDecrypt(originalValue, enc, null)
    }

    /**
     * 通用解密方法
     * @param originalValue 原始字符串
     * @param enc 加密类型
     * @param secretKey 秘钥
     * @return 解密结果
     */
    @JvmStatic
    fun commonDecrypt(originalValue: String?, enc: Int, secretKey: String?): String? {
        if (originalValue.isNullOrEmpty()) {
            return null
        }
        return when (enc) {
            1 -> {
                try {
                    DesCommonUtils.decryptThreeDESECB(originalValue, getSecretKey(secretKey))
                } catch (e: Throwable) {
                    ExceptionReporter.reportExceptionToBugly(IllegalArgumentException("PersonalDesCommonUtils commonDecrypt enc:$enc error massage:$e"))
                    null
                }
            }
            2 -> {
                try {
                    decrypt(originalValue, getSecretKey(), null)
                } catch (e: Throwable) {
                    ExceptionReporter.reportExceptionToBugly(IllegalArgumentException("PersonalDesCommonUtils commonDecrypt enc:$enc error massage:$e"))
                    null
                }
            }
            else -> originalValue
        }
    }

    /**
     * 新加密方法
     * @param originalValue 原始字符串
     * @return 加密结果
     */
    @JvmStatic
    fun newEncrypt(originalValue: String?): String? {
        if (originalValue.isNullOrEmpty()) {
            return null
        }
        return try {
            encrypt(originalValue, getSecretKey(), null)
        } catch (e: Throwable) {
            ExceptionReporter.reportExceptionToBugly(IllegalArgumentException("PersonalDesCommonUtils newEncrypt error massage:$e"))
            null
        }
    }

    /**
     * 新解密方法
     * @param originalValue 原始字符串
     * @return 解密结果
     */
    @JvmStatic
    fun newDecrypt(originalValue: String?): String? {
        if (originalValue.isNullOrEmpty()) {
            return null
        }
        return try {
            decrypt(originalValue, getSecretKey(), null)
        } catch (e: Throwable) {
            ExceptionReporter.reportExceptionToBugly(IllegalArgumentException("PersonalDesCommonUtils newDecrypt error massage:$e"))
            null
        }
    }

    /**
     * 获取秘钥
     */
    private fun getSecretKey(): String {
        return getSecretKey(null)
    }

    /**
     * 获取秘钥
     * @param secretKey
     */
    private fun getSecretKey(secretKey: String?): String {
        return if (secretKey.isNullOrEmpty()) JDKeyStore.getInstance().generateKey(KEY_TYPE_3DES) else secretKey!!
    }
}