package com.jingdong.common.utils.text

import android.app.Activity
import android.content.Context
import android.provider.Settings
import android.text.TextUtils
import com.jingdong.common.impl.UtilFactory
import com.jingdong.common.ui.JDDialog
import com.jingdong.common.utils.text.ScaleModeConstants.TEXT_SCALE_MODE_LARGE
import com.jingdong.sdk.lib.personal.R
import kotlinx.android.synthetic.main.dialog_text_size.*

/**
 * @author zhaoyapeng
 * @version create time:2019-11-20 19:56
 * @Email zhaoyapeng@jd.com
 * @Description ${首页字体dialog弹层}
 */
class HomeTextSizeDialog(private val mContext: Activity) {

    private var jdDialog: JDDialog? = null

    init {
        jdDialog = createDialogWithTextSize(mContext)
    }

    companion object {
        /**
         * 系统默认 字体缩放值
         * */
        private const val DEFAULT_FONT_SCALE = 1.0f

        /**
         * 首页弹层曝光
         * */
        private const val MYJD_WORD_SIZE_EXPO = "MyJD_WordSizeExpo"


        /**
         * 首页字体弹层 去开启 点击
         * */
        private const val MYJD_WORDSIZE_CHANGE = "MyJD_WordSize_Change"


        /**
         * 首页字体弹层 关闭 点击
         * */
        private const val MyJD_WordSize_Close = "MyJD_WordSize_Close"

        private const val PAGE_ID = "MyJD_Main"


        /**
         * 返回 实例
         * */
        @JvmStatic
        fun newInstance(mContext: Activity): HomeTextSizeDialog {
            return HomeTextSizeDialog(mContext)
        }
    }


    /**
     *  创建dialog
     * */
    private fun createDialogWithTextSize(mContext: Activity?): JDDialog {
        val dialog = JDDialog(mContext, R.style.style_dialog_home_text_size)
        dialog.setContentView(R.layout.dialog_text_size)
        dialog.btn_go.setOnClickListener {
            SetTextScaleModeHelper.setTextSizeScaleMode(TEXT_SCALE_MODE_LARGE)
            dialog.dismiss()
            UtilFactory.getInstance().mta?.onClickMta(mContext, MYJD_WORDSIZE_CHANGE, "", "", PAGE_ID)
        }
        dialog.img_close.setOnClickListener {
            dialog.dismiss()
            UtilFactory.getInstance().mta?.onClickMta(mContext, MyJD_WordSize_Close, "", "", PAGE_ID)
        }
        return dialog

    }


    /**
     * 展示dialog
     */

    fun show(): Boolean {
        return when (isCanShow()) {
            true -> {
                TextSizeSpreferenceUtil.putTextSizeShowed(true)
                jdDialog?.show()
                UtilFactory.getInstance().mta?.onExpoMta(mContext, MYJD_WORD_SIZE_EXPO, "", "", PAGE_ID)
                true
            }
            else -> {
                false
            }
        }
    }

    /**
     *  关闭diadlog
     * */
    fun dismiss() {
        jdDialog?.dismiss()
    }


    /**
     * 满足 应用内未设置字体大小，本地没有展示、手机设置了大字体时，显示dialog
     *
     * isLocalShowEd 是否开启过字体dialog
     *
     * isSetLager 是否设置 过 大字体模式
     */
    private fun isCanShow(): Boolean {
        var isLocalShowEd: Boolean = TextSizeSpreferenceUtil.getTextSizeShowed()

        var isSetLager: Boolean = TextUtils.equals(TEXT_SCALE_MODE_LARGE, TextScaleModeHelper.instance.getTextSizeScaleMode())
        return !isSetLager && !isLocalShowEd && getSystemScale() > DEFAULT_FONT_SCALE
    }


    /**
     * 获取系统字体scale
     * */
    private fun getSystemScale(): Float {
        if (mContext == null) {
            return -1f
        }
        var scale = -1f

        try {
            scale = Settings.System.getFloat(mContext.contentResolver, Settings.System.FONT_SCALE)
        } catch (e: Exception) {

        }

        return scale
    }
}
