package com.jingdong.common.utils.text

import com.jingdong.common.utils.CommonUtil
import com.jingdong.common.utils.text.ScaleModeConstants.TEXT_SCALE_MODE_KEY

/**
 * 设置文本缩放模式助手类
 *
 * @author wangguowei1
 * @date 2019-10-09
 */
object SetTextScaleModeHelper {

    /**
     * 设置文本缩放模式
     *
     * @param textScaleMode [com.jingdong.common.utils.text.ScaleModeConstants.TEXT_SCALE_MODE_STANDARD]
     * [com.jingdong.common.utils.text.ScaleModeConstants.TEXT_SCALE_MODE_LARGE]
     */
    @JvmStatic
    fun setTextSizeScaleMode(textScaleMode: String) {
        CommonUtil.getJdSharedPreferences().edit().putString(TEXT_SCALE_MODE_KEY, textScaleMode).apply()
        TextScaleModeHelper.instance.setLastTextScaleMode(textScaleMode)
        TextScaleModeHelper.instance.dispatchOnTextSizeChange()
    }
}