package com.jingdong.common.utils.text

import android.content.Context
import com.jingdong.common.utils.text.ScaleModeConstants.TEXT_SCALE_MODE_LARGE
import com.jingdong.common.utils.text.ScaleModeConstants.TEXT_SCALE_MODE_STANDARD
import com.jingdong.sdk.oklog.OKLog
import java.util.*

/**
 * 字号缩放助手类
 *
 * @author wangguowei1
 * @date 2019-10-14
 */

private const val TAG = "TextScaleSizeHelper"

internal object TextScaleSizeHelper {

    private val sizeMap: EnumMap<OriginalSize, List<ScaleSize>> by lazy {
        val enumMap = EnumMap<OriginalSize, List<ScaleSize>>(OriginalSize::class.java)
        enumMap[OriginalSize.PX16] = arrayListOf(ScaleSize.PX16STANDARD, ScaleSize.PX16LARGE)
        enumMap[OriginalSize.PX18] = arrayListOf(ScaleSize.PX18STANDARD, ScaleSize.PX18LARGE)
        enumMap[OriginalSize.PX20] = arrayListOf(ScaleSize.PX20STANDARD, ScaleSize.PX20LARGE)
        enumMap[OriginalSize.PX22] = arrayListOf(ScaleSize.PX22STANDARD, ScaleSize.PX22LARGE)
        enumMap[OriginalSize.PX24] = arrayListOf(ScaleSize.PX24STANDARD, ScaleSize.PX24LARGE)
        enumMap[OriginalSize.PX26] = arrayListOf(ScaleSize.PX26STANDARD, ScaleSize.PX26LARGE)
        enumMap[OriginalSize.PX28] = arrayListOf(ScaleSize.PX28STANDARD, ScaleSize.PX28LARGE)
        enumMap[OriginalSize.PX30] = arrayListOf(ScaleSize.PX30STANDARD, ScaleSize.PX30LARGE)
        enumMap[OriginalSize.PX32] = arrayListOf(ScaleSize.PX32STANDARD, ScaleSize.PX32LARGE)
        enumMap[OriginalSize.PX34] = arrayListOf(ScaleSize.PX34STANDARD, ScaleSize.PX34LARGE)
        enumMap[OriginalSize.PX36] = arrayListOf(ScaleSize.PX36STANDARD, ScaleSize.PX36LARGE)
        enumMap[OriginalSize.PX40] = arrayListOf(ScaleSize.PX40STANDARD, ScaleSize.PX40LARGE)
        enumMap[OriginalSize.PX60] = arrayListOf(ScaleSize.PX60STANDARD, ScaleSize.PX60LARGE)
        enumMap
    }

    /**
     * 获取安档位缩放所对应的字号
     *
     * @param originalSize 原始字号，单位PX
     */
    @JvmStatic
    fun dynamicFontSize(context: Context, originalSize: Float): Float {
        var scaleSize = originalSize
        sizeMap.entries.forEach { it ->
            if (OKLog.D) {
                OKLog.d(TAG, "name:${it.key.name} originalSize:${it.key.originalSize} value:${it.value}")
            }
            if (originalSize == it.key.originalSize) {
                val scaleSizeList = it.value
                scaleSizeList.forEach {
                    if (OKLog.D) {
                        OKLog.d(TAG, "scaleMode:${it.scaleMode} scaleSize:${it.scaleSize}")
                    }
                    if (it.scaleMode == TextScaleModeHelper.instance.getTextSizeScaleMode()) {
                        return it.scaleSize
                    }
                }
            }
        }
        return scaleSize
    }

    enum class OriginalSize(val originalSize: Float) {
        PX16(16.0F), PX18(18.0F), PX20(20.0F),
        PX22(22.0F), PX24(24.0F), PX26(26.0F),
        PX28(28.0F), PX30(30.0F), PX32(32.0F),
        PX34(34.0F), PX36(36.0F), PX40(40.0F),
        PX60(60.0F),
    }

    enum class ScaleSize(open val scaleMode: String, val scaleSize: Float) {
        PX16STANDARD(TEXT_SCALE_MODE_STANDARD, 16.0F),
        PX16LARGE(TEXT_SCALE_MODE_LARGE, 20.0F),
        PX18STANDARD(TEXT_SCALE_MODE_STANDARD, 18.0F),
        PX18LARGE(TEXT_SCALE_MODE_LARGE, 22.0F),
        PX20STANDARD(TEXT_SCALE_MODE_STANDARD, 20.0F),
        PX20LARGE(TEXT_SCALE_MODE_LARGE, 24.0F),
        PX22STANDARD(TEXT_SCALE_MODE_STANDARD, 22.0F),
        PX22LARGE(TEXT_SCALE_MODE_LARGE, 26.0F),
        PX24STANDARD(TEXT_SCALE_MODE_STANDARD, 24.0F),
        PX24LARGE(TEXT_SCALE_MODE_LARGE, 28.0F),
        PX26STANDARD(TEXT_SCALE_MODE_STANDARD, 26.0F),
        PX26LARGE(TEXT_SCALE_MODE_LARGE, 32.0F),
        PX28STANDARD(TEXT_SCALE_MODE_STANDARD, 28.0F),
        PX28LARGE(TEXT_SCALE_MODE_LARGE, 34.0F),
        PX30STANDARD(TEXT_SCALE_MODE_STANDARD, 30.0F),
        PX30LARGE(TEXT_SCALE_MODE_LARGE, 36.0F),
        PX32STANDARD(TEXT_SCALE_MODE_STANDARD, 32.0F),
        PX32LARGE(TEXT_SCALE_MODE_LARGE, 38.0F),
        PX34STANDARD(TEXT_SCALE_MODE_STANDARD, 34.0F),
        PX34LARGE(TEXT_SCALE_MODE_LARGE, 40.0F),
        PX36STANDARD(TEXT_SCALE_MODE_STANDARD, 36.0F),
        PX36LARGE(TEXT_SCALE_MODE_LARGE, 44.0F),
        PX40STANDARD(TEXT_SCALE_MODE_STANDARD, 40.0F),
        PX40LARGE(TEXT_SCALE_MODE_LARGE, 48.0F),
        PX60STANDARD(TEXT_SCALE_MODE_STANDARD, 60.0F),
        PX60LARGE(TEXT_SCALE_MODE_LARGE, 72.0F),
    }
}