package com.jingdong.common.utils.text

import java.util.concurrent.CopyOnWriteArrayList

/**
 * 文本字号变更观察者
 * 说明：用于注册监听，接受全局通知,此类仅在当前 module 下可见，不对外提供使用。
 *
 * @author wangguowei1
 * @date 2019-10-09
 */
 internal class TextSizeObserver {

    /**
     * 监听对象集合
     */
    private val mOnTextScaleModeChangeListeners: CopyOnWriteArrayList<OnTextScaleModeChangeListener> by lazy {
        CopyOnWriteArrayList<OnTextScaleModeChangeListener>()
    }

    /**
     * 注册指定监听器
     *
     * @param listener
     */
    fun addOnTextSizeChangeListener(listener: OnTextScaleModeChangeListener) {
        if (!mOnTextScaleModeChangeListeners.contains(listener)) {
            mOnTextScaleModeChangeListeners.add(listener)
        }
    }

    /**
     * 移除对应监听器
     *
     * @param listener
     */
    fun removeOnTextSizeChangeListener(listener: OnTextScaleModeChangeListener) {
        mOnTextScaleModeChangeListeners.remove(listener)
    }

    /**
     * 分发通知
     */
    fun dispatchOnTextSizeChange() {
        if (!mOnTextScaleModeChangeListeners.isEmpty()) {
            for (listener in mOnTextScaleModeChangeListeners) {
                listener.onTextScaleModeChanged()
            }
        }
    }
}