package com.rookiestudio.perfectviewer;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jcifs.smb.SmbFile;

import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi.DriveIdResult;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.DriveApi.MetadataBufferResult;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.rookiestudio.baseclass.*;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class TFileListGoogleDrive extends TFileList 
{
  private DriveFolder CurrentDriveFolder=null;
  private String CurrentFolderID=null;
  public TFileListGoogleDrive(Context c,int ListMode,int Sort1,int Sort2) 
  {
    super(c,ListMode,Sort1,Sort2);
  }

  @Override
  public String GetUpperFolder(String Folder)
  {
    if (Folder.endsWith("/")) {
      Folder=Folder.substring(0,Folder.length()-2);
    }
    int Posi=CurrentFolder.indexOf("|", Constant.GDRoot.length());
    if (Posi<0) {
      return Constant.GDRoot;
    } else {
      String ID=CurrentFolder.substring(Constant.GDRoot.length(), Posi);
      String ParentID=Global.GoogleServiceHandler.GetFileParent(ID);
      DriveId aID=Drive.DriveApi.fetchDriveId(TGoogleServiceHandler.MainGoogleApiClient, ID).await().getDriveId();
      CurrentDriveFolder=Drive.DriveApi.getFolder(TGoogleServiceHandler.MainGoogleApiClient,aID);
      CurrentFolderID=CurrentDriveFolder.getDriveId().encodeToString();
      Metadata aMetadata=CurrentDriveFolder.getMetadata(TGoogleServiceHandler.MainGoogleApiClient).await().getMetadata();      
      return Constant.GDRoot+CurrentFolderID+"/"+aMetadata.getTitle();
    }
  }
  
  public boolean SetFolder(String FolderName) 
  {
    if (Global.GoogleServiceHandler==null) {
      Global.GoogleServiceHandler=new TGoogleServiceHandler(context);
    }
    if ((!Global.GoogleServiceHandler.Connecting) && (!Global.GoogleServiceHandler.connected())) {
      Global.GoogleServiceHandler.ConnectGoogleService();      
    }
    while (Global.GoogleServiceHandler.Connecting) {
      try {
        Thread.sleep(100);
      } catch (InterruptedException e) {
      }
    }
    if (!Global.GoogleServiceHandler.connected()) {
      return false;
    }
    if (!FolderName.endsWith("/")) {
      CurrentFolder=FolderName+"/";
    } else {
      CurrentFolder=FolderName;
    }
    String Path="";
    int Posi=CurrentFolder.indexOf("|", Constant.GDRoot.length());
    if (Posi<0) {
      Path="/";
      CurrentDriveFolder=Drive.DriveApi.getRootFolder(TGoogleServiceHandler.MainGoogleApiClient);
      CurrentFolderID=CurrentDriveFolder.getDriveId().encodeToString();
    } else {
      String ID=CurrentFolder.substring(Constant.GDRoot.length(), Posi);
      Path=CurrentFolder.substring(Posi+1);
      DriveId aID=DriveId.decodeFromString(ID);
      CurrentDriveFolder=Drive.DriveApi.getFolder(TGoogleServiceHandler.MainGoogleApiClient,aID);
      CurrentFolderID=CurrentDriveFolder.getDriveId().encodeToString();
    }
    ArrayList<Filter> fltrs = new ArrayList<Filter>();
    fltrs.add(Filters.eq(SearchableField.TRASHED, false));
    Query qry = new Query.Builder().addFilter(Filters.and(fltrs)).build(); 
//    Drive.DriveApi.query(mGoogleApiClient, qry).setResultCallback(metadataBufferCallback); 
    MetadataBufferResult BufferResult=CurrentDriveFolder.queryChildren(TGoogleServiceHandler.MainGoogleApiClient, qry).await();
    MetadataBuffer Buffer=BufferResult.getMetadataBuffer();
    TotalSize=0;
    ListFileData.clear();
    if (Buffer.getCount()>0) {
      for (int i=0;i<Buffer.getCount();i++) {
        Metadata aFile=Buffer.get(i);
        if ((!ShowFolder) && (aFile.isFolder())) {
          continue;
        }
        TFileData NewFileData=new TFileData();
        NewFileData.FileName=aFile.getTitle();
        NewFileData.ID=aFile.getDriveId().encodeToString();
        NewFileData.FullFileName=Constant.GDRoot+NewFileData.ID+"|"+NewFileData.FileName;
        NewFileData.FolderName=Constant.GDRoot+CurrentFolderID+"|"+Path;
        NewFileData.FileSize=aFile.getFileSize();
        NewFileData.FileDate=aFile.getModifiedDate();
        NewFileData.IsFolder=aFile.isFolder();
        NewFileData.IsHidden=false;
        if ((aFile.isFolder()) || (Config.FileIsArchive(NewFileData.FullFileName)) || (Config.FileIsPDF(NewFileData.FullFileName))) {
          THistoryItem aHistoryItem=Global.HistoryManager.FindBookHistory(NewFileData.FullFileName);
          if (aHistoryItem!=null) {
            NewFileData.ReadPage=aHistoryItem.PageNo;
            NewFileData.TotalPage=aHistoryItem.TotalPage;
          }          
        }
        ListFileData.add(NewFileData);
        TotalSize+=NewFileData.FileSize;
      }
    }
    DoSort(SortType,SortDirection);
    return true;
//    RunTime=System.currentTimeMillis()-StartTime;
//    Toast.makeText(null,"SortFolderTime:"+RunTime , Toast.LENGTH_LONG).show();
  }
}
