/**
 * @WebViewJavascriptBridge JsBridge框架
 **/
(function () {
    if (window.baiduInputJSBridge) {
        return;
    }


    var messagingIframe;
    var sendMessageQueue = [];
    var receiveMessageQueue = [];
    var messageHandlers = {};

    var CUSTOM_PROTOCOL_SCHEME = 'baiduinput';
    var QUEUE_HAS_MESSAGE = '__QUEUE_MESSAGE__';

    var responseCallbacks = {};
    var uniqueId = 1;
    var url = window.location.href;
    var lastCallTime = 0;
    var stoId = null;
    var FETCH_QUEUE_INTERVAL = 30;
    function _createQueueReadyIframe(doc) {
    	messagingIframe = doc.createElement('iframe');
    	messagingIframe.style.display = 'none';
    	 setTimeout(function () {
    	 doc.documentElement.appendChild(messagingIframe)},30);

    }
    //add by hq
    function isAndroid(){
    	var ua = navigator.userAgent.toLowerCase();
    	var isA = ua.indexOf("android") > -1;
    	if (isA){
    		return true;
    	}
    	return false;
    }
    //add by hq
    function isIphone(){
    	var ua = navigator.userAgent.toLowerCase();
    	var isIph = ua.indexOf("iphone") > -1;
    	if (isIph){
    		return true;
    	}
    	return false;
    }

    	//set default messageHandler
    function init(messageHandler) {
    	if (baiduInputJSBridge._messageHandler) { throw new Error('baiduInputJSBridge.init called twice') }
    	baiduInputJSBridge._messageHandler = messageHandler;
    	var receivedMessages = receiveMessageQueue;
    	receiveMessageQueue = null;
    	for (var i=0; i<receivedMessages.length; i++) {
    		_dispatchMessageFromObjC(receivedMessages[i]);
    	}
    }

    function send(data, responseCallback) {
    	_doSend({ data:data }, responseCallback);
    }

    function registerHandler(handlerName, handler) {
    	messageHandlers[handlerName] = handler;
    }

    function on(handlerName, data, responseCallback) {
//    console.log("Js的on方法 ，",  JSON.stringify(data));
    	 var event=handlerName;
    	 var params=JSON.stringify(data);
    	 var url=window.location.href;
    	 if (url.indexOf("?")){
    		 url+="&event="+event+"&params="+params;
    	 }else{
    		 url+="?event="+event+"&params="+params;
    	 }
    	_doSend({ handlerName:handlerName, data:data }, responseCallback);
    }


    // sendMessage add message, 触发native处理  sendMessage
    function _doSend(message, responseCallback) {
    	if (responseCallback) {
    		var callbackId = 'cb_'+(uniqueId++)+'_'+new Date().getTime();
    		responseCallbacks[callbackId] = responseCallback;
    		message['callbackId'] = callbackId;
    	}
    	sendMessageQueue.push(message);
    	messagingIframe.src = CUSTOM_PROTOCOL_SCHEME + '://' + QUEUE_HAS_MESSAGE;
    }

    // 提供给native调用,该函数作用:获取sendMessageQueue返回给native,由于android不能直接获取返回的内容,所以使用url shouldOverrideUrlLoading 的方式返回内容
    function _fetchQueue() {
        if(sendMessageQueue.length == 0){
            return;
        }

        // 采用节流方案 30ms以内限制节流
        var currentTime = new Date().getTime();
        var valueTime = currentTime-lastCallTime;
//       console.log("_fetchQueue ，","与上次调用的差值" + valueTime +" : "+currentTime);

        if(valueTime < FETCH_QUEUE_INTERVAL){
            if (!stoId){
                stoId = setTimeout(_fetchQueue,FETCH_QUEUE_INTERVAL);
            }
            return ;
        }
        lastCallTime = new Date().getTime();
        stoId = null;
    	var messageQueueString = encodeURI(JSON.stringify(sendMessageQueue),"utf-8");
    	sendMessageQueue = [];

    	messagingIframe.src = CUSTOM_PROTOCOL_SCHEME + '://return/_fetchQueue/' + messageQueueString;
    }

    // 提供给native使用,
    function _dispatchMessageFromObjC(messageJSON) {
    	setTimeout(function _timeoutDispatchMessageFromObjC() {
    		var message = JSON.parse(messageJSON);
    		var messageHandler;
    		//回调
    		if (message.responseId) {
    			var responseCallback = responseCallbacks[message.responseId];
    			if (!responseCallback) { return; }
    			responseCallback(message.responseData);
    			delete responseCallbacks[message.responseId];
    		} else {
    			var responseCallback;
    			//直接发送
    			if (message.callbackId) {
    				var callbackResponseId = message.callbackId;
    				responseCallback = function(responseData) {
    					_doSend({ responseId:callbackResponseId, responseData:responseData });
    				}
    			}

    			var handler = baiduInputJSBridge._messageHandler;
    			if (message.handlerName) {
    				handler = messageHandlers[message.handlerName];
    			}
    			//查找指定handler
    			try {
    				handler(message.data, responseCallback);
    			} catch(exception) {
    				if (typeof console != 'undefined') {
    					console.log("baiduInputJSBridge: WARNING: javascript handler threw.", message, exception)
    				}
    			}
    		}
    	})
    }

    //提供给native调用,receiveMessageQueue 在会在页面加载完后赋值为null,所以
    function _handleMessageFromObjC(messageJSON) {
    	if (receiveMessageQueue) {
    		receiveMessageQueue.push(messageJSON);
    	} else {
    		_dispatchMessageFromObjC(messageJSON);
    	}
    }

    window.baiduInputJSBridge = {
    	init: init,
    	send: send,
    	registerHandler: registerHandler,
    	on: on,
    	_fetchQueue: _fetchQueue,
    	_handleMessageFromObjC: _handleMessageFromObjC
    };

    var doc = document;
    _createQueueReadyIframe(doc);
    var readyEvent = doc.createEvent('Events');
    readyEvent.initEvent('baiduInputJSBridgeReady');
    readyEvent.bridge = baiduInputJSBridge;
    doc.dispatchEvent(readyEvent);
    function connectBaiduInputJSBridge(callback) {
            if (window.baiduInputJSBridge) {
                callback(baiduInputJSBridge);
            } else {
                document.addEventListener(
                    'baiduInputJSBridgeReady'
                    , function() {
                        callback(baiduInputJSBridge);
                    },
                    false
                );
            }
        }

    connectBaiduInputJSBridge(function(bridge) {
            bridge.init()});
    })();