package com.netease.pushservice.core;
/**
 * Push service AIDL interface.
 * 
 * @author py(hzpengyang@corp.netease.com)
 * 
 */
interface IMessageService { 
   void register(String msgId, String domain, String productKey, String productVersion, in Map params);
   boolean isRegistered(String domain);
   void bindAccount(String msgId, String account, String domain, String productKey, String productVersion, String signature, String nonce, String expireTime, boolean isLogined, in Map params);
   void cancelBind(String msgId, String domain, String account);
   void reportInfo(String msgId, String domain, in Map params);
   void sendMessage(String msgId, String domain, in Map params);
   boolean isConnected();
}