(function() /** {$b5167ccadfb66ea3ba95d92d7c9946c9} */{
    WeReadBridge = function() /** {$b9c7abd4d524a31563f1f27b768c47a9} */ {
        this._sendMessageQueue = [];
        this._callback_count = 1000;
        this._callback_map = {};
        this.available_func = {};
        this._iframe = document.createElement("iframe");
        this._iframe.setAttribute("id", "iframe");
        this._iframe.setAttribute("style","position:absolute;top:0;left:0;width:1px;height:1px;visibility:hidden;");
        this._QUEUE_HAS_MESSAGE_URL = 'wereadapijs://dispatch_message/';
        document.body.appendChild(this._iframe);
 
        this._resultIframe = document.createElement("iframe");
        this._resultIframe.setAttribute("id", "_resultIframe");
        this._resultIframe.setAttribute("style","position:absolute;top:0;left:0;width:1px;height:1px;visibility:hidden;");
        this._resultIframe._SET_RESULT_URL = 'wereadapijs://private/setresult/';
        document.body.appendChild(this._resultIframe);
    }

    window.callback = {}
    function wrapCallback(name, callback) {
        window.callback[name] = callback;
        return name;
    }

    /**
     * 跳转到某个url 这里即可以是app的某个模块 也可以是外部url
     * @url qqmail://ftn?a=b&c=d 或者 http://   @return successOrNot 成功返回YES，失败返回NO,并返回error字符串。
     */
    WeReadBridge.prototype.goToUrl = function(url, successCallback, failCallback) {
        var self = this;
        var params = {"url":url};
        this._call("goToUrl",params,function(successOrNot, result) {
            var params = {"goToUrl":successOrNot};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
   }
 
    /**
     * 获取App的信息，包括version appName vid skey
     * @ver 1.1.1
     * @param successCallback(result) 从回调函数参数 result 获得App 信息： result['version'] result['appName'] result['vid'] result['skey']
     * @param failCallback(result)
     */
    WeReadBridge.prototype.getAppInfo = function(successCallback, failCallback) {
        var self = this;
        var params = {};
        this._call("getAppInfo",params,function(successOrNot, result) {
            var params = {"getAppInfo":result};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
    }

    /**
     * 显示 Web Browser 右上角的更多操作: 分享给微信朋友、分享到朋友圈、复制链接、在浏览器打开
     * @ver 1.1.1
     * @params {'shareToWechatFriend':0, 'shareToWechatTimeline':1, 'copyLink':0, 'openLinkWithBrowser':0, 'shareToWechatFriendParams':{...}, 'shareToWechatTimelineParams':{...} } 分别表示：分享给好友、分享到朋友圈、复制链接、用浏览器打开，0不显示 1显示；分享内容由shareToWechatFriendParams和shareToWechatTimelineParams 指定，格式同 shareToWechatTimeline() 
     */
    WeReadBridge.prototype.showBrowserMoreButton = function(params) {
        var self = this;
        this._call("showBrowserMoreButton",params,function(successOrNot, result) {
            var params = {"showBrowserMoreButton":result};
            self.localLog(params);
        });
    }

    /**
     * @ver 1.1.1
     * 关闭当前 Web Browser
     */
    WeReadBridge.prototype.closeBrowser = function() {
        var self = this;
        var params = {};
        this._call("closeBrowser",params,function(successOrNot, result) {
            var params = {"closeBrowser":result};
            self.localLog(params);
        });
    }

    /**
     * 调用mobileSync
     * @ver 1.1.1
     * @param successCallback(result) result={}
     * @param failCallback(result) result["error"]错误信息
     */
    WeReadBridge.prototype.mobileSync = function(successCallback, failCallback) {
        var self = this;
        var params = {};
        this._call("mobileSync", params, function(successOrNot, result) {
            var params = {"mobileSync":result};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
    }

    /**
     * refreshToken 更新 skey 并返回
     * @ver 1.1.1
     * @param successCallback(result) result["skey"] 新的 skey
     * @param failCallback(result)   result["error"]错误信息
     */
    WeReadBridge.prototype.refreshToken = function(successCallback, failCallback) {
        var self = this;
        var params = {};
        this._call("refreshToken", params, function(successOrNot, result) {
            var params = {"refreshToken":result};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
    }

    /**
     * balanceSync 同步账户余额并返回
     * @ver 1.1.1
     * @param successCallback(result) result["balance"] 账户余额
     * @param failCallback(result)   result["error"]错误信息
     */
    WeReadBridge.prototype.balanceSync = function(successCallback, failCallback) {
        var self = this;
        var params = {};
        this._call("balanceSync", params, function(successOrNot, result) {
            var params = {"balanceSync":result};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
    }
    
    /**
     * 分享到朋友
     * @ver 1.1.1
     * @params {'title':title,'imageUrl':imageUrl,'abstract':abstract,'url':url}
     * @params successCallback 成功回调
     * @params failCallback(result) 失败回调 result['error'] 1用户未安装微信
     */
    WeReadBridge.prototype.shareToWechatFriend = function(params, successCallback, failCallback)  {
        this._shareToWechat(0, params, successCallback, failCallback);
       }

    /**
     * 分享到朋友圈
     * @ver 1.1.1
     * @params {'title':title,'imageUrl':imageUrl,'abstract':abstract,'url':url}
     * @params successCallback 成功回调
     * @params failCallback(result) 失败回调 result['error'] 1用户未安装微信
     */
    WeReadBridge.prototype.shareToWechatTimeline = function(params, successCallback, failCallback)  {
        this._shareToWechat(1, params, successCallback, failCallback);
       }

    /**
     * buyBook 弹起买书页面
     * @ver 1.2
     * @param params params['bookId'] params['price']价格 params['bookTitle']书名 params['author']作者
     * @param successCallback(result) result[""]
     * @param failCallback(result)   result["error"] 0 其他错误 1 没有此书或网络连接失败 2 没有买书直接被用户关闭
     *                               result["reason"] 当result["error"] 为0时有值，返回失败的原因。
     */
    WeReadBridge.prototype.buyBook = function(params, successCallback, failCallback) {
        var self = this;
        this._call("buyBook", params, function(successOrNot, result) {
            var params = {"buyBook":result};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
    }

    /**
     * deposit 弹起充值页面
     * @ver 1.2
     * @param successCallback() 弹起充值页面并关闭后，执行成功回调
     * @param failCallback()
     */
    WeReadBridge.prototype.deposit = function(successCallback, failCallback) {
        var self = this;
        var params = {};
        this._call("deposit", params, function(successOrNot, result) {
            var params = {"deposit":result};
            self.localLog(params);
            if (successOrNot) {
                   successCallback(result);
            } else {
                   failCallback(result);
            }
        });
    }
    
    /**
     * 在发现页的WebView卡片上弹起 ActionSheet，显示按钮的参数同 showBrowserMoreButton() （没有复制链接和在浏览器打开）
     * @ver 1.2
     * @param successCallback(result) 如果用户跳转到微信，执行这个回调函数。result["WXScene"] 0分享给好友 1朋友圈
     * @param failCallback(result)   result['error'] 0其他错误 1用户未安装微信
     */
    WeReadBridge.prototype.showActionSheetAtDiscover = function(params, successCallback, failCallback) {
        var self = this;
        this._call("showActionSheetAtDiscover",params,function(successOrNot, result) {
            var params = {"showActionSheetAtDiscover":result};
            self.localLog(params);
            self._handleCallback(result, successOrNot, successCallback, failCallback);
        });
    }

    WeReadBridge.prototype._shareToWechat = function(isTimeline, params, successCallback, failCallback)  {
        var self = this;
        this._call(isTimeline ? "shareToWechatTimeline" : "shareToWechatFriend",params,function(successOrNot, result) /** {$73c8dd5b50e13e21a37e76c5c2eead04} */{
            var params = {"goToUrl":successOrNot};
            self.localLog(params);
            if (successOrNot) {
               successCallback(result);
            } else {
               failCallback(result);
            }
        });
    }
 
 
    WeReadBridge.prototype.localLog = function(params, successCallback, failCallback) /** {$9fd8e7ec1ddd8fc4d78ce18f0e1677e5} */ {
        var self = this;
        this._call("localLog",params);
    }

    /**
         * 在控制隐藏上下bar的开关
         * @ver 1.5.2
         */
        WeReadBridge.prototype.isNeedToScrollHideBars = function(isNeed, successCallback, failCallback) {
            var self = this;
            var params = {"isNeedToScrollHideBars":isNeed};
            this._call("isNeedToScrollHideBars",params,function(successOrNot, result) {
                var params = {"isNeedToScrollHideBars":result};
                self.localLog(params);
                self._handleCallback(result, successOrNot, successCallback, failCallback);
            });
        }

    WeReadBridge.prototype.fetchQueue = function() /** {$4a202e1afc4b36610e87f574e5478e15} */ {
        var messageQueueString = JSON.stringify(this._sendMessageQueue);
        this._sendMessageQueue = [];
        this._setResultValue('fetchqueue', messageQueueString);
        return messageQueueString;
    }


    WeReadBridge.prototype._setResultValue = function(scene, result) /** {$23e4b67694084da787d5fa5c739b9a66} */ {
        // Android 通过另一个iframe上传数据
        if (result === undefined) {
            result = '';
        }
        this._resultIframe.src = this._resultIframe._SET_RESULT_URL + scene + '&' + this._base64Encode(this._utf8Encode(result));
    }
     // public method for url encoding
    WeReadBridge.prototype._utf8Encode = function(str) /** {$9da9355c0a506c2d0c6dd40c35ea7fb6} */ {
        str = str.replace(/\r\n/g, "\n");
            var utftext = "";

            for (var n = 0; n < str.length; n++) {

                var c = str.charCodeAt(n);

                if (c < 128) {
                    utftext += String.fromCharCode(c);
                } else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                } else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }

            }

            return utftext;
    }  

    WeReadBridge.prototype._base64Encode = function(str) /** {$caa95e8456b5cda1716514776a0bf77a} */ {
        //base64编码
        var base64encodechars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        if (str === undefined) {
            return str;
        }
        var out, i, len;
        var c1, c2, c3;
        len = str.length;
        i = 0;
        out = "";
        while (i < len) {
            c1 = str.charCodeAt(i++) & 0xff;
            if (i == len) {
                out += base64encodechars.charAt(c1 >> 2);
                out += base64encodechars.charAt((c1 & 0x3) << 4);
                out += "==";
                break;
            }
            c2 = str.charCodeAt(i++);
            if (i == len) {
                out += base64encodechars.charAt(c1 >> 2);
                out += base64encodechars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xf0) >> 4));
                out += base64encodechars.charAt((c2 & 0xf) << 2);
                out += "=";
                break;
            }
            c3 = str.charCodeAt(i++);
            out += base64encodechars.charAt(c1 >> 2);
            out += base64encodechars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xf0) >> 4));
            out += base64encodechars.charAt(((c2 & 0xf) << 2) | ((c3 & 0xc0) >> 6));
            out += base64encodechars.charAt(c3 & 0x3f);
        }
        return out;
    }



    WeReadBridge.prototype._sendMessage = function(message) /** {$0685a6a5b33dbf2f615a5ae1faedb0c8} */ {
        this._sendMessageQueue.push(message);
        this._iframe.src = this._QUEUE_HAS_MESSAGE_URL;
    }

    WeReadBridge.prototype.handleMessage = function(message) /** {$623f3ca7480b38b659e4f32c858046f4} */ {
        var callbackId = message["callbackId"];
        if (!callbackId || typeof callbackId !== 'string') {
            return;
        }
        var successOrNot = message["successOrNot"];
        var params = message["params"];
        if (typeof this._callback_map[callbackId] === "function"){
            this._callback_map[callbackId](successOrNot,params);
            delete this._callback_map[callbackId];
        }
    }

    WeReadBridge.prototype._call = function(func, params, callback) /** {$0a78d8c17b87d24c599c91b498b8662b} */ {
        if (!func || typeof func !== "string") {
            return;
        }

        if (typeof params !== "object") {
            params = {};
        }

        var msgObj = {"func":func,"params":params};

        var callbackID = (this._callback_count++).toString();
        params["callbackId"] = callbackID;

        if (typeof callback === "function") {
            this._callback_map[callbackID] = callback;
            msgObj["callbackId"] = callbackID;
        }
        this._sendMessage(JSON.stringify(msgObj));
    }

    WeReadBridge.prototype._handleCallback = function(result, successOrNot, successCallback, failCallback) {
        // Android 返回 JSON String，在这里转JSON
        resultJSON = (typeof result == 'string') ? JSON.parse(result) : result;
        if (successOrNot) {
            successCallback(resultJSON);
        } else {
            failCallback(resultJSON);
        }
    }

    WeReadBridge.prototype.onReady = function(func) /** {$9ce323af53931aa37c8788958d68f687} */ {
        !_isReady && _bindReadyFuns.unshift([this, func]);
    }
    WeReadBridge.prototype.bindReady = function(func) /** {$d3b152348187da57f207a3a3eb27fa54} */ {
        !_isReady ? _bindReadyFuns.unshift([this, func]) : func.call(this);
    }
    WeReadBridge.prototype.isReady = function() /** {$9c23e94ea3f2aafaae1c349574569f78} */ {
        return _isReady;
    }
    WeReadBridge.prototype.isAvailable = function(apiName) /** {$67e34482192a8170c150ec414ed4ba7a} */ {
        return !!(_WeReadBridgeInfo && _WeReadBridgeInfo["apis"][apiName]);
    }
     var _isReady, _WeReadBridgeInfo, _bindReadyFuns = [],
         _onReady = function() /** {$d1b53430a7b4de2d74d12a81eec715ec} */ {
             _WeReadBridgeInfo = window["__QMB_INFO__"];
             if (_isReady) return;
             _isReady = true;
             var _funcParams;
             while (_funcParams = _bindReadyFuns.pop()) {
                 _funcParams[1].call(_funcParams[0]);
             };
         };
     window["wereadBridge"] = new WeReadBridge();
     if (window["__WRB_INFO__"]) {
         _onReady();
     } else {
         window["__WRB_INFO_CALL__"] = function() /** {$4f54cf9d496e3e999912adfb7b5d37b7} */ {
             _onReady();
         };
     }
})();

// /** 函数模板
//     * func_name description
//     * @param successCallback(result) result["param_name"]
//     * @param failCallback(result)   result["param_name"]
//     */
//     WeReadBridge.prototype.func_name = function(params, successCallback, failCallback) {
//         var self = this;
//         this._call("func_name", params, function(successOrNot, result) {
//             var params = {"func_name":result};
//             self.localLog(params);
//             if (successOrNot) {
//                    successCallback(result);
//             } else {
//                    failCallback(result);
//             }
//         });
//     }

// window.wereadBridge = new WeReadBridge();
// window.wereadBridge.goToUrl("http://wecall.qq.com/");//weread://bookDetail?opentype=0&bookId=414048");
/**
    load页面之前需要先执行以下的js
    eval('window["__QMB_INFO__"]={apis:{"a":1,"b":1},ver:"4.0.5",os:"android"};window["__QMB_INFO_CALL__"]&&window["__QMB_INFO_CALL__"]();');
*/

// window.wereadBridge.moreOperation(new Array({'shareToWechatTimeLine': {'title':'title','imageUrl':'imageUrl','abstract':'abstract','url':'url'}}));

// window.wereadBridge.shareToWechatFriend({'title':'中文','imageUrl':'imageUrl','abstract':'中文测试','url':'url'}, function(){}, function(){});
 // window.wereadBridge.shareToWechatTimeline({'title':'中文','imageUrl':'imageUrl','abstract':'中文测试','url':'url'}, function(){}, function(){});

// window.wereadBridge.getAppInfo(function(result){alert('getAppInfo: onSucc:'+JSON.stringify(result));}, function(result){alert('getAppInfo: onFailed:'+JSON.stringify(result));});

 // window.wereadBridge.closeBrowser();
 // window.wereadBridge.window.wereadBridge.mobileSync(function(error,result) {alert('error:' + error+"\n"+'result:' + result);});;
 // window.wereadBridge.window.wereadBridge.refreshToken(function(error,result) {alert('error:' + error+"\n"+'result:' + result);});;
 // window.wereadBridge.showBrowserMoreButton({'shareToWechatFriend':0, 'shareToWechatTimeline':1, 'copyLink':0, 'openLinkWithBrowser':0});
