var WRAUDIO_TEMPLATE = '<div id="wraudioid_xxx" class="audio_container">\
            <div id="wraudio_button" class="audio_button"></div>\
            <div class="audio_content">\
                <p id="wraudio_title" class="audio_title"></p>\
                <div class="audio_progress">\
                    <div class="audio_progress_bottom"></div>\
                    <div id="wraudio_progress_bar" class="audio_progress_top" style="width: 0;"></div>\
                    <div id="wraudio_progress_button" class="audio_progress_current" style="left: 0;"></div>\
                </div>\
                <div class="audio_time">\
                    <span id="wraudio_time_elapsed" class="audio_time_left"></span>\
                    <span id="wraudio_time_remains" class="audio_time_right"></span>\
                </div>\
            </div>\
        </div>';

var _Utils = function () {
    this.findChildById = function (element, childID) {
        var retElement = null;
        var lstChildren = Utils.getAllDescendant(element);

        for (var i = 0; i < lstChildren.length; i++) {
            if (lstChildren[i].id == childID) {
                retElement = lstChildren[i];
                break;
            }
        }

        return retElement;
    }

    this.getAllDescendant = function (element, lstChildrenNodes) {
        lstChildrenNodes = lstChildrenNodes ? lstChildrenNodes : [];

        var lstChildren = element.childNodes;

        for (var i = 0; i < lstChildren.length; i++)  {
            if (lstChildren[i].nodeType == 1) // 1 is 'ELEMENT_NODE'
            {
                lstChildrenNodes.push(lstChildren[i]);
                lstChildrenNodes = Utils.getAllDescendant(lstChildren[i], lstChildrenNodes);
            }
        }

        return lstChildrenNodes;
    }

    this._formatTime = function (time, quotationStyle) {
        if (time < 0) {
            return '- : -'
        }
        var hour = parseInt(time / 3600);
        var min = parseInt((time - hour * 3600) / 60);
        var sec = parseInt((time - hour * 3600 - min * 60));
        var timeText = '';
        if (hour > 0) {
            timeText += hour + ':';
        }
        if (quotationStyle) {
            if (min > 0) {
                timeText +=  min + "'";
            }
        } else {
            if (min < 10) {
                timeText += '0' + min + ':';
            } else {
                timeText += min + ':';
            }
        }
        if (quotationStyle) {
            timeText += sec + "''";
        } else {
            if (sec < 10) {
                timeText += '0' + sec;
            } else {
                timeText += sec;
            }
        }
        return timeText;
    }

    this.formatTime = function (time, remains) {
        var intTime = parseInt(time);
        var desc = this._formatTime(intTime);
        if (remains && intTime > 0) {
            return '-' + desc;
        }
        return desc;
    }
}

var Utils = new _Utils;
var player = {audio: null, current: null};

function getContentRoot() {
    return document.getElementById('editor');
}

function createWRAudio(title, src, duration) {
    var tmp = document.createElement('div');
    tmp.innerHTML = WRAUDIO_TEMPLATE;
    var wrAudio = tmp.firstChild;

    wrAudio.id = 'wraudioid_' + Date.now() + '_' + Math.floor((Math.random() * 1000) + 1);
    wrAudio.src = src;
    wrAudio.duration = duration;

    var titleEl = Utils.findChildById(wrAudio, 'wraudio_title', true);
    titleEl.innerHTML = title || '';
    var button = Utils.findChildById(wrAudio, 'wraudio_button', true);
    button.addEventListener('click', function() {
        clickPlayButton(wrAudio);
    }, false);

    var elapsedEl = Utils.findChildById(wrAudio, 'wraudio_time_elapsed', true);
    var remainsEl = Utils.findChildById(wrAudio, 'wraudio_time_remains', true);
    elapsedEl.innerHTML = Utils.formatTime(0);
    remainsEl.innerHTML = Utils.formatTime(duration, true);
    return wrAudio;
}

function resetWRAudio(wrAudio) {
    if (!wrAudio) {
        return;
    }
    var button = Utils.findChildById(wrAudio, 'wraudio_button', true);
    button.classList.remove('active');
    var elapsedEl = Utils.findChildById(wrAudio, 'wraudio_time_elapsed', true);
    var remainsEl = Utils.findChildById(wrAudio, 'wraudio_time_remains', true);
    elapsedEl.innerHTML = Utils.formatTime(0);
    remainsEl.innerHTML = Utils.formatTime(wrAudio.duration, true);

    var progressBar = Utils.findChildById(wrAudio, 'wraudio_progress_bar', true);
    var progressButton = Utils.findChildById(wrAudio, 'wraudio_progress_button', true);
    progressBar.style.width = '0';
    progressButton.style.left = '0';
}

function clickPlayButton(wrAudio) {
    if (!wrAudio) {
        return;
    }
    var src = wrAudio.src;
    if (!player.current) {
        player.current = wrAudio;
        player.audio.src = src;
        player.audio.play();
    } else if (player.current.id != wrAudio.id) {
        var last = player.current;
        player.current = wrAudio;
        resetWRAudio(last);

        player.audio.src = src;
        player.audio.play();
    } else {
        if (!player.audio.paused) {
            player.audio.pause();
        } else {
            player.audio.play();
        }
    }
}

function onPlay() {
    var button = Utils.findChildById(player.current, 'wraudio_button', true);
    button.classList.add('active');
}

function onPause() {
    var button = Utils.findChildById(player.current, 'wraudio_button', true);
    button.classList.remove('active');
}

function onEnded() {
    var button = Utils.findChildById(player.current, 'wraudio_button', true);
    button.classList.remove('active');
}

function onDurationchange() {
    player.current.duration = player.audio.duration;
}

function onTimeupdate() {
    var wrAudio = player.current;
    var elapsedEl = Utils.findChildById(wrAudio, 'wraudio_time_elapsed', true);
    var remainsEl = Utils.findChildById(wrAudio, 'wraudio_time_remains', true);
    elapsedEl.innerHTML = Utils.formatTime(player.audio.currentTime);
    remainsEl.innerHTML = Utils.formatTime(player.audio.duration - player.audio.currentTime, true);

    var progressBar = Utils.findChildById(wrAudio, 'wraudio_progress_bar', true);
    var progressButton = Utils.findChildById(wrAudio, 'wraudio_progress_button', true);
    var progress = 0;
    if (player.audio.duration > 0) {
        progress = parseInt(player.audio.currentTime / player.audio.duration * 100);
    }
    progressBar.style.width = progress + '%';
    progressButton.style.left = progress + '%';
}

function adjustMPContent() {
    var imgs =  document.querySelectorAll('img[data-src]');
    for (var i = 0; i < imgs.length ; i++) {
        var img = imgs[i];
        img.src = img.getAttribute('data-src');
        img.style = 'width: auto !important; height: auto !important; visibility: visible !important;max-width:100% !important';
    }

    var links =  document.querySelectorAll('a[href^="https://open.weixin.qq.com/connect/oauth2/authorize"],a[href^="http://open.weixin.qq.com/connect/oauth2/authorize"]');
    for (var i = 0; i < links.length ; i++) {
        var link = links[i]

        params = link.href.split('&');
            for (var j = 0;j<params.length;j++) {
                param = params[j];
                if (param.startsWith('redirect_uri=')) {
                link.href = decodeURIComponent(param.split('redirect_uri=')[1]);
            }
        }
    }


    var iframes = document.querySelectorAll('iframe[data-src]');
    for (var i = 0; i < iframes.length ; i++) {
        (function (index) {
            var iframe = iframes[index];
            var iframeWidth = document.body.offsetWidth;
            var iframeHeight = iframeWidth * 0.75;
            var src = iframe.getAttribute('data-src');
            src = src.replace(/preview.html/, 'player.html');
            src = src.replace(/&(width=.*height=.*)&/, '&width=' + iframeWidth + '&height=' + iframeHeight + '&');
            iframe.src = src;
            iframe.setAttribute('width', iframeWidth + 'px');
            iframe.setAttribute('height', iframeHeight + 'px');
            // 是否视频
            /*
            if ((' ' + iframe.className + ' ').indexOf(' video_iframe ') > -1) {
                iframe.onload = function () {
                    var styleNode = document.createElement('style');
                    styleNode.type = 'text/css';
                    styleNode.appendChild(document.createTextNode(''));
                    iframe.contentDocument.body.appendChild(styleNode);
                }
            }
            */
        })(i);
    }

    var votes = document.querySelectorAll(".vote_area");
    for (var i = 0; i < votes.length; i++) {
        var vote = votes[i];
        vote.parentElement.removeChild(vote);
    }

    var miniPrograms = document.querySelectorAll("mp-miniprogram");
    for (var i = 0; i < miniPrograms.length; i++) {
        var miniProgram = miniPrograms[i];
        var parentElement = miniProgram.parentElement;
        if (parentElement && parentElement.tagName && parentElement.tagName.toLowerCase() === 'p') {
            if (parentElement.parentElement) {
                parentElement.parentElement.removeChild(parentElement);
            }
        }
    }

    var miniAppLinks = document.querySelectorAll(".weapp_text_link, .weapp_image_link");
    for (var i = 0; i < miniAppLinks.length; i++) {
        var miniAppLink = miniAppLinks[i];
        miniAppLink.parentElement.removeChild(miniAppLink);
    }

    var needPlayer = false;
    var mpvoices =  document.querySelectorAll('mpvoice[voice_encode_fileid]');
    for (var i = 0; i < mpvoices.length ; i++) {
        var mpvoice = mpvoices[i];
        var title = mpvoice.getAttribute('name');
        var src = 'https://res.wx.qq.com/voice/getvoice?mediaid=' + mpvoice.getAttribute('voice_encode_fileid');
        var duration = mpvoice.hasAttribute('play_length') ? mpvoice.getAttribute('play_length') / 1000 : -1;
        var wrAudio = createWRAudio(title, src, duration);
        mpvoice.parentElement.appendChild(wrAudio);
        needPlayer = true;
    }

    var qqmusics =  document.querySelectorAll('qqmusic[audiourl]');
    for (var i = 0; i < qqmusics.length ; i++) {
        var qqmusic = qqmusics[i];
        var title = qqmusic.getAttribute('music_name');
        var src = qqmusic.getAttribute('audiourl');
        var duration = qqmusic.hasAttribute('play_length') ? qqmusic.getAttribute('play_length') / 1000 : -1;
        var wrAudio = createWRAudio(title, src, duration);
        qqmusic.parentElement.appendChild(wrAudio);
        needPlayer = true;
    }

    if (needPlayer) {
        var audio = document.createElement('audio');
        audio.autoplay = false;
        audio.controls = true;
        audio.style.display = "none";

        audio.addEventListener("play", onPlay, false);
        audio.addEventListener("pause", onPause, false);
        audio.addEventListener("ended", onEnded, false);
        audio.addEventListener("durationchange", onDurationchange, false);
        audio.addEventListener("timeupdate", onTimeupdate, false);

        getContentRoot().appendChild(audio);
        player.audio = audio;
    }

    // 链接的点击由app接管
    var links = document.querySelectorAll('a[href]');
    if (wereadBridge) {
        for (var i = 0; i < links.length; i++) {
            (function(link) {
                link.addEventListener('click', function(e) {
                    if (e.preventDefault) {
                        e.preventDefault();
                    } else {
                        window.event.returnValue = false;
                    }
                    wereadBridge.handleWithRichEditor("onLinkClick", {"param" : link.getAttribute('href')}, "", "");
                }, false);
            })(links[i]);
        }
    }
}

document.addEventListener('DOMContentLoaded', function() {
    adjustMPContent();
}, false);
