var wrMpVideo = {};

(function(){
    var currentPlayer = null;
    var onLoad = window.onload;
    window.onload = function(){
        if(onLoad && typeof onLoad == 'function'){
            onLoad();
        }
        var videoContainers = document.getElementsByClassName("js_tx_video_container");
        for(var i =0; i<videoContainers.length; i++){
            initVideoContainer(videoContainers[i]);
        }

//        debugger;
//        var iframes = document.getElementsByTagName("iframe");
//        for (var i = 0; i < iframes.length; i++) {
//            var ifm = iframes[i];
//            if (ifm.className.indexOf("video_iframe") != -1) {
//                var css = '.page_video .full_screen_opr .mid_play_box { display: none; }',
//                    head = document.head || document.getElementsByTagName('head')[0],
//                    style = document.createElement('style');
//                style.type = 'text/css';
//                style.appendChild(document.createTextNode(css));
//                head.appendChild(style);
//                console.log("视频 iframe", ifm);
//            }
//        }
    }

    function initVideoContainer(container){
        var player = container.playerObj
        if(!player){
            return
        }
        player.on('windowFullscreenChange', function(ev){
            if(ev){
                currentPlayer = player;
                wrMpVideo.getCurrentTime()
                wrMpVideo.getDuration()
                wrMpVideo.getPlayerState()
            }else{
                currentPlayer = null;
            }
        })


        // -1（未开始）0（已结束）1（正在播放）2（已暂停）3（正在缓冲）*/
        player.on('playStateChange', function(state){
            if(currentPlayer != null){
                var result = {
                    cmd: 'videoPlayStateChange',
                    state: state
                }
                wereadBridge.execMPReaderMethod('MPReader', result);
            }
        })

        player.on('videoEnd', function(data){
            console.log('播放已结束：'+JSON.stringify(data))
            if(currentPlayer != null){
                var result = {
                    cmd: 'videoPlayEnd'
                }
                wereadBridge.execMPReaderMethod('MPReader', result);
            }
        })
    }

    wrMpVideo.play = function(){
        currentPlayer && currentPlayer.play()
    }

    wrMpVideo.pause = function(){
        currentPlayer && currentPlayer.pause()
    }

    wrMpVideo.getPlayState = function(){
        if(!currentPlayer){
            return -1;
        }
        return currentPlayer.getPlayState()
    }

    wrMpVideo.seek = function(pos){
        return currentPlayer && currentPlayer.seek(pos)
    }

    wrMpVideo.getCurrentTime = function(){
        if(!currentPlayer){
            return;
        }
        currentPlayer.getCurrentTime().then(function(time){
            var result = {
                cmd: 'videoGetCurrentTime',
                time: time
            }
            wereadBridge.execMPReaderMethod('MPReader', result);
        })

    }

    wrMpVideo.getDuration = function(){
        if(!currentPlayer){
            return;
        }
        currentPlayer.getDuration().then(function(time){
            var result = {
                cmd: 'videoGetDuration',
                time: time
            }
            wereadBridge.execMPReaderMethod('MPReader', result);
        })
    }

    wrMpVideo.getPlayerState = function(){
        if(!currentPlayer){
            return;
        }
        currentPlayer.getPlayerState().then(function(state){

            var result = {
                cmd: 'videoPlayStateChange',
                state: state
            }
            wereadBridge.execMPReaderMethod('MPReader', result);
        })
    }

    wrMpVideo.hasPlayingMusic = function(){
        var voices = document.getElementsByClassName("share_audio_playing");
        if(voices && voices.length > 0){
            return true
        }
        voices = document.getElementsByClassName("share_audio_playing");
        return voices && voices.length > 0
    }

})();