(function () {
  var onLoad = window.onload;
  window.onload = function () {

    if (onLoad && typeof onLoad == "function") {
      onLoad();
    }

    // 填充所有 img 的 src 属性
    var images = document.getElementsByTagName("img");
    for (var i = 0; i < images.length; ++i) {
      var img = images[i];
      var src = img.src;
      if (!src || src.startsWith("data")) {
        var dataSrc = img.getAttribute("data-src");
        if (dataSrc) {
          img.src = dataSrc;
        }
      }
    }

    // 为视频设置背景图
    var iframeList = document.getElementsByClassName("video_iframe");
    for (var i = 0; i < iframeList.length; ++i) {
      var iframe = iframeList[i];
      var img = iframe.getAttribute("data-cover");
      if (img) {
        img = decodeURIComponent(img);
        if (img) {
          var parent = iframe.parentElement;
          while (window.getComputedStyle(parent).display != "block") {
            parent = parent.parentElement;
          }
          parent.style.background = "url(" + img + ")";
          parent.style.backgroundSize = "cover";
          parent.style.backgroundPosition = "50% 50%";
        }
      }
    }
  };
})();
