/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 122:
/***/ (function() {


/* eslint-disable prefer-rest-params */
/* eslint-disable no-extend-native */
if (!Array.prototype.find) {
    Array.prototype.find = function (predicate) {
        if (this == null) {
            throw new TypeError('Array.prototype.find called on null or undefined');
        }
        if (typeof predicate !== 'function') {
            throw new TypeError('predicate must be a function');
        }
        var list = Object(this);
        var length = list.length >>> 0;
        var thisArg = arguments[1];
        var value;
        for (var i = 0; i < length; i++) {
            value = list[i];
            if (predicate.call(thisArg, value, i, list)) {
                return value;
            }
        }
        return undefined;
    };
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
!function() {

;// CONCATENATED MODULE: ./src/types/base.ts
var MPSectionType;
(function (MPSectionType) {
    MPSectionType[MPSectionType["DEFAULT"] = 0] = "DEFAULT";
    MPSectionType[MPSectionType["MP_TITLE"] = 1] = "MP_TITLE";
    MPSectionType[MPSectionType["MP_META"] = 2] = "MP_META";
    MPSectionType[MPSectionType["MP_PROFILE"] = 3] = "MP_PROFILE";
    MPSectionType[MPSectionType["TEXT"] = 4] = "TEXT";
    MPSectionType[MPSectionType["IMAGE"] = 5] = "IMAGE";
    MPSectionType[MPSectionType["VIDEO"] = 6] = "VIDEO";
    MPSectionType[MPSectionType["AUDIO"] = 7] = "AUDIO";
    MPSectionType[MPSectionType["EMPTY"] = 8] = "EMPTY";
    MPSectionType[MPSectionType["MP_TAG"] = 9] = "MP_TAG";
    MPSectionType[MPSectionType["MP_ORIGINAL"] = 10] = "MP_ORIGINAL";
    MPSectionType[MPSectionType["MESSAGE"] = 11] = "MESSAGE";
})(MPSectionType || (MPSectionType = {}));

;// CONCATENATED MODULE: ./src/utils/getStyle.ts
/* harmony default export */ var getStyle = (function (element, style) {
    if (window && window.getComputedStyle) {
        return window.getComputedStyle(element, null).getPropertyValue(style);
    }
    return '';
});

;// CONCATENATED MODULE: ./src/utils/isElementHidden.ts

/* harmony default export */ var isElementHidden = (function (element) {
    var dn = getStyle(element, 'display');
    return dn === 'none';
});

;// CONCATENATED MODULE: ./src/utils/characterNeedsScoreMultiplier.ts
/**
 * 鍒ゆ柇鏄惁涓虹畝浣�/绻佷綋涓枃銆佹棩璇€侀煩璇拰闃挎媺浼杩欏嚑绉嶄簹娲叉枃瀛楋紝杩欎簺鏂囧瓧鍦ㄨ绠楁钀芥槸鍚︽湁鏁堟椂锛屾潈閲嶄細鏇撮珮锛�
 * 鍥犱负鍚屾牱鐨勫瓧绗︽暟锛屽浜庝簹娲叉枃瀛楅€氬父鑳借〃杈炬洿澶氱殑鍚箟锛屽洜姝や簹娲叉枃瀛楅渶瑕佷箻浠ユ洿楂樼殑鏉冮噸銆�
 * @param character 闇€瑕佽妫€娴嬬殑瀛楃銆�
 */
/* harmony default export */ var characterNeedsScoreMultiplier = (function (character) {
    if (!character || character.length === 0) {
        return false;
    }
    // 鑾峰彇瀛楃涓茬殑绗竴涓瓧绗︼紝杞崲涓� UTF-16锛岀粨鏋滀负瀵瑰簲鐨� 10 杩涘埗鏁板瓧
    // 鎶婁互涓嬫暟瀛楄浆鎹负瀵瑰簲鐨勬枃瀛楃殑鏂规硶锛�
    // 1. 10杩涘埗杞崲涓�16杩涘埗锛歨ttp://tool.oschina.net/hexconvert锛屽緱鍒扮殑搴旇鏄�4鎴�5浣嶇殑16杩涘埗鏁板瓧
    // 2. 16杩涘埗鏁板瓧杞崲涓� UTF-16锛岃繘鍏� http://www.qqxiuzi.cn/bianma/Unicode-UTF.php锛岄€夋嫨 UTF-16 缂栫爜锛�
    // 4 浣嶆暟鍓嶉潰鍔犱笂 FEFF 鍗冲彲杞崲锛�5浣嶆暟鍓嶉潰鍒欏姞涓� FEF 杩涜杞崲銆�
    // 渚嬪 19968 杞负16杩涘埗鏄� 4e00锛屽洜姝ゆ妸 FEFF4e00 杩涜杞崲锛屽緱鍒扮殑 UTF 瀛楃鏄眽瀛�"涓€"銆�
    var characterCode = character.charCodeAt(0);
    if (characterCode > 11904 && characterCode < 12031) {
        // 搴旇鏄眽瀛楅儴棣栵紝16杩涘埗琛ㄧず锛歕u2e80 鑷� \u9fa5
        return true;
    }
    if (characterCode > 12352 && characterCode < 12543) {
        // 鏃ヨ锛�16杩涘埗琛ㄧず锛歕u3040 鑷� \u30ff
        return true;
    }
    if (characterCode > 12736 && characterCode < 19903) {
        // 搴旇鏄眽瀛楃瑪鐢伙紝16杩涘埗琛ㄧず锛歕u31c0 鑷� \u4dbf
        return true;
    }
    if (characterCode > 19968 && characterCode < 40959) {
        // 绠€浣撲腑鏂囷紝16杩涘埗琛ㄧず锛歕u4e00锛堝搴旀眽瀛楁槸"涓€"锛夎嚦 \u9fa5锛堝搴旀眽瀛楁槸"榫�"锛�
        return true;
    }
    if (characterCode > 44032 && characterCode < 55215) {
        // 闊╄锛�16杩涘埗琛ㄧず锛歕uac00 鑷� \ud7af
        return true;
    }
    if (characterCode > 63744 && characterCode < 64255) {
        // 绠€浣撲腑鏂囷紝16杩涘埗琛ㄧず锛歕u锛堝搴旀眽瀛楁槸"铯€"锛夎嚦 \u9fa5锛堝搴旀眽瀛楁槸涓濂囨€€殑瀛楋級
        return true;
    }
    if (characterCode > 65072 && characterCode < 65103) {
        // 鍚勭绗﹀彿锛�16杩涘埗琛ㄧず锛歕ufe30 鑷� \ufe4f
        return true;
    }
    if (characterCode > 131072 && characterCode < 173791) {
        // 闃挎媺浼
        return true;
    }
    if (characterCode > 194560 && characterCode < 195103) {
        // 闃挎媺浼浉鍏崇殑绗﹀彿
        return true;
    }
    return false;
});

;// CONCATENATED MODULE: ./src/createMPSection.ts




function computedMPSectionFeature(element) {
    var featureElements = [];
    // 鍒ゆ柇鏄惁涓哄浘鐗� section
    var findImageResult = element.querySelectorAll('img');
    if (findImageResult && findImageResult.length > 0) {
        for (var i = 0; i < findImageResult.length; i++) {
            var imageElement = findImageResult[i];
            featureElements.push(imageElement);
        }
        var elements = featureElements.filter(function (image) {
            return !isElementHidden(image);
        });
        if (elements.length > 0) {
            return {
                type: MPSectionType.IMAGE,
                elements: elements
            };
        }
    }
    // 鍒ゆ柇鏄惁涓鸿棰� section
    var findVideoResult = element.querySelectorAll('video');
    if (findVideoResult && findVideoResult.length > 0) {
        for (var i = 0; i < findVideoResult.length; i++) {
            var videoElement = findVideoResult[i];
            featureElements.push(videoElement);
        }
        var elements = featureElements.filter(function (image) {
            return !isElementHidden(image);
        });
        if (elements.length > 0) {
            return {
                type: MPSectionType.VIDEO,
                elements: elements
            };
        }
    }
    // 鍒ゆ柇鏄惁涓洪煶棰� section
    var findAudioResult = element.querySelectorAll('audio');
    if (findAudioResult && findAudioResult.length > 0) {
        for (var i = 0; i < findAudioResult.length; i++) {
            var audioElement = findAudioResult[i];
            featureElements.push(audioElement);
        }
        return {
            type: MPSectionType.VIDEO,
            elements: featureElements
        };
    }
    // 鍒ゆ柇鏄惁涓哄叕浼楀彿 profile
    var findMPProfileResult = element.querySelector('mpprofile');
    if (findMPProfileResult) {
        return {
            type: MPSectionType.MP_PROFILE,
            elements: [findMPProfileResult]
        };
    }
    // 鍒ゆ柇鏄惁涓� WEUI Message
    var className = element.className;
    if (className && className.indexOf('weui-msg') !== -1) {
        return {
            type: MPSectionType.MESSAGE,
            elements: [element]
        };
    }
    // 鍒ゆ柇涓虹┖鑺傜偣
    var innerText = element.innerText;
    var childrenCount = element.children && element.children.length;
    if (/^\s+$/.test(innerText) || (innerText.trim().length === 0 && childrenCount === 0)) {
        // 鏂囧瓧鍏ㄦ槸绌哄瓧绗︼紝鎴栬€呮病鏈夋湁鏁堟枃瀛楀苟涓旀病鏈夊瓙鍏冪礌锛屽垯浠嶄负鏄┖鑺傜偣銆�
        return {
            type: MPSectionType.EMPTY,
            elements: []
        };
    }
    // 鍒ゆ柇鏄惁涓烘枃瀛�
    if (innerText.length >= 6 || (characterNeedsScoreMultiplier(innerText) && innerText.length >= 2)) {
        // 鏅€氬瓧绗﹂渶瑕佽揪鍒�6涓墠璁や负鏈夋晥锛岄伩鍏� /n/r 绛夌┖娈佃惤璇垽涓烘湁鏁堟钀�
        // 鑰屽綋娈佃惤鍐呭甫鏈変簹娲叉枃瀛楁椂锛屽垯杈惧埌涓や釜瀛楃鍗冲彲璁や负鏈夋晥銆�
        return {
            type: MPSectionType.TEXT,
            elements: [element]
        };
    }
    return {
        type: MPSectionType.DEFAULT
    };
}
/* harmony default export */ var createMPSection = (function (element, parent) {
    var feature = computedMPSectionFeature(element);
    var rect = element.getBoundingClientRect();
    var paddingTop = parseInt(getStyle(element, 'padding-top'));
    var paddingBottom = parseInt(getStyle(element, 'padding-bottom'));
    var MPSection = {
        type: feature.type,
        rect: rect,
        paddingTop: paddingTop,
        paddingBottom: paddingBottom,
        element: element
    };
    if (parent) {
        MPSection.parent = parent;
    }
    if (feature.elements && feature.elements.length > 0) {
        MPSection.featureElements = feature.elements;
    }
    return MPSection;
});

;// CONCATENATED MODULE: ./src/utils/throttle.ts
/* harmony default export */ var throttle = (function (fn, wait) {
    if (wait === void 0) { wait = 100; }
    var inThrottle, lastFn, lastTime;
    return function () {
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        var context = this;
        // eslint-disable-next-line prefer-rest-params
        var args = arguments;
        if (!inThrottle) {
            fn.apply(context, args);
            lastTime = Date.now();
            inThrottle = true;
        }
        else {
            clearTimeout(lastFn);
            lastFn = setTimeout(function () {
                if (Date.now() - lastTime >= wait) {
                    fn.apply(context, args);
                    lastTime = Date.now();
                }
            }, Math.max(wait - (Date.now() - lastTime), 0));
        }
    };
});

;// CONCATENATED MODULE: ./src/utils/getPixelLineHeight.ts

/* harmony default export */ var getPixelLineHeight = (function (element, height) {
    var computedLineHeight = getStyle(element, 'line-height');
    var parseIntComputedLineHeight = parseFloat(computedLineHeight);
    if (parseIntComputedLineHeight) {
        // 鐩存帴鑾峰彇鐨勮楂橈紝鐢变簬瀛楀瀷銆佹覆鏌撶瓑鍘熷洜锛屼細瀛樺湪涓€瀹氳宸紝鎵€浠ュ綋琛屾暟鐗瑰埆澶氱殑鏃跺€欙紝浼氬皾璇曞仛涓€涓籂姝ｃ€�
        var estimateLineCount = height / parseIntComputedLineHeight;
        if (estimateLineCount > 10) {
            // 澶т簬10琛屾椂锛屽疄闄呰楂橀€氬父闅忕潃瀹為檯琛屾暟澧炲鑰屽彉寰楄窡璁＄畻琛岄珮宸紓瓒婃潵瓒婂ぇ锛�
            // 鑰岀敱浜庡疄闄呰鏁板繀瀹氫负鏁存暟锛屾墍浠ュ洓鍐欎簲鍏ュ悗搴旇灏辨槸鐪熷疄琛屾暟锛�
            // 鐢ㄥ師鐢熼珮搴﹂櫎浠ヨ鏁板緱鍒颁竴涓洿鍑嗙‘鐨勨€滆楂樷€濄€�
            return height / Math.round(estimateLineCount);
        }
        return parseIntComputedLineHeight;
    }
    if (computedLineHeight === 'normal') {
        var fontSize = parseFloat(getStyle(element, 'font-size'));
        // 琛岄珮瀹為檯瀵规祻瑙堝櫒鏉ヨ閮芥槸鏁存暟锛屽洜姝や笅闄愬線涓婂彇鏁达紝涓婇檺寰€涓嬪彇鏁淬€�
        var start = Math.ceil(fontSize * 1.1);
        var end = Math.floor(fontSize * 1.2);
        for (var i = start; i <= end; i++) {
            if (height % i === 0) {
                return i;
            }
        }
        return start;
    }
    return 0;
});

;// CONCATENATED MODULE: ./src/utils/isElementFlex.ts

/* harmony default export */ var isElementFlex = (function (element) {
    var dn = getStyle(element, 'display');
    return dn.indexOf('flex') !== -1;
});

;// CONCATENATED MODULE: ./src/utils/isElementStyleNumberHeight.ts
/* harmony default export */ var isElementStyleNumberHeight = (function (element) {
    var elementHeight = element && element.style && element.style.height;
    return parseInt(elementHeight);
});

;// CONCATENATED MODULE: ./src/common/index.ts
var IGNORE_ELEMENT_CLASS_NAMES = [
    'share_media_text_fake'
];
var IGNORE_ELEMENT_IDS = [
    'js_text_content_fake'
];
var IGNORE_ELEMENT_TAGS = [
    'script',
    'style'
];

;// CONCATENATED MODULE: ./src/utils/isIgnoreElement.ts

/* harmony default export */ var isIgnoreElement = (function (element) {
    var className = element.className;
    if (className) {
        var classNameArr = className.split(' ');
        classNameArr.forEach(function (c) {
            if (IGNORE_ELEMENT_CLASS_NAMES.indexOf(c) !== -1) {
                return true;
            }
        });
    }
    var id = element.id;
    if (id && IGNORE_ELEMENT_IDS.indexOf(id) !== -1) {
        return true;
    }
    var tagName = element.tagName;
    if (tagName && IGNORE_ELEMENT_TAGS.indexOf(tagName.toLocaleLowerCase()) !== -1) {
        return true;
    }
    return false;
});

;// CONCATENATED MODULE: ./src/utils/canEstimateIntegerLineHeight.ts

/* harmony default export */ var canEstimateIntegerLineHeight = (function (element, height) {
    var fontSize = parseFloat(getStyle(element, 'font-size'));
    // 琛岄珮瀹為檯瀵规祻瑙堝櫒鏉ヨ閮芥槸鏁存暟锛屽洜姝や笅闄愬線涓婂彇鏁达紝涓婇檺寰€涓嬪彇鏁淬€�
    var start = Math.ceil(fontSize * 1.1);
    var end = Math.floor(fontSize * 1.2);
    for (var i = start; i <= end; i++) {
        if (height % i === 0) {
            return true;
        }
    }
    return false;
});

;// CONCATENATED MODULE: ./src/prerender.ts
/**
 * 棰勬覆鏌擄紝涓昏鏄妸鏂囩珷鍐呭奖鍝嶅垎椤佃绠楃殑涓€浜涘厓绱犲厛杩涜涓€娆￠澶勭悊锛岄伩鍏嶅奖鍝嶅垎椤靛噯纭害銆�
 */
/* harmony default export */ var prerender = (function () {
    // 1. 澶勭悊瑙嗛鍔ㄦ€佺殑鍙睍寮€鏂囧瓧锛岀洿鎺ュ睍寮€鏂囧瓧锛屽悓鏃堕殣钘忓睍寮€鎸夐挳銆�
    // 1.1 鍏堟妸鍙睍寮€鏂囧瓧杩涜灞曞紑
    if (document.querySelector) {
        var folderDefaultText = document.querySelector('.folder_text_content.default');
        if (folderDefaultText && folderDefaultText.classList) {
            folderDefaultText.classList.remove('default');
        }
    }
    // 1.2 鍐嶆妸灞曞紑鎸夐挳闅愯棌
    var expandFolderTextButton = document.getElementById('js_folder_text_switch');
    if (expandFolderTextButton) {
        expandFolderTextButton.style.display = 'none';
    }
});

// EXTERNAL MODULE: ./src/polyfills/array.find.ts
var array_find = __webpack_require__(122);
;// CONCATENATED MODULE: ./src/MPScroller.ts












var PAGE_BOTTOM_GAP = 2;
var FOOTER_BOTTOM_GAP = 20;
var MPScroller = /** @class */ (function () {
    function MPScroller() {
        this.pageWidth = 0;
        this.pageHeight = 0;
        this.headerHeight = 0;
        this.MPSections = [];
        this.MPPages = [];
        this.touchStartY = 0;
        this.currentPageIndex = 0;
        this.needsHeader = false;
        this.edgeElements = [];
        this.isSpecialPage = false;
        this.isDeletedPage = false;
    }
    MPScroller.prototype.init = function (height, headerHeight, needsHeader) {
        console.log("init scroller with header " + height + " and header height " + headerHeight);
        if (needsHeader) {
            this.needsHeader = true;
        }
        prerender();
        this.removeAllPaddingViewsIfNeed(); // 姣忔鎵ц涔嬪墠鍏堥噸缃�
        this.updatePageInfo(height, headerHeight);
        this.findSections(this.needsHeader);
        this.computePagePosition();
        this.fixedLastPageHeight();
        // this.bindEvents();
    };
    MPScroller.prototype.getMPPages = function () {
        return this.MPPages;
    };
    MPScroller.prototype.findHeaderElements = function () {
        // 瀵绘壘鏂囩珷鏍囩
        var article = document.getElementById('js_article');
        if (!article) {
            console.error('MPScroller', 'can not found js_article');
            return;
        }
        // 瀵绘壘 H1 鏍囩
        var h1s = article.getElementsByTagName('h1');
        if (!h1s || h1s.length === 0) {
            console.error('MPScroller', 'can not found h1');
            return;
        }
        var h1 = h1s[0];
        this.MPSections.push({
            type: MPSectionType.MP_TITLE,
            rect: h1.getBoundingClientRect(),
            paddingTop: parseInt(getStyle(h1, 'padding-top')),
            paddingBottom: parseInt(getStyle(h1, 'padding-bottom')),
            element: h1
        });
        // 瀵绘壘 meta锛堜綔鑰咃紝鏃堕棿锛�
        var meta = document.getElementById('meta_content');
        if (meta) {
            this.MPSections.push({
                type: MPSectionType.MP_META,
                rect: meta.getBoundingClientRect(),
                paddingTop: parseInt(getStyle(meta, 'padding-top')),
                paddingBottom: parseInt(getStyle(meta, 'padding-bottom')),
                element: meta
            });
        }
    };
    MPScroller.prototype.findTagElement = function () {
        // 瀵绘壘璇濋淇℃伅
        var tag = document.getElementById('js_tags');
        if (!tag) {
            console.log('MPScroller', 'can not found js_tags');
            return;
        }
        if (isElementHidden(tag)) {
            console.log('MPScroller', 'js_tags is hidden');
            return;
        }
        this.MPSections.push({
            type: MPSectionType.MP_TAG,
            rect: tag.getBoundingClientRect(),
            paddingTop: parseInt(getStyle(tag, 'padding-top')),
            paddingBottom: parseInt(getStyle(tag, 'padding-bottom')),
            element: tag
        });
    };
    MPScroller.prototype.findOriginalElement = function () {
        // 瀵绘壘杞浇鏉ユ簮淇℃伅
        var originals = document.getElementsByClassName('original_area_primary');
        if (!originals || originals.length === 0) {
            console.log('MPScroller', 'can not found original_area_primary');
            return;
        }
        for (var i = 0; i < originals.length; i++) {
            var original = originals[i];
            if (isElementHidden(original)) {
                console.log('MPScroller', 'original_area_primary is hidden');
                continue;
            }
            this.MPSections.push({
                type: MPSectionType.MP_ORIGINAL,
                rect: original.getBoundingClientRect(),
                paddingTop: parseInt(getStyle(original, 'padding-top')),
                paddingBottom: parseInt(getStyle(original, 'padding-bottom')),
                element: original
            });
        }
    };
    MPScroller.prototype.findDeepSections = function (section) {
        // 棰勫鐞嗭紝鏈変笖浠呮湁涓€涓瓙鍏冪礌鏃讹紝鎶婂瓙鍏冪礌褰撲綔鏄� section锛屽彲浠ユ彁楂樺潗鏍囩殑鍑嗙‘搴︺€�
        var targetSection = section;
        var isSingleChild = false;
        if (section.children && section.children.length === 1) {
            targetSection = section.children[0];
            isSingleChild = true;
        }
        // 閽堝甯歌鐨勭紪杈戝櫒杩涜浼樺寲锛屾妸瀛愬厓绱犲綋浣滄槸 section 鍔犲叆鍒� section 鍒楄〃涓€�
        var children = targetSection.children;
        var poweredBy = targetSection.getAttribute('powered-by') || section.getAttribute('powered-by');
        var dataTool = targetSection.getAttribute('data-tool') || section.getAttribute('data-tool');
        var label = targetSection.getAttribute('label') || section.getAttribute('label');
        if ((poweredBy === 'xiumi.us' ||
            (label && label.indexOf('135editor') !== -1) ||
            dataTool === 'mdnice缂栬緫鍣�') && children.length > 0) {
            for (var i = 0; i < children.length; i++) {
                var child = children[i];
                // 杩欓噷閽堝瀛愬厓绱犳湰韬張鍖呭惈杈冨瀛愬厓绱犵殑鎯呭喌杩涜澶勭悊锛�
                // 鏉′欢鍖呮嫭瀛愬厓绱犵殑瀛愬厓绱狅紝鍗冲瓩瀛愬厓绱犺3涓互涓婏紝鍙﹀鏈韩杩欎釜瀛愬厓绱犵殑鏄剧ず楂樺害瑕佽秴杩�600px锛堝ぇ姒傚畾鐨勪竴涓€硷級
                // 婊¤冻鏉′欢鐨勬儏鍐典細鎶婂瓩瀛愬厓绱犲姞鍏ュ埌 section 鍒楄〃涓€�
                var grandchildren = child.children;
                if (grandchildren && grandchildren.length >= 3 && child.offsetHeight > 600) {
                    for (var j = 0; j < grandchildren.length; j++) {
                        var grandchild = grandchildren[j];
                        if (!isIgnoreElement(grandchild)) {
                            var MPSection = createMPSection(grandchild, section);
                            this.MPSections.push(MPSection);
                        }
                    }
                }
                else if (!isIgnoreElement(child)) {
                    var MPSection = createMPSection(child, section);
                    this.MPSections.push(MPSection);
                }
            }
            return true;
        }
        if (isSingleChild && !isIgnoreElement(targetSection)) {
            var MPSection = createMPSection(section);
            var targetMPSection = createMPSection(targetSection, section);
            if (MPSection.type === MPSectionType.TEXT && MPSection.element) {
                // 鏂囧瓧绫诲瀷鐨� section锛屽鏋滆楂樹负 normal锛屽垯涓嶈兘鐩存帴鎷垮瓙鍏冪礌浣滀负 section锛�
                // 鍥犱负 normal 鐨勮绠楁柟寮忔瘮杈冪壒鍒紝鍥犳鍏堝垎鍒敤 section 鍜屽瓙鍏冪礌瀵硅楂樿繘琛屾祴绠楋紝
                // 缁撴灉鏇村噯纭殑锛屾墠鐢ㄦ潵褰撳仛鏈€鍚庣殑 section銆�
                var computedLineHeight = getStyle(MPSection.element, 'line-height');
                if (computedLineHeight === 'normal') {
                    var sectionResult = canEstimateIntegerLineHeight(MPSection.element, MPSection.rect.height);
                    var targetSectionResult = canEstimateIntegerLineHeight(targetMPSection.element, targetMPSection.rect.height);
                    if (sectionResult && !targetSectionResult) {
                        return false;
                    }
                }
            }
            if (targetMPSection.type === MPSectionType.IMAGE ||
                targetMPSection.type === MPSectionType.VIDEO ||
                targetMPSection.type === MPSectionType.AUDIO) {
                // 鍙湁澶氬獟浣撶殑锛屾墠闇€瑕佹妸瀛愬厓绱犳嫀鍑烘潵鎻掑叆锛屾枃瀛楃瓑绫诲瀷鐨勶紝闇€瑕佽€冭檻琛岄珮鍙樺寲锛�
                // 鎻掑叆瀛愬厓绱犲緢澶氭椂鍊欓兘涓嶈兘鎻愰珮鍒嗛〉鍑嗙‘搴︼紝鍙嶈€屼細褰卞搷浜嗗垎椤电殑鍑嗙‘搴︺€�
                this.MPSections.push(targetMPSection);
                return true;
            }
        }
        return false;
    };
    /**
     * BaseContainer 鎸囩殑鏄棰戝姩鎬侊紙鐩存帴鍙戠殑瑙嗛鏂囩珷锛変腑瑙嗛閮ㄥ垎杩欑被鍐呭銆�
     */
    MPScroller.prototype.findBaseContainerSections = function () {
        var baseContainer = document.getElementById('js_base_container');
        if (!baseContainer) {
            console.error('MPScroller', 'can not found base container');
            return;
        }
        if (baseContainer.offsetHeight === 0) {
            console.log('MPScroller', 'height of base container is 0');
            return;
        }
        var MPSection = createMPSection(baseContainer);
        this.MPSections.push(MPSection);
    };
    MPScroller.prototype.findContentSections = function () {
        // 瀵绘壘鏂囩珷涓讳綋锛堝井淇″畾涔夌殑涓讳綋锛�
        var content = document.getElementById('js_content');
        if (!content) {
            console.error('MPScroller', 'can not found article content');
            return;
        }
        if (content.offsetHeight === 0) {
            console.log('MPScroller', 'height of article content is 0');
            return;
        }
        // content 鍐呭彲鑳戒細鍖呭涓€灞� DOM锛屾斁缃湡姝ｇ殑鍐呭锛屽洜姝ら渶瑕佸厛鍒ゅ畾鏄惁涓鸿繖绉嶆儏鍐�
        var actualContent = content;
        var children = content.children;
        for (var i = 0; i < children.length; i++) {
            var item = children[i];
            // 鍏冪礌鐗瑰埆楂樼殑鏃跺€欙紝鎶婂垽瀹氭瘮渚嬫斁澶т竴鐐癸紝鍥犱负鍓╀笅鐨勮竟缂樺厓绱犲彲鑳藉彧鏄緟鍔╁浘鐗囨垨鑰呰棰戯紝鍗犳嵁寰堝皬楂樺害銆�
            var boundary = content.offsetHeight > 20000 ? 0.98 : 0.96;
            if (item.offsetHeight >= content.offsetHeight * boundary) {
                // 褰� content 涓殑鏌愪釜瀛愬厓绱狅紝楂樺害鍗犳嵁浜� content 95% 浠ヤ笂鐨勯珮搴︼紝
                // 鍒欒涓鸿瀛愬厓绱犺鏄湡姝ｆ斁缃唴瀹圭殑鍏冪礌锛坅ctualContent锛�
                actualContent = item;
                if (i < children.length - 1) {
                    // 濡傛灉杩樻湁鍏朵粬瀛愬厓绱狅紝鍒欐妸瀹冧滑鏀惧叆鍒� edgeElements 涓€�
                    for (var j = i + 1; j < children.length; j++) {
                        var child = children[j];
                        this.edgeElements.push(child);
                    }
                }
                break;
            }
        }
        // 鍦ㄥ唴瀹瑰厓绱犱腑锛屾壘鍑烘墍鏈変竴绾х殑 section
        var sections = actualContent.children;
        for (var i = 0; i < sections.length; i++) {
            var section = sections[i];
            if (!isIgnoreElement(section) && !this.findDeepSections(section)) {
                var MPSection = createMPSection(section);
                this.MPSections.push(MPSection);
            }
        }
        this.findEdgeElements();
    };
    MPScroller.prototype.findEdgeElements = function () {
        if (!this.edgeElements || this.edgeElements.length === 0) {
            return;
        }
        for (var i = 0; i < this.edgeElements.length; i++) {
            var section = this.edgeElements[i];
            if (!isIgnoreElement(section) && !this.findDeepSections(section)) {
                var MPSection = createMPSection(section);
                this.MPSections.push(MPSection);
            }
        }
    };
    MPScroller.prototype.findMessages = function () {
        // 妫€娴嬫槸鍚︽湁鐗瑰畾鐨� msg title
        var SPECIAL_TITLES = ['璇ュ唴瀹瑰凡琚彂甯冭€呭垹闄�'];
        // 渚嬪鏂囩珷宸茶鍒犻櫎杩欑椤甸潰锛屼細璁颁竴涓彉閲忚繑鍥炲埌澶栭潰锛岀敱浜庡仛涓€浜涙€ц兘浼樺寲锛堝彲浠ョ洿鎺ヨ烦杩囦竴浜涙楠わ級
        var messages = document.getElementsByClassName('weui-msg');
        if (messages.length > 0) {
            for (var i = 0; i < messages.length; i++) {
                var message = messages[i];
                if (message.offsetHeight > 0) {
                    var titles = message.getElementsByClassName('weui-msg__title');
                    if (titles.length > 0) {
                        var title = titles[0];
                        if (title && title.innerText && title.innerText.length > 0) {
                            if (SPECIAL_TITLES.indexOf(title.innerText) !== -1) {
                                console.log('MPScroller', 'is special page');
                                this.isSpecialPage = true;
                                this.isDeletedPage = true;
                            }
                            var MPSection = createMPSection(message);
                            this.MPSections.push(MPSection);
                        }
                    }
                }
            }
        }
    };
    MPScroller.prototype.findSections = function (needsHeader) {
        this.MPSections = [];
        this.edgeElements = [];
        this.isSpecialPage = false;
        this.isDeletedPage = false;
        if (needsHeader) {
            this.findHeaderElements();
        }
        this.findTagElement();
        this.findOriginalElement();
        this.findMessages();
        if (!this.isSpecialPage) {
            this.findBaseContainerSections();
            this.findContentSections();
        }
        console.log('all sections', this.MPSections);
    };
    /**
     * 璁＄畻灞忓箷鍙敤鐨勪綅缃€�
     */
    MPScroller.prototype.updatePageInfo = function (height, headerHeight) {
        this.pageHeight = height;
        this.pageWidth = window.innerWidth;
        this.headerHeight = headerHeight;
    };
    MPScroller.prototype.getNewPage = function () {
        return {
            width: this.pageWidth,
            height: this.pageHeight,
            sections: []
        };
    };
    MPScroller.prototype.setScreenPositionY = function (y) {
        if (typeof document.documentElement !== 'undefined' &&
            typeof document.documentElement.scrollTop !== 'undefined') {
            document.documentElement.scrollTop = y;
        }
        else if (document.body.scrollTop) {
            document.body.scrollTop = y;
        }
    };
    MPScroller.prototype.getPagePositionY = function (index) {
        var currentPosition = 0;
        for (var i = 0; i < index; i++) {
            var page = this.MPPages[i];
            currentPosition += page.height;
        }
        return currentPosition;
    };
    MPScroller.prototype.getPageHeight = function (index) {
        return this.MPPages[index].height;
    };
    /**
     * 鍚戜笅婊氬姩椤甸潰銆�
     */
    MPScroller.prototype.goNextPage = function () {
        if ((this.currentPageIndex + 1) >= this.MPPages.length) {
            console.log('宸茬粡杈惧埌鏈€鍚庝竴椤碉紝鏃犳硶寰€涓嬫粴鍔�');
            return;
        }
        var currentPagePositionY = this.getPagePositionY(this.currentPageIndex);
        var currentPageHeight = this.getPageHeight(this.currentPageIndex);
        this.setScreenPositionY(currentPagePositionY + currentPageHeight);
        this.currentPageIndex++;
    };
    /**
     * 鍚戜笂婊氬姩椤甸潰銆�
     */
    MPScroller.prototype.goPrevPage = function () {
        if (this.currentPageIndex <= 0) {
            console.log('宸茬粡杈惧埌绗竴椤碉紝鏃犳硶寰€涓婃粴鍔�');
            return;
        }
        var currentPagePositionY = this.getPagePositionY(this.currentPageIndex);
        var previousPageHeight = this.getPageHeight(this.currentPageIndex - 1);
        this.setScreenPositionY(currentPagePositionY - previousPageHeight);
        this.currentPageIndex--;
    };
    /**
     * 鍒涘缓涓€涓崰浣嶅厓绱狅紝鐢ㄤ簬濉厖椤甸潰銆�
     * @param height 鍗犱綅鍏冪礌鐨勯珮搴︺€�
     * @returns 鍗犱綅鍏冪礌銆�
     */
    MPScroller.prototype.getPaddingView = function (height) {
        var paddingView = document.createElement('div');
        paddingView.setAttribute('class', 'mp_scroller_padding_view');
        paddingView.style.height = height + 'px';
        paddingView.style.width = '100%';
        paddingView.style.fontSize = '0';
        paddingView.style.lineHeight = '0';
        paddingView.style.overflow = 'hidden'; // 鎶婂厓绱犺缃垚 BFC锛岄槻姝㈡紡鍑哄瓙鍏冪礌鎴栬€呭瓙鍏冪礌 marginTop 绌块€�
        return paddingView;
    };
    MPScroller.prototype.removeAllPaddingViewsIfNeed = function () {
        var paddingViews = document.getElementsByClassName('mp_scroller_padding_view');
        for (var i = 0; i < paddingViews.length; i++) {
            var paddingView = paddingViews[i];
            if (paddingView.parentElement) {
                paddingView.parentElement.removeChild(paddingView);
            }
        }
    };
    MPScroller.prototype.fixedFirstPageHeight = function (height) {
        if (!this.MPSections || this.MPSections.length === 0) {
            return false;
        }
        // 鎻愬墠瀵绘壘绗竴涓竴涓爮鐩紝浠庤€岀‘瀹氭彃鍏ヤ綅缃€�
        var firstSection = this.MPSections.find(function (section) {
            return section.type !== MPSectionType.MP_TITLE &&
                section.type !== MPSectionType.MP_META &&
                section.type !== MPSectionType.MP_TAG &&
                section.type !== MPSectionType.MP_ORIGINAL;
        });
        var firstElement = firstSection && firstSection.element;
        if (!firstElement || !firstElement.parentNode) {
            return false;
        }
        var parentNode = firstElement.parentNode;
        if (isElementFlex(parentNode)) {
            // flex 甯冨眬浼氬奖鍝嶆彃鍏ュ厓绱犵殑甯冨眬锛屽洜姝ゅ垽鏂鏋滄槸 flex 甯冨眬锛屽垯涓嶆彃鍏ャ€�
            return false;
        }
        var firstPagePaddingView = this.getPaddingView(height);
        firstPagePaddingView.setAttribute('id', 'mp_scroller_first_page_padding');
        firstElement.parentNode.insertBefore(firstPagePaddingView, firstElement);
        return true;
    };
    MPScroller.prototype.rerender = function () {
        this.findSections(this.needsHeader);
        this.computePagePosition();
    };
    /**
     * 璁＄畻姣忎竴灞忔粴鍔ㄧ殑浣嶇疆銆�
     */
    MPScroller.prototype.computePagePosition = function () {
        this.MPPages = [];
        var currentPage = this.getNewPage();
        var currentPageY = 0;
        var isFirstPage = true;
        var initialDifference = 0;
        var firstPagePaddingView = document.getElementById('mp_scroller_first_page_padding');
        // 璁＄畻椤甸潰鍒楄〃
        for (var sectionIndex = 0; sectionIndex < this.MPSections.length; sectionIndex++) {
            var section = this.MPSections[sectionIndex];
            var pageHeight = isFirstPage ? (this.pageHeight - this.headerHeight) : this.pageHeight;
            if (isFirstPage) {
                currentPage.height = pageHeight;
            }
            if (sectionIndex === 0) {
                var firstSectionY = section.rect.y || section.rect.top;
                if (firstSectionY < 0) {
                    initialDifference = Math.abs(firstSectionY);
                }
            }
            var height = section.rect.height;
            var y = (section.rect.y || section.rect.top) + initialDifference - currentPageY;
            var paddingTop = section.paddingTop;
            // 涓昏鍙傛暟鏃ュ織
            console.log('initialDifference, currentPageY, y, height, pageHeight, text', initialDifference, currentPageY, section.rect.y || section.rect.top, height, pageHeight, section.element.innerText.slice(0, 20));
            if ((y + height) < pageHeight) {
                // 濡傛灉褰撳墠鏍忕洰 y 鍧愭爣锛堢浉瀵瑰綋鍓嶉〉闈級鍔犱笂鑷韩楂樺害锛屽皯浜庝竴椤电殑鏍囧噯楂樺害锛屽垯鎶婂綋鍓嶆爮鐩姞鍏ュ埌鏈〉
                currentPage.sections.push(section);
                // 濡傛灉褰撳墠鏍忕洰鏄渶鍚庝竴涓爮鐩紝鍒欐妸鏂板垱寤虹殑椤甸潰楂樺害淇敼涓哄綋鍓嶅厓绱� y 鍧愭爣 + 鍏冪礌楂樺害銆�
                // 骞朵笖椹笂鍔犲叆鍒伴〉闈㈠垪琛ㄤ腑銆�
                if (sectionIndex === (this.MPSections.length - 1)) {
                    currentPage.height = Math.round(y + height);
                    this.MPPages.push(currentPage);
                }
            }
            else if ((y + height) === pageHeight) {
                // 濡傛灉褰撳墠鏍忕洰 y 鍧愭爣锛堢浉瀵瑰綋鍓嶉〉闈級鍔犱笂鑷韩楂樺害锛屽垰濂界瓑浜庝竴椤电殑鏍囧噯楂樺害锛屽垯鎶婂綋鍓嶆爮鐩姞鍏ュ埌鏈〉
                // 鏈〉鐩稿綋浜庢瀯寤哄畬鎴愶紝鍔犲叆鍒伴〉闈㈠垪琛ㄤ腑銆�
                currentPage.sections.push(section);
                this.MPPages.push(currentPage);
                // 璁板綍褰撳墠椤甸潰楂樺害锛屼互鍙婂垱寤轰竴涓柊鐨勫綋鍓嶉〉
                currentPageY += currentPage.height;
                currentPage = this.getNewPage();
            }
            else {
                // 濡傛灉褰撳墠鏍忕洰 y 鍧愭爣锛堢浉瀵瑰綋鍓嶉〉闈級鍔犱笂鑷韩楂樺害锛岃秴杩囦竴椤电殑鏍囩楂樺害锛屽垯鍏堝垽鏂爮鐩被鍨嬨€�
                if (section.type === MPSectionType.TEXT) {
                    // 鏂囧瓧绫诲瀷鐨勬爮鐩笉鑳界洿鎺ユ粴鍔ㄥ埌鏍囧噯楂樺害鐨勪綅缃紝鍙兘浼氫娇寰楁枃瀛楄灞忓箷杈圭紭鍒嗗壊銆�
                    var lineHeight = getPixelLineHeight(section.element, height);
                    // 杩欓噷鍥哄畾鍐嶅噺鍘讳竴涓珮搴� PAGE_BOTTOM_GAP锛屾槸涓轰簡閬垮厤鏂囧瓧瀹屽叏璐磋繎搴曢儴鐨勬儏鍐点€�
                    var remainingHeight = pageHeight - y - paddingTop - PAGE_BOTTOM_GAP;
                    if (remainingHeight < lineHeight) {
                        // 濡傛灉鍓╀綑鐨勭┖闂翠笉瓒充互鎽嗘斁涓€琛屾枃瀛楋紝鍒欐暣涓爮鐩殑楂樺害閮戒笉璁＄畻鍒板綋鍓嶉〉闈腑
                        if (y >= pageHeight) {
                            // 濡傛灉褰撳墠鏍忕洰 y 鍧愭爣锛堢浉瀵瑰綋鍓嶉〉闈級澶т簬绛変簬涓€椤电殑鏍囧噯楂樺害锛屽垯鐢ㄦ爣鍑嗛珮搴︿綔鏈〉闈㈤珮搴︺€�
                            currentPage.height = pageHeight;
                        }
                        else {
                            // 濡傛灉褰撳墠鏍忕洰 y 鍧愭爣锛堢浉瀵瑰綋鍓嶉〉闈級灏戜簬涓€椤电殑鏍囧噯楂樺害锛屽垯鐢� y 鍧愭爣浣滀负褰撳墠椤甸潰鐨勬渶缁堥珮搴︺€�
                            currentPage.height = Math.round(y);
                        }
                    }
                    else {
                        var targetLineCount = Math.floor(remainingHeight / lineHeight);
                        currentPage.height = Math.round(y + paddingTop + targetLineCount * lineHeight);
                    }
                }
                // 鍏朵粬绫诲瀷鐨勬爮鐩鏍规嵁鏍忕洰鐨勯珮搴﹀鐞�
                // 棣栧厛鎶婂綋鍓嶆爮鐩姞鍏ュ埌褰撳墠椤甸潰锛岀劧鍚庢妸褰撳墠椤甸潰鍔犲叆鍒伴〉闈㈠垪琛ㄣ€�
                currentPage.sections.push(section);
                this.MPPages.push(currentPage);
                // 璁板綍褰撳墠椤甸潰楂樺害
                currentPageY += currentPage.height;
                if (isFirstPage && section.type === MPSectionType.TEXT && !firstPagePaddingView) {
                    // 绗竴涓〉闈㈤渶瑕佸～鍏呭ソ瀹屾暣鐨勯〉闈㈤珮搴︼紝淇濊瘉绗竴灞忔病鏈夋枃瀛楁埅鏂紝
                    var firstPageRemainingHeight = pageHeight - PAGE_BOTTOM_GAP - currentPage.height;
                    var isFixed = this.fixedFirstPageHeight(firstPageRemainingHeight);
                    if (isFixed) {
                        return this.rerender();
                    }
                }
                // 褰撳墠椤甸潰楂樺害涓嶅簲璇ヨ秴杩囦竴椤电殑鏍囧噯楂樺害锛屽鏋滆秴杩囷紝鍒欐棩蹇楀憡璀︺€�
                if (currentPage.height > this.pageHeight) {
                    console.warn("page height " + currentPage.height + " is more than standard page height " + this.pageHeight, section);
                }
                // 璁＄畻褰撳墠鏍忕洰宸插崰鐢ㄧ殑楂樺害锛屾敞鎰忓綋鏍忕洰 y 鍧愭爣姣斿綋鍓嶉〉闈㈤珮搴﹀ぇ鏃讹紝
                // 杩欎釜鍊间細鏄礋鏁帮紝鐩稿綋浜庡綋鍓嶆爮鐩苟娌℃湁琚崰鐢ㄩ珮搴︼紝鍙嶈€岃琛ヤ笂涓€浜涢珮搴︿互瀵归綈璺濈锛�
                // 杩欎釜鏃跺€欏鏋滃綋鍓嶆爮鐩悓鏃舵槸鏂囧瓧鏍忕洰锛屽垯璁＄畻绌洪〉闈㈤珮搴︽椂锛岄渶瑕佸厛瀵硅繖涓€滆礋鏁扳€濅綔澶勭悊锛�
                // 鍥犱负鏂囧瓧鏍忕洰闇€瑕佹寜琛岄珮鐨勬暣鏁板€嶈绠楃┖椤甸潰楂樺害锛岃€岃礋鏁扮殑琛ラ珮搴︿細瀵艰嚧鏂囧瓧鏍忕洰鐨勮鏁拌绠椾笉鍑嗙‘銆�
                var existingHeight = currentPage.height - y;
                var remainingSectionHeight = height - existingHeight;
                if (remainingSectionHeight >= this.pageHeight) {
                    // 濡傛灉鏍忕洰楂樺害鍑忓幓褰撳墠椤甸潰鍓╀綑鐨勯珮搴﹀悗锛屼粛鐒跺ぇ浜庣瓑浜庝竴涓爣鍑嗛〉闈㈤珮搴︼紝鍒欏厛缁欓〉闈㈠垪琛ㄥ～鍏呯浉搴旀暟閲忕殑绌烘爣鍑嗛〉闈紝
                    // 鍙栨暣鏁伴〉闈㈠悗锛屽鏋滄湁鍓╀綑鐨勬爮鐩珮搴︼紝涓嶇敤鍋氶澶栧鐞嗭紝鍥犱负涓嬫璁＄畻椤甸潰楂樺害鏄粠涓嬩釜鍏冪礌鐨� y 鍧愭爣绠楄捣锛屽洜姝ゅ墿浣欑殑鏍忕洰楂樺害涓嶄細閬楁紡銆�
                    // 灏戜簬涓€涓爣鍑嗛〉闈㈤珮搴︼紝鐩存帴鎸夋爣鍑嗛珮搴﹀鐞嗭紝鍥犳鏃犻渶棰濆鐨勫鐞�
                    // 闇€瑕佹敞鎰忕殑鏄紝鏂囧瓧绫诲瀷鐨勬爮鐩紝鍦ㄤ骇鐢熺┖椤甸潰鏃讹紝涓嶈兘鐩存帴浣跨敤鏍囧噯楂樺害锛岃繖鍙兘浼氬鑷存枃瀛楄瑁併€�
                    var emptyPageHeight = this.pageHeight;
                    if (section.type === MPSectionType.TEXT) {
                        var lineHeight = getPixelLineHeight(section.element, height);
                        var targetLineCount = Math.floor((pageHeight - PAGE_BOTTOM_GAP) / lineHeight);
                        emptyPageHeight = Math.round(targetLineCount * lineHeight);
                        console.log('empty page height is', emptyPageHeight);
                        // 鏈夆€滆ˉ楂樷€濇椂锛岄渶瑕佽绠椾竴涓熀浜庘€滆ˉ楂樷€濈殑绌洪〉闈紝
                        // 鍚屾椂鎶婂墿浣欓珮搴﹀噺鍘昏繖涓熀浜庘€滆ˉ楂樷€濈殑绌洪〉闈㈢殑楂樺害锛屽啀璁＄畻甯歌鐨勭┖鐣岄潰楂樺害銆�
                        if (existingHeight < 0) {
                            console.log('existing height is less than 0', existingHeight);
                            var firstEmptyPageTargetLineCount = Math.floor((pageHeight - PAGE_BOTTOM_GAP - Math.abs(existingHeight)) / lineHeight);
                            var firstEmptyPageHeight = Math.round(Math.abs(existingHeight) + firstEmptyPageTargetLineCount * lineHeight);
                            var page = this.getNewPage();
                            page.height = firstEmptyPageHeight;
                            currentPageY += page.height;
                            this.MPPages.push(page);
                            remainingSectionHeight -= firstEmptyPageHeight;
                        }
                    }
                    var pageCount = Math.floor(remainingSectionHeight / emptyPageHeight);
                    for (var i = 0; i < pageCount; i++) {
                        var page = this.getNewPage();
                        page.isEmptyPage = true;
                        page.height = emptyPageHeight;
                        currentPageY += page.height;
                        this.MPPages.push(page);
                        remainingSectionHeight -= emptyPageHeight;
                    }
                }
                // 鍒涘缓鏂扮殑褰撳墠椤�
                currentPage = this.getNewPage();
                isFirstPage = false;
                // 濡傛灉褰撳墠鏍忕洰鏄渶鍚庝竴涓爮鐩紝鍒欐妸鏂板垱寤虹殑椤甸潰楂樺害淇敼涓哄厓绱犲墿浣欑殑楂樺害锛�
                // 骞朵笖椹笂鍔犲叆鍒伴〉闈㈠垪琛ㄤ腑銆�
                if (sectionIndex === (this.MPSections.length - 1)) {
                    currentPage.height = Math.round(remainingSectionHeight);
                    this.MPPages.push(currentPage);
                }
            }
        }
        console.log('pages', this.MPPages);
        // 璁＄畻椤甸潰鍒楄〃瀹屾垚鍚庯紝鎶婂叏灞€鐨勫綋鍓嶉〉閲嶇疆涓虹涓€椤点€�
        this.currentPageIndex = 0;
    };
    MPScroller.isLargeDevice = function () {
        return window && window.innerWidth >= 702;
    };
    /**
     * 鍒ゆ柇璁＄畻鍑虹殑鍒嗛〉楂樺害涔嬪拰璺熼〉闈㈠疄闄呴珮搴︾殑宸€笺€�
     */
    MPScroller.prototype.getComputedPageMarginOfError = function () {
        if (!this.MPPages || this.MPPages.length === 0 || !document || !document.body) {
            return 0;
        }
        var height = this.MPPages.reduce(function (acc, page) { return acc + page.height; }, 0);
        var bodyHeight = document.body.offsetHeight;
        console.log('computed all pages height is', height);
        console.log('body height is', bodyHeight);
        if (bodyHeight > height) {
            return bodyHeight - height;
        }
        return 0;
    };
    /**
     * 涓轰簡閬垮厤鏈€鍚庝竴涓〉闈㈠お鐭紝瀵艰嚧涓婁竴椤甸噸澶嶈繃澶氾紝闇€瑕佹妸鏈€鍚庝竴椤典慨姝ｄ负鏍囧噯椤甸潰楂樺害銆�
     * 棣栧厛鏍规嵁鏈€鍚庝竴椤垫湰韬殑楂樺害锛岃绠楅渶瑕佸灏戠┖鐧芥墠杈惧埌涓€涓爣鍑嗛〉闈㈤珮搴︼紝
     * 鐒跺悗鍒涘缓涓€涓浉搴旂殑绌哄厓绱犳彃鍏ュ埌椤甸潰涓紝浠ヤ繚璇侀〉闈㈢殑楂樺害涓庢爣鍑嗛〉闈㈤珮搴︾浉鍚屻€�
     */
    MPScroller.prototype.fixedLastPageHeight = function () {
        var lastPage = this.MPPages[this.MPPages.length - 1];
        if (lastPage.height < this.pageHeight) {
            // 鎻愬墠瀵绘壘鏈€鍚庝竴涓爮鐩紝浠庤€岀‘瀹氭彃鍏ヤ綅缃€�
            var lastSection = this.MPSections[this.MPSections.length - 1];
            if (!lastSection) {
                return;
            }
            var marginOfError = this.getComputedPageMarginOfError();
            // 鍒涘缓涓€涓┖鍏冪礌锛屽苟涓旀彃鍏ュ埌鏈€鍚庝竴椤电殑鏈€鍚庛€�
            // 杩欓噷鍔犱竴涓緝澶х殑绌洪殭锛屾槸涓轰簡閬垮厤鍑虹幇搴曢儴鍏冪礌鍥犱负 margin-bottom 绛夊師鍥狅紝
            // 澶氫簡涓€浜涚┖鐧斤紝浠庤€屽鑷存粴鍔ㄥ埌搴曢儴鍚庤繕鍙互缁х画婊氬姩鍒颁竴椤点€�
            var remainingHeight = Math.max(this.pageHeight - 20 - marginOfError - lastPage.height, 0);
            var paddingView = this.getPaddingView(remainingHeight);
            // 鎶婇〉闈㈠垪琛ㄧ殑鏈€鍚庝竴椤典慨鏀逛负鏍囧噯椤甸潰楂樺害銆�
            lastPage.height = this.pageHeight;
            // 鍏冪礌鍏堟彃鍏ュ埌 fragment 涓紝鍐嶆彃鍏ュ埌鏈€鍚庝竴椤典腑銆�
            var fragment = document.createDocumentFragment();
            fragment.appendChild(paddingView);
            // fragment 鎻掑叆鍒伴〉闈腑銆�
            var content = document.getElementById('js_content');
            var baseContainer = document.getElementById('js_base_container');
            var parentNode = lastSection.element && lastSection.element.parentNode;
            if (lastSection.parent && !isElementFlex(lastSection.parent) && !isElementStyleNumberHeight(lastSection.parent)) {
                // flex 甯冨眬浼氬奖鍝嶆彃鍏ュ厓绱犵殑甯冨眬锛屽洜姝ゅ垽鏂鏋滄槸 flex 甯冨眬锛屽垯涓嶆彃鍏ャ€�
                // 鍙﹀濡傛灉鏄甫鏈夐珮搴︼紝涔熶笉鎻掑叆锛屽洜涓洪珮搴﹀彲鑳戒細褰卞搷鎻掑叆鍏冪礌鐨勫睍绀恒€�
                lastSection.parent.appendChild(fragment);
            }
            else if (parentNode && !isElementFlex(parentNode) && !isElementStyleNumberHeight(parentNode)) {
                parentNode.insertBefore(fragment, lastSection.element.nextSibling);
            }
            else if (content && content.offsetHeight > 0) {
                // 濡傛灉鑳芥壘鍒� js_content锛屽苟涓旈珮搴﹀ぇ浜� 0锛屽垯鎻掑叆鍒� js_content 涓紝杩欐槸鏂囩珷鍐呭鐨勪富浣撹妭鐐广€�
                content.appendChild(fragment);
            }
            else if (baseContainer && baseContainer.offsetHeight > 0) {
                // 濡傛灉鑳芥壘鍒� js_base_container锛屽苟涓旈珮搴﹀ぇ浜� 0锛�
                // 鍒欐彃鍏ュ埌 js_base_container 涓紝杩欐槸瑙嗛鍔ㄦ€佺瓑鍩虹鍐呭鐨勪富浣撹妭鐐广€�
                baseContainer.appendChild(fragment);
            }
        }
    };
    MPScroller.prototype.getExitButtonRect = function () {
        var exitButton = document.getElementById('mp_scroller_exit_button');
        if (exitButton) {
            var rect = exitButton.getBoundingClientRect();
            var y = rect.y || rect.top;
            var x = rect.x || rect.left;
            if (y > 0 && y < this.pageHeight) {
                return {
                    x: x,
                    y: y,
                    width: rect.width,
                    height: rect.height
                };
            }
        }
        return {
            x: 0,
            y: 0,
            width: 0,
            height: 0
        };
    };
    ;
    MPScroller.prototype.bindEvents = function () {
        var _this = this;
        window.addEventListener('touchstart', function (event) {
            _this.touchStartY = event.touches[0].pageY;
            console.log('MPScroller touchstart');
        });
        window.addEventListener('touchmove', function (event) {
            console.log('MPScroller touchmove');
            event.preventDefault();
        }, {
            passive: false
        });
        window.addEventListener('touchend', throttle(function (event) {
            console.log('MPScroller touchend');
            var touchEndY = event.changedTouches[0].pageY;
            if (touchEndY - _this.touchStartY < 0) { // 鍚戜笂婊戝姩, 椤甸潰鍚戜笅婊氬姩
                _this.goNextPage();
            }
            else {
                _this.goPrevPage();
            }
        }, 300));
        // const scrollMove = (event: WheelEvent) => {
        //     if (event.deltaY > 0) {
        //         this.goNextPage();
        //     } else {
        //         this.goPrevPage();
        //     }
        //     return false;
        // }
        // const handlerWheel = throttle(scrollMove, 1000)
        // // https://developer.mozilla.org/en-US/docs/Web/API/Element/mousewheel_event#The_detail_property
        // // firefox鐨勯〉闈㈡粴鍔ㄤ簨浠跺叾浠栨祻瑙堝櫒涓嶄竴鏍�
        // if (window.navigator.userAgent.toLowerCase().indexOf('firefox') === -1) {
        //     document.addEventListener('mousewheel', handlerWheel)
        // } else {
        //     document.addEventListener('DOMMouseScroll', handlerWheel)
        // }
    };
    MPScroller.prototype.showDebugInfo = function () {
        if (!this.MPPages || this.MPPages.length === 0) {
            return;
        }
        this.removeDebugWrapperIfNeed();
        // 鍒涘缓 debug 淇℃伅鐨勫灞� DOM
        var debugWrapper = document.createElement('div');
        debugWrapper.setAttribute('class', 'mp_scoller_debug_wrapper');
        debugWrapper.style.position = 'absolute';
        debugWrapper.style.top = '0';
        debugWrapper.style.left = '0';
        this.MPPages.forEach(function (MPPage, index) {
            var page = document.createElement('div');
            page.style.height = MPPage.height + 'px';
            page.style.width = MPPage.width + 'px';
            if (index % 2 === 0) {
                page.style.backgroundColor = 'rgba(255, 0, 0, .4)';
            }
            else {
                page.style.backgroundColor = 'rgba(60, 155, 255, .4)';
            }
            var pageInfo = document.createElement('div');
            pageInfo.style.fontSize = '10px';
            pageInfo.style.lineHeight = '14px';
            pageInfo.style.padding = '10px';
            var pageIndex = document.createElement('div');
            pageIndex.innerText = "page: " + (index + 1);
            pageInfo.appendChild(pageIndex);
            var pageHeight = document.createElement('div');
            pageHeight.innerText = "height: " + MPPage.height;
            pageInfo.appendChild(pageHeight);
            if (MPPage.isEmptyPage) {
                var pageEmpty = document.createElement('div');
                pageEmpty.innerText = 'type: empty';
                pageInfo.appendChild(pageEmpty);
            }
            page.appendChild(pageInfo);
            debugWrapper.appendChild(page);
        });
        document.body.appendChild(debugWrapper);
    };
    MPScroller.prototype.removeDebugWrapperIfNeed = function () {
        var debugWrappers = document.querySelectorAll('.mp_scoller_debug_wrapper');
        if (debugWrappers.length > 0) {
            for (var i = 0; i < debugWrappers.length; i++) {
                document.body.removeChild(debugWrappers[i]);
            }
        }
    };
    return MPScroller;
}());
// 鍒涘缓骞舵墽琛屽垵濮嬪寲
var scroller = new MPScroller();
var setMPScroller = function (webViewHeight, headerHeight) {
    console.log('support base container, fully es5 bundle, polyfill Array.prototype.find, double check attribute, double check children element');
    console.log('code finish time is 1645191195507');
    console.log("call window.setMPScroller with " + webViewHeight + " and " + headerHeight);
    var foramttedHeaderHeight = Math.floor(headerHeight);
    scroller.init(webViewHeight, foramttedHeaderHeight);
    return scroller.getMPPages();
};
var getMPPages = function () {
    return scroller.getMPPages();
};
var showDebugInfo = function () {
    scroller.showDebugInfo();
};
var removeDebugWrapperIfNeed = function () {
    scroller.removeDebugWrapperIfNeed();
};
var getExitButtonRect = function () {
    return scroller.getExitButtonRect();
};
window.setMPScroller = setMPScroller;
window.getMPPages = getMPPages;
window.showDebugInfo = showDebugInfo;
window.removeDebugWrapperIfNeed = removeDebugWrapperIfNeed;
window.getExitButtonRect = getExitButtonRect;

}();
/******/ })()
;