-- Generated by https://github.com/ezdiy/unimap/blob/master/gen.lua
-- Each row is a sequence of {delta,count} pairs, where
--   * `delta` denotes start of next range since the end of the previous one
--   * `count` is number of glyphs in range
-- For instance set of ranges:
-- 0041..005A, 0061..007A, 00AA, 00BA ...
-- Becomes:
-- 65,26, 8,26, 49,1 17,1 ...
return {
    -- Table of ranges for entire scripts, ordered by UCDN_SCRIPT_* macros, starting with UCDN_SCRIPT_COMMON
    -- Source data is https://www.unicode.org/Public/5.2.0/ucd/Scripts.txt
    -- UCDN is internally used to map character classes (and detect scripts) both by harfbuzz and mupdf
    scripts = {
        {0,65,28,6,28,47,3,15,3,5,25,1,33,1,451,39,7,27,118,1,11,1,8,1,3,1,515,1,120,4,10,1,16,1,5,1,34,1,33,10,117,1,648,2,12,1,898,2,334,1,407,4,292,1,1521,3,73,2,205,2,3,1,1231,1,15,1,9,4,3,5,783,12,4,87,7,7,5,11,3,15,19,25,73,38,3,3,4,6,3,27,3,17,43,1,8,601,25,39,27,11,23,622,3,19,3,1,6,24,3,4,3,4,4,28,3,35,3,1,3,4,5,9,4,52,5,24,3,14,3,11,3,1,5,48,258,589,5,10,680,50,448,12,6,5,3,1,3,25,17,8,6,4,93,2,5,1,92,2,149,16,34,36,62,64,33,81,138,168,6594,64,22786,34,104,3,167,10,21766,2,191,1,20,10,24,35,3,19,3,4,149,1,3,32,28,6,28,11,12,1,47,2,66,7,3,7,12,5,260,3,6,45,5,9,82,12,54,45,52741,246,12,39,4,62,5,17,10,2,9,30,6,48,292,87,11,18,144,85,3,71,3,2,4,1,4,2,4,4,3,12,3,1,3,7,3,65,3,4,4,8,3,7,3,28,3,4,3,5,3,1,5,7,3,340,4,292,4,50,6146,44,6,100,110,11,7,31,4,1,13,1,3,1,4,1,5,1,5,5,10,1,9,1,27,1,3,2,4,1,12,4,4,1,129,34,16,9,789946,1,32,96},
        {65,26,8,26,49,1,17,1,7,23,3,31,3,449,41,5,6685,38,8,49,7,4,7,13,3,70,67,256,371,1,15,1,18,5,151,2,8,1,29,1,19,41,2777,32,31396,102,5,2,112,5,21250,7,1052,26,8,26},
        {880,4,3,3,4,4,8,1,3,1,3,3,3,1,3,20,3,63,16,16,6440,5,52,5,6,5,86,1,322,22,4,6,4,38,4,6,4,8,3,1,3,1,3,1,3,31,4,53,3,15,3,14,4,6,3,19,4,3,3,9,297,1,57371,75,53367,70},
        {1024,133,4,159,6151,1,78,1,4201,32,30786,32,4,18,10,28},
        {1329,38,4,7,3,39,4,1,62858,5},
        {1425,55,10,27,7,5,62762,26,3,5,3,1,3,2,3,2,3,10},
        {1542,6,3,14,5,1,4,31,3,10,13,9,13,6,3,108,3,34,82,48,62418,98,35,363,20,64,4,54,42,13,117,5,3,135,3941,31},
        {1792,14,3,60,4,3},
        {1920,50},
        {2304,58,4,19,3,1,4,3,4,12,4,10,3,2,8,7,40802,28},
        {2433,3,3,8,4,2,4,22,3,7,3,1,5,4,4,9,4,2,4,4,10,1,6,2,3,5,4,22},
        {2561,3,3,6,6,2,4,22,3,7,3,2,3,2,3,2,4,1,3,5,6,2,4,3,5,1,9,4,3,1,9,16},
        {2689,3,3,9,3,3,3,22,3,7,3,2,3,5,4,10,3,3,3,3,4,1,17,4,4,10,3,1},
        {2817,3,3,8,4,2,4,22,3,7,3,2,3,5,4,9,4,2,4,3,10,2,6,2,3,5,4,12},
        {2946,2,3,6,5,3,3,4,5,2,3,1,3,2,5,2,5,3,5,12,6,5,5,3,3,4,4,1,8,1,16,21},
        {3073,3,3,8,3,3,3,23,3,10,3,5,5,8,3,3,3,4,9,2,3,2,8,4,4,10,10,8},
        {3202,2,3,8,3,3,3,23,3,10,3,5,4,9,3,3,3,4,9,2,9,1,3,4,4,10},
        {3330,2,3,8,3,3,3,23,3,16,5,8,3,3,3,4,11,1,10,4,4,16,5,7},
        {3458,2,3,18,5,24,3,9,3,1,4,7,5,1,6,6,3,1,3,8,20,3},
        {3585,58,7,28},
        {3713,2,3,1,4,2,3,1,4,1,8,4,3,7,3,3,3,1,3,1,4,2,3,13,3,3,4,5,3,1,3,6,4,10,4,2},
        {3840,72,3,36,6,27,6,8,3,36,3,15,3,7},
        {4096,160,39362,28},
        {4256,38,12,43,3,1,7173,38},
        {4352,256,7987,94,115,31,67,31,30435,29,645,11172,14,23,6,49,10150,31,5,6,4,6,4,6,4,3},
        {4608,73,3,4,4,7,3,1,3,4,4,41,3,4,4,33,3,4,4,7,3,1,3,4,4,15,3,57,3,4,4,67,6,30,5,26,6632,23,11,7,3,7,3,7,3,7,3,7,3,7,3,7,3,7},
        {5024,85},
        {5120,640,562,70},
        {5760,29},
        {5792,75,5,3},
        {6016,94,4,10,8,10,488,32},
        {6144,2,4,1,3,9,3,10,8,88,10,43},
        {12353,86,8,3,115042,1},
        {12449,90,4,3,242,16,210,47,3,88,52240,10,3,45},
        {12549,41,116,24},
        {11904,26,3,89,14,214,49,1,3,1,27,9,16,4,966,6582,76,20940,22838,302,4,62,4,106,66856,42711,43,4149,16589,542},
        {40960,1165,5,55},
        {66304,31,3,4},
        {66352,27},
        {66560,80},
        {768,112,279,2,454,11,28,1,738,2,4991,3,3,13,3,7,6,1,212,39,24,3,526,2,196,33,3899,6,107,2,52583,16,18,7,984,1,53099,3,19,8,4,7,32,4,798548,240},
        {5888,13,3,7},
        {5920,21},
        {5952,20},
        {5984,13,3,3,3,2},
        {6400,29,5,12,6,12,6,1,5,12},
        {6480,30,4,5},
        {65536,12,3,26,3,19,3,2,3,15,4,14,36,123},
        {66432,30,3,1},
        {66640,48},
        {66688,30,4,10},
        {67584,6,4,1,3,44,3,2,5,1,4,1},
        {10240,256},
        {6656,28,4,2},
        {994,14,10386,114,9,7},
        {6528,44,6,26,8,11,5,2},
        {11264,47,3,47},
        {11568,54,11,1},
        {43008,44},
        {66464,36,6,14},
        {68096,4,3,2,7,8,3,3,3,27,6,3,6,9,10,9},
        {6912,76,6,45},
        {73728,879,147,99,15,4},
        {67840,28,5,1},
        {43072,56},
        {1984,59},
        {7040,43,5,12},
        {7168,56,5,15,5,3},
        {7248,48},
        {42240,300},
        {43136,69,11,12},
        {43264,48},
        {43312,36,13,1},
        {66176,29},
        {66208,49},
        {67872,26,7,1},
        {43520,55,11,14,4,10,4,4},
        {6688,63,3,29,4,11,8,10,8,14},
        {43648,67,26,5},
        {68352,54,5,7},
        {77824,1071},
        {2048,46,4,15},
        {42192,48},
        {42656,88},
        {43392,78,3,11,6,2},
        {43968,46,4,10},
        {67648,22,3,9},
        {68192,32},
        {68416,22,4,8},
        {68448,19,7,8},
        {68608,73},
        {69760,66},
    },
    -- Unicode ranges for each languages. Keys are generally ISO 639 2/3.
    -- Source data https://github.com/freedesktop/fontconfig/tree/master/fc-lang
    langs = {
        ['cu'] = {1025,2,4,2,3,1,4,1,3,1,3,10,3,19,3,31,3,3,3,1,4,2,3,1,4,1,3,1,3,27},
        ['und-zsye'] = {8986,1,208,1,8,1,4,1,523,1,24,1,53,1,56,1,21,1,15,1,10,1,20,1,8,1,11,1,7,1,23,1,9,1,4,1,6,1,4,1,9,1,6,1,31,1,37,1,3,1,6,1,5,1,63,1,28,1,16,1,861,1,54,1,6,1,115888,1,204,1,192,1,4,1,86,1,28,1,26,1,22,1,4,1,7,1,25,1,177,1,49,1,8,1,74,1,33,1,39,1,27,1,97,1,3,1,184,1,8,1,81,1,172,1,7,1,18,1,5,1,3,1,3,1,3,1,5,1,9,1,6,1,4,1,6,1,17,1},
        ['eu'] = {65,26,8,26,88,1,12,1,22,1,12,1},
        ['wen'] = {65,26,8,26,90,1,33,1,20,2,6,2,14,2,39,4,17,2,4,4,6,2,25,2,4,2},
        ['gu'] = {2689,3,3,7,3,1,3,3,3,22,3,7,3,2,3,5,4,10,3,3,3,3,4,1,17,1},
        ['iu'] = {5121,6,5,2,37,6,5,2,17,1,4,6,5,2,17,1,6,6,3,2,17,1,7,6,3,2,17,1,3,6,3,2,17,1,6,6,3,2,9,1,4,6,3,2,16,1,4,6,3,2,6,1,3,1,3,1,3,1,3,1,4,1,34,6,3,2,17,1,5,1,4,5,3,2,5,1,4,8,4,1,25,3,3,4,3,8,7,12,11,7,3,7,194,8},
        ['hu'] = {65,26,8,26,72,1,9,1,5,1,7,1,4,1,5,1,3,1,6,1,9,1,5,1,7,1,4,1,5,1,3,1,85,2,32,2},
        ['ab'] = {1025,1,15,65,3,1,15,1,64,2,8,4,4,2,6,6,6,4,26,2,8,2},
        ['kum'] = {1025,1,16,64,3,1},
        ['haw'] = {65,26,8,26,135,2,18,2,24,2,34,2,30,2,337,1},
        ['chr'] = {5024,85},
        ['kk'] = {1040,64,8,1,61,2,8,2,8,2,24,2,30,2,16,2},
        ['ru'] = {1025,1,16,64,3,1},
        ['zh-cn'] = {711,1,3,1,19256,2,3,1,5,8,3,2,3,4,3,7,5,1,3,2,3,2,3,4,4,1,3,1,3,1,3,1,3,4,3,3,5,1,3,1,3,3,3,6,3,3,3,1,3,2,4,6,6,1,4,1,8,2,3,1,12,1,9,1,3,2,3,5,3,5,4,1,3,2,5,4,3,6,3,4,5,2,3,1,6,2,5,9,3,3,3,2,4,1,3,7,5,3,3,1,3,3,4,1,3,3,5,1,3,2,3,3,5,1,3,1,3,1,3,1,9,2,4,5,7,5,4,3,3,1,3,4,4,2,5,2,3,1,3,1,3,1,3,1,3,1,3,2,7,1,4,1,8,5,3,1,3,1,3,10,4,3,3,1,3,1,4,1,4,2,4,2,3,1,6,2,3,2,5,2,5,2,3,1,3,1,3,1,3,1,4,1,4,1,5,1,3,1,4,1,4,1,3,6,3,1,3,2,7,1,11,1,5,3,6,1,5,4,7,2,3,1,3,4,3,1,3,1,4,1,3,3,4,3,3,1,3,1,6,1,3,1,5,1,15,2,3,1,4,1,3,1,5,3,3,1,4,1,3,1,5,2,3,3,3,3,13,1,3,1,3,1,6,1,5,2,5,1,3,2,7,1,6,1,3,1,10,1,8,1,11,2,5,1,4,3,6,1,4,1,6,1,23,1,3,1,3,3,4,1,7,1,9,2,21,1,8,1,5,1,13,2,6,3,6,1,3,1,7,1,12,2,5,1,8,1,16,1,31,3,3,4,3,2,3,1,3,1,5,1,4,3,5,1,3,1,7,1,4,1,4,1,4,4,3,2,3,7,3,3,4,3,4,1,4,2,4,2,6,1,4,3,3,1,3,2,5,1,3,1,3,2,7,2,4,5,3,3,5,3,4,1,5,1,3,2,3,1,3,2,4,1,3,1,11,1,3,1,4,2,4,1,8,1,3,1,3,2,4,1,3,2,3,6,3,5,4,3,3,1,4,2,4,2,5,6,3,1,4,1,5,1,5,2,3,1,3,2,3,1,4,1,4,6,3,1,3,5,8,1,3,2,4,2,4,1,3,1,7,1,3,1,4,1,5,1,3,1,3,2,6,1,4,1,12,1,3,1,3,2,7,1,9,1,4,1,9,1,3,7,6,6,5,3,12,2,5,1,5,1,3,1,3,1,6,1,3,1,5,1,3,1,8,1,6,1,13,1,10,2,5,3,6,2,3,1,6,1,3,2,6,3,3,2,4,1,4,2,3,1,4,1,5,1,5,1,12,3,4,2,3,1,3,1,3,1,3,4,5,2,3,3,3,3,4,1,3,1,3,7,3,2,3,1,3,1,4,4,3,3,3,2,3,1,6,1,4,1,3,3,4,1,3,3,9,1,4,1,3,1,4,1,3,1,4,2,3,2,3,2,6,1,9,1,6,1,5,1,3,2,7,6,5,1,4,1,3,4,3,1,5,2,4,4,3,12,3,5,3,3,5,1,3,2,3,1,3,3,3,8,3,3,5,1,3,5,3,1,4,4,3,5,3,2,3,2,4,2,3,2,3,1,3,1,4,1,4,1,3,1,3,2,6,1,3,8,3,2,7,1,3,1,3,1,3,1,10,3,3,4,4,3,4,1,3,1,3,1,3,1,6,2,3,3,3,1,3,3,4,3,3,1,7,2,3,8,3,1,3,1,3,2,5,1,4,1,3,1,3,4,3,1,3,4,4,10,3,1,3,2,3,4,7,6,4,2,5,2,8,1,3,2,3,1,3,1,6,2,3,1,7,3,4,1,8,1,6,1,3,3,4,1,4,1,3,1,3,4,3,1,5,1,6,1,3,2,3,1,3,2,3,1,4,2,7,1,6,2,7,1,6,1,4,4,4,1,3,3,8,4,4,2,3,1,3,5,4,5,5,1,3,1,4,1,5,2,4,2,3,1,9,1,11,1,3,1,3,1,3,1,3,1,3,1,3,2,7,2,5,1,4,2,5,4,3,1,7,2,3,1,3,1,3,4,3,1,3,3,4,1,4,2,3,1,3,1,7,2,3,2,8,2,4,1,3,2,10,1,4,1,4,2,5,2,4,1,6,2,5,2,3,1,3,1,4,1,3,1,5,1,14,3,7,1,4,3,4,1,7,1,3,1,5,5,6,1,6,1,6,2,10,2,9,2,5,1,17,1,13,1,9,1,6,1,15,1,11,1,4,1,4,2,3,6,3,1,8,1,3,1,4,2,4,2,5,2,4,3,5,2,3,1,3,3,19,1,4,1,5,1,6,3,3,5,4,1,7,3,4,1,3,1,3,1,6,1,4,1,3,6,7,1,4,8,4,1,3,1,3,4,3,1,3,1,5,1,4,2,5,2,7,5,6,2,7,2,9,1,6,5,3,2,3,1,3,1,3,2,5,1,3,1,5,1,11,2,9,1,4,2,4,1,3,2,4,3,4,1,3,2,5,1,10,1,3,1,6,1,5,3,4,1,4,1,3,1,5,2,5,1,3,1,5,1,5,1,5,1,6,1,3,2,4,1,7,1,7,1,6,1,16,1,9,2,5,1,4,1,5,1,7,1,8,1,7,2,19,1,3,2,3,1,3,1,5,1,10,2,7,2,5,2,10,2,20,1,6,1,5,1,13,1,5,1,16,1,8,2,3,1,3,1,4,1,4,1,4,1,10,1,3,1,4,1,7,1,3,1,6,3,4,2,3,1,4,1,6,2,3,1,3,3,3,3,3,1,4,1,4,4,3,1,6,2,3,1,4,3,3,1,4,2,3,1,4,5,3,1,7,1,3,1,4,1,15,2,3,1,3,2,5,1,5,4,3,3,3,1,4,1,6,2,4,2,3,1,6,1,6,3,4,4,4,2,4,1,8,1,3,1,4,1,9,1,5,2,6,5,4,2,3,1,3,2,7,1,3,1,4,1,5,1,14,1,3,1,5,1,3,1,3,7,4,1,6,1,3,1,6,1,5,1,4,2,4,1,3,1,5,1,9,2,3,1,3,1,7,1,5,1,7,1,4,2,12,1,6,1,9,1,6,1,4,1,11,4,4,1,6,1,20,1,9,2,16,1,9,2,3,1,4,1,7,1,4,2,8,1,4,1,7,1,3,1,3,1,3,1,5,1,5,2,3,1,4,1,4,1,3,1,7,1,25,1,14,2,28,1,3,1,4,1,10,1,17,2,3,3,3,7,3,1,4,5,4,2,3,1,5,2,3,1,3,1,6,1,4,1,4,2,3,3,3,3,3,2,4,1,5,1,3,1,3,8,3,7,5,2,6,1,4,4,3,2,5,3,4,1,3,4,6,1,5,1,3,2,11,3,3,1,4,2,4,1,7,1,3,1,9,5,4,1,3,1,4,1,3,1,4,2,6,1,3,1,4,3,3,1,3,1,3,2,6,1,3,2,3,1,6,1,6,1,4,1,5,11,4,1,4,4,4,4,5,1,5,1,6,1,3,2,3,1,3,2,9,2,3,1,9,2,6,1,3,2,7,1,5,2,4,2,4,1,3,7,7,2,7,1,3,3,5,1,3,1,3,1,3,2,6,1,3,1,3,1,4,1,8,1,8,1,8,1,9,1,4,3,3,1,3,1,4,1,4,1,12,1,8,2,4,2,8,1,7,1,3,1,6,1,4,1,7,1,3,2,3,1,5,2,7,1,10,2,10,1,4,3,13,1,4,1,3,1,13,1,3,2,4,1,6,1,15,1,24,1,5,1,27,1,15,1,9,1,15,1,3,2,4,2,4,5,3,1,4,2,3,4,4,1,7,2,4,3,3,2,3,1,5,1,4,3,4,3,3,6,10,2,7,2,4,1,7,2,4,3,6,1,3,2,8,1,9,2,7,1,4,1,4,2,17,3,3,1,3,1,3,4,3,2,5,1,3,2,4,2,5,3,3,5,3,2,3,1,3,3,6,3,7,1,7,1,3,5,6,1,12,2,8,3,4,1,6,1,14,1,3,1,11,1,3,2,4,1,5,7,5,1,3,2,5,1,3,1,3,1,3,1,3,2,4,1,5,2,6,3,3,2,4,1,3,1,3,1,9,2,3,1,5,1,17,1,3,2,3,4,6,1,5,2,3,1,3,1,4,2,3,2,4,2,3,1,5,1,3,1,3,2,5,3,3,2,3,6,5,1,3,1,4,1,3,3,4,1,6,1,8,1,3,1,4,2,8,1,3,1,6,2,7,4,4,1,4,2,3,4,5,4,5,1,4,2,4,1,4,1,4,2,3,2,4,1,5,1,4,1,4,1,3,10,5,1,4,3,4,1,3,3,4,1,3,3,4,2,5,7,5,1,7,1,7,2,4,1,3,3,9,1,3,1,4,1,3,1,4,1,5,2,4,1,6,3,4,7,3,2,4,1,4,1,3,6,3,1,5,2,6,1,4,2,6,1,3,1,3,1,5,2,3,1,3,2,4,1,4,1,3,1,4,3,3,1,3,2,3,1,5,1,4,2,10,2,5,2,7,1,5,1,4,1,3,1,3,2,3,2,7,4,3,6,4,2,3,1,4,2,7,2,6,1,3,2,5,3,7,1,6,1,6,2,4,2,3,2,5,1,21,1,10,1,3,1,3,1,3,1,4,1,5,1,9,1,6,1,6,2,9,1,6,1,3,1,21,1,4,1,7,1,10,1,11,3,4,1,12,1,8,1,5,1,7,1,3,2,7,2,3,1,19,1,16,1,11,1,8,1,3,1,3,9,4,4,3,2,5,1,3,2,3,2,6,1,3,1,3,1,6,2,4,1,7,5,3,1,5,3,3,4,4,4,5,1,4,1,9,1,4,2,3,8,4,1,4,1,4,1,4,1,3,3,5,1,6,2,8,3,3,4,3,2,5,4,3,2,4,1,4,2,6,1,5,1,5,1,3,3,3,1,4,1,3,7,3,3,3,1,3,3,3,7,4,1,4,2,3,5,4,4,3,1,3,2,3,2,6,4,3,2,6,3,6,1,4,1,6,1,5,2,3,9,4,1,3,2,5,1,4,1,8,2,4,1,6,2,3,2,4,1,3,6,6,1,10,2,3,3,5,1,3,1,5,2,4,1,6,2,4,2,6,1,3,1,6,4,3,1,3,3,3,1,5,1,3,1,9,1,3,2,3,1,3,4,3,3,3,1,4,2,4,2,3,1,3,1,3,1,7,1,3,1,4,1,5,4,3,1,5,1,9,1,3,2,3,1,7,2,4,1,6,1,3,1,3,1,3,1,6,1,3,4,4,1,7,2,4,2,4,2,8,2,3,1,3,2,6,1,5,1,3,2,8,1,7,1,4,1,3,1,3,1,4,5,3,1,9,1,3,1,5,1,7,1,10,1,3,1,5,1,12,3,9,1,3,2,3,1,11,2,4,2,4,1,6,1,7,1,6,1,4,3,3,1,6,1,3,2,3,1,3,1,5,1,3,1,4,1,9,2,3,1,3,1,6,2,7,1,5,1,3,1,3,1,27,1,10,1,10,1,7,1,14,1,7,1,4,2,6,3,3,2,3,1,4,2,7,1,4,2,4,1,4,1,3,1,5,2,4,1,3,1,3,2,5,2,4,1,6,2,5,1,3,1,3,1,4,1,17,1,5,2,5,2,3,1,5,1,3,1,3,2,4,1,3,1,4,2,3,1,3,1,3,1,3,1,3,2,10,1,4,2,5,1,3,4,6,2,3,2,4,1,5,2,10,1,3,1,4,5,4,6,6,2,4,1,7,1,3,2,4,1,5,1,3,1,3,2,5,3,5,1,5,1,3,2,6,1,3,2,6,1,3,1,3,1,4,3,7,1,3,1,4,1,3,1,9,2,4,1,4,6,4,1,6,1,3,1,4,1,3,1,3,1,7,3,5,1,3,2,4,1,5,1,5,1,3,1,4,1,6,1,6,1,6,2,7,1,11,2,7,1,7,1,6,1,6,1,28,1,3,3,10,1,4,1,8,1,3,3,4,1,3,1,4,1,3,3,9,4,3,1,4,1,5,2,3,1,5,1,3,1,3,1,8,1,3,1,3,4,3,1,3,1,4,2,6,1,4,1,4,1,3,2,4,1,3,2,4,1,3,4,3,1,4,1,7,1,3,4,5,1,4,3,4,1,3,2,3,2,3,1,3,1,6,1,3,2,3,1,4,1,4,1,3,1,3,1,6,1,6,1,3,2,3,1,3,3,5,2,3,1,3,2,3,2,3,1,3,2,4,1,3,4,10,1,3,2,12,6,5,3,3,3,3,1,3,1,4,1,5,1,4,1,4,3,3,2,10,1,3,2,6,1,3,6,3,2,3,1,3,1,4,2,7,1,5,1,9,2,9,2,5,3,4,3,3,7,3,3,3,1,3,1,3,2,3,3,12,10,3,1,10,1,3,2,11,1,3,1,3,2,10,1,5,1,5,1,12,1,5,3,6,1,3,2,4,1,3,1,12,1,3,1,8,1,3,1,3,1,6,1,4,1,4,1,3,1,7,1,4,1,12,1,3,2,5,1,5,2,3,1,6,1,5,1,7,1,3,2,3,1,3,1,14,2,5,1,10,1,4,1,5,1,6,1,5,1,3,1,4,1,19,1,4,1,4,1,4,2,3,1,4,1,4,1,6,1,4,1,4,1,7,3,4,1,5,1,3,1,3,1,3,4,5,1,8,2,4,1,4,2,12,2,4,1,3,1,5,1,4,1,4,1,5,1,7,1,10,1,3,1,3,1,3,1,5,1,8,1,5,2,14,1,6,1,12,1,3,1,12,1,14,2,8,1,3,1,8,1,3,1,6,1,3,1,5,1,9,2,7,1,4,1,10,1,9,2,3,1,7,1,5,1,13,1,9,1,4,1,5,1,5,1,11,1,3,2,7,1,10,1,10,1,3,2,117,5,4,1,12,1,6,1,3,2,5,1,6,1,4,2,3,1,4,1,14,1,10,6,4,1,16,1,3,2,6,4,3,2,3,3,3,1,6,2,4,1,5,2,7,1,10,1,10,3,3,1,9,1,3,2,4,1,7,1,3,1,3,1,4,6,3,1,3,1,7,1,10,2,5,1,5,1,3,1,5,1,5,1,9,3,7,1,3,3,3,4,3,4,5,1,3,2,3,1,3,5,5,3,3,1,3,2,4,1,6,1,4,3,5,2,3,2,7,1,5,2,3,1,5,7,4,1,5,3,7,1,3,1,3,1,3,1,4,1,5,2,4,3,3,2,3,2,4,1,4,2,4,2,6,1,3,1,5,1,3,1,3,5,3,3,3,2,4,3,6,2,3,5,6,2,5,2,3,1,5,1,4,5,5,1,4,1,3,4,3,1,4,1,3,2,4,4,3,1,3,4,3,5,4,1,4,1,4,1,5,2,3,1,5,1,6,1,3,3,4,1,8,1,3,1,4,2,4,1,4,3,3,1,5,1,3,4,4,1,3,1,3,4,3,2,3,3,3,4,6,2,3,1,3,1,3,1,4,1,4,1,4,2,5,2,6,1,4,2,5,1,7,1,4,1,4,2,4,1,3,1,4,1,3,3,7,1,3,5,3,2,3,6,4,2,4,1,4,1,4,1,8,2,5,4,5,2,6,1,6,1,3,2,5,2,3,2,4,1,3,1,6,2,3,1,4,1,3,1,5,1,3,1,3,2,10,1,6,1,3,3,3,2,4,1,3,2,4,1,4,1,4,2,3,3,5,1,3,1,3,1,3,1,4,1,3,1,5,1,3,1,10,2,10,2,6,2,3,1,3,1,4,1,5,1,13,1,4,1,17,2,5,1,3,2,4,1,7,2,9,1,5,1,4,1,4,1,4,1,3,1,4,1,6,1,3,2,3,1,3,2,4,2,3,1,5,2,6,1,5,1,5,1,3,1,3,3,3,1,4,1,5,5,3,3,3,2,12,1,6,1,10,1,5,1,4,1,7,1,5,3,12,1,5,1,6,3,3,1,3,1,3,1,3,1,4,1,9,1,9,2,5,1,3,1,12,1,5,1,3,1,5,1,5,1,8,2,5,1,3,1,5,1,3,1,3,1,9,1,5,2,4,3,15,1,6,1,7,1,13,1,4,1,4,1,8,1,3,1,8,1,9,2,13,1,3,2,14,2,35,1,10,2,9,1,19,1,5,1,20,1,4,1,16,1,14,3,3,2,6,2,3,1,5,1,3,3,6,1,5,2,5,1,5,1,3,3,4,1,4,2,15,5,3,1,3,1,5,3,3,3,4,4,6,1,3,1,15,2,3,1,5,1,6,1,3,4,3,3,3,1,9,1,3,1,5,1,13,2,7,1,4,1,3,2,3,3,13,1,10,3,6,1,16,1,6,1,3,1,3,1,15,1,3,1,7,1,3,3,7,1,5,2,6,1,3,1,4,1,8,1,7,1,6,1,6,1,5,2,7,2,9,1,5,1,8,1,3,1,5,1,11,1,12,1,7,2,12,1,6,1,3,1,8,1,12,1,14,1,24,1,12,1,3,1,3,1,5,2,5,5,3,1,3,1,3,1,9,2,5,2,6,1,5,1,4,1,3,1,3,1,3,1,3,2,5,2,3,1,6,2,4,1,4,1,5,2,5,4,4,1,7,2,3,1,3,1,4,1,14,1,14,2,3,2,5,1,3,4,9,4,5,1,6,2,3,1,3,1,6,1,3,1,6,1,3,2,8,2,4,9,4,2,3,3,6,1,3,1,8,1,5,1,6,1,3,3,5,4,4,2,4,1,5,4,3,1,4,1,4,1,4,3,6,2,15,1,4,1,3,1,6,1,10,1,13,2,3,1,16,1,7,1,4,1,3,1,3,1,4,1,4,1,6,1,6,1,5,1,4,1,8,1,3,1,4,3,3,2,5,1,4,2,6,1,3,1,7,3,4,1,3,3,9,1,6,1,3,1,6,1,3,1,3,1,5,1,6,1,18,1,3,2,4,2,6,2,11,2,8,1,4,2,3,1,3,1,3,1,3,1,3,1,4,4,7,1,6,1,21,1,3,1,3,4,3,2,15,1,4,1,7,2,8,1,3,2,3,1,5,1,5,1,4,1,3,1,13,1,3,1,10,3,18,1,25,1,11,1,3,1,3,1,3,3,3,1,9,2,6,1,3,2,9,1,6,1,10,1,3,1,3,1,3,1,6,3,3,1,4,1,7,1,4,2,3,3,3,5,3,1,3,2,3,2,4,1,3,1,6,1,4,1,4,2,3,2,6,1,6,4,10,2,5,1,9,1,3,1,5,2,7,1,5,1,4,1,6,1,5,1,3,2,3,1,3,2,3,2,4,1,3,3,3,3,7,2,3,8,4,2,4,3,5,4,3,4,4,1,6,1,3,3,3,1,4,1,4,1,5,3,3,3,3,2,6,2,4,1,6,1,4,1,4,3,3,1,3,1,6,1,3,1,5,1,6,1,3,3,3,1,5,2,3,1,3,3,4,3,3,1,4,1,4,3,4,1,5,1,3,3,4,1,10,2,8,1,3,1,7,1,3,1,6,1,9,1,5,1,10,1,4,1,3,2,5,1,3,1,3,3,4,1,4,1,4,1,3,1,4,1,4,1,12,1,11,1,4,2,3,1,12,1,4,1,4,2,3,1,3,1,4,6,3,1,3,3,4,1,5,1,7,1,10,2,3,2,3,1,5,2,4,1,3,1,4,1,4,1,4,3,3,1,3,1,13,2,6,2,3,1,5,1,3,2,5,1,3,1,7,4,3,1,3,1,5,2,3,1,5,1,10,2,10,2,7,3,3,2,3,1,4,2,14,1,5,4,5,2,8,3,4,2,14,2,3,1,4,1,3,1,3,2,3,1,5,1,4,1,3,1,7,1,3,1,3,1,15,1,11,1,5,2,7,2,3,1,3,1,3,1,3,4,6,1,4,1,3,1,6,6,8,1,4,2,5,2,3,1,3,3,3,1,3,2,3,1,5,1,3,3,3,1,4,2,4,1,5,1,4,6,3,1,3,1,6,1,3,1,6,1,3,1,3,1,3,1,4,3,7,1,14,5,10,1,6,1,12,1,3,1,4,3,4,1,3,1,5,2,3,3,4,1,3,1,3,1,3,1,3,1,10,5,6,1,6,1,4,1,5,1,5,3,6,1,5,2,5,1,16,1,5,1,7,1,3,1,4,1,4,1,8,1,5,1,15,1,12,1,7,1,17,1,7,3,3,1,3,2,6,1,3,2,11,1,4,2,4,7,3,1,4,1,3,2,6,1,3,1,9,2,3,1,7,2,4,2,6,1,6,1,12,1,14,1,13,1,7,3,3,2,3,2,3,1,4,1,4,1,3,1,3,1,5,2,4,1,4,1,8,1,5,2,3,2,3,1,3,1,3,1,3,2,9,1,4,1,3,1,4,1,3,2,4,1,6,1,3,2,7,1,4,1,4,1,5,1,3,1,4,1,17,1,5,1,3,1,3,3,3,1,8,1,12,1,7,1,26,1,5,1,3,5,6,3,3,2,3,1,3,1,6,1,5,2,4,4,5,2,3,2,6,2,3,1,5,2,7,1,13,1,13,1,12,1,4,1,6,3,4,1,3,2,8,1,3,1,11,2,4,1,3,1,5,2,3,1,3,1,3,2,5,1,3,1,4,2,5,1,3,1,4,1,3,1,5,3,3,1,3,3,3,1,4,1,3,1,6,1,3,1,3,1,3,1,8,1,3,1,3,1,3,2,4,4,3,1,3,1,3,1,3,2,3,1,4,1,3,1,13,1,4,2,4,1,3,1,3,1,3,1,4,1,3,1,6,1,9,1,4,1,5,2,3,1,6,2,5,2,5,8,5,1,4,1,5,1,10,1,6,2,6,1,6,1,3,1,7,2,4,1,5,1,5,2,5,1,5,1,4,1,7,1,6,1,3,1,10,1,5,2,4,1,8,1,10,1,8,2,4,1,15,1,8,3,13,1,39,2,8,3,13,1,9,2,4,1,3,2,5,4,4,1,3,2,6,1,5,1,4,3,7,1,4,3,4,1,5,1,3,2,3,1,3,2,9,3,3,1,4,1,4,2,9,1,8,1,10,1,4,1,16,1,23,1,3,1,6,1,5,1,5,1,64,1,10,1,48,1,9,1,142,1,7,1,7,1,60,1,26,1,5,15,3,5,3,6,4,25,3,13,3,7,3,12,3,16,3,5,3,13,3,24,3,1,3,1,9,1,3,2,12,2,4,2,3,2,3,1,6,1,3,2,7,3,5,1,4,2,3,1,6,1,6,1,4,1,10,1,3,1,3,1,7,1,7,1,4,3,3,1,4,1,4,1,9,2,3,1,7,2,4,2,3,1,3,1,5,1,6,1,3,1,3,1,7,2,4,1,8,3,5,2,4,1,6,1,3,2,3,1,9,2,5,2,3,4,6,3,4,1,3,1,3,6,4,1,5,1,3,1,4,6,8,1,3,1,3,4,4,1,3,1,3,1,4,2,4,1,5,4,6,1,3,1,5,1,3,1,16,2,8,1,15,2,4,2,3,2,3,1,3,2,8,1,4,1,3,1,3,4,3,4,3,2,5,3,3,3,3,2,3,1,4,1,4,1,3,9,3,1,7,3,9,2,3,6,4,1,4,2,3,7,3,6,3,1,3,1,3,1,3,2,6,1,5,1,4,2,4,8,3,1,3,1,3,1,5,1,15,1,4,1,3,2,5,1,3,1,7,1,9,1,3,1,3,3,5,2,3,3,5,2,7,1,6,1,3,1,3,1,5,2,3,2,4,1,6,8,3,1,7,1,3,1,6,1,3,1,8,1,4,3,7,1,4,1,3,1,3,1,10,1,8,2,6,4,4,1,5,1,3,1,24,1,5,1,4,1,3,2,7,2,8,2,3,1,3,3,3,3,7,2,4,1,3,1,3,1,8,2,3,2,3,3,6,1,3,4,3,3,3,7,3,1,4,1,7,1,4,1,3,1,3,1,5,1,10,1,3,1,6,1,10,1,7,3,3,3,6,2,4,3,4,1,3,1,5,1,3,2,3,3,3,2,6,3,4,2,3,1,3,1,4,3,3,10,3,2,4,3,5,2,4,1,4,1,4,2,3,6,3,5,3,2,4,2,3,4,3,4,6,1,5,1,3,1,4,1,4,1,3,1,3,1,7,9,4,1,3,2,3,1,4,2,3,1,4,3,12,2,4,3,3,1,3,1,3,4,3,3,3,1,5,1,4,1,4,2,3,1,7,4,3,1,7,3,3,4,3,13,9,2,4,3,9,2,4,1,6,1,5,2,6,1,4,2,3,1,3,1,9,4,6,5,3,5,3,2,4,2,5,1,3,1,4,1,3,1,4,1,6,1,3,1,3,1,5,2,3,3,5,1,5,2,7,3,7,2,5,1,5,1,3,2,3,1,6,5,3,1,8,1,5,2,8,5,10,1,8,1,5,2,10,1,12,1,7,1,3,4,6,1,3,1,7,1,3,3,5,1,3,1,3,2,3,1,3,1,9,1,6,3,3,2,3,1,10,1,3,1,4,1,6,1,15,1,4,1,3,1,5,3,4,1,3,1,3,1,4,1,6,2,4,1,4,2,3,1,4,1,8,1,3,2,4,1,3,2,7,1,5,1,13,1,4,1,14,1,6,1,3,1,5,1,4,1,6,1,3,1,11,2,12,7,7,1,6,3,13,1,4,1,6,1,7,1,5,1,11,1,3,1,6,3,4,1,7,2,3,1,9,1,13,2,9,1,5,1,3,1,5,3,8,1,3,1,9,1,9,1,7,2,4,1,3,1,8,1,9,1,6,1,19,1,5,1,7,1,13,1,6,1,18,1,3,1,16,1,5,1,18,5,4,1,7,1,5,1,5,1,10,2,3,1,4,1,9,10,9,4,7,1,3,1,8,2,7,2,4,4,3,1,4,3,4,3,5,1,7,1,5,1,3,2,3,3,4,4,4,1,5,2,3,1,4,2,6,1,6,1,5,2,3,5,5,2,6,1,3,1,3,2,5,4,4,1,6,2,3,1,3,2,3,1,3,1,3,1,4,3,3,1,5,1,6,1,4,1,4,1,4,1,5,1,4,2,9,3,4,1,3,1,6,1,5,1,3,1,8,1,4,3,10,1,3,1,5,1,3,1,6,4,5,2,3,1,4,1,4,1,3,1,7,1,5,1,9,1,10,1,4,3,3,1,5,1,3,1,6,1,4,1,4,1,7,1,5,2,7,3,9,1,6,1,6,1,6,1,5,1,12,1,6,1,6,1,8,1,10,1,3,2,6,1,7,2,17,1,8,1,4,1,5,1,5,2,8,2,8,1,4,1,3,1,9,5,4,2,3,2,3,1,3,1,3,1,6,1,7,3,3,2,3,2,4,1,4,1,3,1,6,1,5,1,7,1,7,1,3,1,8,1,3,1,5,1,7,1,6,1,6,2,4,2,4,1,6,1,5,1,3,2,4,2,7,1,4,4,4,1,9,2,3,2,5,2,4,1,3,1,5,1,9,1,7,1,3,2,7,3,7,1,5,1,6,2,6,1,5,1,3,1,12,1,4,1,27,2,8,1,22,1,5,1,3,1,3,1,4,1,60,2,3,9,3,5,5,1,5,1,3,1,3,1,6,1,3,2,6,1,5,1,5,1,14,1,8,1,56,1,11,1,50,1,17,2,10,1,117,1,32,1,65,1,7,1,53,12,3,4,3,9,3,11,3,8,3,25,3,30,3,20,3,25,11,1,6,2,3,1,4,1,10,1,6,1,8,2,9,2,9,1,6,3,9,1,4,1,5,2,3,1,9,1,5,1,134,3,3,48,4,4,3,7,3,5,3,2,5,1,3,1,4,1,4,5,11,1,4,2,6,2,7,1,4,1,12,1,5,1,15,1,3,3,4,1,3,1,3,1,3,2,5,2,3,1,6,2,3,2,3,1,6,2,4,2,3,3,5,2,5,1,3,3,4,1,5,1,3,1,3,5,3,1,9,1,5,2,3,1,4,1,6,1,10,3,4,2,7,2,3,1,3,2,3,1,5,1,5,2,4,1,4,3,3,1,4,5,7,2,8,1,14,1,4,1,4,2,3,2,3,1,3,1,3,1,7,1,4,1,3,1,5,1,3,1,9,2,5,1,9,1,3,1,14,2,4,1,4,1,9,1,21,1,153,4,3,21,3,11,3,5,3,10,3,2,5,1,6,2,3,1,6,2,6,1,4,1,5,2,4,2,3,2,3,2,7,1,3,2,3,3,4,2,3,5,4,1,3,3,3,4,3,2,3,1,4,1,5,3,5,1,4,7,4,3,3,1,3,4,3,1,3,2,4,2,3,6,5,1,8,3,7,2,3,1,4,2,3,1,4,2,3,1,4,1,7,1,3,5,5,2,4,1,8,2,3,1,4,1,6,2,7,2,9,1,3,2,3,2,6,1,4,1,7,1,3,1,3,1,3,1,3,1,3,1,3,1,5,3,4,1,5,1,3,1,3,4,3,4,3,4,4,1,4,1,4,2,3,1,4,1,5,4,3,1,5,1,5,3,5,2,5,3,4,1,3,1,3,1,6,1,5,1,6,2,5,1,3,1,22,1,6,1,5,2,13,1,3,1,9,1,11,1,4,1,4,8,3,1,6,1,4,1,4,2,4,5,5,2,3,1,3,5,3,6,5,3,7,1,3,1,3,1,3,3,4,3,9,2,8,2,8,1,4,3,6,2,6,1,14,1,3,2,3,4,3,1,12,1,153,1,27,1,33,1,27,1,119,1,45,1,38,1,60,1,13,1,105,1,46,1,27,12,3,4,3,1,3,46,3,7,3,3,4,5,3,11,3,20,3,32,3,3,3,6,3,11,3,9,3,5,3,4,3,2,3,9,3,4,3,5,3,13,3,5,4,1,10,1,106,4,3,18,3,7,3,11,3,4,3,2,3,2,3,1,3,2,9,1,5,1,4,6,6,3,3,2,3,1,3,6,3,3,4,1,5,2,7,1,5,1,3,2,3,1,4,4,3,1,7,1,3,4,15,2,3,1,4,1,3,1,3,2,5,1,4,3,4,1,12,1,10,1,4,1,4,1,4,1,4,3,3,2,4,4,3,1,4,4,4,1,4,1,12,1,9,3,6,1,5,1,4,2,3,1,6,1,3,2,4,1,3,4,5,3,5,1,4,1,7,1,3,1,13,1,4,1,4,1,3,1,7,2,6,1,21,2,4,1,4,1,3,1,4,1,3,3,4,1,5,1,11,2,3,1,7,1,10,1,7,1,3,1,5,2,3,1,5,1,9,1,4,1,9,1,3,1,3,1,4,1,3,1,51,2,3,5,7,1,3,2,128,22,3,2,3,3,3,2,3,3,3,9,3,4,40,1,4,3,3,1,4,3,5,2,9,2,38,1,4,1,31,1,39,2,15,1,3,1,3,12,3,4,4,1,3,2,3,3,4,5,3,2,3,1,3,11,13,1,4,1,197,6,3,16,3,5,3,3,4,5,4,3,3,12,3,2,9,2,6,3,3,1,3,1,5,3,4,1,7,2,6,1,3,1,6,1,8,1,3,1,6,1,6,1,3,1,3,1,11,1,3,1,9,1,6,1,8,1,5,1,13,1,5,1,13,1,4,1,10,2,6,5,3,3,5,1,3,1,3,1,4,1,297,1,4,1,3,2,4,4,4,1,3,2,3,3,3,2,6,3,3,12,3,1,3,2,3,9,3,4,7,5,4,7,4,7,4,4,4,1,318,5,3,2,3,6,3,1,3,3,3,6,4,3,3,12,3,2,3,1,5,1,3,2,3,3,3,1,6,2,3,8,4,2,3,1,12,2,4,1,6,2,4,1,8,2,11,1,3,1,8,1,15,1,5,1,4,1,3,2,7,1,6,1,5,3,3,1,4,1,5,1,4,3,3,2,3,1,4,1,3,1,3,2,6,1,11,1,3,2,3,1,14,1,3,2,3,1,4,1,5,1,3,1,8,1,3,1,11,1,4,1,9,1,3,1,3,1,3,2,7,1,13,2,47,2,4,10,14,3,5,2},
        ['ms'] = {65,26,8,26},
        ['sco'] = {65,26,8,26,318,1,102,2,118,1},
        ['mn-cn'] = {6176,88,10,42},
        ['zh-mo'] = {12295,1,1094,1,25,1,16,1,8,1,4,2,22,1,4,1,16,1,24,1,6,1,8,1,24,1,6,1,24,1,12,1,57,1,20,1,17,1,13,1,4,1,3,1,6,2,13,1,20,1,11,1,5,1,9,1,19,1,3,1,5,1,3,1,4,1,5,1,5,1,5,1,6,1,23,3,9,1,4,1,12,1,18,1,10,1,11,1,9,1,5,1,15,3,6,1,18,1,28,1,8,1,37,1,6,1,3,1,5,2,5,1,5,1,4,1,6,1,3,3,15,2,3,1,8,1,9,2,16,1,15,1,6,1,3,1,4,1,16,1,8,1,3,1,12,1,3,2,8,1,7,1,4,1,32,1,14,1,41,1,10,1,26,1,6,1,53,1,7,1,4,1,21,1,11,1,8,1,14,1,10,1,3,1,44,1,62,1,36,1,10,1,6,1,42,1,15,1,13,1,20,1,12,1,14,1,15,1,23,1,30,1,10,2,9,1,10,1,7,1,4,1,21,1,37,1,7,1,4,1,8,1,13,1,4,1,4,1,4,1,3,1,4,1,18,2,18,2,11,1,24,1,8,1,6,1,6,1,3,1,9,2,49,1,21,1,19,1,34,1,19,1,3,1,10,1,20,1,12,1,10,1,10,1,15,1,10,1,23,1,9,1,18,2,10,2,5,1,23,1,4,1,9,1,30,1,5,1,3,1,20,1,7,1,16,1,7,2,27,1,5,1,5,1,64,1,120,1,3,1,5,1,6,1,7,1,16,1,41,1,11,1,22,1,21,1,7,1,3,1,4,1,15,1,4,1,8,2,6,1,7,1,9,1,9,1,11,1,3,1,21,1,9,1,8,1,12,1,8,2,7,1,7,1,9,1,17,1,9,1,5,1,6,1,69,1,4,1,6,1,14,1,32,1,53,3,4,1,5,1,8,1,8,1,4,1,9,1,3,1,6,1,6,2,8,1,4,1,7,1,5,1,6,1,11,1,6,1,6,1,11,1,75,2,11,1,49,1,46,1,24,1,6,1,10,1,9,1,13,2,11,1,54,1,13,1,15,1,5,1,12,1,4,1,6,1,6,1,77,1,5,1,10,1,17,1,8,1,28,1,10,2,6,1,6,1,37,1,54,1,6,1,3,1,18,1,18,1,35,1,30,1,13,1,21,1,11,1,25,1,48,1,33,1,11,1,17,1,27,1,15,1,20,1,5,1,4,1,57,1,8,2,48,1,68,1,42,1,36,1,8,1,25,1,7,1,15,1,6,1,16,2,18,1,104,1,22,1,17,2,17,1,8,1,39,1,3,1,6,1,7,1,11,1,16,2,6,1,14,1,18,1,8,1,6,1,9,1,5,1,5,1,15,2,4,1,14,1,9,1,14,1,15,1,101,1,27,1,4,1,10,1,7,1,3,1,69,1,32,1,86,2,38,1,36,1,101,1,90,1,25,1,8,1,13,1,12,1,103,1,43,1,19,1,36,1,14,1,17,1,14,1,13,1,25,1,13,1,4,1,9,1,8,1,3,1,8,1,13,1,3,1,19,1,6,1,9,1,24,1,31,1,57,1,7,1,43,1,15,1,8,1,18,1,98,1,31,1,5,1,26,1,20,1,28,1,27,1,20,1,12,1,57,2,3,1,10,1,4,1,17,1,3,1,4,1,4,2,7,1,33,2,3,1,69,1,4,1,8,1,46,1,4,1,30,1,19,1,11,1,5,1,3,1,5,1,46,1,3,1,30,1,21,1,13,1,29,1,8,1,37,1,68,1,27,1,12,1,105,1,30,1,10,1,49,2,16,1,15,1,9,1,6,1,20,1,55,1,33,1,74,1,175,1,21,1,16,1,52,1,147,1,65,2,93,1,29,1,21,1,14,2,11,4,21,1,37,1,8,1,24,1,28,2,14,1,9,1,28,1,57,1,39,1,5,1,13,1,13,1,104,1,61,1,10,1,23,1,14,1,7,1,3,1,26,1,12,1,14,1,8,1,23,1,9,1,22,2,3,1,12,1,44,2,30,1,4,1,35,1,5,2,4,1,14,1,15,1,26,1,3,1,23,1,32,1,18,1,12,1,8,1,47,1,11,1,13,1,3,1,7,2,8,1,14,1,11,1,26,1,8,1,11,1,3,1,28,1,8,1,15,1,5,2,11,1,11,1,13,1,14,1,5,2,3,1,9,1,23,1,11,1,3,1,4,1,3,1,10,1,45,1,10,1,14,1,3,1,4,1,14,1,9,1,7,1,24,1,40,1,70,1,57,1,79,1,16,1,8,1,38,1,36,1,21,1,7,1,42,1,10,2,56,1,18,1,38,1,19,2,9,1,16,1,108,1,43,1,14,1,30,1,35,1,14,1,52,1,84,1,117,1,9,1,77,1,40,1,49,1,3,1,37,1,25,1,25,1,19,1,70,1,21,1,146,1,157,1,107,1,134,1,10,1,78,1,41,2,3,2,17,3,79,1,76,1,57,1,83,1,69,1,42,1,7,1,52,1,13,1,119,1,12,1,26,1,11,1,74,1,106,1,101,1,10,1,30,1,3,1,17,1,93,1,73,1,65,1,25,1,14,1,9,1,19,1,5,1,3,1,10,1,44,1,9,1,67,1,18,1,5,1,36,1,42,1,5,1,7,1,56,1,19,1,30,1,58,1,4,1,91,1,78,1,21,1,8,1,29,1,5,1,9,1,28,1,100,1,53,1,18,1,44,1,7,1,58,1,18,1,83,2,27,1,5,1,119,1,31,1,75,1,55,1,44,1,19,1,24,1,41,1,90,1,33,1,158,1,110,1,59,1,6,1,7,1,104,1,87,1,3,1,34,1,73,1,73,1,115,1,23,1,37,1,128,1,21,1,84,1,94,1,3,1,3,1,58,1,65,1,44,1,62,1,57,1,41,1,15,1,86,1,9,1,49,1,39,1,19,1,21,1,39,1,22,1,6,1,6,1,8,1,33,1,134,1,32,1,44,1,67,1,6,1,164,1,5,1,20,1,52,1,86,1,7,1,107,1,4,1,13,1,25,1,166,1,48,1,8,1,16,1,8,1,3,1,14,1,8,1,39,2,36,1,4,1,79,1,58,1,20,1,25,2,16,1,5,1,147,1,19,1,35,1,25,1,33,1,3,1,26,1,39,1,19,1,62,1,122,1,13,1,37,1,8,1,32,1,48,1,41,1,43,1,11,1,48,1,52,1,208,1,30,1,25,2,20,2,14,1,34,1,47,1,55,1,167,1,146,2,8,1,28,1,5,1,33,1,13,1,4,1,42,1,57,1,45,1,35,1,9,1,27,1,3,1,14,1,147,1,218,1,3,1,6,1,43,1,32,1,13,1,191,1,86,1,8,1,10,1,66,1,17,1,33,1,111,1,18,1,58,1,42,1,15,1,81,1,49,1,5,1,78,1,34,1,188,1,70,1,9,1,82,1,61,1,17,1,38,1,34,1,50,1,61,1,147,1,46,1,193,1,152,1,73,1,55,1,42,1,26,1,25,1,63,1,44,1,9,1,121,1,65,1,14,1,18,1,3,1,238,1,185,1,54,1,3,1,14,1,318,1,15,1,41,1,9,1,260,1,29,1,4,1,35,1,48,1,3,1,46,1,46,1,9,1,17,1,60,1,137,1,6,3,62,1,59,1,36,1,12,1,72,1,207,1,147,1,7,1,29,1,27,1,18,1,9,1,6,1,13,1,76,1,6,1,74,1,58,1,6,1,4,1,34,1,28,2,3,1,39,1,19,1,50,1,21,1,35,2,46,1,8,1,11,1,309,1,10,1,9,1,237,1,14,1,127,1,49,1,29,1,130,1,8,1,64,1,132,1,18,1,25,1,61,1,29,1,19,1,4,1,22,1,100,1,29,1,48,1,283,1,4,1,85,1,11,1,4,1,96,1,5,1,15,1,4,1,11,1,36,1,7,1,6,1,12,1,25,1,22,1,195,1,29,1,15,1,54,1,46,1,5,1,6,1,12,1,55,1,3,1,133,1,6,2,21,2,5,1,17,1,74,1,31,1,61,1,45,1,90429,1,219,1,6,1,381,1,29,1,974,1,108,1,1225,1,19,1,19,1,20,1,31,1,32,1,27,1,99,1,65,1,14,2,30,1,12,1,94,1,6,1,68,1,40,1,4,1,5,1,36,1,6,1,54,1,35,1,53,2,14,1,18,1,105,1,55,1,43,1,73,1,20,1,7,2,6,1,71,1,19,1,107,1,9,1,11,1,2094,1,185,1,503,1,464,1,719,1,219,1,2351,1,117,1,136,1,136,1,5,1,14,1,81,1,17,1,139,1,28,1,39,1,98,1,391,1,702,1,869,1,294,1,1534,1,467,1,248,1,1364,1,2278,1,51,1,190,1,645,1,30,1,55,1,952,1,2325,1,1040,1,1155,1,243,1,191,1,361,1,9,1,2188,1,752,1,228,1,223,1,42,1,320,1,222,1,39,1,159,1,28,1,795,1,690,1,154,1,161,1,171,1,220,1,140,1,1620,1,29,1,52,1,312,1,9,1,381,1,4,1,6,1,200,1,335,1,1535,1,572,1,434,1,381,1,844,1,2203,1,42,1},
        ['zh-hk'] = {12295,1,1094,1,25,1,16,1,8,1,4,2,22,1,4,1,16,1,24,1,6,1,8,1,24,1,6,1,24,1,12,1,57,1,20,1,17,1,13,1,4,1,3,1,6,2,13,1,20,1,11,1,5,1,9,1,19,1,3,1,5,1,3,1,4,1,5,1,5,1,5,1,6,1,23,3,9,1,4,1,12,1,18,1,10,1,11,1,9,1,5,1,15,3,6,1,18,1,28,1,8,1,37,1,6,1,3,1,5,2,5,1,5,1,4,1,6,1,3,3,15,2,3,1,8,1,9,2,16,1,15,1,6,1,3,1,4,1,16,1,8,1,3,1,12,1,3,2,8,1,7,1,4,1,32,1,14,1,41,1,10,1,26,1,6,1,53,1,7,1,4,1,21,1,11,1,8,1,14,1,10,1,3,1,44,1,62,1,36,1,10,1,6,1,42,1,15,1,13,1,20,1,12,1,14,1,15,1,23,1,30,1,10,2,9,1,10,1,7,1,4,1,21,1,37,1,7,1,4,1,8,1,13,1,4,1,4,1,4,1,3,1,4,1,18,2,18,2,11,1,24,1,8,1,6,1,6,1,3,1,9,2,49,1,21,1,19,1,34,1,19,1,3,1,10,1,20,1,12,1,10,1,10,1,15,1,10,1,23,1,9,1,18,2,10,2,5,1,23,1,4,1,9,1,30,1,5,1,3,1,20,1,7,1,16,1,7,2,27,1,5,1,5,1,64,1,120,1,3,1,5,1,6,1,7,1,16,1,41,1,11,1,22,1,21,1,7,1,3,1,4,1,15,1,4,1,8,2,6,1,7,1,9,1,9,1,11,1,3,1,21,1,9,1,8,1,12,1,8,2,7,1,7,1,9,1,17,1,9,1,5,1,6,1,69,1,4,1,6,1,14,1,32,1,53,3,4,1,5,1,8,1,8,1,4,1,9,1,3,1,6,1,6,2,8,1,4,1,7,1,5,1,6,1,11,1,6,1,6,1,11,1,75,2,11,1,49,1,46,1,24,1,6,1,10,1,9,1,13,2,11,1,54,1,13,1,15,1,5,1,12,1,4,1,6,1,6,1,77,1,5,1,10,1,17,1,8,1,28,1,10,2,6,1,6,1,37,1,54,1,6,1,3,1,18,1,18,1,35,1,30,1,13,1,21,1,11,1,25,1,48,1,33,1,11,1,17,1,27,1,15,1,20,1,5,1,4,1,57,1,8,2,48,1,68,1,42,1,36,1,8,1,25,1,7,1,15,1,6,1,16,2,18,1,104,1,22,1,17,2,17,1,8,1,39,1,3,1,6,1,7,1,11,1,16,2,6,1,14,1,18,1,8,1,6,1,9,1,5,1,5,1,15,2,4,1,14,1,9,1,14,1,15,1,101,1,27,1,4,1,10,1,7,1,3,1,69,1,32,1,86,2,38,1,36,1,101,1,90,1,25,1,8,1,13,1,12,1,103,1,43,1,19,1,36,1,14,1,17,1,14,1,13,1,25,1,13,1,4,1,9,1,8,1,3,1,8,1,13,1,3,1,19,1,6,1,9,1,24,1,31,1,57,1,7,1,43,1,15,1,8,1,18,1,98,1,31,1,5,1,26,1,20,1,28,1,27,1,20,1,12,1,57,2,3,1,10,1,4,1,17,1,3,1,4,1,4,2,7,1,33,2,3,1,69,1,4,1,8,1,46,1,4,1,30,1,19,1,11,1,5,1,3,1,5,1,46,1,3,1,30,1,21,1,13,1,29,1,8,1,37,1,68,1,27,1,12,1,105,1,30,1,10,1,49,2,16,1,15,1,9,1,6,1,20,1,55,1,33,1,74,1,175,1,21,1,16,1,52,1,147,1,65,2,93,1,29,1,21,1,14,2,11,4,21,1,37,1,8,1,24,1,28,2,14,1,9,1,28,1,57,1,39,1,5,1,13,1,13,1,104,1,61,1,10,1,23,1,14,1,7,1,3,1,26,1,12,1,14,1,8,1,23,1,9,1,22,2,3,1,12,1,44,2,30,1,4,1,35,1,5,2,4,1,14,1,15,1,26,1,3,1,23,1,32,1,18,1,12,1,8,1,47,1,11,1,13,1,3,1,7,2,8,1,14,1,11,1,26,1,8,1,11,1,3,1,28,1,8,1,15,1,5,2,11,1,11,1,13,1,14,1,5,2,3,1,9,1,23,1,11,1,3,1,4,1,3,1,10,1,45,1,10,1,14,1,3,1,4,1,14,1,9,1,7,1,24,1,40,1,70,1,57,1,79,1,16,1,8,1,38,1,36,1,21,1,7,1,42,1,10,2,56,1,18,1,38,1,19,2,9,1,16,1,108,1,43,1,14,1,30,1,35,1,14,1,52,1,84,1,117,1,9,1,77,1,40,1,49,1,3,1,37,1,25,1,25,1,19,1,70,1,21,1,146,1,157,1,107,1,134,1,10,1,78,1,41,2,3,2,17,3,79,1,76,1,57,1,83,1,69,1,42,1,7,1,52,1,13,1,119,1,12,1,26,1,11,1,74,1,106,1,101,1,10,1,30,1,3,1,17,1,93,1,73,1,65,1,25,1,14,1,9,1,19,1,5,1,3,1,10,1,44,1,9,1,67,1,18,1,5,1,36,1,42,1,5,1,7,1,56,1,19,1,30,1,58,1,4,1,91,1,78,1,21,1,8,1,29,1,5,1,9,1,28,1,100,1,53,1,18,1,44,1,7,1,58,1,18,1,83,2,27,1,5,1,119,1,31,1,75,1,55,1,44,1,19,1,24,1,41,1,90,1,33,1,158,1,110,1,59,1,6,1,7,1,104,1,87,1,3,1,34,1,73,1,73,1,115,1,23,1,37,1,128,1,21,1,84,1,94,1,3,1,3,1,58,1,65,1,44,1,62,1,57,1,41,1,15,1,86,1,9,1,49,1,39,1,19,1,21,1,39,1,22,1,6,1,6,1,8,1,33,1,134,1,32,1,44,1,67,1,6,1,164,1,5,1,20,1,52,1,86,1,7,1,107,1,4,1,13,1,25,1,166,1,48,1,8,1,16,1,8,1,3,1,14,1,8,1,39,2,36,1,4,1,79,1,58,1,20,1,25,2,16,1,5,1,147,1,19,1,35,1,25,1,33,1,3,1,26,1,39,1,19,1,62,1,122,1,13,1,37,1,8,1,32,1,48,1,41,1,43,1,11,1,48,1,52,1,208,1,30,1,25,2,20,2,14,1,34,1,47,1,55,1,167,1,146,2,8,1,28,1,5,1,33,1,13,1,4,1,42,1,57,1,45,1,35,1,9,1,27,1,3,1,14,1,147,1,218,1,3,1,6,1,43,1,32,1,13,1,191,1,86,1,8,1,10,1,66,1,17,1,33,1,111,1,18,1,58,1,42,1,15,1,81,1,49,1,5,1,78,1,34,1,188,1,70,1,9,1,82,1,61,1,17,1,38,1,34,1,50,1,61,1,147,1,46,1,193,1,152,1,73,1,55,1,42,1,26,1,25,1,63,1,44,1,9,1,121,1,65,1,14,1,18,1,3,1,238,1,185,1,54,1,3,1,14,1,318,1,15,1,41,1,9,1,260,1,29,1,4,1,35,1,48,1,3,1,46,1,46,1,9,1,17,1,60,1,137,1,6,3,62,1,59,1,36,1,12,1,72,1,207,1,147,1,7,1,29,1,27,1,18,1,9,1,6,1,13,1,76,1,6,1,74,1,58,1,6,1,4,1,34,1,28,2,3,1,39,1,19,1,50,1,21,1,35,2,46,1,8,1,11,1,309,1,10,1,9,1,237,1,14,1,127,1,49,1,29,1,130,1,8,1,64,1,132,1,18,1,25,1,61,1,29,1,19,1,4,1,22,1,100,1,29,1,48,1,283,1,4,1,85,1,11,1,4,1,96,1,5,1,15,1,4,1,11,1,36,1,7,1,6,1,12,1,25,1,22,1,195,1,29,1,15,1,54,1,46,1,5,1,6,1,12,1,55,1,3,1,133,1,6,2,21,2,5,1,17,1,74,1,31,1,61,1,45,1,90429,1,219,1,6,1,381,1,29,1,974,1,108,1,1225,1,19,1,19,1,20,1,31,1,32,1,27,1,99,1,65,1,14,2,30,1,12,1,94,1,6,1,68,1,40,1,4,1,5,1,36,1,6,1,54,1,35,1,53,2,14,1,18,1,105,1,55,1,43,1,73,1,20,1,7,2,6,1,71,1,19,1,107,1,9,1,11,1,2094,1,185,1,503,1,464,1,719,1,219,1,2351,1,117,1,136,1,136,1,5,1,14,1,81,1,17,1,139,1,28,1,39,1,98,1,391,1,702,1,869,1,294,1,1534,1,467,1,248,1,1364,1,2278,1,51,1,190,1,645,1,30,1,55,1,952,1,2325,1,1040,1,1155,1,243,1,191,1,361,1,9,1,2188,1,752,1,228,1,223,1,42,1,320,1,222,1,39,1,159,1,28,1,795,1,690,1,154,1,161,1,171,1,220,1,140,1,1620,1,29,1,52,1,312,1,9,1,381,1,4,1,6,1,200,1,335,1,1535,1,572,1,434,1,381,1,844,1,2203,1,42,1},
        ['zu'] = {65,26,8,26},
        ['ik'] = {1025,1,14,1,3,64,3,1,14,1},
        ['mo'] = {65,26,8,26,73,1,13,1,21,1,13,1,21,2,278,4,487,1,16,64,3,1},
        ['yo'] = {65,26,8,26,71,4,6,3,3,3,5,4,5,3,6,4,6,3,3,3,5,4,5,3,32,2,14,2,27,2,37,2,101,8,37,2,264,4,10,1,6963,2,36,2,86,2,4,2,16,2},
        ['yi'] = {1488,27},
        ['nv'] = {65,26,8,26,72,1,9,1,5,1,7,1,15,1,9,1,5,1,7,1,18,2,20,2,22,2,19,2,169,2,210,1,70,1},
        ['ps-af'] = {1569,4,3,21,8,2,3,5,3,1,51,1,3,1,4,1,5,2,4,1,11,1,4,1,3,1,3,1,16,1,3,1,18,1,17,2,4,1},
        ['ar'] = {1569,26,8,10},
        ['wa'] = {65,26,8,26,73,1,4,1,3,4,5,1,7,1,8,1,8,1,4,1,3,4,5,1,7,1,8,1},
        ['ak'] = {65,26,8,26,74,1,15,1,5,1,15,1,15,1,5,1,52,2,64,2,30,1,11,1,197,1,8,1,169,1,4,1,36,1,7060,2,60,2},
        ['st'] = {65,26,8,26},
        ['om'] = {65,26,8,26},
        ['et'] = {65,26,8,26,75,1,18,2,7,1,9,1,18,2,7,1,101,2,29,2},
        ['tl'] = {65,26,8,26,71,3,7,3,3,3,4,4,6,3,6,3,7,3,3,3,4,4,6,3},
        ['vo'] = {65,16,3,5,3,3,8,16,3,5,3,3,75,1,19,1,7,1,9,1,19,1,7,1},
        ['chm'] = {1025,1,16,64,3,1,84,2,46,2,20,2,10,2,8,2},
        ['ast'] = {65,26,8,26,72,1,9,1,5,1,5,1,3,1,8,1,3,1,6,1,9,1,5,1,5,1,3,1,8,1,3,1,7465,2,18,2},
        ['vi'] = {65,26,8,26,71,4,6,3,3,2,6,4,5,2,4,1,4,4,6,3,3,2,6,4,5,2,4,1,6,2,14,2,24,2,64,2,56,2,15,2,337,4,4,1,4,1,19,1,9,1,7038,90},
        ['ty'] = {65,26,8,26,86,1,33,1,18,2,18,2,24,2,34,2,30,2,338,1},
        ['lt'] = {65,26,8,26,139,2,8,2,10,4,22,2,50,2,10,2,8,2,11,2},
        ['mt'] = {65,26,8,26,71,1,9,1,5,1,3,1,5,1,8,1,8,1,9,1,5,1,3,1,5,1,8,1,18,2,22,2,6,2,85,2},
        ['uz'] = {65,26,8,26},
        ['gd'] = {65,26,8,26,71,2,7,3,4,1,7,2,7,1,8,2,7,3,4,1,7,2,7,1},
        ['nso'] = {65,26,8,26,81,1,11,1,23,1,11,1,109,2},
        ['kl'] = {65,26,8,26,72,3,3,2,5,1,4,2,7,1,5,1,3,2,7,3,3,2,5,1,4,2,7,1,5,1,3,2,46,2,16,1,49,2},
        ['pl'] = {65,26,8,26,90,1,33,1,18,4,18,2,41,4,23,2,31,4},
        ['ur'] = {1569,4,3,3,19,1,8,2,3,3,3,1,50,1,6,1,9,1,3,1,10,1,8,1,18,1,7,1,12,1,5,1,6,1,10,1,7,1},
        ['nl'] = {65,26,8,26,72,2,3,1,5,4,3,1,3,1,5,2,3,1,5,3,6,2,3,1,5,4,3,1,3,1,5,2,3,1,5,3},
        ['id'] = {65,26,8,26,80,1,33,1},
        ['it'] = {65,26,8,26,71,1,9,2,4,2,3,1,4,2,7,2,7,1,9,2,4,2,3,1,4,2,7,2},
        ['el'] = {902,1,3,3,3,1,3,20,3,44},
        ['uk'] = {1028,1,3,2,10,64,6,1,3,2,58,2},
        ['sms'] = {65,26,8,26,73,1,3,2,17,1,14,1,3,2,17,1,24,2,4,2,58,2,22,2,29,2,58,1,46,6,6,2,164,1},
        ['ug'] = {1574,3,3,1,3,1,3,2,3,4,7,1,8,6,3,3,53,1,9,1,19,1,22,1,3,1,16,1,9,3,4,1,6,1,6,1},
        ['sd'] = {1569,2,3,1,3,3,3,17,8,2,3,5,3,1,49,2,3,4,4,2,3,2,4,1,3,2,3,1,11,1,14,1,4,2,6,1,3,1,3,1,9,1,4,1},
        ['tyv'] = {1025,1,16,64,3,1,82,2,12,2},
        ['gl'] = {65,26,8,26,72,1,9,1,5,1,5,1,3,1,8,1,3,1,6,1,9,1,5,1,5,1,3,1,8,1,3,1},
        ['cs'] = {65,26,8,26,72,1,9,1,5,1,7,1,8,1,4,1,5,1,9,1,5,1,7,1,8,1,4,1,16,4,12,2,45,2,17,2,8,2,4,2,10,2,15,2},
        ['bs'] = {65,26,8,26,141,2,6,2,4,2,80,2,29,2},
        ['as'] = {2433,3,3,8,4,2,4,22,3,6,4,1,5,4,4,1,3,7,4,2,4,3,16,2,3,1,18,2},
        ['ve'] = {65,26,8,26,7577,2,42,2,8,2,6,2,38,2},
        ['tw'] = {65,26,8,26,74,1,15,1,5,1,15,1,15,1,5,1,52,2,64,2,30,1,11,1,197,1,8,1,169,1,4,1,36,1,7060,2,60,2},
        ['tig'] = {4608,7,3,15,3,8,10,9,9,15,3,1,3,4,20,15,3,16,18,8,10,7,3,7,3,1,3,4,20,7,3,7,3,8,10,7,3,8,10,15,3,1,3,4,12,32,10,15},
        ['es'] = {65,26,8,26,72,1,9,1,5,1,5,1,3,1,8,1,3,1,6,1,9,1,5,1,5,1,3,1,8,1,3,1},
        ['bua'] = {1025,1,16,64,3,1,94,2,12,2},
        ['ks'] = {1568,5,3,3,19,1,8,2,3,3,3,1,16,1,9,1,20,2,7,1,6,1,9,1,3,1,10,1,8,1,18,1,7,1,12,1,5,1,6,2,9,1,7,1},
        ['rm'] = {65,26,8,26,71,1,9,2,4,1,3,1,5,1,8,1,8,1,9,2,4,1,3,1,5,1,8,1},
        ['is'] = {65,26,8,26,72,1,6,1,4,1,5,1,4,1,4,1,8,1,4,2,4,1,6,1,4,1,5,1,4,1,4,1,8,1,4,2},
        ['tt'] = {1025,1,16,64,3,1,70,2,12,2,12,2,12,2,30,2},
        ['os'] = {1025,1,16,64,3,1},
        ['tn'] = {65,26,8,26,81,1,11,1,23,1,11,1,109,2},
        ['fat'] = {65,26,8,26,74,1,15,1,5,1,15,1,15,1,5,1,52,2,64,2,30,1,11,1,197,1,8,1,169,1,4,1,36,1,7060,2,60,2},
        ['tr'] = {65,26,8,26,73,1,6,1,8,1,9,1,6,2,7,1,6,1,8,1,9,1,6,2,35,2,18,2,46,2},
        ['km'] = {6016,29,4,4,4,3,3,11,4,16},
        ['de'] = {65,26,8,26,75,1,19,1,7,1,4,1,6,1,19,1,7,1},
        ['mai'] = {2309,53,7,15},
        ['to'] = {65,26,8,26,578,1},
        ['ie'] = {65,26,8,26},
        ['he'] = {1488,27},
        ['pa-pk'] = {1569,4,3,3,19,1,8,2,3,3,3,1,50,1,6,1,9,1,3,1,10,1,8,1,18,1,7,1,12,1,5,1,6,1,10,1,7,1},
        ['ts'] = {65,26,8,26},
        ['tk'] = {65,26,8,26,75,1,4,1,16,1,7,2,8,1,4,1,16,1,7,2,75,2,23,2,31,2},
        ['bm'] = {65,26,8,26,209,2,60,1,11,1,14,1,184,1,8,1,24,1},
        ['ti-et'] = {4608,7,3,15,3,15,3,9,9,15,3,1,3,4,4,7,3,1,3,4,4,15,3,23,3,1,3,4,4,31,3,1,3,4,12,1,3,4,4,7,3,7,3,23,3,8,10,15,3,1,3,4,12,39,3,15},
        ['nds'] = {65,26,8,26,75,1,19,1,7,1,4,1,6,1,19,1,7,1},
        ['ti-er'] = {4608,7,3,15,3,8,10,9,9,15,3,1,3,4,4,7,3,1,3,4,4,15,3,16,18,31,3,1,3,4,12,1,3,4,4,7,3,7,3,23,3,8,10,15,3,1,3,4,12,32,10,15},
        ['pap-an'] = {65,26,8,26,72,1,8,2,5,1,5,3,7,2,3,1,6,1,8,2,5,1,5,3,7,2,3,1},
        ['se'] = {65,26,8,26,72,1,33,1,44,2,4,2,58,2,22,2,6,2,23,2},
        ['tg'] = {1025,1,16,64,3,1,66,2,8,2,24,2,4,2,44,2,12,2},
        ['te'] = {3073,3,3,8,3,3,3,23,3,10,3,5,6,7,3,3,3,4,9,2,11,2},
        ['ta'] = {2947,1,3,6,5,3,3,4,5,2,3,1,3,2,5,2,5,3,5,8,3,3,6,5,5,3,3,4,11,1},
        ['zh-sg'] = {711,1,3,1,19256,2,3,1,5,8,3,2,3,4,3,7,5,1,3,2,3,2,3,4,4,1,3,1,3,1,3,1,3,4,3,3,5,1,3,1,3,3,3,6,3,3,3,1,3,2,4,6,6,1,4,1,8,2,3,1,12,1,9,1,3,2,3,5,3,5,4,1,3,2,5,4,3,6,3,4,5,2,3,1,6,2,5,9,3,3,3,2,4,1,3,7,5,3,3,1,3,3,4,1,3,3,5,1,3,2,3,3,5,1,3,1,3,1,3,1,9,2,4,5,7,5,4,3,3,1,3,4,4,2,5,2,3,1,3,1,3,1,3,1,3,1,3,2,7,1,4,1,8,5,3,1,3,1,3,10,4,3,3,1,3,1,4,1,4,2,4,2,3,1,6,2,3,2,5,2,5,2,3,1,3,1,3,1,3,1,4,1,4,1,5,1,3,1,4,1,4,1,3,6,3,1,3,2,7,1,11,1,5,3,6,1,5,4,7,2,3,1,3,4,3,1,3,1,4,1,3,3,4,3,3,1,3,1,6,1,3,1,5,1,15,2,3,1,4,1,3,1,5,3,3,1,4,1,3,1,5,2,3,3,3,3,13,1,3,1,3,1,6,1,5,2,5,1,3,2,7,1,6,1,3,1,10,1,8,1,11,2,5,1,4,3,6,1,4,1,6,1,23,1,3,1,3,3,4,1,7,1,9,2,21,1,8,1,5,1,13,2,6,3,6,1,3,1,7,1,12,2,5,1,8,1,16,1,31,3,3,4,3,2,3,1,3,1,5,1,4,3,5,1,3,1,7,1,4,1,4,1,4,4,3,2,3,7,3,3,4,3,4,1,4,2,4,2,6,1,4,3,3,1,3,2,5,1,3,1,3,2,7,2,4,5,3,3,5,3,4,1,5,1,3,2,3,1,3,2,4,1,3,1,11,1,3,1,4,2,4,1,8,1,3,1,3,2,4,1,3,2,3,6,3,5,4,3,3,1,4,2,4,2,5,6,3,1,4,1,5,1,5,2,3,1,3,2,3,1,4,1,4,6,3,1,3,5,8,1,3,2,4,2,4,1,3,1,7,1,3,1,4,1,5,1,3,1,3,2,6,1,4,1,12,1,3,1,3,2,7,1,9,1,4,1,9,1,3,7,6,6,5,3,12,2,5,1,5,1,3,1,3,1,6,1,3,1,5,1,3,1,8,1,6,1,13,1,10,2,5,3,6,2,3,1,6,1,3,2,6,3,3,2,4,1,4,2,3,1,4,1,5,1,5,1,12,3,4,2,3,1,3,1,3,1,3,4,5,2,3,3,3,3,4,1,3,1,3,7,3,2,3,1,3,1,4,4,3,3,3,2,3,1,6,1,4,1,3,3,4,1,3,3,9,1,4,1,3,1,4,1,3,1,4,2,3,2,3,2,6,1,9,1,6,1,5,1,3,2,7,6,5,1,4,1,3,4,3,1,5,2,4,4,3,12,3,5,3,3,5,1,3,2,3,1,3,3,3,8,3,3,5,1,3,5,3,1,4,4,3,5,3,2,3,2,4,2,3,2,3,1,3,1,4,1,4,1,3,1,3,2,6,1,3,8,3,2,7,1,3,1,3,1,3,1,10,3,3,4,4,3,4,1,3,1,3,1,3,1,6,2,3,3,3,1,3,3,4,3,3,1,7,2,3,8,3,1,3,1,3,2,5,1,4,1,3,1,3,4,3,1,3,4,4,10,3,1,3,2,3,4,7,6,4,2,5,2,8,1,3,2,3,1,3,1,6,2,3,1,7,3,4,1,8,1,6,1,3,3,4,1,4,1,3,1,3,4,3,1,5,1,6,1,3,2,3,1,3,2,3,1,4,2,7,1,6,2,7,1,6,1,4,4,4,1,3,3,8,4,4,2,3,1,3,5,4,5,5,1,3,1,4,1,5,2,4,2,3,1,9,1,11,1,3,1,3,1,3,1,3,1,3,1,3,2,7,2,5,1,4,2,5,4,3,1,7,2,3,1,3,1,3,4,3,1,3,3,4,1,4,2,3,1,3,1,7,2,3,2,8,2,4,1,3,2,10,1,4,1,4,2,5,2,4,1,6,2,5,2,3,1,3,1,4,1,3,1,5,1,14,3,7,1,4,3,4,1,7,1,3,1,5,5,6,1,6,1,6,2,10,2,9,2,5,1,17,1,13,1,9,1,6,1,15,1,11,1,4,1,4,2,3,6,3,1,8,1,3,1,4,2,4,2,5,2,4,3,5,2,3,1,3,3,19,1,4,1,5,1,6,3,3,5,4,1,7,3,4,1,3,1,3,1,6,1,4,1,3,6,7,1,4,8,4,1,3,1,3,4,3,1,3,1,5,1,4,2,5,2,7,5,6,2,7,2,9,1,6,5,3,2,3,1,3,1,3,2,5,1,3,1,5,1,11,2,9,1,4,2,4,1,3,2,4,3,4,1,3,2,5,1,10,1,3,1,6,1,5,3,4,1,4,1,3,1,5,2,5,1,3,1,5,1,5,1,5,1,6,1,3,2,4,1,7,1,7,1,6,1,16,1,9,2,5,1,4,1,5,1,7,1,8,1,7,2,19,1,3,2,3,1,3,1,5,1,10,2,7,2,5,2,10,2,20,1,6,1,5,1,13,1,5,1,16,1,8,2,3,1,3,1,4,1,4,1,4,1,10,1,3,1,4,1,7,1,3,1,6,3,4,2,3,1,4,1,6,2,3,1,3,3,3,3,3,1,4,1,4,4,3,1,6,2,3,1,4,3,3,1,4,2,3,1,4,5,3,1,7,1,3,1,4,1,15,2,3,1,3,2,5,1,5,4,3,3,3,1,4,1,6,2,4,2,3,1,6,1,6,3,4,4,4,2,4,1,8,1,3,1,4,1,9,1,5,2,6,5,4,2,3,1,3,2,7,1,3,1,4,1,5,1,14,1,3,1,5,1,3,1,3,7,4,1,6,1,3,1,6,1,5,1,4,2,4,1,3,1,5,1,9,2,3,1,3,1,7,1,5,1,7,1,4,2,12,1,6,1,9,1,6,1,4,1,11,4,4,1,6,1,20,1,9,2,16,1,9,2,3,1,4,1,7,1,4,2,8,1,4,1,7,1,3,1,3,1,3,1,5,1,5,2,3,1,4,1,4,1,3,1,7,1,25,1,14,2,28,1,3,1,4,1,10,1,17,2,3,3,3,7,3,1,4,5,4,2,3,1,5,2,3,1,3,1,6,1,4,1,4,2,3,3,3,3,3,2,4,1,5,1,3,1,3,8,3,7,5,2,6,1,4,4,3,2,5,3,4,1,3,4,6,1,5,1,3,2,11,3,3,1,4,2,4,1,7,1,3,1,9,5,4,1,3,1,4,1,3,1,4,2,6,1,3,1,4,3,3,1,3,1,3,2,6,1,3,2,3,1,6,1,6,1,4,1,5,11,4,1,4,4,4,4,5,1,5,1,6,1,3,2,3,1,3,2,9,2,3,1,9,2,6,1,3,2,7,1,5,2,4,2,4,1,3,7,7,2,7,1,3,3,5,1,3,1,3,1,3,2,6,1,3,1,3,1,4,1,8,1,8,1,8,1,9,1,4,3,3,1,3,1,4,1,4,1,12,1,8,2,4,2,8,1,7,1,3,1,6,1,4,1,7,1,3,2,3,1,5,2,7,1,10,2,10,1,4,3,13,1,4,1,3,1,13,1,3,2,4,1,6,1,15,1,24,1,5,1,27,1,15,1,9,1,15,1,3,2,4,2,4,5,3,1,4,2,3,4,4,1,7,2,4,3,3,2,3,1,5,1,4,3,4,3,3,6,10,2,7,2,4,1,7,2,4,3,6,1,3,2,8,1,9,2,7,1,4,1,4,2,17,3,3,1,3,1,3,4,3,2,5,1,3,2,4,2,5,3,3,5,3,2,3,1,3,3,6,3,7,1,7,1,3,5,6,1,12,2,8,3,4,1,6,1,14,1,3,1,11,1,3,2,4,1,5,7,5,1,3,2,5,1,3,1,3,1,3,1,3,2,4,1,5,2,6,3,3,2,4,1,3,1,3,1,9,2,3,1,5,1,17,1,3,2,3,4,6,1,5,2,3,1,3,1,4,2,3,2,4,2,3,1,5,1,3,1,3,2,5,3,3,2,3,6,5,1,3,1,4,1,3,3,4,1,6,1,8,1,3,1,4,2,8,1,3,1,6,2,7,4,4,1,4,2,3,4,5,4,5,1,4,2,4,1,4,1,4,2,3,2,4,1,5,1,4,1,4,1,3,10,5,1,4,3,4,1,3,3,4,1,3,3,4,2,5,7,5,1,7,1,7,2,4,1,3,3,9,1,3,1,4,1,3,1,4,1,5,2,4,1,6,3,4,7,3,2,4,1,4,1,3,6,3,1,5,2,6,1,4,2,6,1,3,1,3,1,5,2,3,1,3,2,4,1,4,1,3,1,4,3,3,1,3,2,3,1,5,1,4,2,10,2,5,2,7,1,5,1,4,1,3,1,3,2,3,2,7,4,3,6,4,2,3,1,4,2,7,2,6,1,3,2,5,3,7,1,6,1,6,2,4,2,3,2,5,1,21,1,10,1,3,1,3,1,3,1,4,1,5,1,9,1,6,1,6,2,9,1,6,1,3,1,21,1,4,1,7,1,10,1,11,3,4,1,12,1,8,1,5,1,7,1,3,2,7,2,3,1,19,1,16,1,11,1,8,1,3,1,3,9,4,4,3,2,5,1,3,2,3,2,6,1,3,1,3,1,6,2,4,1,7,5,3,1,5,3,3,4,4,4,5,1,4,1,9,1,4,2,3,8,4,1,4,1,4,1,4,1,3,3,5,1,6,2,8,3,3,4,3,2,5,4,3,2,4,1,4,2,6,1,5,1,5,1,3,3,3,1,4,1,3,7,3,3,3,1,3,3,3,7,4,1,4,2,3,5,4,4,3,1,3,2,3,2,6,4,3,2,6,3,6,1,4,1,6,1,5,2,3,9,4,1,3,2,5,1,4,1,8,2,4,1,6,2,3,2,4,1,3,6,6,1,10,2,3,3,5,1,3,1,5,2,4,1,6,2,4,2,6,1,3,1,6,4,3,1,3,3,3,1,5,1,3,1,9,1,3,2,3,1,3,4,3,3,3,1,4,2,4,2,3,1,3,1,3,1,7,1,3,1,4,1,5,4,3,1,5,1,9,1,3,2,3,1,7,2,4,1,6,1,3,1,3,1,3,1,6,1,3,4,4,1,7,2,4,2,4,2,8,2,3,1,3,2,6,1,5,1,3,2,8,1,7,1,4,1,3,1,3,1,4,5,3,1,9,1,3,1,5,1,7,1,10,1,3,1,5,1,12,3,9,1,3,2,3,1,11,2,4,2,4,1,6,1,7,1,6,1,4,3,3,1,6,1,3,2,3,1,3,1,5,1,3,1,4,1,9,2,3,1,3,1,6,2,7,1,5,1,3,1,3,1,27,1,10,1,10,1,7,1,14,1,7,1,4,2,6,3,3,2,3,1,4,2,7,1,4,2,4,1,4,1,3,1,5,2,4,1,3,1,3,2,5,2,4,1,6,2,5,1,3,1,3,1,4,1,17,1,5,2,5,2,3,1,5,1,3,1,3,2,4,1,3,1,4,2,3,1,3,1,3,1,3,1,3,2,10,1,4,2,5,1,3,4,6,2,3,2,4,1,5,2,10,1,3,1,4,5,4,6,6,2,4,1,7,1,3,2,4,1,5,1,3,1,3,2,5,3,5,1,5,1,3,2,6,1,3,2,6,1,3,1,3,1,4,3,7,1,3,1,4,1,3,1,9,2,4,1,4,6,4,1,6,1,3,1,4,1,3,1,3,1,7,3,5,1,3,2,4,1,5,1,5,1,3,1,4,1,6,1,6,1,6,2,7,1,11,2,7,1,7,1,6,1,6,1,28,1,3,3,10,1,4,1,8,1,3,3,4,1,3,1,4,1,3,3,9,4,3,1,4,1,5,2,3,1,5,1,3,1,3,1,8,1,3,1,3,4,3,1,3,1,4,2,6,1,4,1,4,1,3,2,4,1,3,2,4,1,3,4,3,1,4,1,7,1,3,4,5,1,4,3,4,1,3,2,3,2,3,1,3,1,6,1,3,2,3,1,4,1,4,1,3,1,3,1,6,1,6,1,3,2,3,1,3,3,5,2,3,1,3,2,3,2,3,1,3,2,4,1,3,4,10,1,3,2,12,6,5,3,3,3,3,1,3,1,4,1,5,1,4,1,4,3,3,2,10,1,3,2,6,1,3,6,3,2,3,1,3,1,4,2,7,1,5,1,9,2,9,2,5,3,4,3,3,7,3,3,3,1,3,1,3,2,3,3,12,10,3,1,10,1,3,2,11,1,3,1,3,2,10,1,5,1,5,1,12,1,5,3,6,1,3,2,4,1,3,1,12,1,3,1,8,1,3,1,3,1,6,1,4,1,4,1,3,1,7,1,4,1,12,1,3,2,5,1,5,2,3,1,6,1,5,1,7,1,3,2,3,1,3,1,14,2,5,1,10,1,4,1,5,1,6,1,5,1,3,1,4,1,19,1,4,1,4,1,4,2,3,1,4,1,4,1,6,1,4,1,4,1,7,3,4,1,5,1,3,1,3,1,3,4,5,1,8,2,4,1,4,2,12,2,4,1,3,1,5,1,4,1,4,1,5,1,7,1,10,1,3,1,3,1,3,1,5,1,8,1,5,2,14,1,6,1,12,1,3,1,12,1,14,2,8,1,3,1,8,1,3,1,6,1,3,1,5,1,9,2,7,1,4,1,10,1,9,2,3,1,7,1,5,1,13,1,9,1,4,1,5,1,5,1,11,1,3,2,7,1,10,1,10,1,3,2,117,5,4,1,12,1,6,1,3,2,5,1,6,1,4,2,3,1,4,1,14,1,10,6,4,1,16,1,3,2,6,4,3,2,3,3,3,1,6,2,4,1,5,2,7,1,10,1,10,3,3,1,9,1,3,2,4,1,7,1,3,1,3,1,4,6,3,1,3,1,7,1,10,2,5,1,5,1,3,1,5,1,5,1,9,3,7,1,3,3,3,4,3,4,5,1,3,2,3,1,3,5,5,3,3,1,3,2,4,1,6,1,4,3,5,2,3,2,7,1,5,2,3,1,5,7,4,1,5,3,7,1,3,1,3,1,3,1,4,1,5,2,4,3,3,2,3,2,4,1,4,2,4,2,6,1,3,1,5,1,3,1,3,5,3,3,3,2,4,3,6,2,3,5,6,2,5,2,3,1,5,1,4,5,5,1,4,1,3,4,3,1,4,1,3,2,4,4,3,1,3,4,3,5,4,1,4,1,4,1,5,2,3,1,5,1,6,1,3,3,4,1,8,1,3,1,4,2,4,1,4,3,3,1,5,1,3,4,4,1,3,1,3,4,3,2,3,3,3,4,6,2,3,1,3,1,3,1,4,1,4,1,4,2,5,2,6,1,4,2,5,1,7,1,4,1,4,2,4,1,3,1,4,1,3,3,7,1,3,5,3,2,3,6,4,2,4,1,4,1,4,1,8,2,5,4,5,2,6,1,6,1,3,2,5,2,3,2,4,1,3,1,6,2,3,1,4,1,3,1,5,1,3,1,3,2,10,1,6,1,3,3,3,2,4,1,3,2,4,1,4,1,4,2,3,3,5,1,3,1,3,1,3,1,4,1,3,1,5,1,3,1,10,2,10,2,6,2,3,1,3,1,4,1,5,1,13,1,4,1,17,2,5,1,3,2,4,1,7,2,9,1,5,1,4,1,4,1,4,1,3,1,4,1,6,1,3,2,3,1,3,2,4,2,3,1,5,2,6,1,5,1,5,1,3,1,3,3,3,1,4,1,5,5,3,3,3,2,12,1,6,1,10,1,5,1,4,1,7,1,5,3,12,1,5,1,6,3,3,1,3,1,3,1,3,1,4,1,9,1,9,2,5,1,3,1,12,1,5,1,3,1,5,1,5,1,8,2,5,1,3,1,5,1,3,1,3,1,9,1,5,2,4,3,15,1,6,1,7,1,13,1,4,1,4,1,8,1,3,1,8,1,9,2,13,1,3,2,14,2,35,1,10,2,9,1,19,1,5,1,20,1,4,1,16,1,14,3,3,2,6,2,3,1,5,1,3,3,6,1,5,2,5,1,5,1,3,3,4,1,4,2,15,5,3,1,3,1,5,3,3,3,4,4,6,1,3,1,15,2,3,1,5,1,6,1,3,4,3,3,3,1,9,1,3,1,5,1,13,2,7,1,4,1,3,2,3,3,13,1,10,3,6,1,16,1,6,1,3,1,3,1,15,1,3,1,7,1,3,3,7,1,5,2,6,1,3,1,4,1,8,1,7,1,6,1,6,1,5,2,7,2,9,1,5,1,8,1,3,1,5,1,11,1,12,1,7,2,12,1,6,1,3,1,8,1,12,1,14,1,24,1,12,1,3,1,3,1,5,2,5,5,3,1,3,1,3,1,9,2,5,2,6,1,5,1,4,1,3,1,3,1,3,1,3,2,5,2,3,1,6,2,4,1,4,1,5,2,5,4,4,1,7,2,3,1,3,1,4,1,14,1,14,2,3,2,5,1,3,4,9,4,5,1,6,2,3,1,3,1,6,1,3,1,6,1,3,2,8,2,4,9,4,2,3,3,6,1,3,1,8,1,5,1,6,1,3,3,5,4,4,2,4,1,5,4,3,1,4,1,4,1,4,3,6,2,15,1,4,1,3,1,6,1,10,1,13,2,3,1,16,1,7,1,4,1,3,1,3,1,4,1,4,1,6,1,6,1,5,1,4,1,8,1,3,1,4,3,3,2,5,1,4,2,6,1,3,1,7,3,4,1,3,3,9,1,6,1,3,1,6,1,3,1,3,1,5,1,6,1,18,1,3,2,4,2,6,2,11,2,8,1,4,2,3,1,3,1,3,1,3,1,3,1,4,4,7,1,6,1,21,1,3,1,3,4,3,2,15,1,4,1,7,2,8,1,3,2,3,1,5,1,5,1,4,1,3,1,13,1,3,1,10,3,18,1,25,1,11,1,3,1,3,1,3,3,3,1,9,2,6,1,3,2,9,1,6,1,10,1,3,1,3,1,3,1,6,3,3,1,4,1,7,1,4,2,3,3,3,5,3,1,3,2,3,2,4,1,3,1,6,1,4,1,4,2,3,2,6,1,6,4,10,2,5,1,9,1,3,1,5,2,7,1,5,1,4,1,6,1,5,1,3,2,3,1,3,2,3,2,4,1,3,3,3,3,7,2,3,8,4,2,4,3,5,4,3,4,4,1,6,1,3,3,3,1,4,1,4,1,5,3,3,3,3,2,6,2,4,1,6,1,4,1,4,3,3,1,3,1,6,1,3,1,5,1,6,1,3,3,3,1,5,2,3,1,3,3,4,3,3,1,4,1,4,3,4,1,5,1,3,3,4,1,10,2,8,1,3,1,7,1,3,1,6,1,9,1,5,1,10,1,4,1,3,2,5,1,3,1,3,3,4,1,4,1,4,1,3,1,4,1,4,1,12,1,11,1,4,2,3,1,12,1,4,1,4,2,3,1,3,1,4,6,3,1,3,3,4,1,5,1,7,1,10,2,3,2,3,1,5,2,4,1,3,1,4,1,4,1,4,3,3,1,3,1,13,2,6,2,3,1,5,1,3,2,5,1,3,1,7,4,3,1,3,1,5,2,3,1,5,1,10,2,10,2,7,3,3,2,3,1,4,2,14,1,5,4,5,2,8,3,4,2,14,2,3,1,4,1,3,1,3,2,3,1,5,1,4,1,3,1,7,1,3,1,3,1,15,1,11,1,5,2,7,2,3,1,3,1,3,1,3,4,6,1,4,1,3,1,6,6,8,1,4,2,5,2,3,1,3,3,3,1,3,2,3,1,5,1,3,3,3,1,4,2,4,1,5,1,4,6,3,1,3,1,6,1,3,1,6,1,3,1,3,1,3,1,4,3,7,1,14,5,10,1,6,1,12,1,3,1,4,3,4,1,3,1,5,2,3,3,4,1,3,1,3,1,3,1,3,1,10,5,6,1,6,1,4,1,5,1,5,3,6,1,5,2,5,1,16,1,5,1,7,1,3,1,4,1,4,1,8,1,5,1,15,1,12,1,7,1,17,1,7,3,3,1,3,2,6,1,3,2,11,1,4,2,4,7,3,1,4,1,3,2,6,1,3,1,9,2,3,1,7,2,4,2,6,1,6,1,12,1,14,1,13,1,7,3,3,2,3,2,3,1,4,1,4,1,3,1,3,1,5,2,4,1,4,1,8,1,5,2,3,2,3,1,3,1,3,1,3,2,9,1,4,1,3,1,4,1,3,2,4,1,6,1,3,2,7,1,4,1,4,1,5,1,3,1,4,1,17,1,5,1,3,1,3,3,3,1,8,1,12,1,7,1,26,1,5,1,3,5,6,3,3,2,3,1,3,1,6,1,5,2,4,4,5,2,3,2,6,2,3,1,5,2,7,1,13,1,13,1,12,1,4,1,6,3,4,1,3,2,8,1,3,1,11,2,4,1,3,1,5,2,3,1,3,1,3,2,5,1,3,1,4,2,5,1,3,1,4,1,3,1,5,3,3,1,3,3,3,1,4,1,3,1,6,1,3,1,3,1,3,1,8,1,3,1,3,1,3,2,4,4,3,1,3,1,3,1,3,2,3,1,4,1,3,1,13,1,4,2,4,1,3,1,3,1,3,1,4,1,3,1,6,1,9,1,4,1,5,2,3,1,6,2,5,2,5,8,5,1,4,1,5,1,10,1,6,2,6,1,6,1,3,1,7,2,4,1,5,1,5,2,5,1,5,1,4,1,7,1,6,1,3,1,10,1,5,2,4,1,8,1,10,1,8,2,4,1,15,1,8,3,13,1,39,2,8,3,13,1,9,2,4,1,3,2,5,4,4,1,3,2,6,1,5,1,4,3,7,1,4,3,4,1,5,1,3,2,3,1,3,2,9,3,3,1,4,1,4,2,9,1,8,1,10,1,4,1,16,1,23,1,3,1,6,1,5,1,5,1,64,1,10,1,48,1,9,1,142,1,7,1,7,1,60,1,26,1,5,15,3,5,3,6,4,25,3,13,3,7,3,12,3,16,3,5,3,13,3,24,3,1,3,1,9,1,3,2,12,2,4,2,3,2,3,1,6,1,3,2,7,3,5,1,4,2,3,1,6,1,6,1,4,1,10,1,3,1,3,1,7,1,7,1,4,3,3,1,4,1,4,1,9,2,3,1,7,2,4,2,3,1,3,1,5,1,6,1,3,1,3,1,7,2,4,1,8,3,5,2,4,1,6,1,3,2,3,1,9,2,5,2,3,4,6,3,4,1,3,1,3,6,4,1,5,1,3,1,4,6,8,1,3,1,3,4,4,1,3,1,3,1,4,2,4,1,5,4,6,1,3,1,5,1,3,1,16,2,8,1,15,2,4,2,3,2,3,1,3,2,8,1,4,1,3,1,3,4,3,4,3,2,5,3,3,3,3,2,3,1,4,1,4,1,3,9,3,1,7,3,9,2,3,6,4,1,4,2,3,7,3,6,3,1,3,1,3,1,3,2,6,1,5,1,4,2,4,8,3,1,3,1,3,1,5,1,15,1,4,1,3,2,5,1,3,1,7,1,9,1,3,1,3,3,5,2,3,3,5,2,7,1,6,1,3,1,3,1,5,2,3,2,4,1,6,8,3,1,7,1,3,1,6,1,3,1,8,1,4,3,7,1,4,1,3,1,3,1,10,1,8,2,6,4,4,1,5,1,3,1,24,1,5,1,4,1,3,2,7,2,8,2,3,1,3,3,3,3,7,2,4,1,3,1,3,1,8,2,3,2,3,3,6,1,3,4,3,3,3,7,3,1,4,1,7,1,4,1,3,1,3,1,5,1,10,1,3,1,6,1,10,1,7,3,3,3,6,2,4,3,4,1,3,1,5,1,3,2,3,3,3,2,6,3,4,2,3,1,3,1,4,3,3,10,3,2,4,3,5,2,4,1,4,1,4,2,3,6,3,5,3,2,4,2,3,4,3,4,6,1,5,1,3,1,4,1,4,1,3,1,3,1,7,9,4,1,3,2,3,1,4,2,3,1,4,3,12,2,4,3,3,1,3,1,3,4,3,3,3,1,5,1,4,1,4,2,3,1,7,4,3,1,7,3,3,4,3,13,9,2,4,3,9,2,4,1,6,1,5,2,6,1,4,2,3,1,3,1,9,4,6,5,3,5,3,2,4,2,5,1,3,1,4,1,3,1,4,1,6,1,3,1,3,1,5,2,3,3,5,1,5,2,7,3,7,2,5,1,5,1,3,2,3,1,6,5,3,1,8,1,5,2,8,5,10,1,8,1,5,2,10,1,12,1,7,1,3,4,6,1,3,1,7,1,3,3,5,1,3,1,3,2,3,1,3,1,9,1,6,3,3,2,3,1,10,1,3,1,4,1,6,1,15,1,4,1,3,1,5,3,4,1,3,1,3,1,4,1,6,2,4,1,4,2,3,1,4,1,8,1,3,2,4,1,3,2,7,1,5,1,13,1,4,1,14,1,6,1,3,1,5,1,4,1,6,1,3,1,11,2,12,7,7,1,6,3,13,1,4,1,6,1,7,1,5,1,11,1,3,1,6,3,4,1,7,2,3,1,9,1,13,2,9,1,5,1,3,1,5,3,8,1,3,1,9,1,9,1,7,2,4,1,3,1,8,1,9,1,6,1,19,1,5,1,7,1,13,1,6,1,18,1,3,1,16,1,5,1,18,5,4,1,7,1,5,1,5,1,10,2,3,1,4,1,9,10,9,4,7,1,3,1,8,2,7,2,4,4,3,1,4,3,4,3,5,1,7,1,5,1,3,2,3,3,4,4,4,1,5,2,3,1,4,2,6,1,6,1,5,2,3,5,5,2,6,1,3,1,3,2,5,4,4,1,6,2,3,1,3,2,3,1,3,1,3,1,4,3,3,1,5,1,6,1,4,1,4,1,4,1,5,1,4,2,9,3,4,1,3,1,6,1,5,1,3,1,8,1,4,3,10,1,3,1,5,1,3,1,6,4,5,2,3,1,4,1,4,1,3,1,7,1,5,1,9,1,10,1,4,3,3,1,5,1,3,1,6,1,4,1,4,1,7,1,5,2,7,3,9,1,6,1,6,1,6,1,5,1,12,1,6,1,6,1,8,1,10,1,3,2,6,1,7,2,17,1,8,1,4,1,5,1,5,2,8,2,8,1,4,1,3,1,9,5,4,2,3,2,3,1,3,1,3,1,6,1,7,3,3,2,3,2,4,1,4,1,3,1,6,1,5,1,7,1,7,1,3,1,8,1,3,1,5,1,7,1,6,1,6,2,4,2,4,1,6,1,5,1,3,2,4,2,7,1,4,4,4,1,9,2,3,2,5,2,4,1,3,1,5,1,9,1,7,1,3,2,7,3,7,1,5,1,6,2,6,1,5,1,3,1,12,1,4,1,27,2,8,1,22,1,5,1,3,1,3,1,4,1,60,2,3,9,3,5,5,1,5,1,3,1,3,1,6,1,3,2,6,1,5,1,5,1,14,1,8,1,56,1,11,1,50,1,17,2,10,1,117,1,32,1,65,1,7,1,53,12,3,4,3,9,3,11,3,8,3,25,3,30,3,20,3,25,11,1,6,2,3,1,4,1,10,1,6,1,8,2,9,2,9,1,6,3,9,1,4,1,5,2,3,1,9,1,5,1,134,3,3,48,4,4,3,7,3,5,3,2,5,1,3,1,4,1,4,5,11,1,4,2,6,2,7,1,4,1,12,1,5,1,15,1,3,3,4,1,3,1,3,1,3,2,5,2,3,1,6,2,3,2,3,1,6,2,4,2,3,3,5,2,5,1,3,3,4,1,5,1,3,1,3,5,3,1,9,1,5,2,3,1,4,1,6,1,10,3,4,2,7,2,3,1,3,2,3,1,5,1,5,2,4,1,4,3,3,1,4,5,7,2,8,1,14,1,4,1,4,2,3,2,3,1,3,1,3,1,7,1,4,1,3,1,5,1,3,1,9,2,5,1,9,1,3,1,14,2,4,1,4,1,9,1,21,1,153,4,3,21,3,11,3,5,3,10,3,2,5,1,6,2,3,1,6,2,6,1,4,1,5,2,4,2,3,2,3,2,7,1,3,2,3,3,4,2,3,5,4,1,3,3,3,4,3,2,3,1,4,1,5,3,5,1,4,7,4,3,3,1,3,4,3,1,3,2,4,2,3,6,5,1,8,3,7,2,3,1,4,2,3,1,4,2,3,1,4,1,7,1,3,5,5,2,4,1,8,2,3,1,4,1,6,2,7,2,9,1,3,2,3,2,6,1,4,1,7,1,3,1,3,1,3,1,3,1,3,1,3,1,5,3,4,1,5,1,3,1,3,4,3,4,3,4,4,1,4,1,4,2,3,1,4,1,5,4,3,1,5,1,5,3,5,2,5,3,4,1,3,1,3,1,6,1,5,1,6,2,5,1,3,1,22,1,6,1,5,2,13,1,3,1,9,1,11,1,4,1,4,8,3,1,6,1,4,1,4,2,4,5,5,2,3,1,3,5,3,6,5,3,7,1,3,1,3,1,3,3,4,3,9,2,8,2,8,1,4,3,6,2,6,1,14,1,3,2,3,4,3,1,12,1,153,1,27,1,33,1,27,1,119,1,45,1,38,1,60,1,13,1,105,1,46,1,27,12,3,4,3,1,3,46,3,7,3,3,4,5,3,11,3,20,3,32,3,3,3,6,3,11,3,9,3,5,3,4,3,2,3,9,3,4,3,5,3,13,3,5,4,1,10,1,106,4,3,18,3,7,3,11,3,4,3,2,3,2,3,1,3,2,9,1,5,1,4,6,6,3,3,2,3,1,3,6,3,3,4,1,5,2,7,1,5,1,3,2,3,1,4,4,3,1,7,1,3,4,15,2,3,1,4,1,3,1,3,2,5,1,4,3,4,1,12,1,10,1,4,1,4,1,4,1,4,3,3,2,4,4,3,1,4,4,4,1,4,1,12,1,9,3,6,1,5,1,4,2,3,1,6,1,3,2,4,1,3,4,5,3,5,1,4,1,7,1,3,1,13,1,4,1,4,1,3,1,7,2,6,1,21,2,4,1,4,1,3,1,4,1,3,3,4,1,5,1,11,2,3,1,7,1,10,1,7,1,3,1,5,2,3,1,5,1,9,1,4,1,9,1,3,1,3,1,4,1,3,1,51,2,3,5,7,1,3,2,128,22,3,2,3,3,3,2,3,3,3,9,3,4,40,1,4,3,3,1,4,3,5,2,9,2,38,1,4,1,31,1,39,2,15,1,3,1,3,12,3,4,4,1,3,2,3,3,4,5,3,2,3,1,3,11,13,1,4,1,197,6,3,16,3,5,3,3,4,5,4,3,3,12,3,2,9,2,6,3,3,1,3,1,5,3,4,1,7,2,6,1,3,1,6,1,8,1,3,1,6,1,6,1,3,1,3,1,11,1,3,1,9,1,6,1,8,1,5,1,13,1,5,1,13,1,4,1,10,2,6,5,3,3,5,1,3,1,3,1,4,1,297,1,4,1,3,2,4,4,4,1,3,2,3,3,3,2,6,3,3,12,3,1,3,2,3,9,3,4,7,5,4,7,4,7,4,4,4,1,318,5,3,2,3,6,3,1,3,3,3,6,4,3,3,12,3,2,3,1,5,1,3,2,3,3,3,1,6,2,3,8,4,2,3,1,12,2,4,1,6,2,4,1,8,2,11,1,3,1,8,1,15,1,5,1,4,1,3,2,7,1,6,1,5,3,3,1,4,1,5,1,4,3,3,2,3,1,4,1,3,1,3,2,6,1,11,1,3,2,3,1,14,1,3,2,3,1,4,1,5,1,3,1,8,1,3,1,11,1,4,1,9,1,3,1,3,1,3,2,7,1,13,2,47,2,4,10,14,3,5,2},
        ['ku-am'] = {1040,22,3,4,4,1,4,22,3,4,4,1,110,2,30,2,14,2,52,4},
        ['und-zmth'] = {32,2,3,1,6,9,11,1,3,1,4,3,27,4,4,1,27,4,36,2,11,1,5,2,5,1,3,1,9,1,25,1,33,1,59,1,472,1,3,1,3,1,45,1,90,1,19,1,4,1,12,1,19,1,19,1,28,1,7207,1,11,3,5,1,31,1,20,1,139,1,34,1,13,1,3,1,6,1,4,1,13,1,221,1,3,2,3,2,3,1,8,1,4,1,3,1,10,2,6,1,5,1,14,1,3,1,3,2,6,3,77,1,4,1,5,1,16,1,3,1,29,1,9,1,6,2,59,4,24,1,639,1,583,4,109592,1,87,1,73,1,5,1,4,1,5,1,147,1,6,1,7,1,5,1,347,1},
        ['sv'] = {65,26,8,26,71,2,4,2,5,1,3,1,12,1,7,1,5,2,4,2,5,1,3,1,12,1,7,1},
        ['am'] = {4608,7,3,15,3,15,3,9,9,15,3,1,3,4,20,15,3,23,3,1,3,4,4,31,3,1,3,4,20,7,3,7,3,23,3,8,10,15,3,1,3,4,12,39,3,15},
        ['hz'] = {65,26,8,26,694,1,6884,2,56,2},
        ['kr'] = {65,26,8,26,277,1,80,1,112,2},
        ['sn'] = {65,26,8,26},
        ['lah'] = {1569,4,3,3,19,1,8,2,3,3,3,1,50,1,6,1,9,1,3,1,10,1,8,1,18,1,7,1,12,1,5,1,6,1,10,1,7,1},
        ['dz'] = {3904,8,3,33,9,6,3,1,3,4,4,2,16,8,3,33},
        ['su'] = {65,26,8,26,80,1,33,1},
        ['hr'] = {65,26,8,26,141,2,6,2,4,2,80,2,29,2},
        ['ce'] = {1025,1,6,1,11,64,3,1},
        ['be'] = {1030,1,9,1,3,64,8,1,9,1},
        ['sr'] = {1026,1,7,4,5,10,3,15,9,9,3,15,11,1,7,4,5,1},
        ['kn'] = {3202,2,3,8,3,3,3,23,3,10,3,5,6,7,3,3,3,4,9,2,9,1,3,2},
        ['ln'] = {65,26,8,26,72,2,8,2,4,2,6,2,7,2,7,2,8,2,4,2,6,2,7,2,32,2,108,1,11,1,197,1,8,1,167,2,11,1},
        ['fur'] = {65,26,8,26,71,3,7,1,5,1,7,1,8,1,8,3,7,1,5,1,7,1,8,1},
        ['nn'] = {65,26,8,26,71,1,5,3,4,2,9,3,3,1,3,1,5,1,5,1,5,3,4,2,9,3,3,1,3,1,5,1},
        ['nqo'] = {1984,59},
        ['wal'] = {4608,7,3,15,3,15,3,9,9,15,3,1,3,4,4,7,3,1,3,4,4,15,3,23,3,1,3,4,4,31,3,1,3,4,12,1,3,4,4,7,3,7,3,23,3,8,10,15,3,1,3,4,12,39,3,15},
        ['ss'] = {65,26,8,26},
        ['bn'] = {2433,3,3,8,4,2,4,22,3,7,3,1,5,4,4,1,3,7,4,2,4,3,16,2,3,1},
        ['shs'] = {55,1,11,1,3,1,3,1,3,3,3,11,3,3,9,1,3,1,3,1,3,3,3,11,3,3,73,1,9,1,5,1,21,1,9,1,5,1,551,1},
        ['hsb'] = {65,26,8,26,90,1,33,1,20,2,6,2,14,2,39,4,21,2,8,2,25,2,4,2},
        ['en'] = {65,26,8,26,71,1,8,5,5,1,3,1,4,1,3,1,11,1,8,5,5,1,3,1,4,1,3,1},
        ['so'] = {65,26,8,26},
        ['gn'] = {65,26,8,26,72,1,9,1,5,1,5,1,3,1,8,1,8,1,3,1,7,1,5,1,5,1,3,1,3,1,6,1,48,1,65,1,7509,1,61,1},
        ['sma'] = {65,26,8,26,75,2,11,1,8,1,15,2,11,1,8,1},
        ['csb'] = {65,26,8,26,74,1,7,1,3,1,8,3,6,1,11,1,7,1,3,1,8,3,6,1,12,2,61,4,56,2},
        ['doi'] = {2306,2,3,8,4,2,4,22,3,7,3,1,4,5,4,9,4,2,4,3,4,3,10,21},
        ['sm'] = {65,26,8,26,578,1},
        ['smn'] = {65,26,8,26,72,2,3,1,30,2,3,1,41,2,4,2,58,2,22,2,29,2},
        ['ky'] = {1025,1,16,64,3,1,82,2,12,2},
        ['fy'] = {65,26,8,26,73,1,3,1,6,3,5,1,6,1,3,1,5,3,4,1,4,1,3,1,6,3,5,1,6,1,3,1,5,3},
        ['smj'] = {65,26,8,26,72,1,4,2,13,1,17,1,4,2,13,1},
        ['hy'] = {1329,38,12,39},
        ['an'] = {65,26,8,26,72,1,9,1,5,1,5,1,3,1,8,1,3,1,6,1,9,1,5,1,5,1,3,1,8,1,3,1},
        ['sl'] = {65,26,8,26,141,2,6,2,4,2,80,2,29,2},
        ['ay'] = {65,26,8,26,75,1,12,1,3,1,12,1,9,1,12,1,3,1,12,1},
        ['sk'] = {65,26,8,26,72,1,4,1,6,1,5,1,7,2,7,1,4,1,5,1,4,1,6,1,5,1,7,2,7,1,4,1,16,4,43,2,4,2,10,2,13,2,12,2,4,2,25,2},
        ['cy'] = {65,26,8,26,73,1,8,2,5,2,6,1,15,1,8,2,5,2,6,1,12,1,118,5,7433,6,110,2},
        ['ber-dz'] = {65,26,8,26,147,2,132,1,5,1,83,2,117,1,9,1,7082,2,24,2,62,2,10,2,38,2},
        ['af'] = {65,26,8,26,79,4,4,2,6,1,8,1,14,4,4,2,6,1,8,1,79,1},
        ['ht'] = {65,26,8,26,79,1,11,1,23,1,11,1},
        ['sid'] = {4608,7,3,15,3,15,3,9,9,15,3,1,3,4,4,7,3,1,3,4,4,15,3,23,3,1,3,4,4,31,3,1,3,4,12,1,3,4,4,7,3,7,3,23,3,8,10,15,3,1,3,4,12,39,3,15},
        ['ku-ir'] = {1574,3,3,1,3,4,3,4,6,2,8,2,3,5,55,1,9,1,13,1,7,1,13,1,6,1,7,1,7,1,18,1,7,1,3,1},
        ['sq'] = {65,26,8,26,78,1,5,1,29,1,5,1},
        ['ng'] = {65,26,8,26},
        ['mg'] = {65,26,8,26,72,1,20,1,14,1,20,1},
        ['lg'] = {65,26,8,26,209,2},
        ['quz'] = {65,26,8,26,88,1,33,1,472,1},
        ['mi'] = {65,26,8,26,135,2,18,2,24,2,34,2,30,2,7370,2},
        ['ig'] = {65,26,8,26,7761,4,24,2},
        ['sg'] = {65,26,8,26,73,1,3,1,7,2,4,2,6,1,3,1,6,2,7,1,3,1,7,2,4,2,6,1,3,1,6,2},
        ['io'] = {65,26,8,26},
        ['mni'] = {2404,1,30,3,3,8,4,2,4,22,3,7,3,1,5,4,4,9,4,2,4,4,15,2,3,1,8,10,3,1},
        ['sc'] = {65,26,8,26,71,1,9,1,5,1,7,1,8,1,8,1,9,1,5,1,7,1,8,1},
        ['ny'] = {65,26,8,26,251,2},
        ['my'] = {4096,34,3,5,3,2,3,7},
        ['bg'] = {1040,27,3,1,3,29,3,1,3,2},
        ['syr'] = {1808,29,5,16},
        ['bin'] = {65,26,8,26,71,2,8,2,4,2,6,2,7,2,7,2,8,2,4,2,6,2,7,2,519,2,7096,2,20,2},
        ['mn-mn'] = {1025,1,16,64,3,1,94,2,58,2},
        ['sah'] = {1025,1,16,64,3,1,68,2,16,2,10,2,12,2,30,2},
        ['rw'] = {65,26,8,26},
        ['ro'] = {65,26,8,26,73,1,13,1,21,1,13,1,21,2,278,4},
        ['rn'] = {65,26,8,26},
        ['qu'] = {65,26,8,26,88,1,33,1,472,1},
        ['pt'] = {65,26,8,26,71,4,5,4,4,1,6,4,6,1,3,1,5,4,5,4,4,1,6,4,6,1,3,1},
        ['ps-pk'] = {1569,4,3,21,8,2,3,5,3,1,51,1,3,1,4,1,5,2,4,1,11,1,4,1,3,1,3,1,16,1,3,1,18,1,18,1,4,1,3,1},
        ['xh'] = {65,26,8,26},
        ['prs'] = {1569,4,3,21,8,2,3,5,4,1,10,1,43,1,9,1,19,1,18,1,7,1,30,1},
        ['pes'] = {1569,4,3,21,8,2,3,5,4,1,10,1,43,1,9,1,19,1,18,1,7,1,30,1},
        ['sh'] = {65,26,8,26,141,2,6,2,4,2,80,2,29,2,645,1,7,4,5,65,4,1,7,4,5,1,52,2,6,2,8,4,8,2,4,2,12,2,30,2,16,2},
        ['th'] = {3585,58,6,16},
        ['hne'] = {2309,53,7,15},
        ['pa'] = {2565,6,6,2,4,22,3,7,3,2,3,2,3,2,4,1,3,5,6,2,4,3,13,4,21,5},
        ['ota'] = {1569,2,5,21,8,8,55,1,9,1,19,1,22,1,3,1,30,1},
        ['or'] = {2817,3,3,8,4,2,4,22,3,7,3,2,4,4,4,8,5,2,4,3,10,2,6,2,3,3},
        ['mh'] = {65,26,8,26,135,2,59,2,10,2,7,2,30,2},
        ['vot'] = {65,26,8,26,75,1,19,1,7,1,9,1,19,1,7,1,101,2,29,2},
        ['oc'] = {65,26,8,26,71,2,7,3,5,1,6,2,8,1,7,2,7,3,5,1,6,2,8,1},
        ['yap'] = {65,26,8,26,75,1,8,1,12,1,15,1,8,1,12,1},
        ['ku-tr'] = {65,26,8,26,78,1,4,1,5,1,14,1,13,1,4,1,5,1,14,1,100,2},
        ['nr'] = {65,26,8,26},
        ['pap-aw'] = {65,26,8,26,88,1,33,1},
        ['ne'] = {2305,3,3,7,5,2,4,22,3,7,3,1,4,5,6,6,5,2,4,3,4,1,21,13},
        ['kw'] = {65,26,8,26,135,2,18,2,24,2,34,2,30,2,200,2},
        ['sat'] = {2305,3,3,6,6,2,4,22,3,7,3,1,4,1,4,2,4,7,6,2,4,3,4,1,21,13},
        ['ch'] = {65,26,8,26,73,1,16,1,12,1,7,1,16,1,12,1},
        ['zh-tw'] = {19968,2,3,1,5,11,4,3,3,2,6,2,8,1,6,1,3,2,3,4,6,2,3,2,7,2,3,1,3,2,4,1,3,3,4,2,4,1,3,2,4,4,11,1,11,1,12,2,4,3,3,1,3,1,4,4,4,5,5,1,3,1,4,2,3,2,3,3,3,1,4,4,6,1,4,1,4,2,7,5,3,6,3,1,8,7,3,4,3,1,3,3,4,2,8,8,5,1,3,1,3,4,3,2,4,4,3,9,4,2,5,1,6,1,11,2,3,2,4,2,3,1,3,1,3,6,3,1,3,1,4,4,4,25,4,1,3,4,3,3,4,23,3,1,3,1,3,4,3,5,3,5,17,2,4,2,3,3,3,3,5,7,3,1,3,3,3,5,3,2,3,12,12,1,3,2,3,1,3,6,3,1,5,1,3,1,6,3,3,1,3,5,3,12,3,6,3,9,3,3,3,1,3,1,3,1,6,1,5,2,3,1,3,11,3,1,3,1,3,1,3,1,4,12,4,4,3,4,3,6,4,1,4,1,4,1,3,2,3,1,3,1,5,4,4,2,3,3,3,7,5,2,10,13,3,2,3,3,3,2,3,8,4,2,3,1,3,5,4,2,3,1,4,1,4,8,3,6,3,1,3,2,3,2,3,1,3,4,3,11,5,6,3,2,3,1,3,1,4,4,3,3,4,2,4,2,3,6,3,7,3,3,3,7,3,3,6,1,3,2,3,1,3,7,3,3,3,1,3,3,3,4,4,1,5,4,5,1,5,1,8,1,3,2,4,1,3,1,3,5,3,2,7,1,3,1,3,1,3,2,6,1,3,1,5,2,6,2,3,1,4,3,7,3,3,1,3,5,3,1,5,1,4,2,5,3,3,2,16,2,3,1,3,2,3,3,4,1,4,2,3,1,4,5,3,1,3,1,3,4,4,2,6,3,4,1,4,2,4,3,5,1,3,4,3,4,3,2,7,1,3,2,3,2,3,6,5,1,3,3,5,6,3,2,8,7,4,1,3,2,3,2,3,4,3,6,4,7,5,1,3,1,4,4,3,1,5,2,4,1,4,1,4,6,14,2,3,1,3,4,5,1,3,1,5,1,6,2,3,5,3,1,3,3,4,3,3,1,4,1,3,1,5,3,3,3,3,2,3,3,3,2,7,2,3,4,3,6,4,3,3,2,3,2,3,5,8,1,4,1,3,3,4,1,4,1,3,1,4,6,3,3,3,4,3,2,5,4,4,1,4,1,3,1,3,1,3,2,3,1,4,1,7,1,3,6,3,1,3,3,3,2,4,1,4,1,3,1,7,1,5,2,4,1,3,1,3,5,3,4,6,2,3,1,6,2,6,1,3,1,6,1,3,1,9,1,6,4,3,1,8,1,3,2,5,1,5,1,3,6,3,12,3,1,4,1,4,2,6,1,3,2,3,13,7,2,3,6,5,11,3,2,3,1,3,5,3,4,3,4,3,4,3,1,5,2,6,1,13,9,4,2,4,10,3,9,3,1,3,3,4,4,3,3,4,2,3,1,3,1,7,3,4,13,3,1,4,3,3,16,6,2,8,1,9,1,3,3,3,8,3,2,4,3,5,2,3,4,3,1,3,1,3,10,3,5,3,1,4,1,4,1,13,2,4,1,3,14,3,2,3,1,3,2,3,4,3,1,3,2,3,6,4,3,6,1,3,2,3,6,5,1,12,3,5,10,4,9,3,5,4,3,3,2,3,1,3,8,3,5,4,3,3,1,7,1,5,2,3,21,4,5,3,1,3,9,7,1,4,1,5,2,3,2,3,7,3,1,3,1,3,2,4,5,3,6,5,3,3,1,9,1,3,2,3,1,3,3,3,5,3,4,3,6,4,2,3,3,3,1,3,1,6,1,5,4,5,1,3,1,3,5,3,13,3,4,6,10,6,5,4,1,3,1,3,4,3,2,9,4,3,5,5,6,6,3,3,4,3,2,3,6,5,1,3,2,4,1,4,2,3,5,4,2,3,1,4,2,4,1,3,1,8,1,3,2,6,1,3,4,4,7,6,3,3,1,3,1,3,3,3,3,3,2,6,3,3,5,4,2,8,1,4,1,3,2,5,1,3,1,3,10,16,2,3,1,3,1,3,4,3,1,3,9,5,3,4,1,3,2,9,2,4,1,5,3,3,5,3,4,3,4,10,1,8,2,3,3,3,2,3,1,3,3,4,2,5,2,3,3,3,1,3,2,8,1,4,7,3,1,3,1,4,3,3,14,4,3,3,11,3,1,5,1,6,1,3,4,3,2,3,3,3,4,3,14,3,1,3,1,3,1,10,8,3,5,3,5,3,2,5,4,4,1,4,1,3,1,3,1,3,1,4,3,4,11,3,7,4,4,3,2,5,1,5,6,3,1,3,2,3,2,3,2,3,2,3,1,3,1,8,1,3,4,3,2,4,5,6,2,3,6,3,4,3,3,4,3,4,3,3,2,4,1,6,1,6,2,3,4,5,1,4,1,7,4,4,1,3,4,3,2,3,1,5,1,3,1,3,2,3,1,3,7,3,1,7,2,5,1,3,1,3,1,5,2,3,4,5,4,3,3,3,2,3,1,3,1,5,3,6,1,3,3,3,2,3,5,3,4,3,11,6,1,4,4,3,2,4,4,5,2,3,9,7,2,3,6,4,6,3,2,3,1,3,4,3,11,3,1,3,1,3,5,3,2,3,4,3,3,3,3,4,7,4,8,3,1,7,2,3,1,4,1,3,1,3,1,3,5,3,2,3,3,4,1,3,1,5,1,5,2,6,1,3,5,4,1,3,1,3,5,3,5,3,2,4,4,3,4,3,7,3,1,3,4,3,2,3,2,4,1,8,2,3,4,3,1,5,2,7,3,3,3,3,4,3,1,4,6,4,1,4,3,3,1,4,1,3,21,3,1,3,8,9,15,3,2,3,7,6,7,3,1,3,1,3,1,3,3,3,1,3,3,3,2,4,2,4,2,3,2,3,3,3,2,3,2,3,6,3,1,3,5,3,1,3,1,5,1,5,5,4,1,3,1,3,2,4,4,3,2,3,6,3,4,3,1,4,4,5,1,3,2,3,1,3,4,3,1,3,2,3,2,3,1,3,1,3,1,3,3,3,3,3,2,3,2,4,2,3,1,3,6,7,7,5,3,3,1,4,4,3,2,7,4,3,4,4,5,3,5,3,1,3,2,6,15,3,5,4,2,3,1,3,1,8,1,3,2,4,12,4,2,5,1,6,1,4,1,3,2,4,1,3,1,3,1,5,2,3,1,5,6,3,4,4,5,4,7,4,3,3,2,4,2,4,1,3,4,3,4,3,4,3,1,3,2,6,4,3,1,9,1,3,6,3,7,9,1,3,19,3,1,3,4,15,7,3,3,3,3,3,6,4,2,10,1,3,1,3,3,3,2,4,1,3,4,3,1,3,1,3,3,6,2,5,5,3,2,3,1,3,2,3,3,3,4,3,8,6,1,3,11,3,2,3,5,3,1,3,1,3,4,3,1,3,3,4,1,5,1,6,1,5,2,3,1,3,3,3,2,4,1,3,2,6,1,3,2,3,7,3,1,3,5,4,1,6,4,3,1,3,2,3,7,6,4,3,7,3,2,3,2,3,1,3,2,4,1,3,2,4,2,3,1,3,1,3,1,3,1,3,2,3,3,3,1,6,6,4,4,4,1,4,1,3,5,4,1,3,1,5,3,4,3,3,1,5,1,3,1,3,1,4,1,4,8,3,1,3,7,4,2,3,1,3,1,7,2,3,3,6,2,3,2,3,3,6,6,5,3,3,3,3,3,3,5,4,11,3,5,3,2,3,4,3,1,3,1,3,1,4,7,3,1,7,3,4,3,5,1,3,7,3,5,3,10,6,1,4,2,3,9,3,1,4,19,3,5,4,1,3,2,3,3,4,2,4,1,5,2,3,2,3,2,3,2,3,2,5,1,4,4,3,2,3,2,3,1,3,1,4,3,3,4,5,2,3,2,3,1,3,4,5,1,5,1,4,2,3,1,3,5,3,2,6,1,3,4,5,1,6,1,3,2,3,1,3,5,3,3,3,2,3,4,4,7,4,8,5,3,5,4,3,2,3,4,5,2,3,8,4,1,4,3,3,1,3,7,3,1,3,1,5,1,4,2,3,4,3,6,5,2,3,2,3,3,4,1,3,2,3,3,3,1,3,3,3,2,3,2,3,1,3,2,10,15,3,6,3,3,3,12,4,4,3,1,3,1,8,8,3,1,4,2,4,1,4,3,4,4,3,3,4,15,3,1,14,3,3,8,3,3,3,1,3,1,3,4,4,4,3,2,3,2,6,1,9,3,3,14,3,13,3,1,3,3,4,6,3,4,3,1,3,1,11,13,3,4,3,4,3,4,3,4,3,5,3,1,3,4,3,1,5,1,5,3,3,2,3,2,4,1,3,1,3,2,5,1,4,4,4,12,4,5,3,1,3,2,3,3,3,3,3,4,3,3,3,1,3,8,3,2,3,1,3,1,3,1,3,2,7,6,3,5,3,1,5,2,3,1,3,1,3,2,3,1,4,16,3,1,3,1,3,1,3,2,3,3,3,9,10,1,3,1,7,3,4,9,3,2,3,3,4,13,3,2,4,4,3,3,3,3,3,3,4,3,5,7,3,1,3,3,3,2,3,1,3,3,3,1,5,1,4,7,4,6,3,2,3,5,5,5,3,1,3,7,8,8,3,2,3,9,3,2,3,5,3,1,3,2,3,8,17,10,3,4,3,2,3,5,4,1,3,1,3,15,3,7,16,25,5,3,3,7,3,4,19,6,3,1,4,3,3,1,3,7,3,18,4,7,12,1,3,3,3,1,3,6,4,4,3,4,4,6,3,4,3,7,3,1,3,4,3,11,3,11,13,2,3,1,3,15,3,2,3,9,3,3,3,3,3,5,3,10,4,1,14,1,4,8,3,7,3,3,3,11,3,7,4,5,3,1,5,5,3,1,9,1,3,2,3,5,5,2,3,7,5,5,3,6,3,10,3,1,3,1,4,1,4,1,3,6,4,2,3,2,3,6,3,5,3,5,4,1,3,4,3,4,9,5,3,5,3,1,3,3,3,4,3,1,3,1,3,6,6,1,3,3,3,1,3,2,3,3,3,6,4,2,3,8,3,2,3,2,3,1,4,5,4,7,3,3,4,7,4,7,4,2,4,4,3,1,3,3,3,1,3,1,3,2,3,3,6,1,3,1,3,7,4,3,5,7,3,1,3,1,4,1,4,11,4,6,4,1,6,1,5,3,3,4,3,1,3,8,3,2,3,2,3,3,3,3,3,2,4,4,3,3,3,1,3,6,6,6,3,2,4,2,4,2,3,3,3,2,4,2,3,2,4,10,6,4,4,1,3,20,8,2,3,4,3,5,4,1,3,3,3,6,4,2,8,3,3,1,3,1,3,2,3,1,4,1,3,2,8,7,3,2,3,3,3,1,3,1,3,1,3,5,3,1,3,7,3,1,3,1,5,1,3,8,4,2,4,6,5,1,3,4,7,4,4,5,3,2,3,5,3,2,3,1,5,1,3,7,4,1,4,1,5,1,3,7,3,1,4,2,3,1,3,2,3,4,3,1,3,3,3,4,4,1,3,4,3,3,4,4,3,1,3,2,3,4,3,2,4,1,3,1,3,5,4,3,3,5,4,1,3,3,4,8,7,5,3,7,3,1,3,3,3,2,3,5,11,1,3,2,3,17,3,1,3,5,3,1,3,4,3,6,3,4,3,2,3,1,16,3,3,10,6,7,3,13,5,8,4,6,3,16,3,1,3,1,4,1,20,3,3,3,3,1,3,2,3,3,5,2,3,4,3,3,3,5,4,6,4,7,3,2,3,7,3,2,24,1,3,3,3,2,3,6,3,9,3,3,3,4,4,6,3,2,5,3,3,6,4,15,16,1,3,4,3,4,3,9,3,1,3,6,3,2,3,7,3,16,8,5,3,12,3,1,15,1,6,1,6,2,3,4,3,3,3,3,3,4,3,2,4,5,3,2,3,4,3,11,3,2,3,2,3,10,4,8,8,2,4,1,8,2,3,2,3,5,3,4,3,1,3,2,3,15,3,5,3,1,3,5,3,4,3,1,4,8,4,2,6,1,10,1,3,5,4,4,4,4,3,3,4,8,3,7,4,1,3,1,3,1,3,7,3,1,3,5,3,1,3,4,11,1,3,2,4,10,4,1,3,4,3,1,3,5,4,3,3,4,3,6,3,1,3,6,3,1,3,1,8,1,9,4,3,3,3,1,3,1,4,3,3,8,4,3,3,9,3,1,5,4,5,2,3,6,3,1,6,2,3,3,5,3,3,3,3,1,7,9,5,1,3,2,3,3,3,4,3,1,6,5,5,1,3,3,5,4,5,5,4,5,5,1,3,2,3,1,3,1,4,1,5,2,3,1,3,4,3,10,3,3,3,10,3,2,4,3,4,1,3,2,3,10,4,1,4,1,6,1,5,4,3,1,4,3,3,3,3,1,3,3,3,4,3,1,4,6,3,1,4,3,3,6,4,2,3,4,3,2,3,3,4,1,3,2,3,2,4,11,3,2,3,3,3,3,3,2,4,1,3,1,3,3,3,3,4,2,4,2,3,2,5,3,3,12,3,2,3,3,3,3,3,4,3,4,3,1,3,3,3,6,3,3,3,3,4,2,3,1,3,1,4,1,4,6,4,1,5,7,3,1,3,2,3,1,3,1,3,7,5,7,3,1,3,6,3,1,3,1,3,2,3,2,3,17,3,5,3,6,15,4,3,2,3,2,3,18,3,2,3,2,3,9,3,6,3,4,3,1,3,3,3,9,3,1,5,1,8,2,3,2,4,12,5,6,3,4,3,1,4,1,3,28,23,3,5,13,3,5,5,13,3,13,3,6,3,2,19,3,3,2,4,4,3,2,3,7,3,1,3,10,3,24,3,16,3,5,4,1,4,1,3,1,21,5,3,10,4,12,3,10,3,5,3,3,3,2,4,6,3,1,3,16,3,1,4,2,3,4,4,3,16,2,5,4,3,3,3,4,3,13,4,2,4,7,3,2,3,2,3,27,3,1,5,1,16,5,3,2,3,6,3,9,3,6,4,3,4,4,4,3,3,1,3,6,3,3,3,11,3,8,3,4,3,1,12,8,3,2,3,2,3,8,3,2,3,8,3,2,4,3,3,7,3,1,3,6,3,4,3,1,3,6,8,1,3,21,3,1,3,3,3,2,3,6,3,10,6,2,4,1,4,10,3,4,3,8,3,1,4,1,4,3,3,4,4,4,3,7,3,1,4,10,3,6,3,6,5,7,3,6,3,9,3,3,3,1,6,2,4,4,3,2,3,10,3,4,6,2,4,1,3,1,3,1,3,1,3,2,6,5,5,1,5,1,4,6,3,3,6,1,3,1,4,1,6,1,3,7,3,3,3,2,3,1,5,1,8,4,3,2,3,3,3,4,4,4,3,3,3,3,3,1,12,2,4,2,3,8,3,2,3,1,3,1,3,1,4,6,3,1,4,1,5,1,3,4,3,6,3,2,3,1,7,5,5,1,5,1,8,4,3,2,3,1,3,4,3,1,3,3,3,1,3,3,3,15,3,1,3,1,3,1,3,1,7,1,4,1,3,1,4,3,3,4,3,2,6,2,3,1,3,1,4,1,3,9,4,2,3,4,3,1,4,5,3,1,4,2,4,16,4,3,3,1,3,3,3,5,4,4,3,5,5,3,3,3,3,1,5,2,3,5,3,3,3,3,4,1,3,2,4,1,4,2,6,3,3,3,4,2,4,5,3,2,4,1,6,2,3,4,3,3,3,2,3,1,3,7,4,1,4,2,4,1,3,4,3,7,5,1,3,2,3,1,3,3,3,3,3,4,3,7,4,3,3,2,3,4,3,4,3,4,3,2,3,2,4,10,3,1,3,3,5,2,6,1,4,1,3,8,4,4,3,1,3,3,3,1,3,5,3,1,4,3,3,2,3,1,3,4,9,2,3,12,7,2,3,3,4,1,3,3,4,4,3,4,5,2,3,3,3,1,5,1,4,8,4,3,3,3,3,4,5,2,3,3,3,3,6,5,3,6,4,8,3,3,3,2,3,4,3,18,4,1,5,6,7,1,3,4,3,3,3,2,3,3,6,8,3,2,3,3,3,2,3,4,3,4,6,3,3,9,3,1,4,1,3,1,3,5,3,2,7,3,3,1,3,1,3,6,3,11,10,1,5,2,3,1,4,7,3,15,5,1,6,4,3,1,3,1,5,2,3,6,3,2,3,1,3,4,3,2,4,3,4,1,3,2,4,7,3,1,5,1,4,6,3,1,3,7,6,1,3,1,3,2,3,2,3,1,3,1,3,4,3,1,3,7,3,1,3,4,4,4,3,2,3,7,3,1,6,2,5,1,6,19,3,2,4,1,3,1,7,4,5,1,3,4,3,3,4,2,4,3,3,10,3,1,3,2,3,1,3,2,4,2,3,12,5,4,4,4,8,2,4,2,3,2,6,1,6,5,3,1,4,5,5,3,4,2,7,4,5,4,5,1,3,2,4,3,4,3,4,2,4,3,4,1,6,4,3,1,4,2,6,1,3,2,3,2,3,11,3,2,3,1,4,9,3,2,3,5,3,8,3,2,7,1,3,19,3,1,6,6,3,3,3,4,4,17,5,1,3,7,4,1,3,1,3,2,6,2,4,4,4,1,5,1,3,2,4,5,3,1,4,4,3,2,5,2,3,3,3,3,4,1,4,2,3,5,3,2,3,1,3,6,4,2,4,2,3,2,4,6,7,1,3,1,5,2,3,4,5,2,4,1,3,2,3,3,4,5,3,3,4,2,5,3,7,6,3,1,3,5,3,2,3,10,3,6,3,1,4,1,3,3,3,5,6,4,3,1,5,3,3,1,3,2,3,2,3,1,3,3,5,1,3,1,3,14,7,4,4,6,4,1,3,3,4,4,3,6,3,11,11,1,4,10,3,3,3,5,3,1,5,1,3,1,3,11,3,1,3,2,3,4,4,8,4,4,3,1,4,1,3,1,4,1,3,2,3,5,4,3,3,6,3,1,3,1,3,2,3,1,3,3,4,8,5,7,6,2,3,2,4,1,4,9,10,1,3,5,3,17,3,2,12,1,3,1,4,3,3,3,3,1,3,1,11,3,3,1,3,1,3,2,4,10,9,1,3,2,3,3,4,5,3,1,4,1,3,2,3,1,3,8,5,8,3,7,4,1,3,3,7,3,3,1,4,1,3,3,4,10,4,2,6,2,3,7,3,1,3,4,3,2,3,1,4,3,4,1,3,7,3,2,3,2,5,1,4,1,3,1,3,5,4,1,3,1,3,4,4,1,3,11,3,1,3,1,5,1,4,3,4,6,3,9,4,9,4,8,3,3,3,5,3,1,4,1,3,3,6,2,3,2,3,1,3,2,7,1,3,2,3,4,3,7,3,3,5,3,3,1,3,3,3,5,3,5,3,6,3,5,5,1,4,2,3,1,3,3,3,2,4,2,3,1,5,5,4,2,3,2,3,6,9,3,3,2,6,1,3,4,4,1,3,4,4,6,3,6,3,3,3,1,5,1,3,1,4,1,4,4,7,1,3,1,3,3,3,2,5,1,3,3,3,5,7,1,3,3,3,3,4,4,6,3,3,4,3,2,4,3,3,4,4,4,4,9,4,2,3,1,3,6,6,3,3,2,6,5,3,2,3,8,3,1,5,4,4,2,3,1,4,2,7,1,8,2,7,2,4,4,6,1,3,3,8,2,3,3,3,1,3,3,4,3,3,3,5,6,6,4,3,2,3,1,3,5,3,1,3,12,4,1,4,1,6,1,5,15,3,1,3,1,3,1,9,2,3,5,3,1,5,2,3,9,11,1,3,2,3,2,3,8,4,6,3,3,4,2,4,1,9,2,3,1,3,1,4,2,3,3,6,1,3,2,4,1,3,2,3,4,3,1,7,2,4,20,6,5,4,3,3,1,3,7,3,3,3,9,9,1,4,8,3,9,4,1,4,1,5,3,3,6,4,1,3,1,3,4,3,2,4,1,4,2,4,1,3,4,4,2,4,5,3,4,3,2,4,2,3,1,4,3,4,1,3,3,4,2,4,3,3,2,5,2,3,5,7,2,3,3,3,1,4,1,8,1,3,5,5,7,7,1,4,1,3,3,3,1,3,3,3,4,3,1,4,5,3,1,6,2,3,1,3,1,3,5,3,1,3,3,4,1,3,2,3,35,7,2,3,2,3,6,3,2,3,16,4,1,5,9,3,1,4,2,3,2,3,3,4,6,3,7,7,5,3,3,3,4,3,1,5,4,3,4,3,1,7,8,4,2,3,2,3,7,3,2,3,12,3,4,3,4,3,1,5,1,6,5,3,5,3,1,4,5,3,1,3,7,3,2,3,3,9,1,6,16,4,12,5,3,3,29,4,1,5,11,3,1,3,6,6,4,3,1,3,2,3,13,3,3,5,3,3,4,3,1,3,1,3,10,155,1,3,3,4,3,5,3,4,1,3,4,3,3,4,2,4,1,4,7,3,1,3,10,3,1,3,2,3,3,3,7,5,1,3,10,4,2,3,3,5,5,3,3,3,6,4,2,3,5,3,15,3,1,3,1,3,10,3,2,3,1,5,2,3,6,3,2,3,14,3,3,3,7,3,5,5,8,3,6,3,2,3,2,3,1,4,1,3,1,3,3,3,1,5,1,4,5,3,1,5,3,5,1,4,3,3,1,6,4,5,1,3,1,3,1,3,3,7,1,4,1,6,1,4,5,3,5,5,3,4,1,3,4,3,4,4,2,3,2,3,2,3,6,5,3,3,1,5,3,3,3,3,2,3,2,4,1,3,1,9,4,3,4,3,6,4,11,3,2,3,4,8,1,3,7,4,7,3,3,4,2,3,1,3,1,12,2,3,2,3,1,3,3,3,5,3,1,3,1,3,3,3,2,10,2,4,2,6,2,3,2,4,12,7,2,3,1,3,3,3,4,3,1,3,1,4,7,3,5,6,2,3,2,4,8,3,1,7,1,3,10,3,2,4,4,3,2,3,1,3,6,3,1,3,8,3,6,3,2,3,2,3,4,4,1,3,5,3,7,3,6,3,3,5,3,4,6,3,5,3,2,3,7,4,3,3,3,6,8,4,1,4,1,3,3,4,1,4,9,3,2,3,2,3,1,3,2,3,1,3,1,3,1,4,6,3,8,3,2,3,1,3,2,3,1,3,2,3,5,3,2,3,2,3,2,5,5,4,3,6,2,3,8,5,4,3,9,3,3,3,7,3,12,3,1,3,2,15,7,3,1,3,2,3,4,3,6,3,4,3,8,4,3,4,1,3,10,4,2,10,2,3,1,3,2,3,1,3,1,3,1,3,10,3,1,3,12,4,7,3,14,3,1,30,6,3,6,3,1,3,1,4,11,3,10,3,2,3,1,3,10,4,3,14,1,3,14,3,2,3,1,4,6,3,11,3,6,3,9,3,8,3,1,3,2,3,2,3,11,9,1,9,1,7,1,3,3,3,15,3,2,3,6,3,1,3,4,3,3,3,1,3,2,3,3,3,5,3,1,3,5,3,6,4,8,4,2,5,1,5,1,8,5,4,1,4,12,3,1,4,6,3,5,3,1,3,1,3,5,4,4,3,4,3,12,3,2,5,1,13,6,3,7,3,2,3,8,3,1,5,10,3,10,3,6,3,15,11,1,3,2,3,2,3,8,4,2,4,1,3,7,3,1,3,2,3,15,4,1,5,8,3,1,3,18,4,3,3,13,3,5,6,3,3,8,4,4,3,8,3,1,3,6,4,1,3,4,3,4,3,6,3,6,3,4,5,6,3,5,4,4,3,4,6,1,7,6,3,10,3,2,3,3,4,6,3,5,3,3,4,1,4,3,4,4,3,1,3,5,4,1,3,2,3,2,3,5,3,5,3,5,3,2,4,1,3,4,10,3,4,5,3,2,3,8,3,3,4,5,3,4,6,3,3,23,3,2,5,2,3,2,3,10,4,3,3,1,3,6,9,7,4,1,3,15,4,3,6,5,3,1,3,11,3,3,3,6,3,2,3,3,3,6,4,1,7,36,5,9,7,5,3,3,5,1,3,6,3,3,3,6,4,3,7,7,3,15,3,5,3,5,6,4,4,3,3,14,3,4,3,1,4,3,3,2,3,4,3,6,3,2,3,6,4,2,3,5,3,1,3,3,3,8,3,5,3,6,3,5,3,7,3,2,5,1,3,5,5,2,3,3,3,3,3,1,5,3,5,5,3,1,3,4,3,4,3,1,4,8,6,2,3,4,4,3,3,7,4,2,3,2,3,1,4,2,3,3,6,2,5,5,3,3,3,3,8,6,3,1,3,1,3,12,3,1,7,2,4,2,3,7,3,9,4,2,4,3,3,4,3,1,3,11,5,2,3,3,3,3,3,11,3,4,4,4,4,2,3,1,3,1,4,1,3,2,4,5,4,15,3,1,4,7,3,4,3,1,4,4,3,2,3,3,3,2,3,1,4,1,5,1,5,1,3,4,4,5,3,4,3,1,5,1,3,4,4,1,5,2,3,2,4,4,19,5,4,5,3,8,3,2,3,3,4,5,3,3,3,3,3,3,3,3,4,2,3,1,3,1,3,6,3,4,4,1,3,3,4,2,3,1,3,1,4,1,3,2,4,2,4,1,3,1,4,4,3,4,4,3,3,1,3,1,3,7,3,6,3,1,4,1,3,4,4,1,3,2,3,4,3,8,3,4,4,1,3,7,5,3,3,1,3,3,3,2,3,3,5,1,3,2,3,6,3,2,6,1,3,1,5,1,3,9,3,8,3,1,3,1,3,1,3,9,3,8,3,1,3,3,4,1,3,12,3,3,3,5,3,5,3,2,3,18,3,1,3,7,3,3,3,4,3,1,3,3,3,6,3,3,4,7,4,13,3,2,3,2,4,1,3,4,3,4,3,2,5,1,4,5,3,4,3,1,3,3,3,1,3,3,3,1,5,5,3,3,3,1,3,2,153,1,3,1,3,5,3,3,3,12,5,4,4,1,3,2,3,1,3,2,3,3,3,6,3,5,3,7,3,1,4,3,3,3,4,2,3,2,3,7,3,4,3,3,3,6,3,6,4,2,3,20,3,2,3,1,3,1,4,1,3,3,3,1,3,1,3,2,3,13,3,1,3,3,3,2,3,3,4,7,3,1,3,1,3,7,4,1,3,2,4,5,3,1,3,1,74,1,3,4,3,6,3,3,3,4,3,1,3,1,4,2,4,2,5,2,3,11,4,1,3,2,4,3,3,1,3,1,3,2,3,6,4,6,3,2,3,1,3,2,3,2,4,4,4,7,3,1,3,9,3,6,3,7,3,7,7,1,3,5,3,6,3,2,4,1,3,25,3,1,3,1,4,1,3,2,3,4,3,2,4,7,3,2,3,8,3,1,4,5,3,15,3,2,3,2,3,1,4,3,3,1,3,1,3,3,6,2,3,11,3,9,3,1,4,5,3,4,3,5,7,1,9,1,4,1,4,1,3,1,8,5,3,1,3,4,4,2,4,7,5,5,3,2,3,2,3,1,4,9,3,6,3,7,3,2,3,9,3,7,4,4,4,2,3,1,3,2,4,8,3,1,4,3,3,8,3,1,3,15,3,8,56,2,4,1,5,1,4,1,3,1,6,6,3,1,12,1,4,1,3,3,4,1,3,1,3,2,4,7,10,7,3,1,3,2,3,2,3,1,5,5,3,13,6,3,3,3,4,4,3,12,10,3,3,2,3,3,3,1,5,4,3,2,3,1,4,1,3,3,3,9,4,2,3,4,3,1,3,2,5,3,3,1,3,4,3,23,3,2,3,1,3,3,4,2,3,3,3,1,4,6,3,3,4,1,6,8,3,1,6,3,3,1,3,1,3,1,3,2,3,2,4,1,7,10,3,7,4,6,3,7,5,17,3,1,3,6,3,1,3,15,3,17,3,4,4,4,3,14,3,2,3,4,3,1,6,7,4,3,3,1,3,2,4,4,3,4,7,8,3,3,3,1,3,5,7,11,3,1,3,2,3,12,3,1,3,2,3,3,3,4,3,3,3,1,3,7,3,3,3,4,3,2,6,3,3,9,4,1,3,3,3,3,5,1,3,9,3,2,3,2,3,4,3,4,3,2,3,1,3,1,6,5,7,2,3,5,3,5,4,4,6,2,3,13,3,2,4,2,4,1,3,2,3,5,6,2,3,2,3,1,5,1,3,9,3,2,3,4,3,5,4,1,3,11,4,13,7,6,5,2,5,20,3,1,3,3,5,5,4,1,3,5,5,4,7,6,3,5,3,1,3,1,3,2,3,6,3,5,3,4,3,15,3,3,5,4,3,2,4,1,11,2,3,10,3,9,3,1,3,2,3,3,3,1,4,1,3,2,4,2,5,3,3,4,3,1,3,1,3,2,6,3,3,4,3,2,3,8,3,3,3,10,3,1,3,8,3,1,10,1,3,3,4,2,3,1,3,7,3,7,3,4,3,4,3,3,5,1,3,1,8,12,4,1,4,2,3,14,3,2,8,1,9,5,3,1,3,4,3,9,3,2,5,9,4,4,4,1,3,1,7,2,3,1,3,3,5,4,3,12,5,8,245,1,4,4,4,1,3,2,4,1,3,2,3,10,5,1,4,2,3,2,3,1,3,3,4,2,3,4,3,2,5,3,3,8,4,1,3,9,4,7,5,3,3,8,56,1,3,1,3,5,5,1,3,1,3,7,8,5,3,2,3,3,7,8,3,2,5,1,4,5,3,4,7,4,3,10,5,3,3,1,4,9,3,2,4,5,3,3,3,2,3,1,4,2,3,1,4,4,3,1,3,1,3,2,3,2,5,2,3,2,4,16,5,14,3,3,3,1,4,3,6,4,4,7,3,1,3,2,3,1,3,6,3,1,3,7,4,1,3,2,4,5,3,11,3,3,3,1,4,1,4,3,4,3,4,3,3,4,3,1,8,1,5,1,3,1,3,3,3,1,3,3,5,1,3,3,3,1,3,1,3,1,3,3,3,3,3,12,4,1,3,2,3,3,6,1,4,4,3,3,3,7,3,1,3,5,6,1,4,2,3,1,3,1,5,1,3,1,3,5,3,1,3,6,4,7,4,4,3,1,3,1,3,1,9,1,4,2,3,1,4,1,3,4,3,12,3,1,3,8,4,3,4,4,3,2,4,1,3,4,3,1,3,1,3,2,3,1,4,1,3,3,3,1,7,1,3,4,3,3,3,8,5,3,3,6,3,4,3,1,3,3,5,6,53,2,4,4,3,3,4,1,3,1,3,9,3,1,3,1,4,1,3,2,16,1,5,1,4,2,3,1,3,1,3,3,3,1,3,1,4,1,3,1,3,1,4,2,3,3,3,1,3,2,3,1,3,4,3,1,5,9,3,2,4,2,3,1,4,2,3,13,3,1,6,1,3,4,3,1,3,1,3,1,3,3,3,2,3,1,3,10,3,2,3,2,3,1,54,4,4,3,4,1,3,1,3,4,4,11,5,3,3,1,5,3,5,1,3,1,3,15,3,3,3,1,4,4,3,1,3,2,3,3,3,2,4,1,3,10,3,7,3,3,3,3,3,1,4,3,4,6,3,1,3,4,3,1,3,6,3,3,3,7,4,10,3,3,3,5,3,6,3,3,4,3,3,1,3,8,62,1,4,1,3,1,3,3,3,2,4,3,3,2,3,5,5,2,4,1,4,1,3,8,3,1,5,1,4,1,3,1,3,1,4,2,5,5,3,3,4,2,3,6,4,1,3,4,3,1,3,5,3,3,4,6,5,3,3,4,3,3,3,1,4,2,3,3,3,1,3,1,4,3,3,2,3,6,3,1,3,6,3,2,3,3,3,4,5,3,4,1,3,3,5,1,4,3,4,4,4,5,3,1,3,1,4,4,9,4,3,1,6,2,4,1,3,3,3,3,3,1,3,2,3,3,7,2,3,2,5,1,3,3,3,2,3,5,10,5,3,4,3,1,3,3,3,5,3,3,5,1,8,2,6,1,9,5,3,1,3,2,5,3,4,1,6,2,5,1,3,3,4,2,3,3,5,4,3,2,3,1,3,7,4,1,3,1,3,7,3,1,3,1,3,6,6,3,3,2,4,3,6,2,4,1,3,3,3,4,108,3,3,2,4,1,5,7,3,5,3,2,4,7,8,1,3,1,3,2,3,3,3,1,3,4,3,2,3,2,3,2,5,5,3,1,4,3,4,1,3,7,3,1,6,3,4,1,3,4,3,8,3,3,7,6,4,7,3,3,3,1,3,1,3,4,3,9,5,1,3,1,3,1,3,15,3,5,3,2,3,1,3,12,3,2,3,3,3,1,3,2,3,10,3,11,3,6,3,2,3,6,3,10,3,11,3,1,3,1,3,1,3,7,3,1,3,3,3,2,88,1,5,2,3,2,3,2,3,2,4,9,4,4,4,1,3,5,3,3,4,2,3,1,3,1,5,2,3,1,5,4,5,2,3,1,3,1,3,2,6,1,5,6,3,4,3,1,3,7,5,5,4,1,3,4,3,6,3,5,3,3,6,2,3,2,5,3,3,2,3,2,3,5,3,1,3,1,3,4,4,17,4,1,3,2,3,4,4,10,4,1,3,6,3,7,3,5,4,3,3,5,3,8,4,1,16,1,4,3,3,2,4,1,5,1,5,1,3,1,3,1,23145,2},
        ['mr'] = {2309,53,7,15},
        ['bh'] = {2309,53,7,15},
        ['fo'] = {65,26,8,26,72,1,6,1,8,1,4,1,4,1,6,1,3,1,4,1,5,1,6,1,8,1,4,1,4,1,6,1,3,1,4,1},
        ['eo'] = {65,26,8,26,143,2,20,2,8,2,16,2,40,2,16,2},
        ['za'] = {65,26,8,26},
        ['ku-iq'] = {1574,3,3,1,3,4,3,4,6,2,8,2,3,5,55,1,9,1,13,1,7,1,13,1,6,1,7,1,7,1,18,1,7,1,3,1},
        ['bo'] = {3904,8,3,33,9,6,3,1,3,4,4,2,16,8,3,33},
        ['sa'] = {2309,53,7,15},
        ['ml'] = {3330,2,3,8,3,3,3,23,3,16,6,6,4,3,3,4,11,1,10,2},
        ['mk'] = {1024,1,4,1,3,1,4,3,3,2,3,10,3,15,41,1,4,1,3,1,4,3,3,2,3,1},
        ['no'] = {65,26,8,26,71,1,6,2,4,2,9,3,5,1,9,1,6,2,4,2,9,3,5,1},
        ['byn'] = {4608,7,3,15,3,8,10,9,9,15,3,1,3,4,4,7,3,1,3,4,4,15,3,16,18,31,3,1,3,4,12,1,3,4,4,7,3,7,3,23,3,8,10,15,3,1,3,4,12,32,10,15},
        ['lo'] = {3713,2,3,1,4,2,3,1,4,1,8,4,3,7,3,3,3,1,3,1,4,2,3,13,3,3,4,5,3,1,3,6,16,2},
        ['ko'] = {12593,51,3,42,31347,2,4,1,4,4,7,8,3,5,4,1,5,1,9,2,3,3,8,2,4,1,5,1,12,1,3,1,8,1,5,1,5,1,21,2,4,1,4,2,3,1,7,2,3,4,4,4,5,1,5,1,9,2,3,3,8,3,3,1,4,2,9,2,3,3,5,1,4,1,5,1,5,1,10,1,3,1,10,2,4,1,4,2,3,1,3,1,4,3,3,1,3,2,7,2,4,1,5,1,3,1,7,2,3,1,3,1,8,1,5,1,5,1,10,1,4,2,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,10,1,3,1,10,2,4,1,4,4,6,3,3,1,3,2,7,2,4,1,5,1,13,2,8,1,20,1,10,2,4,1,5,1,9,2,3,1,10,1,5,1,5,1,21,2,4,1,4,3,8,2,3,1,3,1,8,1,29,2,4,1,4,2,3,1,7,2,3,1,3,2,5,1,3,3,3,1,5,1,3,1,7,2,3,3,5,1,4,2,4,1,5,1,9,2,3,3,8,2,8,1,49,3,3,1,5,1,9,2,3,3,8,2,4,1,13,1,4,1,3,1,8,1,5,1,5,1,12,2,6,1,4,1,29,2,4,1,3,1,3,1,9,2,3,1,3,3,6,2,8,1,13,2,8,2,21,1,8,1,5,1,5,1,9,2,5,1,8,1,29,2,4,1,5,1,8,3,3,1,3,2,7,1,9,1,13,2,8,2,4,1,5,1,9,2,4,1,9,1,5,1,5,1,9,2,12,1,29,2,4,1,3,1,3,1,3,1,6,3,3,1,3,1,5,1,32,2,4,1,5,1,9,2,3,1,3,1,8,3,3,1,4,4,7,2,3,5,3,1,3,3,4,1,5,1,9,2,3,3,8,2,4,1,5,1,9,1,6,1,36,2,3,2,5,1,3,2,6,2,3,3,7,3,4,1,5,1,9,2,3,3,8,2,4,1,5,1,9,2,4,2,4,1,5,1,5,1,25,2,4,1,5,1,3,1,7,2,3,1,3,1,6,3,5,1,5,1,13,1,37,1,5,1,5,1,9,2,3,1,10,2,4,1,5,1,10,1,3,1,3,1,8,2,4,1,4,2,9,2,3,1,3,1,8,1,21,1,9,1,29,1,5,1,5,1,9,2,12,2,8,1,9,2,5,1,8,2,4,1,5,3,7,2,3,1,3,2,5,1,3,1,5,1,5,1,21,2,4,1,5,1,3,1,7,2,3,1,3,1,6,1,3,3,3,1,4,5,5,3,3,5,5,3,4,1,5,1,9,2,3,3,8,1,57,3,3,1,4,2,3,2,6,2,3,1,3,1,3,1,4,1,3,2,4,1,5,1,9,2,3,3,8,1,5,1,5,1,13,2,8,1,5,1,25,2,4,1,4,2,3,1,3,1,5,2,3,1,3,1,3,1,3,1,4,1,5,1,5,1,21,1,21,1,9,1,5,1,5,1,9,2,3,1,10,1,29,2,4,1,5,1,9,2,3,1,3,1,8,1,21,1,9,1,22,1,8,1,5,1,5,1,10,1,3,1,3,1,8,1,5,1,5,1,9,1,6,1,8,2,4,1,4,2,3,1,7,2,3,1,3,1,8,1,29,2,4,1,4,2,9,2,3,4,7,2,4,1,5,1,9,2,3,3,7,3,4,1,5,1,9,2,3,3,64,2,4,1,5,1,3,2,6,2,3,3,7,3,4,1,5,1,9,2,3,3,8,1,21,1,37,2,4,1,5,1,14,1,8,1,9,1,21,1,29,1,5,1,53,2,4,1,5,1,8,2,6,1,36,1,29,1,5,1,5,1,9,2,5,1,36,2,4,1,4,2,9,2,3,1,10,1,5,1,5,1,9,2,12,1,5,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,4,5,4,4,1,5,1,9,2,3,3,8,2,4,1,16,1,3,1,36,2,4,1,5,1,9,2,3,3,7,3,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,3,8,1,5,1,14,1,3,1,10,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,18,1,28,1,9,1,5,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,10,1,3,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,8,1,21,1,9,1,29,2,4,1,5,1,9,1,4,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,1,3,2,4,2,31,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,3,5,7,2,3,1,3,2,4,1,3,3,4,1,5,1,9,2,3,4,7,2,8,1,14,1,36,2,4,1,5,1,3,1,7,2,3,1,3,2,6,3,4,1,5,1,9,2,3,3,8,2,4,1,5,1,12,3,3,1,6,1,29,2,3,2,5,1,3,1,7,2,3,1,3,1,8,1,5,1,17,2,36,1,5,1,5,1,10,1,3,1,3,1,8,1,5,1,5,1,10,1,3,1,10,3,3,1,4,4,7,2,3,1,3,1,5,1,3,2,5,1,5,1,10,1,3,1,10,1,29,1,5,1,5,1,21,1,5,1,5,1,9,1,4,1,10,1,5,1,5,1,9,1,4,1,38,2,4,1,4,2,3,1,7,2,3,3,3,1,3,1,4,5,4,5,6,2,3,1,3,1,5,1,4,2,4,1,5,1,9,2,3,3,5,1,4,2,4,1,14,1,40,2,4,1,4,2,3,1,7,2,3,1,3,2,7,2,4,1,4,2,9,2,3,3,8,2,4,1,5,1,10,1,3,3,5,1,4,1,5,1,25,3,3,1,5,1,9,2,3,1,3,1,8,1,5,1,17,1,9,1,21,1,9,2,4,1,5,1,9,2,12,1,5,1,25,2,4,1,4,4,7,2,3,1,3,1,5,2,3,1,9,1,13,1,9,1,29,2,4,1,5,1,14,1,8,1,5,1,5,1,9,1,4,1,3,1,8,2,4,1,5,1,9,2,3,1,38,2,4,1,5,1,3,1,7,2,3,1,3,3,6,2,4,1,5,1,3,1,7,2,3,3,7,3,4,1,5,1,9,2,3,3,8,2,16,1,41,2,4,1,4,2,9,1,4,3,8,1,22,1,8,2,16,2,3,3,36,2,4,1,5,1,9,2,5,1,64,1,29,1,22,1,8,2,4,1,5,1,9,1,4,1,3,1,92,1,22,1,8,1,5,1,5,1,9,2,40,2,4,1,5,1,9,2,3,1,3,1,8,2,3,2,4,4,7,2,3,3,5,1,4,2,4,1,5,1,9,2,3,3,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,9,1,6,1,8,5,4,2,3,2,6,2,3,3,6,1,3,2,4,1,5,1,9,2,3,3,8,2,4,1,5,1,9,2,3,3,8,1,5,1,5,1,14,1,8,3,3,1,5,1,3,1,7,2,3,1,3,1,5,1,4,2,4,1,5,1,14,1,8,1,5,1,5,1,9,1,4,2,9,1,5,1,5,1,9,2,3,1,10,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,4,2,9,2,3,1,3,1,3,1,3,2,3,1,21,1,9,2,4,1,5,1,9,1,6,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,8,1,9,1,4,1,3,1,8,2,4,1,5,2,8,2,3,1,3,1,36,2,4,1,4,2,8,3,3,1,3,1,6,1,3,2,3,2,5,1,9,2,4,2,7,3,4,1,5,1,9,2,4,2,29,1,36,2,4,1,5,1,3,1,7,2,4,2,8,1,5,1,5,1,77,2,4,1,4,2,3,1,7,2,5,1,8,2,4,1,17,1,9,1,21,1,9,1,5,1,5,1,9,2,12,1,29,2,4,1,5,1,9,2,5,1,8,1,21,1,9,1,29,1,5,1,46,1,8,2,4,1,5,1,3,1,6,3,12,1,5,1,5,1,9,1,13,2,4,1,5,1,9,2,3,1,3,1,8,2,4,3,3,3,6,3,3,3,5,2,3,2,4,1,5,1,9,2,3,3,8,2,4,1,5,1,4,1,6,2,3,1,3,1,5,1,3,2,5,1,5,1,10,1,12,2,4,2,3,4,7,7,3,1,3,1,3,2,4,1,5,1,9,2,3,1,3,1,8,3,3,1,5,1,3,2,6,6,5,4,5,1,5,1,9,2,3,2,9,2,4,1,5,3,3,1,4,3,3,1,3,1,3,1,6,2,4,1,5,1,9,2,3,3,8,2,4,1,13,1,4,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,3,7,2,3,1,3,1,8,2,4,1,5,1,9,2,4,2,8,2,4,1,5,1,9,2,5,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,3,1,6,2,4,1,5,1,7,1,3,2,3,1,3,8,5,1,5,1,9,1,4,1,10,2,4,1,5,3,6,3,3,4,5,1,3,2,4,1,3,3,3,1,7,2,3,4,7,2,4,1,5,1,9,2,3,3,8,2,4,1,3,1,3,1,9,1,6,1,8,1,5,1,5,1,21,2,4,1,5,1,3,1,7,2,3,1,3,2,7,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,9,2,4,2,8,1,29,2,4,1,5,1,3,1,7,2,3,1,3,3,5,3,8,1,10,1,3,1,3,1,8,1,21,2,8,1,5,1,5,1,9,2,3,1,3,1,8,2,4,1,18,1,8,2,4,1,5,3,7,2,3,1,3,1,8,1,21,1,9,1,29,2,4,1,5,1,9,2,3,1,10,1,5,1,5,1,9,1,13,2,4,1,5,1,9,2,3,1,3,1,36,2,4,1,4,2,3,1,7,2,3,1,3,2,4,2,3,2,4,1,3,1,3,1,4,1,6,2,3,3,8,2,4,1,5,1,9,2,3,3,8,1,5,1,18,1,36,2,4,1,5,1,9,2,3,3,8,1,22,1,8,1,21,1,37,2,4,1,5,1,9,2,3,1,3,1,3,1,6,2,8,1,13,1,9,1,21,1,9,1,5,1,5,1,9,2,33,1,8,2,4,1,5,1,9,2,5,1,8,1,21,2,36,1,29,1,29,1,17,1,4,1,3,1,36,2,4,1,5,1,9,2,5,2,6,3,4,1,3,1,3,1,9,2,3,4,7,2,4,1,5,1,9,2,3,3,8,1,5,1,3,1,3,1,9,1,6,1,36,2,4,1,5,1,9,2,3,3,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,17,1,9,1,5,1,18,1,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,14,1,36,1,5,1,5,1,9,2,3,1,3,1,8,1,17,1,13,2,4,1,5,1,9,2,3,1,3,1,8,1,21,1,9,1,5,1,25,1,5,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,9,1,6,1,8,2,4,1,5,1,9,2,3,1,3,1,36,2,4,1,4,3,8,2,3,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,3,8,2,21,1,36,2,4,1,4,2,9,2,3,3,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,9,2,3,3,8,1,29,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,1,6,1,8,1,22,1,8,1,9,1,21,1,29,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,14,1,8,1,22,1,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,9,1,13,2,4,1,5,1,9,2,5,1,36,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,2,8,2,3,3,8,2,4,1,5,1,9,2,3,3,8,1,22,1,36,2,4,1,5,1,3,1,7,2,3,3,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,17,1,9,1,5,1,25,2,4,1,5,1,9,2,3,1,3,1,6,1,3,1,5,1,25,1,29,1,5,1,16,1,3,1,8,1,29,2,4,1,5,1,9,2,3,1,3,1,8,1,21,1,9,1,29,2,4,1,5,1,9,2,5,1,8,1,5,1,5,1,9,1,6,1,8,2,4,1,4,2,3,1,7,2,3,1,10,1,5,1,5,1,9,2,12,2,4,1,5,1,9,2,3,1,3,1,8,3,3,1,5,1,3,1,7,2,3,3,5,1,4,2,4,1,5,1,9,2,3,3,8,2,56,2,4,1,5,1,9,2,3,3,8,2,4,1,5,1,9,2,3,1,3,1,8,1,5,1,5,1,9,2,4,2,8,1,9,1,10,1,3,1,10,2,4,1,5,1,9,2,3,1,3,1,8,1,22,1,36,1,5,1,25,1,5,1,5,1,10,1,3,1,10,2,4,1,4,2,3,1,7,2,3,1,3,1,8,1,22,1,36,1,5,1,5,1,9,1,4,1,10,1,5,1,5,1,9,1,4,1,3,1,8,1,5,1,5,1,9,2,3,1,38,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,6,1,4,2,3,1,3,1,8,2,4,1,5,1,9,2,3,3,8,1,22,1,36,2,4,1,5,1,3,1,7,2,3,1,3,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,2,3,3,8,1,5,1,5,1,10,1,12,2,4,1,5,1,6,1,4,2,3,1,3,1,5,1,4,2,4,1,5,1,12,1,3,1,8,2,4,1,16,1,3,1,8,2,4,1,5,1,10,1,3,1,3,1,8,1,5,1,5,1,10,1,3,1,10,2,4,1,5,1,6,1,4,1,4,1,3,1,8,1,5,1,5,1,9,1,6,1,8,2,4,1,5,1,14,1,8,2,4,1,5,1,9,2,3,1,3,1,8,2,4,1,5,1,9,1,4,1,3,1,8,2,4,1,3,4,8,2,3,1,3,1,5,1,4,1,5,1,5,1,9,2,5,1,8,2,4,1,5,1,9,2,3,1,3,1},
        ['fil'] = {65,26,8,26,71,3,7,3,3,3,4,4,6,3,6,3,7,3,3,3,4,4,6,3},
        ['kok'] = {2309,53,7,15},
        ['ho'] = {65,26,8,26},
        ['si'] = {3458,2,3,9,5,6,5,12,3,11,3,9,3,1,4,7,5,1,6,6,3,1,3,7,21,1},
        ['ha'] = {65,26,8,26,264,1,10,1,15,2,27,2,160,1,5,1},
        ['ga'] = {65,26,8,26,72,1,9,1,5,1,7,1,8,1,8,1,9,1,5,1,7,1,8,1,17,2,22,2,7394,2,8,2,20,2,34,2,22,2,10,2,10,2},
        ['ja'] = {12288,3,4,1,3,1,59,83,9,4,4,86,6,4,7427,2,3,1,5,5,3,2,7,1,3,1,3,2,9,1,6,1,8,1,6,1,7,2,3,2,10,1,11,1,9,1,3,1,5,2,20,1,3,1,12,1,3,1,7,1,3,2,3,2,7,1,3,2,8,1,6,1,4,1,8,3,14,1,8,1,10,2,5,1,7,2,3,2,11,3,10,1,3,1,3,1,5,1,6,1,7,1,14,4,10,1,4,1,19,1,6,1,5,1,3,1,3,1,11,1,8,4,4,1,3,1,5,1,4,1,24,1,3,1,11,1,13,1,3,1,15,1,3,1,5,1,14,2,7,2,10,1,4,2,8,1,14,1,7,1,5,1,14,1,6,1,3,1,4,1,3,1,16,1,3,1,3,1,6,1,8,1,7,1,5,2,8,1,15,1,17,1,7,1,14,1,10,1,16,3,8,1,17,1,5,1,8,2,20,1,7,1,4,1,3,1,8,1,8,1,9,1,3,1,7,1,6,1,14,1,26,1,5,1,15,1,14,1,12,1,26,4,3,2,3,1,3,1,4,1,11,1,12,1,4,1,4,3,5,1,5,1,3,2,5,1,10,2,5,1,4,1,6,1,6,1,3,1,8,1,6,1,8,1,11,2,14,1,3,1,8,1,17,1,5,1,6,1,17,1,3,3,7,1,4,1,4,3,3,1,8,1,7,1,7,1,8,2,5,1,8,1,7,6,13,1,4,1,4,1,10,1,6,1,9,2,12,2,3,1,4,1,19,1,21,1,5,2,4,1,7,2,8,1,4,1,6,1,6,1,6,1,3,1,3,1,3,1,13,1,4,2,5,1,3,1,4,1,3,1,4,1,12,1,13,1,5,1,4,1,18,2,10,1,26,3,5,1,3,1,3,1,5,2,3,1,8,4,4,2,3,1,7,1,17,2,3,3,4,1,13,1,21,1,3,1,6,1,21,1,9,1,8,1,7,1,3,5,7,1,3,2,3,1,11,3,7,2,4,2,3,2,5,2,13,1,5,2,4,6,11,1,5,1,8,1,6,1,14,2,10,1,7,3,31,1,3,1,10,1,10,2,16,1,39,1,12,1,4,2,33,1,18,1,9,1,11,1,3,2,10,1,32,1,3,1,14,1,9,1,10,1,5,1,50,1,6,1,18,1,3,2,13,3,12,1,16,1,31,1,36,1,44,2,55,1,13,1,20,1,84,2,4,1,3,1,4,1,14,1,3,2,8,1,4,1,19,1,4,1,14,1,9,2,9,1,19,1,6,1,4,1,8,1,26,1,25,1,10,1,25,1,41,1,4,1,18,1,25,1,3,2,3,1,5,1,3,1,4,2,16,1,16,1,7,1,8,1,4,1,13,2,10,1,8,1,4,1,4,1,4,1,5,1,12,1,22,1,6,1,17,1,5,1,6,1,13,1,12,1,12,1,4,1,7,1,4,1,3,1,32,1,4,1,3,3,24,1,7,1,7,2,5,1,3,1,7,1,6,1,3,3,4,1,4,1,23,3,7,1,3,1,4,1,18,1,4,1,3,1,5,1,6,2,10,1,6,3,7,1,13,1,4,1,13,1,4,1,5,1,14,1,3,1,15,1,3,1,9,2,24,1,17,1,5,1,3,1,24,1,9,1,16,1,24,1,21,1,13,1,26,1,20,1,10,1,39,1,9,1,4,1,22,1,66,1,47,1,5,1,4,2,6,1,7,2,3,1,6,1,27,1,3,3,4,1,12,7,3,1,4,3,11,1,3,1,4,4,4,1,7,1,4,1,3,1,3,1,7,1,7,1,10,1,3,1,3,1,3,1,7,1,3,1,6,1,11,1,3,1,5,2,3,2,3,1,3,1,4,3,4,2,3,1,10,1,24,1,10,7,6,1,4,1,3,2,11,1,10,1,7,2,11,1,3,1,32,1,18,1,9,1,4,1,8,1,6,1,41,2,16,1,7,1,18,1,8,1,9,1,20,1,40,1,142,2,4,1,3,1,3,4,7,1,4,1,11,1,4,1,5,2,4,1,7,1,18,1,9,1,7,1,3,1,3,2,4,1,6,1,6,1,9,1,17,1,15,1,16,3,5,2,3,4,4,1,3,1,8,1,6,1,7,1,3,1,6,1,11,2,5,1,3,1,10,3,12,1,7,2,45,2,4,1,8,1,4,1,7,1,6,2,4,3,11,1,7,3,11,1,5,1,3,1,8,1,22,1,7,1,10,1,8,1,3,1,6,2,9,1,4,1,5,2,4,2,7,2,5,1,3,2,5,1,11,1,9,2,5,1,6,2,6,1,11,1,3,1,8,2,11,3,4,1,5,1,12,1,11,1,30,1,5,1,8,1,4,1,6,1,3,2,3,1,34,1,6,1,3,1,18,1,3,1,4,2,5,1,3,1,7,1,32,1,12,2,4,1,4,1,4,2,9,1,11,1,10,1,13,1,12,1,12,2,9,1,4,1,15,1,9,1,7,1,12,2,5,1,38,1,5,1,4,2,3,1,8,1,14,2,6,1,7,1,3,1,7,1,13,1,13,1,23,1,4,1,3,1,4,1,7,1,5,1,9,1,10,1,10,1,35,1,7,1,25,3,9,1,13,1,10,1,6,1,5,1,4,1,5,2,8,1,3,1,3,1,3,1,7,1,3,1,29,1,6,1,4,1,7,2,5,1,7,1,8,1,5,1,3,2,5,1,3,1,14,1,7,1,5,1,5,1,4,2,9,1,5,1,5,1,4,1,3,2,6,2,3,1,3,1,4,2,12,2,7,1,4,2,8,1,4,1,7,1,11,1,9,1,7,1,10,1,4,1,5,1,17,1,11,1,13,1,3,1,6,1,13,1,7,1,14,1,9,1,6,1,5,1,7,1,7,1,4,1,7,2,4,1,3,2,3,1,9,1,30,2,11,2,7,1,14,1,7,1,7,1,20,1,32,2,14,1,5,1,5,1,23,1,18,1,7,1,21,1,34,1,11,1,5,1,16,1,13,1,26,1,7,1,68,1,11,1,3,1,4,2,7,1,11,1,3,1,7,1,3,1,10,2,10,1,5,1,5,2,3,1,17,1,3,1,6,1,4,1,7,1,3,1,4,1,9,2,8,2,4,1,10,1,5,1,9,1,7,1,5,1,9,1,12,1,4,5,4,1,15,1,13,2,8,1,6,2,12,2,6,1,3,2,6,1,3,1,14,1,7,1,40,1,6,2,6,1,3,1,12,1,7,1,11,1,6,2,16,1,6,1,4,1,7,1,20,1,16,1,7,1,23,1,3,1,5,2,5,1,3,2,9,2,5,1,9,1,3,1,5,1,3,1,3,1,10,1,3,4,5,1,4,1,7,1,4,1,13,1,8,2,15,1,3,1,5,1,11,1,3,1,14,2,18,1,6,1,3,1,4,1,3,2,4,1,3,1,14,1,8,1,15,1,13,1,4,2,30,1,3,1,3,1,7,1,5,1,5,2,16,1,15,1,10,1,15,2,4,2,5,1,3,1,6,1,10,1,12,1,4,1,39,1,19,1,18,1,9,1,21,1,8,1,8,1,9,1,6,1,16,1,13,1,12,1,9,2,15,1,82,1,9,1,3,1,6,2,6,1,74,1,14,1,38,1,29,1,9,1,9,2,16,1,19,1,21,1,166,1,29,2,7,1,12,1,9,1,5,1,15,1,8,1,16,2,4,1,4,1,7,1,5,2,8,1,15,3,12,1,31,2,6,2,5,2,14,2,5,1,3,1,8,1,53,1,3,1,7,1,30,1,4,2,7,1,4,2,13,1,10,1,4,1,6,2,17,1,11,1,4,1,7,1,6,1,15,1,4,1,9,2,18,1,6,2,3,2,4,1,3,1,9,2,3,1,10,1,13,3,3,1,4,1,9,1,4,1,25,1,13,1,8,1,8,1,6,1,18,1,4,1,4,1,4,2,24,1,11,1,5,1,5,1,7,1,4,2,17,1,18,1,23,1,4,1,11,1,22,1,17,1,11,1,7,1,7,1,5,1,11,1,3,3,3,1,9,1,9,1,7,1,6,1,4,1,4,1,4,1,40,1,18,1,9,1,16,3,17,1,7,1,8,1,26,1,5,1,12,1,7,1,7,1,13,2,23,1,14,2,5,1,10,1,6,1,13,1,3,1,10,2,13,1,29,1,9,1,4,1,6,1,11,1,3,1,21,1,61,2,3,1,41,1,5,1,62,1,64,1,5,2,14,1,13,2,5,1,32,1,13,2,15,1,90,1,6,1,17,1,7,1,19,1,12,1,15,1,3,1,6,1,29,1,22,1,19,1,19,1,35,1,34,1,37,1,12,2,8,1,11,2,18,1,3,1,13,1,3,1,10,1,8,1,40,1,13,1,4,1,8,1,13,1,24,1,17,1,4,2,47,1,5,1,13,1,4,1,9,1,10,1,6,1,32,1,16,1,19,1,4,1,3,1,3,1,31,1,37,1,20,1,14,1,18,1,6,1,4,1,47,1,45,1,36,1,37,1,10,1,14,1,42,1,17,1,35,1,3,1,6,1,5,1,6,1,9,4,5,1,4,2,18,1,4,1,3,1,4,1,6,1,4,2,9,1,6,1,7,1,4,1,13,1,16,1,4,1,27,1,8,1,13,1,8,1,3,1,15,1,4,1,4,1,8,1,8,1,12,1,26,1,54,1,17,1,5,1,37,2,3,2,7,1,3,2,40,1,18,1,8,1,5,1,14,1,5,1,5,1,5,2,11,1,5,1,3,1,5,1,7,1,4,1,9,1,3,2,20,2,27,1,3,1,5,1,34,1,3,1,4,1,71,2,7,1,41,1,8,1,4,1,9,1,3,1,5,1,16,1,19,2,30,1,3,1,42,1,15,2,22,1,17,1,42,1,8,1,40,1,26,1,14,1,45,1,3,1,3,1,11,2,14,1,8,2,8,1,4,1,6,1,21,1,5,1,9,1,3,1,50,2,11,1,7,2,7,1,8,1,11,1,8,1,12,1,17,1,4,1,13,1,21,1,5,1,11,2,3,2,3,1,12,1,3,1,29,1,10,1,3,1,5,1,8,1,3,1,16,2,13,1,16,2,29,1,18,1,5,1,6,1,11,1,8,1,4,1,25,1,11,1,12,1,7,1,27,1,4,1,3,1,8,1,3,1,3,1,50,1,5,1,13,1,11,1,17,1,8,1,9,1,5,1,6,1,28,1,62,1,31,1,15,1,20,1,20,1,23,1,3,1,8,1,6,2,4,1,13,1,24,1,25,1,18,1,18,1,4,1,4,1,3,1,5,2,7,1,3,1,8,1,6,3,6,3,10,1,5,2,4,1,7,2,9,1,3,1,9,1,5,1,15,1,4,1,6,1,12,1,5,2,4,1,33,2,20,1,5,2,10,1,5,1,12,1,6,1,3,2,9,1,7,1,9,2,7,1,6,1,8,1,7,1,4,1,24,1,12,1,6,1,4,1,17,1,4,1,10,1,11,2,25,1,4,1,199,1,53,1,5,1,3,1,3,1,4,1,3,1,15,1,6,1,5,1,17,1,7,1,5,2,21,1,5,1,12,1,7,1,42,2,6,1,3,1,3,1,12,1,6,1,3,1,29,1,36,1,9,1,23,1,4,1,19,1,4,1,11,1,3,1,6,1,5,2,4,1,5,2,6,1,4,1,9,1,10,1,4,1,7,1,3,1,17,1,23,1,5,1,6,1,6,1,4,1,3,2,3,1,17,1,24,1,3,1,28,1,3,1,6,1,23,1,6,1,9,3,33,1,3,2,12,1,12,1,20,1,14,1,17,1,6,1,3,1,4,1,7,2,9,1,13,1,5,1,3,1,10,1,8,2,12,1,3,1,11,2,3,1,15,1,32,1,10,1,4,1,5,1,22,1,19,1,19,1,3,1,3,1,6,1,6,1,27,1,5,1,11,2,12,1,18,1,13,1,27,1,15,1,20,1,10,1,7,1,32,1,84,1,3,1,8,1,10,1,20,1,32,1,48,1,13,1,15,1,5,1,18,1,77,1,13,1,8,1,71,1,37,1,9,1,72,1,35,1,5,3,34,1,24,1,6,1,19,1,84,1,3,1,11,1,3,1,3,1,14,1,15,1,18,1,12,1,51,1,7,1,34,1,21,1,27,1,114,1,180,1,7,1,7,1,8,1,5,1,5,1,3,1,5,1,3,1,6,1,9,1,8,1,21,1,12,1,22,1,23,2,4,1,11,1,7,1,8,1,29,1,6,2,10,1,10,1,3,1,78,1,20,1,14,1,3,1,6,2,5,1,5,1,8,1,5,1,14,1,4,1,10,1,32,1,18,1,4,1,27,1,3,2,6,1,7,1,6,1,5,2,8,1,12,1,4,1,5,1,3,2,7,1,3,1,21,1,5,2,10,1,3,1,4,1,4,1,4,1,6,1,3,4,21,1,3,1,4,2,7,1,3,1,4,1,7,1,3,1,5,1,9,2,4,1,3,1,14,1,9,1,5,1,12,1,17,2,7,2,11,1,7,1,3,2,4,1,11,1,12,1,3,1,3,1,5,1,25,1,32,1,5,1,11,1,11,1,3,1,6,1,193,1,16,1,5,1,17,1,8,1,10,1,35,1,18,2,3,3,6,6,4,1,6,1,4,2,4,2,4,2,3,3,4,1,4,1,10,1,9,2,3,1,3,1,3,1,5,1,5,1,4,1,16,1,13,1,93,1,3,1,11,1,5,1,4,1,15,1,6,1,26,1,17,1,43,1,5,1,15,1,5,1,3,1,22,1,6,1,28,1,75,1,26,1,31,1,32,1,3,2,6,1,14,1,4,1,23,1,6,1,7,1,7,1,21,1,13,2,15,1,13,1,88,1,4,1,6,1,15,2,9,1,3,1,10,1,10,1,4,1,4,1,24,1,3,1,4,1,8,1,7,1,4,2,3,1,4,1,10,2,4,2,7,1,4,1,3,2,4,1,12,1,4,2,7,1,11,1,4,1,3,1,4,2,3,2,6,3,8,1,5,2,3,1,7,1,5,2,8,1,3,2,3,1,6,1,6,1,32,1,4,1,5,1,15,1,19,1,5,1,20,1,8,1,6,1,9,1,3,1,7,1,80,3,5,1,3,1,15,1,9,1,3,1,10,1,3,2,27,1,11,1,29,1,16,2,5,4,3,1,12,2,7,1,43,1,40,1,17,1,24,1,8,1,16,1,16,1,4,1,3,1,20,1,22,1,65,1,7,1,10,1,37,1,7,1,7,1,3,2,4,1,26,1,17,1,27,1,24,1,11,1,25,1,52,1,56,1,58,1,295,1,10,1,10,1,3,1,7,1,3,1,16,2,3,1,14,1,22,1,18,1,69,1,15,1,9,1,10,1,10,1,10,1,4,1,12,1,8,4,6,1,7,1,4,1,3,2,3,1,3,1,4,1,9,2,5,1,5,2,6,1,6,1,3,2,5,1,4,1,21,1,5,1,10,4,6,1,6,1,18,2,6,1,3,1,7,1,3,1,5,2,5,1,6,1,8,1,4,1,19,1,12,1,12,1,33,1,8,1,6,1,5,1,8,1,12,1,96,1,33,1,9,1,5,1,4,2,3,2,3,1,9,4,6,1,22,1,15,2,17,3,7,2,4,1,7,1,10,1,66,1,52,1,5,1,4,1,14,1,4,1,11,3,8,1,6,1,3,1,8,1,22,1,111,1,4,1,20,1,25,3,11,1,3,1,61,1,5,2,30,1,43,1,79,1,17,1,13,1,21,1,19,1,72,1,12,1,7,1,4,1,16,1,7,1,85,1,59,1,254,1,16,1,156,1,38,1,204,1,21,1,5,1,16,1,21,2,10,1,15,1,8,1,59,1,41,1,40,1},
        ['ia'] = {65,26,8,26},
        ['da'] = {65,26,8,26,72,1,5,2,4,1,5,1,7,1,6,1,3,1,4,1,5,1,5,2,4,1,5,1,7,1,6,1,3,1,4,1},
        ['ii'] = {40960,1165},
        ['li'] = {65,26,8,26,75,1,5,1,4,1,9,1,4,1,15,1,5,1,4,1,9,1,4,1},
        ['ki'] = {65,26,8,26,175,2,64,2},
        ['fi'] = {65,26,8,26,75,2,18,1,15,2,18,1,107,2,29,2},
        ['sw'] = {65,26,8,26},
        ['hi'] = {2309,53,7,15},
        ['brx'] = {2305,3,3,8,4,2,4,22,3,7,3,1,4,5,4,9,4,2,4,3,4,3,15,17},
        ['la'] = {65,26,8,26,135,2,18,2,24,4,32,4,28,4},
        ['ka'] = {4304,33},
        ['na'] = {65,26,8,26,74,1,15,1,5,1,15,1,15,1,5,1,116,2},
        ['wo'] = {65,26,8,26,71,1,4,1,7,1,3,1,7,1,3,1,14,1,4,1,7,1,3,1,7,1,3,1,88,2},
        ['ff'] = {65,26,8,26,209,2,55,1,10,1,20,1,23,2,160,1,5,1,28,1},
        ['av'] = {1025,1,6,1,11,64,3,1},
        ['ee'] = {65,26,8,26,71,2,8,2,4,2,6,2,7,2,7,2,8,2,4,2,6,2,7,2,33,2,48,2,60,1,4,1,8,3,3,1,31,1,28,8,129,1,3,1,6,1,9,1,41,1,118,2,12,1},
        ['cv'] = {258,2,767,1,16,64,3,1,90,2,44,2,28,2},
        ['dv'] = {1920,49},
        ['crh'] = {65,26,8,26,73,1,6,1,11,1,6,1,7,1,7,1,6,1,11,1,6,1,7,1,35,2,18,2,46,2},
        ['ba'] = {1040,64,68,2,6,2,8,4,8,2,4,2,12,2,30,2,16,2},
        ['gv'] = {65,26,8,26,78,1,33,1},
        ['bi'] = {65,26,8,26,80,1,7,1,14,1,14,1,7,1,14,1},
        ['br'] = {65,26,8,26,73,1,9,1,8,1,4,1,6,1,4,1,7,1,9,1,8,1,4,1,6,1,4,1},
        ['jv'] = {65,26,8,26,79,2,32,2},
        ['kv'] = {1025,1,6,1,11,64,3,1,6,1,145,2},
        ['lv'] = {65,26,8,26,135,2,12,2,6,2,16,2,8,2,12,2,5,2,10,2,7,2,10,2,10,2,10,2,19,2},
        ['fr'] = {65,26,8,26,71,1,3,1,5,6,4,2,6,1,6,1,3,2,5,1,3,1,5,6,4,2,6,1,6,1,3,2,4,1,84,2,38,1},
        ['az-ir'] = {1569,4,3,21,8,2,3,5,4,1,10,1,43,1,9,1,19,1,18,1,7,1,30,1},
        ['fa'] = {1569,4,3,21,8,2,3,5,4,1,10,1,43,1,9,1,19,1,18,1,7,1,30,1},
        ['ca'] = {65,26,8,26,71,1,8,3,5,1,3,1,4,2,8,1,3,1,5,1,8,3,5,1,3,1,4,2,8,1,3,1,68,2},
        ['az-az'] = {65,26,8,26,78,1,16,1,7,1,12,1,16,1,7,1,35,2,18,2,46,2,49,1,203,1},
        ['lez'] = {1025,1,6,1,11,64,3,1},
        ['sel'] = {1025,1,16,64,3,1},
        ['co'] = {65,26,8,26,71,1,3,1,5,6,4,2,6,1,6,1,3,2,5,1,3,1,5,6,4,2,6,1,6,1,3,2,4,1,84,2,38,1},
        ['kwm'] = {65,26,8,26},
        ['kj'] = {65,26,8,26},
        ['gez'] = {4608,7,3,15,3,15,3,9,9,15,3,1,3,4,20,8,10,8,10,7,3,1,3,4,4,8,10,15,3,1,3,4,20,7,3,7,3,8,10,7,3,8,18,7,3,1,3,4,12,9,9,23,3,15},
        ['kab'] = {65,26,8,26,147,2,132,1,5,1,83,2,117,1,9,1,7082,2,24,2,62,2,10,2,38,2},
        ['fj'] = {65,26,8,26},
        ['kaa'] = {1025,1,16,64,3,1,66,2,8,2,8,2,12,2,4,2,38,2},
        ['ber-ma'] = {11568,2,3,1,5,1,3,1,3,3,4,1,4,3,3,1,3,2,4,3,5,4,4,4,4,1,3,3,3,1,11,1},
        ['aa'] = {65,26,8,26,73,1,9,1,5,1,7,1,8,1,8,1,9,1,5,1,7,1,8,1},
        ['lb'] = {65,26,8,26,73,1,3,1,5,4,4,1,7,1,3,1,6,2,4,1,4,1,3,1,5,4,4,1,7,1,3,1,6,2},
        ['bho'] = {2309,53,7,15},
        ['nb'] = {65,26,8,26,71,1,6,2,4,2,9,3,5,1,9,1,6,2,4,2,9,3,5,1},
    },
}
