return {
    com = {
        ",",
        north = ";",
        northeast = "(",
        northwest = "\\",
        east = "?",
        west = "¿",
        "{",
        "}",
        "[",
    },
    prd = {
        ".",
        north = ":",
        northeast = ")",
        northwest = "/",
        east = "…",
        west = "!",
        "]",
        "-",
        "_",
    },
    _at = {
        "@",
        north = "Ⓒ",
        northeast = "™",
        northwest = "Ⓡ",
    },
    _eq = {
        "=",
        north = "≠",
        northeast = "»",
        northwest = "«",
        east = ">",
        west = "<",
        south = "≈",
        southeast = "≥",
        southwest = "≤",
    },
    _A_ = {
        "A",
        north = "Ä",
        northeast = "Á",
        northwest = "À",
        east = "Â",
        west = "Ã",
        south = "Ą",
        southeast = "Æ",
        southwest = "Å",
        "Ā",
        "Ǎ",
    },
    _a_ = {
        "a",
        north = "ä",
        northeast = "á",
        northwest = "à",
        east = "â",
        west = "ã",
        south = "ą",
        southeast = "æ",
        southwest = "å",
        "ā",
        "ǎ",
    },
    _B_ = {
        "B",
        north = "Β",
        northeast = "β",
        northwest = "♭",
    },
    _b_ = {
        "b",
        north = "Β",
        northeast = "β",
        northwest = "♭",
    },
    _C_ = {
        "C",
        north = "Ċ",
        northeast = "Ć",
        northwest = "🄯", -- copyleft symbol
        east = "Ĉ",
        west = "Č",
        south = "Ç",
        southeast = "©", -- copyright symbol
        southwest = "¢", -- cent sign
    },
    _c_ = {
        "c",
        north = "ċ",
        northeast = "ć",
        northwest = "🄯", -- copyleft symbol
        east = "ĉ",
        west = "č",
        south = "ç",
        southeast = "©", -- copyright symbol
        southwest = "¢", -- cent sign
    },
    _D_ = {
        "D",
        north = "Đ",
        northeast = "Ð",
        northwest = "Ď",
        east = "Δ",
    },
    _d_ = {
        "d",
        north = "đ",
        northeast = "ð",
        northwest = "ď",
        east = "δ",
    },
    _E_ = {
        "E",
        north = "Ë",
        northeast = "É",
        northwest = "È",
        east = "Ê",
        west = "Ẽ",
        south = "Ę",
        southeast = "€",
        southwest = "Ė",
        "Ē",
        "Ě",
        "ɛ",
    },
    _e_ = {
        "e",
        north = "ë",
        northeast = "é",
        northwest = "è",
        east = "ê",
        west = "ẽ",
        south = "ę",
        southeast = "€",
        southwest = "ė",
        "ē",
        "ě",
        "ɛ",
    },
    _F_ = {
        "F",
        east = "ƒ", -- Guilder/Florin
        west = "Φ", -- uppercase phi
    },
    _f_ = {
        "f",
        east = "ƒ", -- Guilder/Florin
        west = "φ", -- lowercase phi
    },
    _G_ = {
        "G",
        east = "ɣ", -- voiced velar fricative IPA
        west = "Γ", -- uppercase gamma
    },
    _g_ = {
        "g",
        east = "ɣ", -- voiced velar fricative IPA
        west = "γ", -- lowercase gamma
    },
    _H_ = {
        "H",
        east = "ɥ", -- labialized palatal approximant (like a combination between /w/ and /y/)
        west = "Η", -- uppercase eta
    },
    _h_ = {
        "h",
        east = "ɥ", -- labialized palatal approximant (like a combination between /w/ and /y/)
        west = "η", -- lowercase eta
    },
    _I_ = {
        "I",
        north = "Ï",
        northeast = "Í",
        northwest = "Ì",
        east = "Î",
        west = "Ĩ",
        south = "Į",
        "Ī",
        "ɪ", -- small capital letter i, near-close front unrounded vowel IPA
    },
    _i_ = {
        "i",
        north = "ï",
        northeast = "í",
        northwest = "ì",
        east = "î",
        west = "ĩ",
        south = "į",
        "ī",
        "ɪ", -- small capital letter i, near-close front unrounded vowel IPA
    },
    _J_ = {
        "J",
        east = "ʝ", -- voiced palatal fricative
    },
    _j_ = {
        "j",
        east = "ʝ", -- voiced palatal fricative
    },
    _K_ = {
        "K",
        north = '"',
        south = "Ķ",
        east = "–", -- hyphen minus
        southeast = "—", -- em dash
        southwest = "–", -- en dash
        "Κ", -- kappa uppercase
        "κ", -- kappa lowercase
    },
    _k_ = {
        "k",
        north = '"',
        south = "ķ",
        east = "–", -- hyphen minus
        southeast = "—", -- em dash
        southwest = "–", -- en dash
        "Κ", -- kappa uppercase
        "κ", -- kappa lowercase
    },
    _L_ = {
        "L",
        north = "'",
        northeast = "Ĺ",
        northwest = "Ľ",
        east = "+",
        west = "Ł",
        south = "Ļ",
        southeast = "£",
        southwest = "ꝉ", -- abbreviation for vel (Latin or)
        "Λ",
        "λ",
        "ɫ", -- dark l, velarized alveolar lateral approximant IPA
    },
    _l_ = {
        "l",
        north = "'",
        northeast = "ĺ",
        northwest = "ľ",
        east = "+",
        west = "ł",
        south = "ļ",
        southeast = "£",
        southwest = "ꝉ", -- abbreviation for vel (Latin or)
        "Λ",
        "λ",
        "ɫ", -- dark l, velarized alveolar lateral approximant IPA
    },
    _M_ = {
        "M",
        east = "ɱ", -- labiodental nasal IPA
        west = "Μ", -- upptercase mu
    },
    _m_ = {
        "m",
        east = "ɱ", -- labiodental nasal IPA
        west = "μ", -- lowercase mu
    },
    _N_ = {
        "N",
        north = "Ñ",
        northeast = "Ń",
        northwest = "Ǹ",
        east = "ɲ", -- palatal nasal IPA
        west = "Ν", -- uppercase nu
        southeast = "Ŋ", -- uppercase letter eng (ligature of N and G)
        south = "Ņ",
        southwest = "Ň", -- Czech
    },
    _n_ = {
        "n",
        north = "ñ",
        northeast = "ń",
        northwest = "ǹ",
        east = "ɲ", -- palatal nasal IPA
        west = "ν", -- lowercase nu
        southeast = "ŋ", -- letter eng (ligature of N and G), velar nasal IPA
        south = "ņ",
        southwest = "ň", -- Czech
    },
    _O_ = {
        "O",
        north = "Ö",
        northeast = "Ó",
        northwest = "Ò",
        east = "Ô",
        west = "Õ",
        south = "Ǫ",
        southeast = "Œ",
        southwest = "Ø",
        "Ō",
        "ɔ", -- open o, open-mid back rounded vowel IPA
        "ɒ", -- turned alpha, open back rounded vowel IPA
    },
    _o_ = {
        "o",
        north = "ö",
        northeast = "ó",
        northwest = "ò",
        east = "ô",
        west = "õ",
        south = "ǫ",
        southeast = "œ",
        southwest = "ø",
        "ō",
        "ɔ", -- open o, open-mid back rounded vowel IPA
        "ɒ", -- turned alpha, open back rounded vowel IPA
    },
    _P_ = {
        "P",
        west = "Π", -- uppercase pi
    },
    _p_ = {
        "p",
        west = "π", -- lowercase pi
    },
    _Q_ = {
        "Q",
        north = "[",
        northeast = "{",
        --- @todo Render q̃ correctly on key (not a problem in textbox?)
        --east = {"q̃"}, -- Old/Middle French abbreviation of que
    },
    _q_ = {
        "q",
        north = "[",
        northeast = "{",
        --- @todo Render q̃ correctly on key (not a problem in textbox?)
        --east = {"q̃"}, -- Old/Middle French abbreviation of que
    },
    _R_ = {
        "R",
        north = "ρ", -- lowercase rho
        northeast = "Ŕ",
        northwest = "Ρ ", -- uppercase rho
        east = "ɾ", -- alveolar flap or tap IPA
        west = "Ř", -- r with háček (Czech)
        south = "Ŗ", -- r cedilla (Latvian)
        southeast = "ɻ", -- retroflex approximant IPA
        southwest = "ɹ", -- alveolar approximant IPA
        "ʀ", -- uvular trill IPA
        "ʁ", -- voiced uvular fricative IPA
    },
    _r_ = {
        "r",
        north = "ρ", -- lowercase rho
        northeast = "ŕ",
        northwest = "Ρ ", -- uppercase rho
        east = "ɾ", -- alveolar flap or tap IPA
        west = "ř", -- r with háček (Czech)
        south = "ŗ", -- r cedilla (Latvian)
        southeast = "ɻ", -- retroflex approximant IPA
        southwest = "ɹ", -- alveolar approximant IPA
        "ʀ", -- uvular trill IPA
        "ʁ", -- voiced uvular fricative IPA
    },
    _S_ = {
        "S",
        north = "ẞ", -- uppercase eszett
        northeast = "Ś",
        northwest = "ʃ", -- esh, voiceless palato-alveolar fricative IPA
        east = "Ŝ",
        west = "Š",
        south = "Ş",
        southeast = "$",
        southwest = "Ṣ",
        "ſ", -- long s
        "Σ", -- uppercase sigma
    },
    _s_ = {
        "s",
        north = "ß", -- lowercase eszett
        northeast = "ś",
        northwest = "ʃ", -- esh, voiceless palato-alveolar fricative IPA
        east = "ŝ",
        west = "š",
        south = "ş",
        southeast = "$",
        southwest = "ṣ",
        "ſ", -- long s
        "σ", -- lowercase sigma
        "ς", -- lowercase word-end sigma
    },
    _T_ = {
        "T",
        north = "θ",
        northeast = "Þ",
        northwest = "Ț",
        east = "Ʈ",
        west = "Ť",
        south = "Ţ",
        southeast = "ʈ",
        southwest = "Ṭ",
        "Τ",
        "τ",
    },
    _t_ = {
        "t",
        north = "θ",
        northeast = "þ",
        northwest = "ț",
        east = "Ʈ",
        west = "ť",
        south = "ţ",
        southeast = "ʈ",
        southwest = "ṭ",
        "Τ",
        "τ",
    },
    _U_ = {
        "U",
        north = "Ü",
        northeast = "Ú",
        northwest = "Ù",
        east = "Û",
        west = "Ũ",
        south = "Ų",
        southwest = "Ů",
        "Ū",
        "ʌ", -- turned v, open-mid back unrounded vowel IPA
    },
    _u_ = {
        "u",
        north = "ü",
        northeast = "ú",
        northwest = "ù",
        east = "û",
        west = "ũ",
        south = "ų",
        southwest = "ů",
        "ū",
        "ʌ", -- turned v, open-mid back unrounded vowel IPA
    },
    _V_ = {
        "V",
        north = "ʌ", -- open-mid back unrounded vowel IPA
        northwest = "Ʋ", -- v with hook
        east = "Ꜹ",
        west = "Ṽ",
    },
    _v_ = {
        "v",
        north = "ʌ", -- open-mid back unrounded vowel IPA
        northwest = "ʋ", -- v with hook, labiodental approximant IPA
        east = "ꜹ",
        west = "ṽ",
    },
    _W_ = {
        "W",
        north = "]",
        northeast = "}",
        northwest = "ʍ", -- inverted w, voiceless labial-velar approximant IPA
        east = "Ƿ", -- wynn, Old English for /w/
    },
    _w_ = {
        "w",
        north = "]",
        northeast = "}",
        northwest = "ʍ", -- inverted w, voiceless labial-velar approximant IPA
        east = "ƿ", -- wynn, Old English for /w/
    },
    _X_ = {
        "X",
        east = "Χ", -- uppercase chi
        west = "Ξ", -- uppercase xi
    },
    _x_ = {
        "x",
        east = "χ", -- lowercase chi
        west = "ξ", -- lowercase xi
    },
    _Y_ = {
        "Y",
        north = "Ŷ",
        northeast = "Ý",
        northwest = "Ỳ",
        east = "Ÿ",
        west = "Ỹ",
        south = "ʎ", -- palatal lateral approximant IPA (looks like mirror lambda, but actually upside down y)
        southeast = "ʏ", -- near-close, near-front rounded vowel IPA
        southwest = "Υ", -- uppercase upsilon
    },
    _y_ = {
        "y",
        north = "ŷ",
        northeast = "ý",
        northwest = "ỳ",
        east = "ÿ",
        west = "ỹ",
        south = "ʎ", -- palatal lateral approximant IPA (looks like mirror lambda, but actually upside down y)
        southeast = "ʏ", -- near-close, near-front rounded vowel IPA
        southwest = "υ", -- lowercase upsilon
    },
    _Z_ = {
        "Z",
        northeast = "Ź",
        northwest = "Ζ", -- zeta uppercase
        west = "Ž",
        south = "ʐ", -- voiced retroflex sibilant fricative IPA
        southeast = "ʒ", -- ezh, voiced palato-alveolar fricative IPA
        southwest = "Ż",
    },
    _z_ = {
        "z",
        northeast = "ź",
        northwest = "ζ", -- zeta lowercase
        west = "ž",
        south = "ʐ", -- voiced retroflex sibilant fricative IPA
        southeast = "ʒ", -- ezh, voiced palato-alveolar fricative IPA
        southwest = "ż",
    },
}
