package com.amazon.android.widget.items

import android.content.Context
import android.graphics.drawable.Drawable
import android.support.v4.content.ContextCompat
import com.amazon.android.widget.ICommandItemPresenter
import com.amazon.android.widget.ICommandItemPresenter.DisplayPreference
import com.amazon.kcp.library.ContentMetadataDisplayItem
import com.amazon.kcp.reader.IShareHelper
import com.amazon.kcp.reader.ReaderActivity
import com.amazon.kcp.util.Utils
import com.amazon.kindle.build.BuildInfo
import com.amazon.kindle.content.ContentMetadata
import com.amazon.kindle.krl.R
import com.amazon.kindle.krx.content.IBook

/**
 * A special button for sharing progress in KFC Builds.
 * @author hensonm
 */
class KFCShareProgressCommandItem(val activity: ReaderActivity, val contentMetadata: ContentMetadata?)
    : AbstractReaderActionCommandItem(R.string.menuitem_share_progress) {

    override fun getButtonIdentifier() = "KFCShareProgressCommandItem"

    override fun getPriority(model: IBook?) = activity.resources.getInteger(R.integer.command_bar_share_progress)

    override fun getDisplayPreference(context: Context): DisplayPreference = DisplayPreference.OVERFLOW_ONLY

    override fun onClick(): Boolean {
        val docViewer = activity.docViewer ?: return false
        val shareHelper = Utils.getFactory().shareHelper

        if (contentMetadata != null) {
            val libraryItem = ContentMetadataDisplayItem(contentMetadata)
            shareHelper.share(activity, activity.findViewById(R.id.reader_drawer_layout),
                    docViewer.document, libraryItem, IShareHelper.ShareType.PROGRESS_READER)
            return true
        }

        return false
    }

    override fun isVisible(model: IBook?): Boolean {
        if (!BuildInfo.isChinaBuild()) {
            return false
        }

        if (contentMetadata != null) {
            val shareHelper = Utils.getFactory().shareHelper
            val libraryItem = ContentMetadataDisplayItem(contentMetadata)

            if (shareHelper.showNewShareOption(activity, libraryItem)) {
                return !activity.appController.applicationCapabilities.isInDemoMode
            }
        }
        return false
    }

    override fun getImage(context: Context): Drawable? {
        return ContextCompat.getDrawable(context, android.R.drawable.ic_menu_share)
    }
}