package com.amazon.kcp.reader.nightmode

import com.amazon.kindle.krx.content.IBook
import com.amazon.kindle.krx.providers.ISortableProvider
import com.amazon.kindle.krx.ui.ILocationSeekerDecoration

/**
 * Provide night mode button at the right part of location seeker.
 *
 * @author zhangbog
 */
class NightModeLocationSeekerDecorationProvider(val nightModeController: NightModeController)
    : ISortableProvider<ILocationSeekerDecoration, IBook> {

    override fun getPriority(book: IBook?) = 0

    override fun get(book: IBook?): ILocationSeekerDecoration? =
            when {
                book == null -> null
                isChildrenMangaOrComic(book) -> null
                else -> NightModeSeekerDecoration(nightModeController)
            }

    /**
     *  KFA_14751 comic books shouldn't have night mode btn.
     */
    fun isChildrenMangaOrComic(book: IBook): Boolean =
            when (book.contentClass) {
                IBook.BookContentClass.CHILDREN -> true
                IBook.BookContentClass.MANGA -> true
                IBook.BookContentClass.COMIC -> true
                else -> false
            }
}