package com.amazon.kcp.reader.nightmode

import android.content.Context
import android.support.annotation.DrawableRes
import android.view.View
import android.view.ViewParent
import android.widget.ImageButton
import android.widget.ImageView
import com.amazon.android.util.UIUtils
import com.amazon.kindle.R
import com.amazon.kindle.krx.ui.BaseLocationSeekerDecoration
import com.amazon.kindle.krx.ui.ColorMode
import com.amazon.kindle.krx.ui.ILocationSeekerDecoration

/**
 * Provide night mode button at the right part of location seeker.
 *
 * @author zhangbog
 */
class NightModeSeekerDecoration(private val nightModeController: NightModeController) : BaseLocationSeekerDecoration() {
    private var nightModeToggleButton: ImageButton? = null

    override fun getDecoration(type: ILocationSeekerDecoration.DecorationType?,
                               activityContext: Context,
                               parentView: ViewParent,
                               colorMode: ColorMode): View? = when {
        type != ILocationSeekerDecoration.DecorationType.RIGHT -> null
        activityContext === nightModeToggleButton?.context -> nightModeToggleButton
        else -> {
            val newButton = ImageButton(activityContext)
            newButton.setImageDrawable(activityContext.resources.getDrawable(getButtonIcon(colorMode)))
            newButton.background = UIUtils.getDrawableForThemeAttribute(activityContext, R.attr.selectableItemBackgroundBorderless)
            newButton.scaleType = ImageView.ScaleType.CENTER_INSIDE

            newButton.setOnClickListener { nightModeController.toggleNightMode() }
            nightModeToggleButton = newButton
            newButton
        }
    }

    @DrawableRes
    private fun getButtonIcon(colorMode: ColorMode): Int = when {
        nightModeController.isInNightMode -> R.drawable.ic_night_mode_sun_nln
        colorMode.isDark -> R.drawable.ic_night_mode_moon_nln_white
        else -> R.drawable.ic_night_mode_moon_nln_black
    }
}
