var Field= function(cName){
    this.getNameInternal= function(){return cName;};
};


Field.prototype= {
    get name(){return this.getNameInternal();},
    
	get value(){
		var value= MSResult(msApp.getFieldValue(this.name));
		if(!isNaN(value))
			return new Number(value);
		return value;	
	},
	
    set value(v){
		msApp.setFieldValue(this.name, MSParam(v));
	},
	
    get doc(){
		return (function(){return this;}).call(null);
	},
	
	getArray: function(){
		var names= MSResult(msApp.getFieldChildren(this.name));
		var res= new Array(names.length);
		for(var i= 0; i<names.length; i++){
			res[i]= new Field(names[i]);
		}
		return res;
	},
	
	isBoxChecked: function(nWidget){
		return MSResult(msApp.isFieldBoxChecked(this.name, nWidget));
	},
	
	set hidden(bHidden){
		if(bHidden)
			msApp.setFieldDisplay(this.name, display.hidden);
		else
			msApp.setFieldDisplay(this.name, display.visible);
	}
}

var display= {
	get visible(){
		return 0;
	},

	get hidden(){
		return 1;
	},

	get noPrint(){
		return 2;
	},

	get noView(){
		return 3;
	}
}

var border= {
	get s(){
		return 0;
	},

	get b(){
		return 1;
	},

	get d(){
		return 2;
	},

	get i(){
		return 3;
	},
	
	get u(){
		return 4;
	}
}