function AFNumber_Keystroke(nDec, sepStyle, negStyle, currStyle, strCurrency, bCurrencyPrepend)
{
    //NOT IMPLEMENTED
    event.rc= false;
}


function AFSimple_Calculate(cFunction, cFields)
{
    if(cFunction=="SUM")
    {
        var sum= 0;
        for(var i= 0; i<cFields.length; i++)
        {
             var val = event.target.doc.getField(cFields[i]).value;
             if(!val)
             {
                val = 0;
             }

            sum+= new Number(val);            
        }
        
        event.value= sum;
        return;
    }
    
    if(cFunction=="PRD")
    {
        var prd= 1;
        for(var i= 0; i<cFields.length; i++)
        {          
             var val = event.target.doc.getField(cFields[i]).value;
             if(!val)
             {
                val = 0;
             }
                
             prd*= new Number(val);                            
        }
        
        event.value= cFields.length > 0 ? prd : 0;
        return;
    }

    throw new Error("AFSimple_Calculate(" + cFunction + "...) is not implemented");
}

function AFMakeNumber(val){
    return new Number(val);
}


function AFNumber_Format(nDec, sepStyle, negStyle, currStyle, strCurrency, bCurrencyPrepend)
{
    var num= AFMakeNumber(event.value);
    
    var res= num.toFixed(nDec);
    
    if(bCurrencyPrepend)
        res= strCurrency + res;
    else
        res= res + strCurrency;

    event.value= res;
    event.rc= true; 
}

function AFMergeChange(event)
{
	var prefix, postfix;
	var value = event.value;
	if(event.willCommit) return event.value;
	if(event.selStart >= 0)
		prefix = value.substring(0, event.selStart);
	else
		prefix = "";
	if(event.selEnd >= 0 && event.selEnd <= value.length)
		postfix = value.substring(event.selEnd, value.length);
	else
		postfix = "";
	return prefix + event.change + postfix;
}

function AFExtractNums(string)
{
	if(!string)
		return null;

	var nums = new Array();
	var inNum= false;
	for(pos= 0; pos<string.length; pos++)
	{
		var ch= string.charAt(pos);
		if(ch>='0' && ch<='9')
		{
			if(!inNum){
				inNum= true;
				nums.length++;
				nums[nums.length-1]=ch-'0';
			}
			else
			{	
				nums[nums.length-1]*=10;
				nums[nums.length-1]+=ch-'0';
			}
		}
		else
			inNum= false;
	}

	if(nums.length >= 1) 
		return nums;
	return null;
}

function AFParseDateEx(cDate, cFormat)
{
	
    var posY= -1;
    var lenY= 0;
    var posD= -1;
    var lenD= 0;
    var posM= -1;
    var lenM= 0;
    var posH= -1;
    var lenH= 0;
    var posMin= -1;
    var lenMin= 0;
    var posSec= -1;
    var lenSec= 0;

	var component= 0;
	for(pos= 0; pos<cFormat.length; pos++){
		switch(cFormat.charAt(pos))
		{
		case 'y':
			if(posY<0)
				posY= component++;
			lenY++;
			break;
		case 'm':
			if(posM<0)
				posM= component++;
			lenM++;
			break;
		case 'd':
			if(posD<0)
				posD= component++;
			lenD++;
			break;
        case 'H':
            if(posH<0)
                posH= component++;
            lenH++;
            break;
        case 'M':
            if(posMin<0)
                posMin= component++;
            lenMin++;
            break;
        case 's':
            if(posSec<0)
                posSec= component++;
            lenSec++;
            break;
		}
	}
	
	var nums= AFExtractNums(cDate);
	if(!nums)
		return nums;

	var year= 2000;
	if (posY>=0 && posY<nums.length)
	    year = nums[posY];

	if(year<100)
		year+=2000;

	var month= 1;
	if (posM>=0 && posM < nums.length)
	    month = nums[posM];

	if(month<1 || month>12)
		return null;

	var day= 1;
	if(posD>=0 && posD < nums.length)
		day= nums[posD];

	if(day<1 || day>31)
		return null;
	
	switch(month){
		case 4:
		case 6:
		case 9:
		case 11:
			if(day>30)
				return null;
			break;
		case 2:
			if(day>29)
				return null;
			if(day==29 && !((year%400)==0 || ((year%4)==0 && (year%100)!=0 ))){
					return null;
			}
			break;
	}

	var hour = 0;
	if (posH >=0 && posH < nums.length)
	    hour = nums[posH];

	if (hour < 0 || hour > 23) {
	    return null;
	}

    var minute = 0;
    if (posMin >=0 && posMin < nums.length)
    	minute = nums[posMin];

    if (minute < 0 || minute > 59) {
        return null;
    }

    var second = 0;
    if (posSec >=0 && posSec < nums.length)
        second = nums[posSec];

    if (second < 0 || second > 59) {
        return null;
    }

	//TODO: fix valid days in short months
	
	var date= new Date(year, month-1, day, hour, minute, second);
	if(isNaN(date.getTime()))
		return null;
	return date;
}

function AFDate_FormatEx(cFormat)
{
	if (!event.value) 
		return;	/* Blank fields remain blank */

	var date = AFParseDateEx(event.value, cFormat);
	if (!date) {
		event.value = "";
		return;
	}
	
	event.value = util.printd(cFormat, date);
}

function AFTime_Format(cFormat)
{
    if (typeof cFormat === 'number') {
        switch(cFormat) {
        case 0:
            cFormat='HH:MM';
            break;
        case 1:
            cFormat='H:MM';
            break;
        case 2:
            cFormat='HH:MM:ss';
            break;
        case 4:
            cFormat='H:MM:ss';
            break;
        }
    }
    AFDate_FormatEx(cFormat)
}