var util= {};

util.printf= function(){
	
	var res= "";
	var format= arguments[0];
	var idxArgument= 1;
	
	for(;;){
		var idx= format.indexOf("%");
		if(idx<0){
			res+=format;
			break;
		}
		
		res+= format.substr(0, idx);
		format= format.substr(++idx);		
		var arg= arguments[idxArgument++];

		var nDecSep;
		if(format.charAt(0)==','){
			nDecSep= format.charAt(1);
			format= format.substr(2);
		}
		//console.log("nDecSep= " + nDecSep);
		
		var cFlags;
		if(format.charAt(0)=='+'){
			cFlags= format.charAt(0);
			format= format.substr(1);
		}
		else if(format.charAt(0)==' '){
			cFlags= format.charAt(0);
			format= format.substr(1);
		}
		else if(format.charAt(0)=='0'){
			cFlags= format.charAt(0);
			format= format.substr(1);
		}
		else if(format.charAt(0)=='#'){
			cFlags= format.charAt(0);
			format= format.substr(1);
		}
		
		//console.log("cFlags= " + cFlags);

		
		var nWidth;
		if(format.charAt(0)>'0' && format.charAt(0)<'9'){
			nWidth= format.charAt(0)-'0';
			format= format.substr(1);
			if(format.charAt(0)>'0' && format.charAt(0)<'9'){
				width*=10;
				nWidth+= format.charAt(0)-'0';
				format= format.substr(1);
			}
			
			//console.log("nWidth= " + nWidth);
		}
		
		var nPrecision;
		if(format.charAt(0)=='.'){
			nPrecision= format.charAt(1)-'0';
			format= format.substr(2);
		}
		
		var cConvChar= format.charAt(0);
		format= format.substr(1);
		switch(cConvChar){
		case 'f':
			res+= new Number(arg).toFixed(nPrecision);
			break;
		case 'd':
			res+= new Number(arg).toFixed();
			break;
		case 'x':
			res+= new Number(arg);
			break;
		case 's':
			res += arg;
			break;
		default:
			throw new Error("Invalid printf cConvChar: " + cConvChar);
		}
	}
	
	return res;
	
};

util.printd= function(cFormat, date)
{
	var ch= undefined;
	var len= 0;
	var res= "";

	var printComponent= function(type, len){
		switch(type)
		{
			case 'm':
				if(len==2)
				{
					var m= date.getMonth()+1;
					if(m<10)
						res+="0";
					res+= m;
				}
				else
					res+= date.getMonth()+1;
				break;
			case 'd':
				if(len==2)
				{
					var d= date.getDate();
					if(d<10)
						res+="0";
					res+= d;
				}
				else
					res+= date.getDate();	
				break;				
			case 'y':
				if(len==2)
					res+= date.getFullYear() %100;
				else
					res+= date.getFullYear();
				break;
			case 'H':
			    if(len==2)
                {
                    var d= date.getHours();
                    if(d<10)
                        res+="0";
                    res+= d;
                }
                else
                    res+= date.getHours();
                break;
            case 'M':
                if(len==2)
                {
                    var d= date.getMinutes();
                    if(d<10)
                        res+="0";
                    res+= d;
                }
                else
                    res+= date.getMinutes();
                break;
            case 's':
                if(len==2)
                {
                    var d= date.getSeconds();
                    if(d<10)
                        res+="0";
                    res+= d;
                }
                else
                    res+= date.getSeconds();
                break;
			default:
				while(len--)
					res+= type;
				break;
		}
		
		return res;
	};
	
	for(pos= 0; pos<cFormat.length; pos++)
	{
		if(ch=='\\')
		{
			res+= cFormat.charAt(pos);
			ch= undefined;
			len= 0;
		}
		else if(ch==cFormat.charAt(pos))
		{
			len++;
		}
		else
		{
			printComponent(ch, len);
			ch= cFormat.charAt(pos);
			len= 1;
		}		
	}	
	
	printComponent(ch, len);
	return res;
}