precision highp float;

varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
varying highp vec2 textureCoordinate3;
varying highp vec2 textureCoordinate4;
varying highp vec2 textureCoordinate5;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform sampler2D inputImageTexture4;
uniform sampler2D inputImageTexture5;

uniform lowp float alpha;

void main()
 {
     lowp vec4 base = texture2D(inputImageTexture, textureCoordinate);


     if(alpha == 1.0)
     {
         gl_FragColor = base;
     }
     else
     {

         lowp vec2 pos2 = vec2(textureCoordinate2.x, textureCoordinate2.y);
         highp vec4 color = texture2D(inputImageTexture4, pos2);
         lowp vec2 blurCoordinate = vec2(textureCoordinate.x,textureCoordinate.y);

         highp vec4 blurBase = texture2D(inputImageTexture2, blurCoordinate);
         lowp vec2 blurCoordinate2 = vec2( textureCoordinate2.x,textureCoordinate2.y);
         highp vec4 blurColor =   texture2D(inputImageTexture5, blurCoordinate2);
         highp vec4 mask = texture2D(inputImageTexture3, textureCoordinate3);


         highp vec4 result;
         highp vec4 tmpFragColor;

         if(color.a == 0.0)
         {
             result = base;
         }
         else
         {
             result =   color* (((blurBase/blurColor - 1.0)*1.0) + 1.0);
         }
         tmpFragColor =  vec4( ( result.rgb*(1.0 - mask.a) + base.rgb*((mask.a)))*1.0 , 1.0);
         gl_FragColor = mix(base , tmpFragColor , alpha);
    }

 }
