precision highp float;
precision highp int;

varying vec2 vTextureCo;
uniform vec2 u_centerCoord;
uniform float u_radius;
uniform sampler2D uTexture;

void main() {
    vec4 pixColor = texture2D(uTexture, vTextureCo);
    float dist = distance(vTextureCo, u_centerCoord);
    if (dist < u_radius + 0.005) {
        float mask = smoothstep(u_radius, u_radius + 0.005, dist);
        gl_FragColor = vec4(pixColor.rgb, 1.0 - mask);
    } else {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    }
}