package com.lib.downloader.aidl;

import com.lib.downloader.info.RPPDTaskInfo;
import com.lib.downloader.aidl.RPPIDownloadCallBack;

interface RPPIDownloadService {

	void requestDTaskInfoList();
    
   	void createDTask(in RPPDTaskInfo task);
   	
   	void createBatchDTask(in List<RPPDTaskInfo> taskList);
   
   	void startDTask(long uniqueId);
   	
   	void restartDTask(long uniqueId);
   	
   	void restartNewDTask(in RPPDTaskInfo task);
   
   	void stopDTask(long uniqueId);
   	
   	void stopBatchDTask(in List<RPPDTaskInfo> taskList);
   
   	void deleteDTask(long uniqueId, int hashCode, boolean needDelFile);
   	
   	void deleteBatchDTask(in List<RPPDTaskInfo> taskList, int hashCode, boolean needDelFile);
   	
   	void setDMaxTask(int maxTask);
   	
   	void setWifiOnly(boolean isWifiOnly, boolean needContinue, boolean needSave);
   
   	void registerIDownloadCallBack(RPPIDownloadCallBack callback);
   
   	void unregisterIDownloadCallBack(RPPIDownloadCallBack callback);
   
   	void restoredDTaskInfoList(in List<RPPDTaskInfo> taskList, in List<String> pathList);
   	
   	void changeDTaskSourceType(long uniqueId, int sourceType);
   	
   	void changeDTaskScheduleType(long uniqueId, boolean noNeedSchedule);
   	
   	void stopAllRunningDTask();
   	
   	void resetFreeFlowDTask(long uniqueId, in RPPDTaskInfo task);
}


