  function parseQuery (query) {
    var queryArr;
    var result = {};
    query = query.replace('?', '');
  
    if (!query)return result;
  
    queryArr = query.split('&');
    
    for(var i=0;i<queryArr.length;i++){
      var item=queryArr[i];
      var keyValueArr = item.split('=');
      var value = keyValueArr[1];
      
      result[keyValueArr[0]] = value ? decodeURIComponent(value) : null;
    }

    return result;
  }
  
  function getDesc() {
    var desc;
    var metaDesc=document.querySelector('[name=description]');

    if(!metaDesc||!metaDesc.content){
      desc=document.body.innerText;
      desc=desc?desc.replace(/\s/g,'').substring(0,200):'';
    }else{
      desc=metaDesc.content;
    }

    return desc;
  }

  function getImage() {
    var imgs=document.querySelectorAll('img');
    var imgsrcReg=/^(http:|https:)/;
    if(!imgs){
      return '';
    }

    for(var i=0;i<imgs.length;i++){
      var img=imgs[i];
      var naturalWidth=img.naturalWidth;

      if(naturalWidth>=60&&imgsrcReg.test(img.src)){
        return img.src;
      }
    }
    return '';
  }
  
  function getShareUrl() {
    var params=parseQuery(location.search);
    
    return params.shareUrl?params.shareUrl:location.href;
  }

  window.Client.shareSocial('-1',getShareUrl(),document.title,getDesc(),getImage());

