local ffi = require("ffi")

ffi.cdef[[
typedef signed char l_int8;
typedef unsigned char l_uint8;
typedef short int l_int16;
typedef short unsigned int l_uint16;
typedef int l_int32;
typedef unsigned int l_uint32;
typedef float l_float32;
typedef double l_float64;
struct Box {
  l_int32 x;
  l_int32 y;
  l_int32 w;
  l_int32 h;
  l_uint32 refcount;
};
typedef struct Box BOX;
struct Boxa {
  l_int32 n;
  l_int32 nalloc;
  l_uint32 refcount;
  struct Box **box;
};
typedef struct Boxa BOXA;
struct Numa {
  l_int32 nalloc;
  l_int32 n;
  l_int32 refcount;
  l_float32 startx;
  l_float32 delx;
  l_float32 *array;
};
typedef struct Numa NUMA;
static const int L_INSERT = 0;
static const int L_COPY = 1;
static const int L_CLONE = 2;
static const int L_COPY_CLONE = 3;
struct PixColormap {
  void *array;
  l_int32 depth;
  l_int32 nalloc;
  l_int32 n;
};
struct Pix {
  l_uint32 w;
  l_uint32 h;
  l_uint32 d;
  l_uint32 spp;
  l_uint32 wpl;
  l_uint32 refcount;
  l_int32 xres;
  l_int32 yres;
  l_int32 informat;
  l_int32 special;
  char *text;
  struct PixColormap *colormap;
  l_uint32 *data;
};
typedef struct Pix PIX;
BOX *boxCreate(l_int32, l_int32, l_int32, l_int32);
BOXA *boxaCreate(l_int32);
BOX *boxaGetBox(BOXA *, l_int32, l_int32);
NUMA *numaCreate(l_int32);
NUMA *numaCreateFromFArray(l_float32 *, l_int32, l_int32);
BOXA *boxaCombineOverlaps(BOXA *);
BOXA *boxaClipToBox(BOXA *, BOX *);
BOX *boxCopy(BOX *);
BOX *boxClone(BOX *);
BOX *boxOverlapRegion(BOX *, BOX *);
BOX *boxAdjustSides(BOX *, BOX *, l_int32, l_int32, l_int32, l_int32);
l_int32 boxaAddBox(BOXA *, BOX *, l_int32);
l_int32 numaGetMax(NUMA *, l_float32 *, l_int32 *);
l_int32 numaGetIValue(NUMA *, l_int32, l_int32 *);
l_int32 boxaGetCount(BOXA *);
l_int32 numaGetCount(NUMA *);
l_int32 boxaWrite(const char *, BOXA *);
void boxDestroy(BOX **);
void boxaDestroy(BOXA **);
void numaDestroy(NUMA **);
void pixDestroy(PIX **);
l_int32 pixWritePng(const char *, PIX *, l_float32);
l_int32 pixWriteMemPng(l_uint8 **, size_t *, PIX *, l_float32);
l_int32 pixGetWidth(PIX *);
l_int32 pixGetHeight(PIX *);
l_int32 pixGetDepth(PIX *);
l_int32 pixGetWpl(PIX *);
l_int32 pixSetPixel(PIX *, l_int32, l_int32, l_uint32);
l_uint32 *pixGetData(PIX *);
PIX *pixCreate(l_int32, l_int32, l_int32);
PIX *pixConvertTo1(PIX *, l_int32);
PIX *pixThresholdToBinary(PIX *, l_int32);
PIX *pixConvertTo32(PIX *);
PIX *pixDrawBoxaRandom(PIX *, BOXA *, l_int32);
PIX *pixMultiplyByColor(PIX *, PIX *, BOX *, l_uint32);
PIX *pixBlendBackgroundToColor(PIX *, PIX *, BOX *, l_uint32, l_float32, l_int32, l_int32);
l_int32 pixGetRegionsBinary(PIX *, PIX **, PIX **, PIX **, struct Pixa *);
BOXA *pixSplitIntoBoxa(PIX *, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32);
PIX *pixReduceRankBinaryCascade(PIX *, l_int32, l_int32, l_int32, l_int32);
]]
