package com.rookiestudio.Transitions;

import com.rookiestudio.baseclass.TSprite;
import com.rookiestudio.perfectviewer.Config;
import com.rookiestudio.perfectviewer.Constant;
import com.rookiestudio.perfectviewer.Global;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Region;
import android.graphics.drawable.GradientDrawable;
import android.util.Log;

public class TPageCurl extends TTransitionBase {

  private static final String TAG="perfectviewer";
  private int mWidth=0;
  private int mHeight=0;
  private int mCornerX=0; // 拖拽点对应的页脚
  private int mCornerY=0;
  private Path mPath0;
  private Path mPath1;

  PointF mBezierStart1=new PointF(); // 贝塞尔曲线起始点
  PointF mBezierControl1=new PointF(); // 贝塞尔曲线控制点
  PointF mBeziervertex1=new PointF(); // 贝塞尔曲线顶点
  PointF mBezierEnd1=new PointF(); // 贝塞尔曲线结束点

  PointF mBezierStart2=new PointF(); // 另一条贝塞尔曲线
  PointF mBezierControl2=new PointF();
  PointF mBeziervertex2=new PointF();
  PointF mBezierEnd2=new PointF();

  float mMiddleX;
  float mMiddleY;
  float mDegrees;
  float mTouchToCornerDis;
  ColorMatrixColorFilter mColorMatrixFilter;
  Matrix mMatrix;
  float[] mMatrixArray={ 0,0,0,0,0,0,0,0,1.0f };

  boolean mIsRTandLB; // 是否属于右上左下
  float mMaxLength=(float) Math.hypot(mWidth,mHeight);
  int[] mBackShadowColors;
  int[] mFrontShadowColors;
  GradientDrawable mBackShadowDrawableLR;
  GradientDrawable mBackShadowDrawableRL;
  GradientDrawable mFolderShadowDrawableLR;
  GradientDrawable mFolderShadowDrawableRL;

  GradientDrawable mFrontShadowDrawableHBT;
  GradientDrawable mFrontShadowDrawableHTB;
  GradientDrawable mFrontShadowDrawableVLR;
  GradientDrawable mFrontShadowDrawableVRL;

  Bitmap NextPageMirror=null;
  Paint mPaint;
  private int PageCenterX;
  private int PageCenterY;

  public TPageCurl(Context context) {
    super(context);
    // TODO Auto-generated constructor stub
    mPath0=new Path();
    mPath1=new Path();
    createDrawable();

    mPaint=new Paint();
    mPaint.setFilterBitmap(true);
    mPaint.setStyle(Paint.Style.FILL);

    ColorMatrix cm=new ColorMatrix();
    float array[]={ 0.55f,0,0,0,80.0f,0,0.55f,0,0,80.0f,0,0,
        0.55f,0,80.0f,0,0,0,0.2f,0 };
    cm.set(array);
    mColorMatrixFilter=new ColorMatrixColorFilter(cm);
    mMatrix=new Matrix();

    TouchPoint.x=0.01f; // 不让x,y为0,否则在点计算时会有问题
    TouchPoint.y=0.01f;
  }

  public void SetBitmaps(Bitmap bm1,TSprite Sprite1,Bitmap bm2,TSprite Sprite2) {
    super.SetBitmaps(bm1,Sprite1,bm2,Sprite2);
    mWidth=bm1.getWidth();
    mHeight=bm1.getHeight();
/*    if (DualPageMode) {
      mWidth/=2;
    }
    if (NextPageMirror!=null) {
      NextPageMirror.recycle();
      NextPageMirror=null;
    }
    Matrix matrix = new Matrix(); 
    matrix.preScale(-1.0f, 1.0f); 
    NextPageMirror = Bitmap.createBitmap(bm2, 0, 0, bm2.getWidth(), bm2.getHeight(), matrix, false);*/
    PageCenterX=mWidth/2;
    PageCenterY=mHeight/2;
  }
  
  public void SetScreen(int w,int h) 
  {
    super.SetScreen(w,h);
  }
  
  public void SetStartXY(float x,float y) 
  {
    super.SetStartXY(x,y);    
    calcCornerXY(x,y);
    TouchPoint.x=x;
    TouchPoint.y=y;
    Log.d("perfectviewer","SetStartXY:  StartPoint.x:"+StartPoint.x+"  StartPoint.y:"+StartPoint.y);
  }
  
  public void StartAuto(boolean isForward,int delayMillis) 
  {
    if (Global.BookDirection!=Constant.PageDirection_Right) {
      isForward=!isForward;
    }
    if (isForward) {
      SetStartXY(CurrentPageSprite.X,CurrentPageSprite.Y+mHeight-1);
      Move(CurrentPageSprite.X+PageCenterX,CurrentPageSprite.Y+PageCenterY);
      MoveDirection=1;
    } else {
      if (DualPageMode) {
        SetStartXY(CurrentPageSprite.X+(mWidth*2)-1,CurrentPageSprite.Y+mHeight-1);
        Move(CurrentPageSprite.X+mWidth+PageCenterX,CurrentPageSprite.Y+PageCenterY);
      } else {
        SetStartXY(CurrentPageSprite.X+mWidth-1,CurrentPageSprite.Y+mHeight-1);
        Move(CurrentPageSprite.X+PageCenterX,CurrentPageSprite.Y+PageCenterY);
      }
      MoveDirection=-1;      
    }
    startAnimation(delayMillis);
  }
    
  /**
  *Author : hmg25 Version: 1.0 Description : 计算拖拽点对应的拖拽脚
   */
  public void calcCornerXY(float x,float y) {
    if (x <= ScreenWidth/2)
      mCornerX=0;
    else
      mCornerX=ScreenWidth;
    if (y <= ScreenHeight/2)
      mCornerY=0;
    else
      mCornerY=ScreenHeight;
    if ((mCornerX == 0 && mCornerY == ScreenHeight)
        || (mCornerX == ScreenWidth && mCornerY == 0))
      mIsRTandLB=true;
    else
      mIsRTandLB=false;
  }

  public void Move(float x,float y) 
  {
    super.Move(x,y);
    if (MoveDirection==0) {
      if (DiffPoint.x>0) {
        MoveDirection=1;
      } else {
        MoveDirection=-1;        
      }
    }
/*    if (TouchPoint.y<0) {
      TouchPoint.y=1;
    } else if (TouchPoint.y>=mHeight) {
      TouchPoint.y=mHeight-1;
    } else {
      if (mCornerY==0) {
        if (TouchPoint.y>=PageCenterY) {
          TouchPoint.y=PageCenterY-1;
        }
      } else {
        if (TouchPoint.y<=PageCenterY) {
          TouchPoint.y=PageCenterY+1;
        }
      }
    }*/
  }

  /**
  *Author : hmg25 Version: 1.0 Description : 求解直线P1P2和直线P3P4的交点坐标
   */
  public PointF getCross(PointF P1,PointF P2,PointF P3,PointF P4) {
    PointF CrossP=new PointF();
    // 二元函数通式： y=ax+b
    float a1=(P2.y-P1.y)/(P2.x-P1.x);
    float b1=((P1.x*P2.y)-(P2.x*P1.y))/(P1.x-P2.x);

    float a2=(P4.y-P3.y)/(P4.x-P3.x);
    float b2=((P3.x*P4.y)-(P4.x*P3.y))/(P3.x-P4.x);
    CrossP.x=(b2-b1)/(a1-a2);
    CrossP.y=a1*CrossP.x+b1;
    return CrossP;
  }

  private void calcPoints() {
    float OldX=mBezierControl1.x;
    mMiddleX=(TouchPoint.x+mCornerX)/2;
    mMiddleY=(TouchPoint.y+mCornerY)/2;
    mBezierControl1.x=mMiddleX-(mCornerY-mMiddleY)*(mCornerY-mMiddleY)/(mCornerX-mMiddleX);
    mBezierControl1.y=mCornerY;
    mBezierControl2.x=mCornerX;
    mBezierControl2.y=mMiddleY-(mCornerX-mMiddleX)*(mCornerX-mMiddleX)/(mCornerY-mMiddleY);

    mBezierStart1.x=mBezierControl1.x-(mCornerX-mBezierControl1.x)/2;
    mBezierStart1.y=mCornerY;
/*    if (DualPageMode) {
      if (MoveDirection!=1) {
        if ((mBezierStart1.x<mWidth) && (TouchPoint.x<mWidth)) {
          mBezierStart1.x=mWidth;
        }
      } else {
        if ((mBezierStart1.x>mWidth) && (TouchPoint.x>mWidth)) {
          mBezierStart1.x=mWidth;
        } else if ((mBezierStart1.x<0) && (TouchPoint.x<0)) {
          mBezierStart1.x=0;
        }
      }
    }*/
    // 当mBezierStart1.x < 0或者mBezierStart1.x > 480时
    // 如果继续翻页，会出现BUG故在此限制
    if (TouchPoint.x > 0 && TouchPoint.x < mWidth) {
      if (mBezierStart1.x < 0 || mBezierStart1.x > mWidth) {
        if (mBezierStart1.x < 0)
          mBezierStart1.x=mWidth-mBezierStart1.x;

        float f1=Math.abs(mCornerX-TouchPoint.x);
        float f2=mWidth*f1/mBezierStart1.x;
        TouchPoint.x=Math.abs(mCornerX-f2);

        float f3=Math.abs(mCornerX-TouchPoint.x)* Math.abs(mCornerY-TouchPoint.y)/f1;
        TouchPoint.y=Math.abs(mCornerY-f3);

        mMiddleX=(TouchPoint.x+mCornerX)/2;
        mMiddleY=(TouchPoint.y+mCornerY)/2;

        mBezierControl1.x=mMiddleX-(mCornerY-mMiddleY)* (mCornerY-mMiddleY)/(mCornerX-mMiddleX);
        mBezierControl1.y=mCornerY;

        mBezierControl2.x=mCornerX;
        mBezierControl2.y=mMiddleY-(mCornerX-mMiddleX)
            * (mCornerX-mMiddleX)/(mCornerY-mMiddleY);
         //Log.i("perfectviewer","mTouchX --> "+TouchPoint.x+"  mTouchY-->  "+TouchPoint.y);
         //Log.i("perfectviewer","mBezierControl1.x--  "+mBezierControl1.x+"  mBezierControl1.y -- "+mBezierControl1.y);
         //Log.i("perfectviewer","mBezierControl2.x -- "+mBezierControl2.x+"  mBezierControl2.y -- "+mBezierControl2.y);
         mBezierStart1.x=mBezierControl1.x-(mCornerX-mBezierControl1.x)/2;
      }
    }
    mBezierStart2.x=mCornerX;
    mBezierStart2.y=mBezierControl2.y-(mCornerY-mBezierControl2.y)/ 2;

    mTouchToCornerDis=(float) Math.hypot((TouchPoint.x-mCornerX),(TouchPoint.y-mCornerY));

    Log.i("perfectviewer","mTouchX  "+TouchPoint.x+"  mTouchY  "+TouchPoint.y+"  mCornerY  "+mCornerX+"  mCornerY  "+mCornerY);
    Log.i("perfectviewer","mBezierControl1.x  "+mBezierControl1.x+"  mBezierControl1.y  "+mBezierControl1.y+"  mBezierStart1.x  "+mBezierStart1.x+"  mBezierStart1.y  "+mBezierStart1.y);
    //Log.i("perfectviewer","mMiddleX  "+mMiddleX+"  mMiddleY  "+mMiddleY+"  mCornerX  "+mCornerX+"  mCornerY  "+mCornerY);
    Log.i("perfectviewer","mBezierControl2.x  "+mBezierControl2.x+"  mBezierControl2.y  "+mBezierControl2.y+"  mBezierStart2.x  "+mBezierStart2.x+"  mBezierStart2.y  "+mBezierStart2.y);

    mBezierEnd1=getCross(TouchPoint,mBezierControl1,mBezierStart1,mBezierStart2);
    mBezierEnd2=getCross(TouchPoint,mBezierControl2,mBezierStart1,mBezierStart2);

     //Log.i("perfectviewer","mBezierEnd1.x  "+mBezierEnd1.x+"  mBezierEnd1.y  "+mBezierEnd1.y);
     //Log.i("perfectviewer","mBezierEnd2.x  "+mBezierEnd2.x+"  mBezierEnd2.y  "+mBezierEnd2.y);

    /*
    *mBeziervertex1.x 推导
    *((mBezierStart1.x+mBezierEnd1.x)/2+mBezierControl1.x)/2 化简等价于
    *(mBezierStart1.x+ 2*mBezierControl1.x+mBezierEnd1.x)/4
     */
    mBeziervertex1.x=(mBezierStart1.x+2*mBezierControl1.x+mBezierEnd1.x)/4;
    mBeziervertex1.y=(2*mBezierControl1.y+mBezierStart1.y+mBezierEnd1.y)/4;
    mBeziervertex2.x=(mBezierStart2.x+2*mBezierControl2.x+mBezierEnd2.x)/4;
    mBeziervertex2.y=(2*mBezierControl2.y+mBezierStart2.y+mBezierEnd2.y)/4;
  }

  private void drawCurrentPageArea(Canvas canvas,Bitmap bitmap,Path path) {
    mPath0.reset();
    mPath0.moveTo(mBezierStart1.x,mBezierStart1.y);
    mPath0.quadTo(mBezierControl1.x,mBezierControl1.y,mBezierEnd1.x,
        mBezierEnd1.y);
    mPath0.lineTo(TouchPoint.x,TouchPoint.y);
    mPath0.lineTo(mBezierEnd2.x,mBezierEnd2.y);
    mPath0.quadTo(mBezierControl2.x,mBezierControl2.y,mBezierStart2.x,
        mBezierStart2.y);
    mPath0.lineTo(mCornerX,mCornerY);
    mPath0.close();

    canvas.save();
    canvas.clipPath(path,Region.Op.XOR);
    canvas.drawBitmap(bitmap,0,0,null);
    canvas.restore();
  }

  private void drawNextPageAreaAndShadow(Canvas canvas,Bitmap bitmap) {
    if ((Float.isNaN(mBezierEnd2.x)) || (Float.isNaN(mBezierEnd2.y))) {
      canvas.drawBitmap(bitmap, 0, 0, null);
      return;
    }
    mPath1.reset();
    mPath1.moveTo(mBezierStart1.x,mBezierStart1.y);
    mPath1.lineTo(mBeziervertex1.x,mBeziervertex1.y);
    mPath1.lineTo(mBeziervertex2.x,mBeziervertex2.y);
    mPath1.lineTo(mBezierStart2.x,mBezierStart2.y);
    mPath1.lineTo(mCornerX,mCornerY);
    mPath1.close();

    mDegrees=(float) Math.toDegrees(Math.atan2(mBezierControl1.x
        - mCornerX,mBezierControl2.y-mCornerY));
    int leftx;
    int rightx;
    GradientDrawable mBackShadowDrawable;
    if (mIsRTandLB) {
      leftx=(int) (mBezierStart1.x);
      rightx=(int) (mBezierStart1.x+mTouchToCornerDis/4);
      mBackShadowDrawable=mBackShadowDrawableLR;
    } else {
      leftx=(int) (mBezierStart1.x-mTouchToCornerDis/4);
      rightx=(int) mBezierStart1.x;
      mBackShadowDrawable=mBackShadowDrawableRL;
    }
    float pp=0;
    if (MoveDirection==1) {
      pp=((mWidth-TouchPoint.x)/mWidth);
    } else {
      pp=(TouchPoint.x/mWidth);
    }
//    mBackShadowDrawable.setAlpha((int) (255*pp));
//    Log.i("perfectviewer","leftx  "+leftx+"  rightx  "+rightx);
//    Log.i("perfectviewer","mBezierStart1.x  "+mBezierStart1.x+"  mTouchToCornerDis  "+mTouchToCornerDis);
    canvas.save();
    canvas.clipPath(mPath0);
    canvas.clipPath(mPath1,Region.Op.INTERSECT);
    canvas.drawBitmap(bitmap,0,0,null);
    canvas.rotate(mDegrees,mBezierStart1.x,mBezierStart1.y);
    mBackShadowDrawable.setBounds(leftx,(int) mBezierStart1.y,rightx,(int) (mMaxLength+mBezierStart1.y));
    mBackShadowDrawable.draw(canvas);
    canvas.restore();
  }

  public void DrawFrame(Canvas canvas)
  {
    if (MoveDirection==0) {
      return;
    }
    canvas.drawColor(0xFFAAAAAA);
    calcPoints();
    drawCurrentPageArea(canvas,CurrentPageBitmap,mPath0);
    drawNextPageAreaAndShadow(canvas,NextPageBitmap);
    drawCurrentPageShadow(canvas);
    if (DualPageMode) {
      drawCurrentBackArea(canvas,NextPageMirror);
    } else {
      drawCurrentBackArea(canvas,CurrentPageBitmap);
    }
  }

  /**
  *Author : hmg25 Version: 1.0 Description : 创建阴影的GradientDrawable
   */
  private void createDrawable() {
    int[] color={ 0x333333,0xb0333333 };
    mFolderShadowDrawableRL=new GradientDrawable(
        GradientDrawable.Orientation.RIGHT_LEFT,color);
    mFolderShadowDrawableRL
        .setGradientType(GradientDrawable.LINEAR_GRADIENT);

    mFolderShadowDrawableLR=new GradientDrawable(
        GradientDrawable.Orientation.LEFT_RIGHT,color);
    mFolderShadowDrawableLR
        .setGradientType(GradientDrawable.LINEAR_GRADIENT);

    mBackShadowColors=new int[] { 0xff111111,0x111111 };
    mBackShadowDrawableRL=new GradientDrawable(
        GradientDrawable.Orientation.RIGHT_LEFT,mBackShadowColors);
    mBackShadowDrawableRL.setGradientType(GradientDrawable.LINEAR_GRADIENT);

    mBackShadowDrawableLR=new GradientDrawable(
        GradientDrawable.Orientation.LEFT_RIGHT,mBackShadowColors);
    mBackShadowDrawableLR.setGradientType(GradientDrawable.LINEAR_GRADIENT);

    mFrontShadowColors=new int[] { 0x80111111,0x111111 };
    mFrontShadowDrawableVLR=new GradientDrawable(
        GradientDrawable.Orientation.LEFT_RIGHT,mFrontShadowColors);
    mFrontShadowDrawableVLR
        .setGradientType(GradientDrawable.LINEAR_GRADIENT);
    mFrontShadowDrawableVRL=new GradientDrawable(
        GradientDrawable.Orientation.RIGHT_LEFT,mFrontShadowColors);
    mFrontShadowDrawableVRL
        .setGradientType(GradientDrawable.LINEAR_GRADIENT);

    mFrontShadowDrawableHTB=new GradientDrawable(
        GradientDrawable.Orientation.TOP_BOTTOM,mFrontShadowColors);
    mFrontShadowDrawableHTB
        .setGradientType(GradientDrawable.LINEAR_GRADIENT);

    mFrontShadowDrawableHBT=new GradientDrawable(
        GradientDrawable.Orientation.BOTTOM_TOP,mFrontShadowColors);
    mFrontShadowDrawableHBT
        .setGradientType(GradientDrawable.LINEAR_GRADIENT);
  }

  /**
  *Author : hmg25 Version: 1.0 Description : 绘制翻起页的阴影
   */
  public void drawCurrentPageShadow(Canvas canvas) {
    double degree;
    if (mIsRTandLB) {
      degree=Math.PI
          / 4
          - Math.atan2(mBezierControl1.y-TouchPoint.y,TouchPoint.x
              - mBezierControl1.x);
    } else {
      degree=Math.PI
          / 4
          - Math.atan2(TouchPoint.y-mBezierControl1.y,TouchPoint.x
              - mBezierControl1.x);
    }
    // 翻起页阴影顶点与touch点的距离
    double d1=(float) 25*1.414*Math.cos(degree);
    double d2=(float) 25*1.414*Math.sin(degree);
    float x=(float) (TouchPoint.x+d1);
    float y;
    if (mIsRTandLB) {
      y=(float) (TouchPoint.y+d2);
    } else {
      y=(float) (TouchPoint.y-d2);
    }
    mPath1.reset();
    mPath1.moveTo(x,y);
    mPath1.lineTo(TouchPoint.x,TouchPoint.y);
    mPath1.lineTo(mBezierControl1.x,mBezierControl1.y);
    mPath1.lineTo(mBezierStart1.x,mBezierStart1.y);
    mPath1.close();
    float rotateDegrees;
    canvas.save();

    canvas.clipPath(mPath0,Region.Op.XOR);
    canvas.clipPath(mPath1,Region.Op.INTERSECT);
    int leftx;
    int rightx;
    GradientDrawable mCurrentPageShadow;
    if (mIsRTandLB) {
      leftx=(int) (mBezierControl1.x);
      rightx=(int) mBezierControl1.x+25;
      mCurrentPageShadow=mFrontShadowDrawableVLR;
    } else {
      leftx=(int) (mBezierControl1.x-25);
      rightx=(int) mBezierControl1.x+1;
      mCurrentPageShadow=mFrontShadowDrawableVRL;
    }

    rotateDegrees=(float) Math.toDegrees(Math.atan2(TouchPoint.x
        - mBezierControl1.x,mBezierControl1.y-TouchPoint.y));
    canvas.rotate(rotateDegrees,mBezierControl1.x,mBezierControl1.y);
    mCurrentPageShadow.setBounds(leftx,
        (int) (mBezierControl1.y-mMaxLength),rightx,
        (int) (mBezierControl1.y));
    mCurrentPageShadow.draw(canvas);
    canvas.restore();

    mPath1.reset();
    mPath1.moveTo(x,y);
    mPath1.lineTo(TouchPoint.x,TouchPoint.y);
    mPath1.lineTo(mBezierControl2.x,mBezierControl2.y);
    mPath1.lineTo(mBezierStart2.x,mBezierStart2.y);
    mPath1.close();
    canvas.save();
    canvas.clipPath(mPath0,Region.Op.XOR);
    canvas.clipPath(mPath1,Region.Op.INTERSECT);
    if (mIsRTandLB) {
      leftx=(int) (mBezierControl2.y);
      rightx=(int) (mBezierControl2.y+25);
      mCurrentPageShadow=mFrontShadowDrawableHTB;
    } else {
      leftx=(int) (mBezierControl2.y-25);
      rightx=(int) (mBezierControl2.y+1);
      mCurrentPageShadow=mFrontShadowDrawableHBT;
    }
    rotateDegrees=(float) Math.toDegrees(Math.atan2(mBezierControl2.y
        - TouchPoint.y,mBezierControl2.x-TouchPoint.x));
    canvas.rotate(rotateDegrees,mBezierControl2.x,mBezierControl2.y);
    float temp;
    if (mBezierControl2.y < 0)
      temp=mBezierControl2.y-mHeight;
    else
      temp=mBezierControl2.y;

    int hmg=(int) Math.hypot(mBezierControl2.x,temp);
    if (hmg > mMaxLength)
      mCurrentPageShadow
          .setBounds((int) (mBezierControl2.x-25)-hmg,leftx,
              (int) (mBezierControl2.x+mMaxLength)-hmg,
              rightx);
    else
      mCurrentPageShadow.setBounds(
          (int) (mBezierControl2.x-mMaxLength),leftx,
          (int) (mBezierControl2.x),rightx);

    // Log.i("perfectviewer","mBezierControl2.x   "+mBezierControl2.x
    //+"  mBezierControl2.y  "+mBezierControl2.y);
    mCurrentPageShadow.draw(canvas);
    canvas.restore();
  }

  /**
  *Author : hmg25 Version: 1.0 Description : 绘制翻起页背面
   */
  private void drawCurrentBackArea(Canvas canvas,Bitmap bitmap) {
    int i=(int) (mBezierStart1.x+mBezierControl1.x)/2;
    float f1=Math.abs(i-mBezierControl1.x);
    int i1=(int) (mBezierStart2.y+mBezierControl2.y)/2;
    float f2=Math.abs(i1-mBezierControl2.y);
    float f3=Math.min(f1,f2);
    mPath1.reset();
    mPath1.moveTo(mBeziervertex2.x,mBeziervertex2.y);
    mPath1.lineTo(mBeziervertex1.x,mBeziervertex1.y);
    mPath1.lineTo(mBezierEnd1.x,mBezierEnd1.y);
    mPath1.lineTo(TouchPoint.x,TouchPoint.y);
    mPath1.lineTo(mBezierEnd2.x,mBezierEnd2.y);
    mPath1.close();
    GradientDrawable mFolderShadowDrawable;
    int left;
    int right;
    if (mIsRTandLB) {
      left=(int) (mBezierStart1.x-1);
      right=(int) (mBezierStart1.x+f3+1);
      mFolderShadowDrawable=mFolderShadowDrawableLR;
    } else {
      left=(int) (mBezierStart1.x-f3-1);
      right=(int) (mBezierStart1.x+1);
      mFolderShadowDrawable=mFolderShadowDrawableRL;
    }
    float pp=0;
    if (MoveDirection==1) {
      pp=((mWidth-TouchPoint.x)/mWidth);
    } else {
      pp=(TouchPoint.x/mWidth);
    }
    Log.i("perfectviewer","pp:"+pp);
//    mFolderShadowDrawable.setAlpha((int) (255*pp));
    canvas.save();
    canvas.clipPath(mPath0);
    canvas.clipPath(mPath1,Region.Op.INTERSECT);

    if (!DualPageMode) {
      mPaint.setColorFilter(mColorMatrixFilter);
    }

    float dis=(float) Math.hypot(mCornerX-mBezierControl1.x,mBezierControl2.y-mCornerY);
    float f8=(mCornerX-mBezierControl1.x)/dis;
    float f9=(mBezierControl2.y-mCornerY)/dis;
    if (!DualPageMode) {
      mMatrixArray[0]=1-2*f9*f9;
      mMatrixArray[1]=2*f8*f9;
      mMatrixArray[3]=mMatrixArray[1];
      mMatrixArray[4]=1-2*f8*f8;
    } else {
      mMatrixArray[0]=1-2*f9*f9;
      mMatrixArray[1]=2*f8*f9;
      mMatrixArray[3]=mMatrixArray[1];
      mMatrixArray[4]=1-2*f8*f8;
    }
//    Log.i("perfectviewer","mMatrixArray[0]:"+mMatrixArray[0]+" mMatrixArray[1]:"+mMatrixArray[1]+" mMatrixArray[3]:"+mMatrixArray[3]+" mMatrixArray[4]:"+mMatrixArray[4]);
    mMatrix.reset();
    mMatrix.setValues(mMatrixArray);
//    mMatrix.preScale(-1.0f, 1.0f); 
    mMatrix.preTranslate(-mBezierControl1.x,-mBezierControl1.y);
    mMatrix.postTranslate(mBezierControl1.x,mBezierControl1.y);
    canvas.drawBitmap(bitmap,mMatrix,mPaint);
    // canvas.drawBitmap(bitmap,mMatrix,null);
    mPaint.setColorFilter(null);
    canvas.rotate(mDegrees,mBezierStart1.x,mBezierStart1.y);
    mFolderShadowDrawable.setBounds(left,(int) mBezierStart1.y,right,(int) (mBezierStart1.y+mMaxLength));
    mFolderShadowDrawable.draw(canvas);
    canvas.restore();
  }

  public boolean computeScroll() {
    super.computeScroll();
    if (mScroller.computeScrollOffset()) {
      float x=mScroller.getCurrX();
      float y=mScroller.getCurrY();
      TouchPoint.x=x;
      TouchPoint.y=y;
//      Log.d("perfectviewer","computeScroll x:"+x+" y:"+y);
      return true;
    } else if (AnimateMoving) {
      AnimateMoving=false;
      MoveDirection=0;
      if (OnUpdateFrame!=null) {
        OnUpdateFrame.onEndAnimation();
      }            
      if (NextPageMirror!=null) {
        NextPageMirror.recycle();
        NextPageMirror=null;
      }
    }
    return false;
  }

  public void startAnimation(int delayMillis) {
    int dx,dy;
    // dx 水平方向滑动的距离，负值会使滚动向左滚动
    // dy 垂直方向滑动的距离，负值会使滚动向上滚动
    if (mCornerX > 0) {
      if (DualPageMode) {
        dx=(int)-TouchPoint.x;
      } else {
        dx=-(int)(mWidth+TouchPoint.x);
      }
    } else {
      dx=(int) (mWidth-TouchPoint.x+mWidth);
    }
    if (mCornerY > 0) {
      dy=(int) (mHeight-TouchPoint.y);
    } else {
      dy=(int) (1-TouchPoint.y); // 防止TouchPoint.y最终变为0
    }
    Log.d("perfectviewer","MoveDirection:"+MoveDirection+"  sx:"+TouchPoint.x+"  dx:"+dx);
    mScroller.startScroll((int) TouchPoint.x,(int) TouchPoint.y,dx,dy,delayMillis);
    AnimateMoving=true;
  }

  public void startCancelAnimation(int delayMillis) {
    int dx,dy;
    if (StartPoint.x<Config.ScreenCenterX) {
      dx=(int)(1-TouchPoint.x);      
    } else {
      dx=(int)(mWidth-TouchPoint.x);            
    }
    if (StartPoint.y<Config.ScreenCenterY) {
      dy=(int)(1-TouchPoint.y);      
    } else {
      dy=(int)(mHeight-2-TouchPoint.y);
    }
    mScroller.startScroll((int) TouchPoint.x, (int)TouchPoint.y, dx, dy,delayMillis);
    AnimateMoving=true;
  }
  
  public int IsMovable(int XDiff,int YDiff,boolean TopMax,boolean BottomMax,boolean LeftMax,boolean RightMax) {
    if (Math.abs(YDiff)>Math.abs(XDiff)) {
      return 0;
    }
    int TargetPage=0;
    if (XDiff<0) {
      if (RightMax||Config.LockVerticalMove) {
        if (Global.BookDirection==Constant.PageDirection_Right) {
          TargetPage=-1;
        } else {
          TargetPage=1;
        }
      }
    } else {
      if (LeftMax||Config.LockVerticalMove) {
        if (Global.BookDirection==Constant.PageDirection_Right) {
          TargetPage=1;
        } else {
          TargetPage=-1;
        }
      }
    }
    return TargetPage;
  }
  
  public boolean IsCancelMove(int XDiff,int YDiff) {
    double px=0;
    if (Config.MinDragDistance>0) {      
      px=(double)Config.MinDragDistance/100.0;
    }
    if (XDiff<Config.ScreenWidth*px) {
      return true;
    }
    return false;
  }
}
