package com.qq.reader.plugin.audiobook.core;

import com.qq.reader.plugin.audiobook.core.SongInfo;

interface IQQPlayerService
{
    boolean isPlayingOnTheSurface();
    void stop();
    void pause();
    void play();
    void prev();
    void next();
    void resume();
    void becomingnoisy();
    long getDuration();
    long getCurrTime();
    long seek(long pos);
    int getPlayState();
    long getBufferLength();
    long getTotalLength();
    
    void setPlayMode(int playMode);
    int getPlayMode();
    
    SongInfo getCurrent();
    
    void setList(in SongInfo[] list, in Bundle key);
    void setListBySongInfo(in SongInfo[] list, in Bundle key, in SongInfo songinfo);
    SongInfo[] getList();
    int size();

    
    int getCurPos();
    void playPos(int pos);
    void add(in SongInfo[] songs, int index);
    void erase(int pos);
    void eraseSong(in SongInfo song);
    
    int getBufferPercent();
    void exit();
    void setPlayPos(int pos);
}

