mooReader.CFI = (function(){
	var $NodeFound = false ;
	var $FoundNode = null ;
	var $TextOffset = 0 ;
	var $ReaderRoot = document.body ;
	var $SourceRoot = null ;
	
	function _InitCFIObject(RootNode) {
		return {Node:null, CFI:"", ParentCFI:"", Type:0, Index:0, Offset:0, UID:"", Text:"", ClassName:"", FileOffset:0, Root:RootNode} ;		
	}
	
	function _GetLastPath(PathString) {
		var PathList = PathString.split("/");
		return PathList[PathList.length-1] ;
	}
	
	function _GetPathByDeleteLastOne(PathString) {
		var CutPos = PathString.length - 1 ;
		var Result = "" ;
		for(var Index=CutPos; Index>=0; Index--){
			if (PathString.substr(Index,1) == "/") {
				Result = PathString.substring(0, Index); 
				break ;
			}
		}
		return Result ;
	}
	
	function _GetElementNodeByCFIPath(ElementCFIPath, RootNode) {
		this.$NodeFound = false ;
		this.$FoundNode = null ;
		_GetElementNodeByCFI(RootNode, ElementCFIPath) ;
		return $FoundNode ;
	}
	
	
	
	function _InitCFIObjectWithPath(CFIPath, RootNode) {
		var CFIObject = _InitCFIObject(RootNode) ;
		CFIObject.CFI = CFIPath ;
		if (CFIPath == "/4") {
			CFIObject.Node = RootNode ;
			CFIObject.ParentCFI = "html" ;
			CFIObject.Type == 1 ;
			return CFIObject ;
		}
		
		var CutPos = CFIPath.indexOf(":") ;
		if (CutPos < 0) {
			CFIObject.Type = 1 ;
			CFIObject.Node = _GetElementNodeByCFIPath(CFIPath, RootNode) ;
			CFIObject.ParentCFI = _GetPathByDeleteLastOne(CFIObject.CFI) ;
			return CFIObject ;
		}
		
		CFIObject.Offset = parseInt(CFIPath.substring(CutPos+1, CFIPath.length), 10) ;
		CFIPath = CFIPath.substring(0, CutPos);
		CFIObject.Index = parseInt(_GetLastPath(CFIPath), 10) ;
		CFIObject.ParentCFI = _GetPathByDeleteLastOne(CFIPath) ;
		var ParentNode = _GetElementNodeByCFIPath(CFIObject.ParentCFI, RootNode) ;
		CFIObject.Node = _GetTextNodeByCFIIndex(ParentNode, CFIObject.Index) ;
		CFIObject.Type = 3 ;
		return CFIObject ;
	}
	
	function _InitCFIObjectWithPoint(PointX, PointY) {
		var CFIObject = _InitCFIObject($ReaderRoot) ;
	    if ( document.body.style.webkitUserSelect != "auto" ) {
	    	document.body.style.webkitUserSelect = "auto" ;
	    } ;
		var PointedRange = document.caretRangeFromPoint(PointX, PointY);
		if (PointedRange != undefined) {
			if (PointedRange.startContainer.nodeType == 1) {
				CFIObject.Type = 1 ;
				CFIObject.Node = PointedRange.startContainer ;
				CFIObject.CFI = PointedRange.startContainer.dataset.cfi ;
			} else {
				var StartNode = PointedRange.startContainer ;
				var EndNode = PointedRange.endContainer ;
				var StartOffset = PointedRange.startOffset ;
				var EndOffset = PointedRange.endOffset ;
				CFIObject = _InitCFIObjectWithTextNode(StartNode, document.body) ;
				CFIObject.Type = PointedRange.startContainer.nodeType ;
				CFIObject.Index = _GetTextNodeCFIIndex(CFIObject.Node) ;
				CFIObject.Offset = StartOffset ; 
				CFIObject.ParentCFI = CFIObject.Node.parentNode.dataset.cfi ;
				CFIObject.CFI = CFIObject.ParentCFI + "/" + CFIObject.Index + ":" + CFIObject.Offset ;				
			}
		} else {
			CFIObject.CFI = "undefined" ;
		}
		document.body.style.webkitUserSelect = "none" ;
		return CFIObject ;		
	}
	
	function _InitCFIObjectWithTextNode(TextNode, RootNode) {
		var CFIObject = _InitCFIObject(RootNode) ;
		CFIObject.Node = TextNode ;
		CFIObject.ParentCFI = TextNode.parentNode.dataset.cfi ;
		CFIObject.Type = 3 ;
		CFIObject.Index = _GetTextNodeCFIIndex(TextNode) ;
		return CFIObject ;		
	}
	
	function _InitRootNodes() {
		if ($ReaderRoot == null) {
			$ReaderRoot = document.body ;
		}
		if ($SourceRoot == null) {
			_CreateOriginalDocumentBody() ;
		}
	}

	function _ResetDOMTreeNodesCFI(ParentNode, ParentCFI) {
		var BaseIndex = 0 ;
		var CFIIndex = 0 ;
		$.each(ParentNode.childNodes, function(index){
			if (this.nodeType == 1) {
				CFIIndex = (BaseIndex+1)*2 ;
				BaseIndex++ ;
				this.dataset.cfi = ParentCFI + "/" + CFIIndex ;
				_ResetDOMTreeNodesCFI(this, this.dataset.cfi) ;
			}
		})
	}	
	
	function __GetTextNodeAtParentOffset(ParentNode) {
		$.each(ParentNode.childNodes, function(index){			
			if ($NodeFound) {
				return false ;
			}
			switch(this.nodeType) {
				case 1:
					__GetTextNodeAtParentOffset(this) ;
					break ;
				case 3:
					if (this.nodeValue.length > $TextOffset) {
						$NodeFound = true ;
						$FoundNode = this ;
						//console.log("FOUND", $TextOffset, this.nodeValue.length);
						//$TextOffset = this.nodeValue.length - $TextOffset ;
					} else {
						$TextOffset = $TextOffset - this.nodeValue.length ;
						//console.log("TEXT", this.nodeValue, this.nodeValue.length, $TextOffset) ;						
					}
					break ;
				default:
					break ;
			}
		})
	}
	
	function _GetTextNodeAtParentOffset(ParentNode, NodeOffset) {
		$NodeFound = false ;
		$FoundNode = null ;
		$TextOffset = NodeOffset ;
		__GetTextNodeAtParentOffset(ParentNode) ;
		return $FoundNode ;
	}
	
	function _GetElementNodeByCFI(ParentNode, ElementCFI) {
		$FoundNode = null ;
		$NodeFound = false ;
		__GetElementNodeByCFI(ParentNode, ElementCFI) ;
		return $FoundNode ;
	}
	
	function __GetElementNodeByCFI(ParentNode, ElementCFI) {
		$.each(ParentNode.childNodes, function(index){
			if (this.nodeType == 1) {
				if (this.dataset.cfi == ElementCFI) {
					$NodeFound = true ;
					$FoundNode = this ;
					return false ;
				} else {
					__GetElementNodeByCFI(this, ElementCFI) ;
					if ($NodeFound) {
						return false ;
					}
				}
			}
		})
	}
	
	
	function _GetTextNodeByCFIIndex(ParentNode, CFIIndex) {
		var BaseIndex = 0 ;
		var Result = null ;
		$.each(ParentNode.childNodes, function(index){
			if (this.nodeType == 3) {
				var NodeIndex = (BaseIndex*2) + 1 ;
				if (NodeIndex == CFIIndex) {
					Result = this ;
					return false ;
				}
				BaseIndex++ ;
			}
		})
		return Result ;
	}
	
	function __GetTextOffsetFromRoot(ParentNode, TextNode) {
		$.each(ParentNode.childNodes, function(index){
			if (this.nodeType == 3) {
				if (this.isSameNode(TextNode)) {
					$NodeFound = true ;
					return false ;
				}
				$TextOffset = $TextOffset + this.nodeValue.length ;
				//console.log(this.nodeValue, this.nodeValue.length, $TextOffset);
			}
			if (this.nodeType == 1) {
				__GetTextOffsetFromRoot(this, TextNode) ;
				if ($NodeFound) {
					return false ;
				}
			}
		})
	}
	
	function _GetTextOffsetFromRoot(RootNode, TextNode) {
		$TextOffset = 0 ;
		$FoundNode = null ;
		$NodeFound = false ;
		__GetTextOffsetFromRoot(RootNode, TextNode) ;
		return $TextOffset ;
	}
	
	function _GetTextNodeCFIIndex(TextNode) {
		var BaseIndex = 0;
		var Result = 0 ;
		$.each(TextNode.parentNode.childNodes, function(index){
			if (this.nodeType == 3) {
				var CFIIndex = (BaseIndex*2) + 1 ;
				if (this.isSameNode(TextNode)) {
					Result = CFIIndex ;
					return false ;
				}
				BaseIndex++ ;
			}			
		})
		return Result ;
	}
		
	function _GetTextNodeAtRootOffset(RootNode, NodeOffset) {
		var CFIObject = _InitCFIObject(RootNode) ;
		CFIObject.Node = _GetTextNodeAtParentOffset(RootNode, NodeOffset)  ;
		CFIObject.Offset = $TextOffset ;
		CFIObject.ParentCFI = CFIObject.Node.parentNode.dataset.cfi ;
		CFIObject.Index = _GetTextNodeCFIIndex(CFIObject.Node) ;
		CFIObject.CFI = CFIObject.ParentCFI + "/" + CFIObject.Index + ":" + CFIObject.Offset ;
		CFIObject.Type = 3 ;
		return CFIObject ;
	}

	return {
		ResetDOMCFI: function(DocumentBody) {
			if (DocumentBody.dataset.reset == undefined) {
				DocumentBody.dataset.reset = "Y" ;
				DocumentBody.dataset.cfi = "/4" ;
				_ResetDOMTreeNodesCFI(DocumentBody, "/4") ;
			}
		},
		InitCFIObject: function(RootNode) {
			return _InitCFIObject(RootNode) ;			
		},
		InitCFIObjectWithPath: function(CFIPath, RootNode) {
			return _InitCFIObjectWithPath(CFIPath, RootNode) ;			
		},
		InitCFIObjectWithPoint: function(PointX, PointY) {
			return _InitCFIObjectWithPoint(PointX, PointY) ;
		},
		GetTextOffsetFromRoot: function(RootNode, TextNode) {
			return _GetTextOffsetFromRoot(RootNode, TextNode) ;
		},
		GetTextNodeAtRootOffset: function(RootNode, NodeOffset) {
			return _GetTextNodeAtRootOffset(RootNode, NodeOffset) ;
		},
		GetTextNodeCFIIndex: function(TextNode) {
			return _GetTextNodeCFIIndex(TextNode) ;
		}
		
		
	}
})();

//===========================================================================//
// Reader's CFI Functions
//===========================================================================//
mooReader.CFI.Reader = (function(){
	var $SourceRoot = null ;
	var $ReaderRoot = null ;

	function _RemoveReadmooNodeList(NodeList) {
		$.each(NodeList, function(index){
			NodeParent=this.parentNode ;
			if ($(this).text().length==0) {
				$(this).remove();
			} else {
				$(this.childNodes[0]).unwrap();
			}
			NodeParent.normalize();							
		})		
	}
	
	function _RemoveAllReadmooTags(RootNode) {
		var NodeList = $(RootNode).find("span").filter(function(){			
			return $(this).data("uid") != undefined ; 
		})
		_RemoveReadmooNodeList(NodeList) ;		
	}
	
	function _InitSourceRoot() {
		$SourceRoot = document.body.cloneNode(true) ;
		_RemoveAllReadmooTags($SourceRoot);
		$SourceRoot.normalize() ;
		mooReader.CFI.ResetDOMCFI($SourceRoot) ;
	}
	
	function _InitRootNodes() {
		if ($ReaderRoot == null) {
			$ReaderRoot = document.body ;
		}
		if ($SourceRoot == null) {
			_InitSourceRoot() ;
		}
	}
	
	function _GetTextNodeReaderCFI(TextNode, TextOffset) {
		_InitRootNodes() ;
		var CFIObject = mooReader.CFI.InitCFIObject($ReaderRoot) ;
		CFIObject.Node = TextNode ;
		CFIObject.Offset = TextOffset ;
		CFIObject.Type = 3 ;
		CFIObject.ParentCFI = TextNode.parentNode.dataset.cfi ;
		CFIObject.Index = mooReader.CFI.GetTextNodeCFIIndex(TextNode) ;
		CFIObject.CFI = CFIObject.ParentCFI + "/" + CFIObject.Index + ":" + CFIObject.Offset ;
		return CFIObject ;
	}
	
	function _ReaderCFIPathToSourceCFIPath(ReaderCFIPath) {
		_InitRootNodes() ;
		var ReaderObject = mooReader.CFI.InitCFIObjectWithPath(ReaderCFIPath, $ReaderRoot);
		var TextOffset = mooReader.CFI.GetTextOffsetFromRoot($ReaderRoot, ReaderObject.Node) ;
		TextOffset = TextOffset + ReaderObject.Offset ;
		var SourceObject = mooReader.CFI.GetTextNodeAtRootOffset($SourceRoot, TextOffset) ;
		return SourceObject ;
	}
	
	function _SourceCFIPathToReaderCFIPath(SourceCFIPath) {
		_InitRootNodes() ;
		var SourceObject = mooReader.CFI.InitCFIObjectWithPath(SourceCFIPath, $SourceRoot) ;
		var TextOffset = mooReader.CFI.GetTextOffsetFromRoot($SourceRoot, SourceObject.Node) ;
		TextOffset = TextOffset + SourceObject.Offset ;
		var ReaderObject = mooReader.CFI.GetTextNodeAtRootOffset($ReaderRoot, TextOffset) ;
		return ReaderObject ;
	}
	
	function _GetBookmarkCFI(PaddingWidth, ReaderDirection) {
		_InitRootNodes() ;
		var ReaderObject = mooReader.CFI.InitCFIObjectWithPoint(PaddingWidth+10, 0) ;
		var SourceObject = null ;
		if (ReaderObject.Type == 3) {
			SourceObject = _ReaderCFIPathToSourceCFIPath(ReaderObject.CFI) ;			
		} else {
	    	document.body.style.webkitUserSelect = "auto" ;
			SourceObject = document.elementFromPoint(PaddingWidth+10, 0);
	    	document.body.style.webkitUserSelect = "none" ;
			SourceObject = mooReader.CFI.InitCFIObjectWithPath(SourceObject.dataset.cfi, $ReaderRoot) ;
		}
		return SourceObject ;
	}
	
	function _GetFileOffsetByNodeCFI(NodeCFI) {
		var Result = 100 ;
		return Result ;
	}
	
	return {
		ReaderCFIToSourceCFI: function(ReaderCFIPath) { return _ReaderCFIPathToSourceCFIPath(ReaderCFIPath); },
		SourceCFIToReaderCFI: function(SourceCFIPath) { return _SourceCFIPathToReaderCFIPath(SourceCFIPath); },
		GetTextNodeReaderCFI: function(TextNode, TextOffset) {
			return _GetTextNodeReaderCFI(TextNode, TextOffset) ;
		},
		GetBookmarkCFI: function(PaddingWidth, ReaderDirection) {
			return _GetBookmarkCFI(PaddingWidth, ReaderDirection) ;
		},
		GetFileOffsetByNodeCFI: function(NodeCFIPath) {
			return _GetFileOffsetByNodeCFI(NodeCFIPath) ;
		}
	}
})();

//===========================================================================//
// CFI Functions For Android
//===========================================================================//
mooReader.CFI.Android = (function(){
	
	return {
		ReaderCFIToSourceCFI: function(ReaderCFIPath) { 
			var SourceObject = mooReader.CFI.Reader.ReaderCFIToSourceCFI(ReaderCFIPath) ;
			console.log(SourceObject);
		},
		SourceCFIToReaderCFI: function(SourceCFIPath) {
			var ReaderObject = mooReader.CFI.Reader.SourceCFIToReaderCFI(SourceCFIPath) ;
			console.log(ReaderObject);
		},
		GetBookmarkCFI: function(PaddingWidth, ReaderDirection, ViewerTag) {
			var BookmarkObject = mooReader.CFI.Reader.GetBookmarkCFI(PaddingWidth, ReaderDirection) ;
			switch(ViewerTag) {
				case mooReader.Base.VID_MASTER_VIEWER:
					JSIMasterViewer.JSGetBookmarkCFI((BookmarkObject != null), BookmarkObject.CFI) ;
					break ;
				case mooReader.Base.VID_SECOND_VIEWER:
					JSISecondViewer.JSGetBookmarkCFI((BookmarkObject != null), BookmarkObject.CFI) ;
					break ;
				case mooReader.Base.VID_SCROLL_VIEWER:
					JSIScrollViewer.JSGetBookmarkCFI((BookmarkObject != null), BookmarkObject.CFI) ;
					break ;
				default:
					break ;
			}
//			console.log(BookmarkObject) ;
		},
		GetFileOffsetByNodeCFI: function(CFIPath) {
			var FileOffset = mooReader.CFI.Reader.GetFileOffsetByNode(CFIPath) ;
			console.log("FILE-OFFSET", FileOffset) ;
		}		
	}
})();




