mooReader.Hilite = (function(){
	var $DebugMode = false ;
	var $DebugValue = "" ;
	var $OK = "{OK}" ;
	var $None = "{NONE}" ;
	var $TextOffset = 0 ;
	var $DataFound = false ;
	var $FoundData = null ;
	var $CurrentInfo = {
		uid: "", 
		userClass: "mooUserHilite",
		socialClass: "mooSocialHilite",
		selectClass: "mooSelection",
		rangeRect: "",
		text: "",
		className: "",
		reversed: false,
		rangeCFI: "",
		startSpan: null,
		endSpan: null,
		priorPoints: {start:{X:0, Y:0}, end:{X:0, Y:0}},
		pointRanges: {start:null, end:null}, 
		startInfo: {node:null, offset:0},
		endInfo:{node:null, offset:0}
	}
	var $RangeStart = {node:null, offset:-1} ;
	var $RangeEnd = {node:null, offset:-1} ;
	var $RangeCommon = {node:null, rectList:"", rect:""} ;
	var $RangePoints = {start:{X:-1, Y:-1}, end:{X:-1, Y:-1}} ;
	var $Horizontal = true ;
	var $MarkStart = null ;
	var $MarkEnd = null ;
		
	function _GetResult(Result) {
		if ($DebugMode) {
			Result = Result + "\n" + "{DEBUG}=" + $DebugValue ;
		}
		return Result ;
	}
	
	function _ResetHighLightData() {
		$CurrentInfo = {
			uid: "", 
			userClass: "mooUserHilite",
			socialClass: "mooSocialHilite",
			selectClass: "mooSelection",
			rangeRect: "",
			text: "",
			className: "",
			reversed: false,
			startSpan: null,
			endSpan: null,
			priorPoints: {start:{X:0, Y:0}, end:{X:0, Y:0}},
			pointRanges: {start:null, end:null}, 
			startInfo: {node:null, offset:0},
			endInfo:{node:null, offset:0}
		}
		$RangeStart = {node:null, offset:-1} ;
		$RangeEnd = {node:null, offset:-1} ;
		$RangeCommon = {node:null, rectList:"", rect:""} ;
		$RangePoints = {start:{X:-1, Y:-1}, end:{X:-1, Y:-1}} ;
		$Horizontal = true ;
		$MarkStart = null ;
		$MarkEnd = null ;
	}
	
	function _RemoveHighLightByClass(ClassName) {
		$("."+ClassName).each(function(index){
			var NodeParent = this.parentNode ;
			$(this.childNodes[0]).unwrap();
			NodeParent.normalize();										
		})		
		document.body.normalize() ;
		mooReader.CFI.ResetTreeCFI(document.body, "/4");
	}
	
	function _GetRangeRectData(RangeRectList) {
		var Last = RangeRectList.length - 1 ;
		var RangeRect = {startX:-1, startY:-1, endX:-1, endY:-1} ;
		RangeRect.startX = RangeRectList[0].left ;
		RangeRect.startY = RangeRectList[0].top ;
		RangeRect.endX = RangeRectList[Last].right ;
		RangeRect.endY = RangeRectList[Last].bottom ;
		$CurrentInfo.rangeRect = RangeRect.startX + ";" +
								RangeRect.startY + ";" +
								RangeRect.endX + ";" +
								RangeRect.endY ;
	}
	
	function _GetRangeCommonAndRect() {
		document.body.style.webkitUserSelect = "auto" ;		
		var TempRange = document.createRange() ;
		document.body.style.webkitUserSelect = "none" ;		
		TempRange.setStart($RangeStart.node, $RangeStart.offset) ;
		TempRange.setEnd($RangeEnd.node, $RangeEnd.offset) ;
		var CommonNode = TempRange.commonAncestorContainer ;
		if (CommonNode.nodeType != 1) {
			CommonNode = CommonNode.parentNode ;
		}
		$RangeCommon.node = CommonNode ;
		_GetRangeRectData(TempRange.getClientRects()) ;
		TempRange.detach() ;			
	}
	
	function _FindFirstRangeNode(ParentNode) {
		$.each(ParentNode.childNodes, function(index){
			if (this.nodeType == 3) {
				if (this.isSameNode($RangeStart.node)) {
					$StartFound = true ;
					return false ;
				}
				if (this.isSameNode($RangeEnd.node)) {
					$EndFound = true ;
					return false ;
				}
			}
			if (this.nodeType == 1) {
				_FindFirstRangeNode(this);
				if ($StartFound || $EndFound) {
					return false ;
				}
			}
		})		
	}
	
	function _SwapRangeNodesIfNeeded() {
		$CurrentInfo.reversed = false ;
		if ($RangeStart.node.isSameNode($RangeEnd.node)) {
			if ($RangeStart.offset > $RangeEnd.offset) {
				TempNode = $RangeStart ;
				$RangeStart = $RangeEnd ;
				$RangeEnd = TempNode ;
				$CurrentInfo.reversed = true ;
			}
			return ;
		}
		$StartFound = false ;
		$EndFound = false ;
		_FindFirstRangeNode(document.body) ;
		if ($EndFound) {
			TempNode = $RangeStart ;
			$RangeStart = $RangeEnd ;
			$RangeEnd = TempNode ;
			$CurrentInfo.reversed = true ;			
		}
	}	
	
	function _CheckPointsRange(StartX, StartY, EndX, EndY) {
		try{
		$RangeStart = null ;
		$RangeEnd = null ;
		document.body.style.webkitUserSelect = "auto" ;		
		var StartRange = document.caretRangeFromPoint(StartX, StartY) ; 
		var EndRange = document.caretRangeFromPoint(EndX, EndY) ; 
		document.body.style.webkitUserSelect = "none" ;
		if ((StartRange == null) || (EndRange == null)) {
			console.log("range null") ;
			return false ;
		}
		if ((StartRange.startContainer == null) || (EndRange.startContainer == null)) {
			return false ;
		}
		var StartNode = {node:StartRange.startContainer, offset:StartRange.startOffset} ;
		var EndNode = {node:EndRange.startContainer, offset:EndRange.startOffset} ;
		if ((StartNode.node.nodeType != 3) || (EndNode.node.nodeType != 3)) {
			return false ;
		}
		if (StartNode.node.isSameNode(EndNode.node)) {
			if (StartNode.offset == EndNode.offset) {
				if (StartNode.offset == StartNode.node.nodeValue.length) {
					return false ;
				}
			}
		}
		
		$RangeStart = StartNode ;
		$RangeEnd = EndNode ;
		
		$RangePoints.start.X = StartX ;
		$RangePoints.start.Y = StartY ;
		$RangePoints.end.X = EndX ;
		$RangePoints.end.Y = EndY ;
		return true ;
	} catch(e) {
		console.log("ERROR", e.message) ;
	}
	}
	
	function _GetValidRangeNodes() {
		try{
		if ($RangeStart.node.isSameNode($RangeEnd.node)) {
			if ($RangeStart.offset == $RangeEnd.offset) {
				$RangeStart = mooReader.CFI.GetNextValidTextNodeInfo1(document.body, $RangeStart.node, $RangeStart.offset);
				$RangeEnd = mooReader.CFI.GetTextNodeCFIInfo($RangeStart.node, $RangeStart.offset + 1) ;
			} else {
				$RangeStart = mooReader.CFI.GetNextValidTextNodeInfo1(document.body, $RangeStart.node, $RangeStart.offset);
				$RangeEnd = mooReader.CFI.GetPriorValidTextNodeInfo1(document.body, $RangeEnd.node, $RangeEnd.offset) ;
			}
			return true ;
		}
		$RangeStart = mooReader.CFI.GetNextValidTextNodeInfo1(document.body, $RangeStart.node, $RangeStart.offset);
		$RangeEnd = mooReader.CFI.GetPriorValidTextNodeInfo1(document.body, $RangeEnd.node, $RangeEnd.offset) ;
		return true ;
		
	}catch(e){
		console.log("ERROR", e.message);
	}
		
	}
	
	function _ReloadValidRangeNodes() {
		$RangeStart = mooReader.CFI.GetNextValidTextNodeInfo1(document.body, $RangeStart.node, $RangeStart.offset);
		$RangeEnd = mooReader.CFI.GetPriorValidTextNodeInfo1(document.body, $RangeEnd.node, $RangeEnd.offset) ;		
	}
	
	function _HighLightTextNode(TextNode, StartOffset, EndOffset, ClassName)
	{
		try {
		if (TextNode == null) {
			console.log("null") ;
			return ;
		}
		if (TextNode.parentNode == null) {
			console.log("parent null", TextNode.nodeValue);
			return ;
		}
		var NodeText = TextNode.nodeValue ;
		var TextLength = NodeText.length ;
		var ParentNode = TextNode.parentNode ;
		var HighLightNode = document.createElement('span') ;
		HighLightNode.dataset.huid = $CurrentInfo.uid ;
		HighLightNode.className = ClassName ;
		
		if (StartOffset < 0) {
			HighLightNode.innerHTML = NodeText ;
			ParentNode.insertBefore(HighLightNode, TextNode);
			ParentNode.removeChild(TextNode);
			ParentNode.normalize() ;
			return ;
		}
		
		var BeforeText = "" ;
		var AfterText = "" ;
		var HighLightText = "" ;
		var Result = 0 ;
		var BeforeNode = null ;
		var AfterNode = null ;
		BeforeText = NodeText.substring(0, StartOffset) ;
		HighLightText = NodeText.substring(StartOffset, EndOffset);
		AfterText = NodeText.substring(EndOffset, TextLength);
		if (BeforeText != "") {
			BeforeNode = document.createTextNode(BeforeText) ;
			ParentNode.insertBefore(BeforeNode, TextNode);
		}
		HighLightNode.innerHTML = HighLightText ;
		ParentNode.insertBefore(HighLightNode, TextNode);
		
		if (AfterText != "") {
			AfterNode = document.createTextNode(AfterText) ;
			ParentNode.insertBefore(AfterNode, TextNode);
		}
		ParentNode.removeChild(TextNode);
		ParentNode.normalize() ;
	}catch(e){
		console.log("high light text node:", e.message) ;
	}
	}
	
	
	function _HighLightTextNodesBetweenStartAndEnd(CommonNode, ClassName) {
		$.each(CommonNode.childNodes, function(index){
			if (this.nodeType == 3) {
				if (this.isSameNode($MarkStart.node)) {
					$StartFound = true ;
					return true ;
				}
				if (this.isSameNode($MarkEnd.node)) {
					$EndFound = true ;
					return false ;
				}
				if ($StartFound && !$EndFound) {
					// Node 與 Node 之間，可能有 空白或 "\r", "\n"
					// 但依然會讀成是一個 TextNode，所以先進行檢查
					// 此類的 TextNode 就不進行 High Light 的處理
					if (!mooReader.Base.IsEmptyTextNode(this)) {
						_HighLightTextNode(this, -1, -1, ClassName) ;						
					}
				}
			}
			if (this.nodeType == 1) {
				_HighLightTextNodesBetweenStartAndEnd(this, ClassName);
				if ($EndFound) {
					return false ;
				}
			}
		})				
	}
	
	function _HighLightTextNodesInRange(ClassName) {
		if ($MarkStart.node.isSameNode($MarkEnd.node)) {
			_HighLightTextNode($MarkStart.node, $MarkStart.offset, $MarkEnd.offset, ClassName) ;
		} else {
			$StartFound = false ;
			$EndFound = false ;
			_HighLightTextNodesBetweenStartAndEnd($MarkCommon.node, ClassName) ;
			_HighLightTextNode($MarkStart.node, $MarkStart.offset, $MarkStart.node.nodeValue.length, ClassName) ;
			_HighLightTextNode($MarkEnd.node, 0, $MarkEnd.offset, ClassName) ;
		}
		mooReader.CFI.ResetTreeCFI($MarkCommon.node, $MarkCommon.node.dataset.cfi);				
	}
	
	function _ShowSelectionInPointRange(StartX, StartY, EndX, EndY, DebugMode) {
		$DebugMode = DebugMode ;
		var Result = $None ;			
		// 移除 HighLight 時，會造成 DOM 的結構改變，所以必須在取得 Point Node 前先整個清除。
		// 否則先取得 Point Node 再刪除時，會發生找不到 Point Node 的錯誤
		_RemoveHighLightByClass($CurrentInfo.selectClass) ; 
		$CurrentInfo.uid = ProCreateGUID(20) ;
		var NodeChanged = false ;
		if (_CheckPointsRange(StartX, StartY, EndX, EndY)) {
			//if (_GetValidRangeNodes()) {
			//	NodeChanged = true ;
			//}
		} else {
			if ($RangeStart == null) {
				return $None ;
			}
			_ReloadPointsRange() ;			
		}
		_GetValidRangeNodes() ;
		_SwapRangeNodesIfNeeded(document.body) ;
		_GetRangeCommonAndRect() ;
		$MarkStart = $RangeStart ;
		$MarkEnd = $RangeEnd ;
		$MarkCommon = $RangeCommon ; //console.log($RangeCommon.rect) ;
		_HighLightTextNodesInRange($CurrentInfo.selectClass) ;	
		$CurrentInfo.text = _GetHighLightWholeText($CurrentInfo.uid) ;
		Result = $CurrentInfo.rangeRect + ";" + 
				$CurrentInfo.uid + ";" + 
				$CurrentInfo.text + ";" +
				$CurrentInfo.reversed ;
		return _GetResult(Result) ;
	}
	
	function _RestoreHighLightTextNodes(DocumentBody, CommonCFI, BookStartCFI, BookEndCFI) {
		$CurrentInfo.text = "" ;
		mooReader.CFI.InitBodyObjects() ; // 分別建立原始書籍與現行 Reader 的 document body 物件
		$RangeCommon = mooReader.CFI.GetElementNodeByCFI(DocumentBody, CommonCFI) ;
		$RangeStart = mooReader.CFI.ConvertBookCFIToReaderCFIInfo(BookStartCFI, false) ;
		$RangeEnd = mooReader.CFI.ConvertBookCFIToReaderCFIInfo(BookEndCFI, false) ;
		_SwapRangeNodesIfNeeded() ;
		_GetRangeCommonAndRect() ;
		$MarkStart = $RangeStart ;
		$MarkEnd = $RangeEnd ;
		$MarkCommon = $RangeCommon ;
		_HighLightTextNodesInRange($CurrentInfo.className) ;
		mooReader.CFI.ResetTreeCFI($RangeCommon, $RangeCommon.dataset.cfi);
		return $CurrentInfo.uid;		
	}
	
	function _RestoreHighLight(CommonCFI, StartCFI, EndCFI, HiliteType, HighLightID, DebugMode) {
		$DebugMode = DebugMode ;
		$CurrentInfo.uid = HighLightID ;
		switch(HiliteType){
			case "SOCIAL": $CurrentInfo.className = $CurrentInfo.socialClass ; break ;
			case "USER": $CurrentInfo.className = $CurrentInfo.userClass ; break ;
			case "SELECT": $CurrentInfo.className = $CurrentInfo.selectClass ; break ;
			default: $CurrentInfo.className = "" ; break ;
		} ;
		Result = $None ;
		if ($CurrentInfo.className != "") {
			Result = _RestoreHighLightTextNodes(document.body, CommonCFI, StartCFI, EndCFI) ;	
			Result = $CurrentInfo.uid ;		
		}
		return _GetResult(Result) ;		
	}
	
	function _CountElemetTextOffsetFromBody(ParentNode, ElementNode) {
		var TextLength = 0 ;
		$.each(ParentNode.childNodes, function(index){
			if (this.nodeType == 3) {
				if (mooReader.Base.IsEmptyTextNode(this)) {
					return true ;
				}
				$TextOffset = $TextOffset + this.nodeValue.length ;
			}
			if (this.nodeType == 1) {
				if (this.isSameNode(ElementNode)) {
					$DataFound = true ;
					return false ;
				} else {
					_CountElemetTextOffsetFromBody(this, ElementNode) ;
					if ($DataFound) {
						return false ;
					}
				}
			}
		})
	}
	
	function _GetSpanTextOffsetFromBody(SpanNode){
		$TextOffset = 0 ;
		$DataFound = false ;
		_CountElemetTextOffsetFromBody(document.body, SpanNode) ;
		return $TextOffset ;
	}	
	
	
	function _ConvertSelectionToHighLight(HighLightID, DebugMode) {
		try {
		$DebugMode = DebugMode ;
		console.log("HIGHLIGHT-ID", HighLightID);
		var HighLightSpanList = $("span").filter(function() { 
			return $(this).data("huid") == HighLightID ; 
		});
		var StartSpan = HighLightSpanList[0];
		var StartOffset = _GetSpanTextOffsetFromBody(StartSpan);
		var EndSpan = HighLightSpanList[HighLightSpanList.length-1];
		console.log(EndSpan.innerHTML);
		var EndOffset = $(EndSpan).text().length ;
		if (!EndSpan.isSameNode(StartSpan)) {
			EndOffset = EndOffset + _GetSpanTextOffsetFromBody(EndSpan) ;
		} else {
			EndOffset = StartOffset + EndOffset ;
		}
		$("."+$CurrentInfo.selectClass).each(function(){
			$(this).attr("class", $CurrentInfo.userClass);
		})
		document.body.style.webkitUserSelect = "auto" ;
		$DebugValue = $DebugValue + ";" + StartOffset + ";" + EndOffset ;
		console.log(StartOffset, EndOffset) ;
		var RangeCFI = mooReader.CFI.GetRangeCFIExpress(StartOffset, EndOffset) ;
		//var RangeCFI = mooReader.CFI.GetRangeCFIAtBookBodyByOffset(StartOffset, EndOffset) ;
		document.body.style.webkitUserSelect = "none" ;
	}catch(e){
		RangeCFI = e.message ;
	}
		return _GetResult(RangeCFI) ;		
	}
	
	function _GetHighLightWholeText(HighLightID)
	{
		var NodeList = $("body").find("span").filter(function(){			
			return (($(this).data("huid") != undefined) && ($(this).data("huid") == HighLightID)) ; 
		})
		var HighLightText = "" ;
		$.each(NodeList, function(index){
			HighLightText = HighLightText + $(this).text();
		})
		return HighLightText ;
	}
	
	function _GetHighLightTypeID(HighLightClass)
	{
		if (HighLightClass == $CurrentInfo.userClass) {
			return "USER" ;
		}
		if (HighLightClass == $CurrentInfo.socialClass) {
			return "SOCIAL" ;
		}
		if (HighLightClass == $CurrentInfo.selectClass) {
			return "SELECT" ;
		}
		return HighLightClass ;
	}
	
	
	function _GetReaderPointedNodeInfo(PointX, PointY)
	{
		document.body.style.webkitUserSelect = "auto" ;
		var PointedNode = mooReader.CFI.GetPointedNodeInfo(PointX, PointY) ;
	    document.body.style.webkitUserSelect = "none" ;
		var ParentNode = null ;
	
		if (PointedNode.type == 3) {
			ParentNode = PointedNode.node.parentNode ;
			if (ParentNode.dataset.huid == undefined) {
				PointedNode.typeid = "TEXTNODE" ;
			} else {
				PointedNode.huid = ParentNode.dataset.huid ;
				PointedNode.classname = ParentNode.className ;
				PointedNode.parentcfi = ParentNode.dataset.cfi ;
				PointedNode.text = _GetHighLightWholeText(PointedNode.huid) ;
				PointedNode.typeid = _GetHighLightTypeID(PointedNode.classname) ;
			}
		} else {
			//console.log(""PointedNode) ;
			PointedNode.typeid = PointedNode.node.nodeName.toUpperCase() ;
		}
		
		return PointedNode ;
	}
	
	function _GetReaderPointedNodeType(PointX, PointY, TypeOnly, DebugMode) {
		$DebugMode = DebugMode ;
		var PointedNodeInfo = _GetReaderPointedNodeInfo(PointX, PointY) ;		
		if (TypeOnly) {
			Result = PointedNodeInfo.typeid ;
		} else {
			Result = PointedNodeInfo.typeid + ";" +
					 PointedNodeInfo.huid + ";" +
					 PointedNodeInfo.text + ";" +
					 PointedNodeInfo.cfi;
		}
		return _GetResult(Result) ;
	}
	
	function _RemoveSelection() {
		_RemoveHighLightByClass($CurrentInfo.selectClass) ;
	}
	
	function _UpdateHighLightUID(OldID, NewID) {
		var NodeList = $("body").find("span").filter(function(){			
			return (($(this).data("huid") != undefined) && ($(this).data("huid") == OldID)) ; 
		})
		
		$.each(NodeList, function(index){
			this.dataset.huid = NewID ;
		})
		return NodeList.length + $OK ;
	}
	
	function _RemoveHighLightByUID(HighLightID) {
		
		var NodeList = $("body").find("span").filter(function(){			
			return (($(this).data("huid") != undefined) && ($(this).data("huid") == HighLightID)) ; 
		})
		
		$.each(NodeList, function(index){
			var NodeParent = this.parentNode ;
			$(this.childNodes[0]).unwrap();
			NodeParent.normalize();										
		})
		document.body.normalize() ;
		console.log($OK, HighLightID, NodeList.length) ;
	}
	
	function _GetSelectionRangeCFI(HighLightID, DebugMode){
		try {
		$DebugMode = DebugMode ;
		console.log("HIGHLIGHT-ID", HighLightID);
		var HighLightSpanList = $("span").filter(function() { 
			return $(this).data("huid") == HighLightID ; 
		});
		var StartSpan = HighLightSpanList[0];
		var StartOffset = _GetSpanTextOffsetFromBody(StartSpan);
		var EndSpan = HighLightSpanList[HighLightSpanList.length-1];
		console.log(EndSpan.innerHTML);
		var EndOffset = $(EndSpan).text().length ;
		if (!EndSpan.isSameNode(StartSpan)) {
			EndOffset = EndOffset + _GetSpanTextOffsetFromBody(EndSpan) ;
		} else {
			EndOffset = StartOffset + EndOffset ;
		}
		document.body.style.webkitUserSelect = "auto" ;
		$DebugValue = $DebugValue + ";" + StartOffset + ";" + EndOffset ;
		console.log(StartOffset, EndOffset) ;
		var RangeCFI = mooReader.CFI.GetRangeCFIExpress(StartOffset, EndOffset) ;
		//var RangeCFI = mooReader.CFI.GetRangeCFIAtBookBodyByOffset(StartOffset, EndOffset) ;
		document.body.style.webkitUserSelect = "none" ;
	}catch(e){
		RangeCFI = e.message ;
	}
		return _GetResult(RangeCFI) ;		
	}
	
	return {
		ResetHighLightData: function() { 
			_ResetHighLightData() 
		},
		ShowSelectionInPointRange: function(StartX, StartY, EndX, EndY, DebugMode) {
			return _ShowSelectionInPointRange(StartX, StartY, EndX, EndY, DebugMode) ;
		},
		RestoreHighLight: function(CommonCFI, StartCFI, EndCFI, HiliteType, HighLightID, DebugMode) {
			return _RestoreHighLight(CommonCFI, StartCFI, EndCFI, HiliteType, HighLightID, DebugMode) ;
		},
		ConvertSelectionToHighLight: function(HighLightID, DebugMode) {
			return _ConvertSelectionToHighLight(HighLightID, DebugMode) ;
		},
		GetReaderPointedNodeType: function(PointX, PointY, TypeOnly, DebugMode) {
			return _GetReaderPointedNodeType(PointX, PointY, TypeOnly, DebugMode) ;
		},
		RemoveSelection: function() {
			_RemoveSelection() ;
		},
		UpdateHighLightID: function(OldID, NewID) {
			return _UpdateHighLightUID(OldID, NewID) ;
		},
		RemoveHighLightByUID: function(HighLightID) {
			return _RemoveHighLightByUID(HighLightID) ;
		},
		GetSelectionRangeCFI: function(HighLightID, DebugMode){
			return _GetSelectionRangeCFI(HighLightID, DebugMode) ;
		}
		
	}
})();