mooReader.Page = (function(){
	var $Options = {View: null, Layout: null, Font:null, Theme:null} ;
	var $Reader = null ;
	var $LAYOUT_ONE_COLUMN	= 1 ;
	var $LAYOUT_TWO_COLUMN	= 2 ;
	var $LAYOUT_SCROLLING	= 3 ;
	
	function _ParsePageOptions(OptionsJson){
		var Json = JSON.parse(OptionsJson);
		var PageView	= { DeviceWidth:0, DeviceHeight:0, PageWidth:0, PageHeight:0, PageCount:0, ColumnCount:0, Tag:0, Ratio:0 } ;
		var PageLayout	= { Changed:false, Type:0, PaddingSide:0, PaddingTop:0, PaddingBotton:0, ColumnWidth:0, ColumnGap:0, MaxWidth:0, MaxHeight:0 } ;
		var PageFont	= { Changed:false, Family:"", Size:0 } ;
		var PageTheme	= { Changed:false, Code:"" } ;
		
		$Options.View	= PageView ;
		$Options.Layout	= PageLayout ;
		$Options.Font	= PageFont ;
		$Options.Theme	= PageTheme ;
		
		$Options.View.DeviceWidth	= Json.layout_options.device_webview_width ;
		$Options.View.DeviceHeight	= Json.layout_options.device_webview_height ;
		$Options.View.PageWidth		= $Options.View.DeviceWidth / window.devicePixelRatio ;
		$Options.View.PageHeight	= $Options.View.DeviceHeight / window.devicePixelRatio ;
		$Options.View.Tag			= Json.tag_index ;
		$Options.View.Ratio			= window.devicePixelRatio ;
		
		$Options.Layout.Changed			= Json.layout_changed ;
		$Options.Layout.Type			= Json.layout_options.layout_type ;
		$Options.Layout.PaddingSide		= Json.layout_options.padding_side ;
		$Options.Layout.PaddingTop		= Json.layout_options.padding_top ;
		$Options.Layout.PaddingBottom	= Json.layout_options.padding_bottom ;
		switch ($Options.Layout.Type) {
			case $LAYOUT_ONE_COLUMN:  // One Column Layout
				$Options.Layout.ColumnWidth = $Options.View.PageWidth - ($Options.Layout.PaddingSide * 2)*3;
				$Options.Layout.ColumnGap = $Options.Layout.PaddingSide * 2 ;
				$Options.Layout.MaxWidth = $Options.Layout.ColumnWidth - 10 ;
				//console.log("Options:" + $Options.Layout.ColumnWidth);
				break ;
			case $LAYOUT_TWO_COLUMN:  // Two Column Layout
				$Options.Layout.ColumnGap = $Options.Layout.PaddingSide * 2 ;
				$Options.Layout.ColumnWidth = $Options.View.PageWidth - ($Options.Layout.PaddingSide *2) - $Options.Layout.ColumnGap ;
				$Options.Layout.ColumnWidth = $Options.Layout.ColumnWidth / 2 ;
				//console.log("PageWidth=" + $Options.View.PageWidth );
				//console.log("Gap=" + ($Options.Layout.PaddingSide * 2));
				//console.log("Width=" + $Options.Layout.ColumnWidth);
				
				$Options.Layout.MaxWidth = $Options.Layout.ColumnWidth - 10 ;
				break ;
			default: // Scrolling Layout 
				$Options.Layout.ColumnWidth = 0 ;
				$Options.Layout.ColumnGap = 0 ;
				$Options.Layout.MaxWidth = $Options.View.PageWidth - (($Options.Layout.PaddingSide * 2) - 10) ;
				break ;			
		}
		$Options.Layout.MaxHeight = $Options.View.PageHeight - $Options.Layout.PaddingBottom ;
		
		$Options.Font.Changed	= Json.font_changed ;
		$Options.Font.Family	= Json.font_options.font_family ;
		$Options.Font.Size		= Json.font_options.font_size ;
		
		$Options.Theme.Changed	= Json.theme_changed ;
		$Options.Theme.Code		= Json.theme_options.theme_name ;
		
	}

	function _ResetViewOptions(OptionsJson){
		var ContentLength = 0 ;
		var BodyClientWidth = document.body.clientWidth ;
		var BodyScrollWidth = document.body.scrollWidth ;
		var ScrollWidth = BodyScrollWidth - BodyClientWidth ;
		_ParsePageOptions(OptionsJson) ;
		$Options.View.PageHeight = 480 ;
		$Options.Layout.ColumnWidth = 520 ;
		$Options.Layout.ColumnGap = 60 ;
		$Options.Font.Size = 100 ;
		
		mooReader.Base.ResetImage(1280,460);
		
		//mooReader.Base.ResetImage($Options.Layout.MaxWidth, $Options.Layout.MaxHeight) ;
		
		if ($Options.Font.Changed) {
			//mooReader.Base.SetFontSize($Options.Font.Size) ;
		}
		if ($Options.Theme.Changed) {
			mooReader.Base.SetReaderTheme($Options.Theme.Code) ;			
		}
		//ContentLength = document.body.scrollHeight ;
		console.log("ContentLength=" + ContentLength) ;
		
		
		//document.body.style.height = $Options.View.PageHeight + "px" ;
		//document.body.style.width = document.body.scrollWidth + "px" ;
		console.log("bodyHeight=" + document.body.style.height + ", Height=" + $Options.View.PageHeight);
		//$Options.Layout.ColumnWidth = 520 ;
		document.body.style.height = "480px";
		
		//$("body").css("width", "100%");
		
		if ($Options.Layout.ColumnWidth > 0) {
			$("body").css("-webkit-column-width", $Options.Layout.ColumnWidth + "px").css("-webkit-column-gap", $Options.Layout.ColumnGap + "px").css("font-size", $Options.Font.Size +"%").css("padding-left","30px").css("padding-right","30px") ;
			console.log("ColumnWidth=" + $Options.Layout.ColumnWidth + ", Gap=" + $Options.Layout.ColumnGap + ", FontSize=" + $Options.Font.Size);
		}
		//$("body").css("padding-left",	$Options.Layout.PaddingSide + "px")
		//.css("padding-right",	$Options.Layout.PaddingSide + "px");
//				.css("padding-top", 	$Options.Layout.PaddingTop + "px")
//				.css("padding-bottom",	$Options.Layout.PaddingBottom + "px" );
				
		var TotalWidth = 0 ;
		switch ($Options.Layout.Type) {
			case $LAYOUT_ONE_COLUMN:
				$Options.View.PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth) ;
				$Options.View.ColumnCount = $Options.View.PageCount ;
				TotalWidth = ($Options.View.PageCount * $Options.View.PageCount)-($Options.View.PaddingSide*2)-ScrollWidth ;
				document.body.style.width = TotalWidth + "px" ;
				break ;
			case $LAYOUT_TWO_COLUMN:
				$Options.View.PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth) ;
				console.log("PageCount=" + $Options.View.PageCount + ", scrollWidth=" + document.body.scrollWidth);
				EndOffset = document.body.scrollWidth % $Options.View.PageWidth ;
				if (EndOffset > ($Options.View.PageWidth/2)) {
					$Options.View.PageCount = $Options.View.PageCount + 1 ;
				}
				TotalWidth = ($Options.View.PageWidth * $Options.View.PageCount)-($Options.Layout.PaddingSide*2)-ScrollWidth ;
				console.log("TotalWidth=" + TotalWidth + ",PageWidth=" + $Options.View.PageWidth) ;
				document.body.style.width = (1280-8) + "px" ;
				console.log("document.body.scrollWidth=" + document.body.scrollWidth);
				break ;
			case $LAYOUT_SCROLLING:
				break ;
			default:
				break ;
		}	
		console.log("document.body.style.height=" + document.body.style.height);
	}
	
	function _ResetViewOptions2(OptionsJson) {
		try {
		var ContentLength = 0 ;
		var BodyClientWidth = document.body.clientWidth ;
		var BodyScrollWidth = document.body.scrollWidth ;
		var ScrollWidth = BodyScrollWidth - BodyClientWidth ;
		_ParsePageOptions(OptionsJson) ;
		$Options.View.PageWidth = 640 ;
		$Options.View.PageHeight = 480 ;
		$Options.Layout.MaxWidth = 640 ;
		$Options.Layout.MaxHeight = 480 ;
		$Options.Layout.ColumnWidth = 230 ;
		$Options.Layout.ColumnGap = 60 ;
		$Options.Layout.PaddingSide = 30 ;
		var HalfWidth = ($Options.View.PageWidth / 2) ;
		$("body").css("width","100%").css("height","100%").css("margin","0px").css("padding","0px");
		$("#readmoo").css("width","100%").css("height","100%").css("margin","0px").css("padding","0px");
		//document.body.clientWidth = 640 ;
		console.log("-----" + document.body.clientWidth + "----");
		$("img").css("maxHeight", "460px");
		//$("div").css("maxHeight", "460px");
		
		
		//console.log("document.body.scrollWidth=" + document.body.clientWidth) ;
		
		//mooReader.Base.ResetImage(1280,460);
		//mooReader.Base.ResetImage($Options.Layout.MaxWidth,$Options.Layout.MaxHeight);
		//console.log("document.body.scrollWidth=" + document.body.clientWidth) ;
		FontSize=140;
		// 100 = 421 
		// 115 = 488 67 
		// 120 = 549 128 
		// 130 = 667 246 118 
		// 140 = 694 273 27
		$("#readmoo").css("font-size",FontSize+"%") ;
		$("#readmoo").css("line-height", "140%");
		//console.log("document.body.clientHeight=" + document.body.clientHeight) ;
		//console.log("document.body.scrollHeight=" + document.body.scrollHeight) ;
		//console.log("document.body.offsetHeight=" + document.body.offsetHeight) ;
//		document.body.style.height = "480px" ;
		var ContentLength = document.body.scrollHeight ;
		console.log("ContentLength=" + ContentLength + ", clientHeight=" + document.body.clientHeight) ;
		document.body.style.height = $Options.View.PageHeight + "px" ;
		//console.log("===== clientHeight=" + document.body.clientHeight) ;
		console.log("===== scrollHeight=" + document.body.scrollHeight) ;
		//console.log("===== offsetHeight=" + document.body.offsetHeight) ;
		console.log("===== WindowHeight=" + window.innerHeight) ;
		console.log("===== doccliHeight=" + document.documentElement.clientHeight) ;
		//console.log("===" + $Options.View.PageHeight );
		//console.log("---------- aaa=" + document.body.style.height);
		//console.log("document.body.clientWidth=" + document.body.clientWidth) ;
//		$("body").css("-webkit-column-width","520px").css("-webkit-column-gap","60px").css("font-size",FontSize+"%").css("padding-left","30px").css("padding-right","30px");
		$("#readmoo").css("-webkit-column-width",$Options.Layout.ColumnWidth + "px").css("-webkit-column-gap", $Options.Layout.ColumnGap + "px") ;
		$("#readmoo").css("padding-left", $Options.Layout.PaddingSide + "px").css("padding-right", $Options.Layout.PaddingSide + "px");
		EndOffset = document.body.scrollWidth % $Options.View.PageWidth ;
		PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth) ;
		//console.log("PageCount=" + PageCount) ;
		console.log("***********************");
		ReaderObject = document.getElementById("readmoo");
		ContentWidth = ReaderObject.scrollWidth - 60  ;
		console.log("ReaderObject.scrollWidth=" + ReaderObject.scrollWidth);
		console.log("ReaderObject.clientWidth=" + ReaderObject.clientWidth);
		console.log("ReaderObject.offsetWidth=" + ReaderObject.offsetWidth);
		console.log("ReaderObject.width=" + $("#readmoo").width());
		console.log("ContentWidth=" + ContentWidth) ;
		console.log("***********************");
		console.log("EndOffset=" + EndOffset + ", PageCount=" + PageCount);
		
		switch ($Options.Layout.Type) {
			case $LAYOUT_ONE_COLUMN:
				break ;
			case $LAYOUT_TWO_COLUMN:
				$Options.View.PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth) ;	
				console.log("$Options.View.PageCount=" + $Options.View.PageCount);
				/*
				HalfColumnWidth = $Options.View.PageHeight / 2 ;
				if (ContentLength < HalfColumnWidth) {
					$Options.View.ColumnCount = 1 ;
					$Options.View.PageCount = 0 ;
				} else {
					if (ContentLength <= ($Options.View.PageHeight)) {
						$Options.View.ColumnCount = 1 ;
						$Options.View.PageCount = 0 ;
					} else {
						$Options.View.PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth) ;	
						console.log("$Options.View.PageCount=" + $Options.View.PageCount);
					}
				}
				*/
				$Options.View.PageCount++ ;
				TotalWidth = $Options.View.PageCount * $Options.View.PageWidth ;			
				break ;
			case $LAYOUT_SCROLLING:
				break ;
			default:
		}
/*		
		if (EndOffset < HalfWidth) {
			PageCount = PageCount + 1 ;
		
			TotalWidth = PageCount * $Options.View.PageWidth ;			
			console.log("TotalWidth=" + TotalWidth);	
			//TotalWidth = (document.body.scrollWidth + (1280-EndOffset)) ;		
		} else {
			PageCount = PageCount + 1 ;
			TotalWidth = PageCount * $Options.View.PageWidth ;				
			console.log("TotalWidth=" + TotalWidth);	
		}
		//console.log("EndOffset=" + EndOffset + ", TotalWidth=" + TotalWidth) ;
	//	document.body.st
		*/
		var WidthOffset = ScrollWidth + ($Options.Layout.PaddingSide*2) ;
		console.log("ScrollWidth=" + ScrollWidth) ;
		console.log("PaddingWidth=" + $Options.Layout.PaddingSide) ;
		//document.body.style.width = (TotalWidth - WidthOffset) + "px" ;
		document.body.style.width = (TotalWidth - WidthOffset) + "px";
		console.log("document.body.scrollWidth=" + document.body.scrollWidth);
		console.log("TotalWidth=" + TotalWidth + ", PageCount=" + $Options.View.PageCount + ", ColumnCount=" + $Options.View.ColumnCount) ;
		//console.log("document.body.style.width=" + document.body.style.width);
		//console.log("document.body.scrollWidth=" + document.body.scrollWidth);
		//console.log("document.body.scrollHeight=" + document.body.scrollHeight);
		//console.log("document.body.style.height=" + document.body.style.height);
		}catch(e) {
			console.log(e.message);
		
		}
	}

function _ResetViewOptions1(OptionsJson){
	console.log("document.body.scrollWidth=" + document.body.clientWidth) ;
	mooReader.Base.ResetImage(1280,460);
	console.log("document.body.scrollWidth=" + document.body.clientWidth) ;
	FontSize=100;
	console.log("document.body.clientHeight=" + document.body.clientHeight) ;
	console.log("document.body.scrollHeight=" + document.body.scrollHeight) ;
	console.log("document.body.offsetHeight=" + document.body.offsetHeight) ;
	document.body.style.height = "480px" ;
	console.log("---------- aaa=" + document.body.style.height);
	console.log("document.body.clientWidth=" + document.body.clientWidth) ;
	$("body").css("-webkit-column-width","520px").css("-webkit-column-gap","60px").css("font-size",FontSize+"%").css("padding-left","30px").css("padding-right","30px");
	EndOffset = document.body.scrollWidth % 1280 ;
	PageCount = Math.floor(document.body.scrollWidth / 1280) ;
	console.log("PageCount=" + PageCount) ;
	if (EndOffset > 640) {
		PageCount = PageCount + 1 ;
		
		TotalWidth = PageCount * 1280 ;				
		//TotalWidth = (document.body.scrollWidth + (1280-EndOffset)) ;		
	} else {
		TotalWidth = PageCount * 1280 ;				
	}
	console.log("EndOffset=" + EndOffset + ", TotalWidth=" + TotalWidth) ;
//	document.body.st
	document.body.style.width = (TotalWidth-8-60) + "px" ;
	/*
	console.log("document.body.style.width=" + document.body.style.width);
	console.log("document.body.scrollWidth=" + document.body.scrollWidth);
	console.log("document.body.scrollHeight=" + document.body.scrollHeight);
	console.log("document.body.style.height=" + document.body.style.height);
	*/
	//console.log("Json="+ OptionsJson) ;
	/*
	document.body.style.width  = document.body.clientWidth + "px";
	document.body.style.height = document.body.clientHeight + "px" ;
	console.log("document.body.clientWidth=" + document.body.clientWidth) ;
	console.log("document.body.scrollWidth=" + document.body.scrollWidth) ;
	console.log("document.html.clientHeight=" + document.documentElement.clientHeight) ;
	console.log("document.html.scrollHeight=" + document.documentElement.scrollHeight) ;
	console.log("document.html.offsetHeight=" + document.documentElement.offsetHeight) ;
	console.log("window.innerHeight=" + window.innerHeight);
	*/
	//TestOBJ = document.documentElement ;
	//for (I in TestOBJ) {
	//	console.log(I + "=> " +  TestOBJ[I]);
	//}
	
}

function _GetSpineColumnCount(OptionsJson) {
	_ParsePageOptions(OptionsJson) ;
	mooReader.Base.ResetElementsMaxSize($Options.Layout.MaxWidth, $Options.Layout.MaxHeight);
	$("body").css("width","100%").css("padding", "0px").css("margin","0px");
	$("body").css("padding-left", $Options.Layout.PaddingSide + "px");
	$("body").css("padding-right", $Options.Layout.PaddingSide + "px");
	document.body.style.width = ($Options.View.PageWidth-($Options.Layout.PaddingSide*2)) + "px" ;
	
	if ($Options.Font.Changed) {
		$("body").css("font-size", $Options.Font.Size+"%") ;
		$("body").css("line-height", "140%");
	}
	var SingleColumnContent = (document.body.scrollHeight <= $Options.View.PageHeight) ;
	if (SingleColumnContent) {
		JsonString = "{page_count:1, column_count:1}" ;
		mooAndroid.JSGetSpineColumnCount(true, $Options.View.Tag, JsonString) ;
		//console.log("Column=1, PageCount=1");
		return ;
	}
	$("body").css("-webkit-column-width", "460px").css("-webkit-column-gap", "60px");
	$Options.View.PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth) ;
	$Options.View.PageCount++ ;
	document.body.style.width = (($Options.View.PageCount * $Options.View.PageWidth) - ($Options.Layout.PaddingSide*2)) + "px";
	$Options.View.ColumnCount = $Options.View.PageCount ;
	JsonString = "{page_count:" + $Options.View.PageCount + "," +
				"column_count:" + $Options.View.ColumnCount + "}" ;
	mooAndroid.JSGetSpineColumnCount(true, $Options.View.tag, JsonString) ;
	//console.log("PageCount=" + $Options.View.PageCount);
}

function _ResetViewOptions4(OptionsJsone) {
	$Reader = document.body.parentNode ;
	console.log("document.body.scrollWidth=" + $Reader.clientWidth) ;
	mooReader.Base.ResetImage(1280,300);
	console.log("document.body.scrollWidth=" + $Reader.clientWidth) ;
	FontSize=150;
	console.log("document.body.clientHeight=" + $Reader.clientHeight) ;
	console.log("document.body.scrollHeight=" + $Reader.scrollHeight) ;
	console.log("document.body.offsetHeight=" + $Reader.offsetHeight) ;
	$Reader.style.height = "480px" ;
	console.log("---------- aaa=" + $Reader.style.height);
	console.log("document.body.clientWidth=" + $Reader.clientWidth) ;
	$("html").css("-webkit-column-width","520px").css("-webkit-column-gap","60px").css("font-size",FontSize+"%");
	$("body").css("padding-left","30px").css("padding-right","30px");
	console.log("-------------------");
	console.log("Reader clientWidth=" + $Reader.clientWidth) ;
	console.log("Reader scrollWidth=" + $Reader.scrollWidth) ;
	console.log("Reader offsetWidth=" + $Reader.offsetWidth) ;
	console.log("Reader width=" + $("html").width());
	console.log("Body width=" + $("body").width());
	console.log("Body clientWidth=" + document.body.clientWidth) ;
	console.log("Body scrollWidth=" + document.body.scrollWidth) ;
	console.log("Body offsetWidth=" + document.body.offsetWidth) ;
	console.log("-------------------");
	EndOffset = $Reader.scrollWidth % 1280 ;
	PageCount = Math.floor($Reader.scrollWidth / 1280) ;
	console.log("PageCount=" + PageCount) ;
	if (EndOffset > 640) {
		PageCount = PageCount + 1 ;
		
		TotalWidth = PageCount * 1280 ;				
		//TotalWidth = (document.body.scrollWidth + (1280-EndOffset)) ;		
	} else {
		TotalWidth = PageCount * 1280 ;				
	}
	console.log("EndOffset=" + EndOffset + ", TotalWidth=" + TotalWidth) ;
//	document.body.st
	$Reader.style.width = (TotalWidth-8-60) + "px" ;
	
}
	function _ResetWebReader1(OptionJson) {
		_ParsePageOptions(OptionJson) ;
		mooReader.Base.ResetElementMaxSize("img", $Options.Layout.MaxWidth, $Options.Layout.MaxHeight);		
		mooReader.Base.ResetElementMaxSize("frame", $Options.Layout.MaxWidth, $Options.Layout.MaxHeight);		
		mooReader.Base.ResetReaderFont($Options.Font) ;
		mooReader.Base.ResetReaderTheme($Options.Theme) ;		
		mooReader.Base.ResetSidePadding($Options.Layout.PaddingSide) ;
		mooReader.CFI.ResetDOMCFI(document.body);
		var ContentLength = document.body.scrollHeight ;
//		console.log("Content-Length=" + document.body.scrollHeight+ ",ViewHeight=" + $Options.View.PageHeight) ;
		
		document.body.style.width = ($Options.View.PageWidth-($Options.Layout.PaddingSide*2)) + "px" ;
		console.log("--- document.body.style.width=" + document.body.style.width);
		switch ($Options.Layout.Type) {
			case $LAYOUT_ONE_COLUMN:
			case $LAYOUT_TWO_COLUMN:
				document.body.style.height = $Options.View.PageHeight + "px" ;
				//console.log("--- document.body.style.height=" + document.body.style.height);
				$("body").css("-webkit-column-width",$Options.Layout.ColumnWidth + "px").css("-webkit-column-gap", $Options.Layout.ColumnGap) ;
				//console.log("document.body.scrollWidth=" + document.body.scrollWidth) ;
				if (ContentLength <= $Options.View.PageHeight) {
					$Options.View.PageCount = 0 ;
				} else {
					$Options.View.PageCount = Math.floor(document.body.scrollWidth / $Options.View.PageWidth ) ;
				}
				$Options.View.PageCount++ ;
				ContentSize = ($Options.View.PageCount * $Options.View.PageWidth) - ($Options.Layout.PaddingSide * 2) ;
				document.body.style.width = ContentSize + "px" ;
				break ;
			case $LAYOUT_SCROLLING:
				console.log("SCROLLING");
				break ;
			default:
				break ;
		}	
		
		mooReader.Base.Android.GetJSI($Options.View.Tag).JSResetWebViewer(true, $Options.View.PageCount, window.devicePixelRatio) ;
		/*
		switch($Options.View.Tag) {
			case mooReader.Base.VID_MASTER_VIEWER:
				JSIMasterViewer.JSResetWebViewer(true, $Options.View.Tag) ;
				break ;
			case mooReader.Base.VID_SECOND_VIEWER:
				JSISecondViewer.JSResetWebViewer(true, $Options.View.Tag) ;
				break ;
			case mooReader.Base.VID_SCROLL_VIEWER:
				JSIScrollViewer.JSResetWebViewer(true, $Options.View.Tag) ;
				break ;
			case mooReader.Base.VID_PAGE_INDEXER:
				JSIPageIndexer.JSResetWebViewer(true, $Options.View.Tag) ;
				break ;
			case mooReader.Base.VID_TEMP_INDEXER:
				JSITempIndexer.JSResetWebViewer(true, $Options.View.Tag) ;
				break ;
			default:
				break ;
		}
		*/
	}
	
	function _ResetWebReader(OptionJson) {
		_ParsePageOptions(OptionJson) ;
		mooReader.Base.ResetElementsMaxSize($Options.Layout.MaxWidth, $Options.Layout.MaxHeight);		
		mooReader.Base.ResetReaderFont($Options.Font) ;
		mooReader.Base.ResetReaderTheme($Options.Theme) ;
		mooReader.Base.ResetReaderPadding($Options.Layout.PaddingSide, $Options.Layout.PaddingTop, $Options.Layout.PaddingBottom) ;
		mooReader.CFI.ResetDOMCFI(document.body, false);
		document.body.style.width = ($Options.View.PageWidth-($Options.Layout.PaddingSide*2)) + "px" ;
		mooAndroid.JSResetWebReader(true, $Options.View.Tag) ;
	}


return {
	GetSpineColumnCount: function(OptionJson) {
		_GetSpineColumnCount(OptionJson) ;		
	},
	ResetWebReader: function(OptionJson) {
		_ResetWebReader1(OptionJson) ;			
	},
	ResetViewOptions: function(OptionJson) {
		_GetSpineColumnCount(OptionJson) ;
		//_ResetViewOptions3(OptionJson) ;
	}
}
})();

