mooReader = {};

mooReader.Base = (function(){
	
	function _ResetReaderFont(FontSet) {
		$("html").css("font-size", FontSet.Size + "%") ;
		$("html").css("line-height", "140%") ;		
	}
	
	function _ResetReaderTheme(ThemeSet) {
		switch(ThemeSet.Code) {
			case "CLASSIC":
				document.body.parentNode.className = "sepia";
				break ;
			case "NIGHT":
				document.body.parentNode.className = "night";
				break ;
			default:
				document.body.parentNode.className = "";
				break ;
		}
	}
	
	function _ResetElementMaxSize(ElementName, MaxWidth, MaxHeight) {
		var ElementWidth = 0 ;
		var ElementHeight = 0 ;
		var ShowRatio = 1 ;
		$(ElementName).each(function(){
			ElementWidth = this.width ;
			ElementHeight = this.height ;
			if (ElementHeight > MaxHeight) { // 先確保圖檔能夠在 Reader 裏完整 Show 出
				ShowRatio = MaxHeight / ElementHeight ;
				ElementHeight = MaxHeight ;
				ElementWidth = ElementWidth * ShowRatio ;
			}
			if (ElementWidth > MaxWidth) {
				ShowRatio = MaxWidth / ElementWidth ;
				ElementWidth = MaxWidth ;
				ElementHeight = ElementHeight * ShowRatio ;
			}
			this.width = ElementWidth ;
			this.height = ElementHeight ;
		})		
	}
	
	function _ResetSidePadding(PaddingWidth) {
		$("html").css("padding-left", PaddingWidth + "px").css("padding-right", PaddingWidth + "px") ;
	}
	
	return {
		VID_MASTER_VIEWER: 1001,
		VID_SECOND_VIEWER: 1002,
		VID_SCROLL_VIEWER: 1003,
		VID_PAGE_INDEXER: 1004,
		VID_TEMP_INDEXER: 1005,
		VID_FONT_PREVIEWER: 1006,
		ResetReaderFont: function(FontSet) {
			_ResetReaderFont(FontSet) ;
		},
		ResetReaderTheme: function(ThemeSet) {
			_ResetReaderTheme(ThemeSet) ;
		},
		ResetElementMaxSize: function(ElementName, MaxWidth, MaxHeight) {
			_ResetElementMaxSize(ElementName, MaxWidth, MaxHeight) ;
		},
		ResetSidePadding: function(PaddingWidth) {
			_ResetSidePadding(PaddingWidth) ;
		}
	}
})();

mooReader.Base.Android = (function(){
	
	function _GetJSInterface(ViewerTag) {
		var Result = null ;
		switch(ViewerTag) {
			case mooReader.Base.VID_MASTER_VIEWER:
				Result = JSIMasterViewer ;
				break ;
			case mooReader.Base.VID_SECOND_VIEWER:
				Result = JSISecondViewer ;
				break ;
			case mooReader.Base.VID_SCROLL_VIEWER:
				Result = JSIScrollViewer ;
				break ;
			case mooReader.Base.VID_PAGE_INDEXER:
				Result = JSIPageIndexer ;
				break ;
			case mooReader.Base.VID_TEMP_INDEXER:
				Result = JSITempIndexer ;
				break ;
			case mooReader.Base.VID_FONT_PREVIEWER:
				Result = JSIFontPreviewer ;
				break ;
			default:
				break ;				
		}
		return Result ;
	}
	
	return {
		GetJSI: function(ViewerTag) {
			return _GetJSInterface(ViewerTag) ;
		},
		ResetReaderFont: function(FontSet, ViewerTag) {
			mooReader.Base.ResetReaderFont(FontSet) ;
			this.GetJSI(ViewerTag).JSResetReaderFont(true) ;
		},
		ResetReaderTheme: function(ThemeSet, ViewerTag) {
			mooReader.Base.ResetReaderTheme(ThemeSet) ;
			this.GetJSI(ViewerTag).JSResetReaderTheme(true) ;
		},
		ResetElementMaxSize: function(ElementName, MaxWidth, MaxHeight) {
			mooReader.Base.ResetElementMaxSize(ElementName, MaxWidth, MaxHeight) ;
		},
		ResetSidePadding: function(PaddingWidth) {
			mooReader.Base.ResetSidePadding(PaddingWidth) ;
		}
	}
})();
	



