CREATE TABLE IF NOT EXISTS APP_MESSAGE (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(1),
  USER_ID varchar,
  MESSAGE_ID integer DEFAULT(0),
  MESSAGE_TITLE varchar,
  MESSAGE_CONTENT varchar,
  MESSAGE_DESC varchar,
  MESSAGE_LINK varchar,
  BUTTON_TITLE varchar,
  MESSAGE_DATE varchar,
  READ_FLAG integer DEFAULT(0)
);


CREATE TABLE IF NOT EXISTS BOOKMARK_EXTRA (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  USER_ID varchar,
  READING_ID varchar,
  BOOKMARK_ID varchar,
  BOOKMARK_CFI varchar
);


CREATE TABLE IF NOT EXISTS BOOK_INDEX (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  BOOK_ID varchar,
  FONT_SIZE double DEFAULT(100),
  SPINE_INDEX integer DEFAULT(0),
  SINGLE_VIEW integer DEFAULT(0),
  LEFT_SPINE integer DEFAULT(0),
  LEFT_OFFSET double DEFAULT(0),
  LEFT_IS_SINGLE integer DEFAULT(0),
  LEFT_SIZE double DEFAULT(0),
  LEFT_IS_LAST integer DEFAULT(0),
  RIGHT_SPINE integer DEFAULT(0),
  RIGHT_OFFSET double DEFAULT(0),
  RIGHT_IS_SINGLE integer DEFAULT(0),
  RIGHT_SIZE double DEFAULT(0),
  RIGHT_IS_LAST integer DEFAULT(0),
  IS_LANDSCAPE integer DEFAULT(0),
  IS_PHONE integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS BOOK_INDEXES (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  BOOK_ID varchar,
  SPINE_INDEX integer,
  NAV_TITLE varchar,
  NAV_SOURCE varchar,
  NAV_LEVEL integer DEFAULT(1),
  NAV_FILE varchar
);


CREATE TABLE IF NOT EXISTS BOOK_NAVPOINTS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  BOOK_ID varchar,
  PARENT_ID varchar,
  NAVPOINT_ID varchar,
  SPINE_INDEX integer,
  NAVPOINT_TITLE varchar,
  NAVPOINT_ORDER integer DEFAULT(0),
  NAVPOINT_SOURCE varchar,
  NAVPOINT_FILE varchar
);

CREATE TABLE IF NOT EXISTS BOOK_WEIGHTS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  BOOK_ID varchar,
  SOURCE varchar,
  WEIGHT integer DEFAULT(0),
  PERCENTAGE integer DEFAULT(0),
  IS_PREVIEW boolean DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS FOREVER_BOOKS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  ITEM_ID integer DEFAULT(null),
  BOOK_ID varchar,
  BOOK_AUTHOR varchar,
  BOOK_TITLE varchar,
  BOOK_PUBLISHER varchar,
  COVER_URL varchar,
  PERMA_LINK_ID varchar,
  PERMA_LINK_URL varchar,
  BOOK_ACTION varchar,
  FILE_SIZE double DEFAULT(0),
  BOOK_TAGS varchar,
  SET_ID varchar,
  SORT integer DEFAULT(0),
  TAG varchar,
  NEW_ARRIVE bool,
  POPULAR bool,
  START_TIME varchar,
  END_TIME varchar,
  SUBSCRIBED bool,
  IS_18X bool
);

CREATE TABLE IF NOT EXISTS FOREVER_SETS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  SET_ID varchar,
  SET_TITLE varchar,
  SET_CONTENT varchar,
  SET_END_TIME varchar,
  SUBSCRIBED bool,
  LAST_SYNC_TIME varchar,
  BANNER varchar
);

CREATE TABLE IF NOT EXISTS READER_PAGES (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  USER_ID varchar,
  BOOK_ID varchar
);

CREATE TABLE IF NOT EXISTS READING_PINGS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(1),
  USER_ID varchar,
  READING_ID varchar,
  PING_ID varchar,
  PING_PROGRESS float DEFAULT(0.0),
  PING_DURATION integer DEFAULT(300),
  OCCURRED_AT varchar,
  PING_LATITUDE varchar,
  PING_LONGITUDE varchar,
  PING_CFI varchar,
  DATA_STATE integer DEFAULT(0),
  UPDATED_DATE varchar,
  START_UTC_TIME varchar DEFAULT(null),
  END_UTC_TIME varchar DEFAULT(null),
  SET_ID varchar,
  USER_AGENT varchar,
  LAST_SYNC_TIME varchar
);

CREATE TABLE IF NOT EXISTS SPINE_CFIS (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  CFI_UID varchar,
  NODE_CFI varchar,
  NODE_LEFT integer DEFAULT(0),
  NODE_RIGHT integer DEFAULT(0),
  NODE_COLUMN integer DEFAULT(0),
  NODE_PAGE integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS SPINE_INFOS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  BOOK_ID varchar,
  SPINE_INDEX integer DEFAULT(0),
  FONT_SIZE integer DEFAULT(0),
  SPINE_SIZE float DEFAULT(0),
  PAGE_COUNT integer DEFAULT(0),
  READER_LAYOUT integer DEFAULT(0),
  COLUMN_WIDTH float DEFAULT(0),
  IS_LANDSCAPE integer DEFAULT(0),
  CFI_UID varchar,
  IS_VERTICAL integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS USER_ACTIONS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  AUSER_ID varchar,
  ABOOK_ID varchar,
  BOOK_TYPE integer DEFAULT(0),
  START_AT varchar DEFAULT(0),
  LAST_SPINE integer,
  CLOSE_AT varchar,
  READ_PROGRESS float,
  CURRENT_AT varchar
);

CREATE TABLE IF NOT EXISTS USER_BASE (
  USER_ID varchar PRIMARY KEY UNIQUE NOT NULL,
  USER_NAME varchar,
  FIRST_NAME varchar,
  LAST_NAME varchar,
  FULL_NAME varchar,
  USER_COUNTRY varchar,
  USER_CITY varchar,
  CREATED_TIME varchar,
  AVATAR_IMAGE varchar,
  EMAIL_ADDRESS varchar,
  WEB_SITE varchar,
  USER_DESC text,
  PERMALINK_URL varchar,
  INTERESTING_COUNT integer DEFAULT(0),
  READING_COUNT integer DEFAULT(0),
  ADOBE_TOKEN varchar,
  FINISHED_COUNT integer DEFAULT(0),
  ABANDONED_COUNT integer DEFAULT(0),
  FOLLOWERS_COUNT integer DEFAULT(0),
  FOLLOWINGS_COUNT integer DEFAULT(0),
  OPEN_COUNT integer DEFAULT(0),
  LAST_LOGIN_TIME varchar,
  AT_VALUE varchar,
  AC_VALUE varchar,
  LOGIN_MARK integer DEFAULT(0),
  NICK_NAME varchar
);

CREATE TABLE IF NOT EXISTS USER_BOOKMARKS (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  USER_ID varchar,
  READING_ID varchar,
  BOOKMARK_ID varchar,
  POSITION float DEFAULT(0),
  CONTENT varchar,
  BOOKMARKED_AT varchar,
  DEVICE varchar,
  PERMA_LINK varchar,
  LIKES_COUNT integer DEFAULT(0),
  LOCATOR_TITLE varchar,
  LOCATOR_CFI varchar,
  LOCATOR_TEXT varchar,
  LOCATOR_POSITION float DEFAULT(0),
  LOCATOR_SPINE integer DEFAULT(0),
  DATA_STATE integer DEFAULT(0)
);


CREATE TABLE IF NOT EXISTS USER_BOOKS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  ITEM_ID integer DEFAULT(null),
  BOOK_ID varchar,
  BOOK_AUTHOR varchar,
  BOOK_TITLE varchar,
  BOOK_PUBLISHER varchar,
  BOOK_PUBLICATION_DATE varchar,
  COVER_URL varchar,
  PERMA_LINK_ID varchar,
  PERMA_LINK_URL varchar,
  BOOK_ACTION varchar,
  FILE_SIZE integer DEFAULT(0),
  BOOK_TAGS varchar,
  IS_FIXED_LAYOUT integer DEFAULT(0),
  IS_18X bool
);


CREATE TABLE IF NOT EXISTS USER_BOOK_OPTION (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  BOOK_ID varchar,
  LAST_SPINE integer DEFAULT(0),
  LAST_CFI varchar,
  START_AT varchar,
  CURRENT_AT varchar,
  CLOSE_AT varchar,
  READING_PROGRESS float DEFAULT(0.0),
  DOWNLOAD_STATE integer DEFAULT(0),
  EXISTS_MARK integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS USER_COMMENTS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  HILITE_ID varchar,
  READING_ID varchar DEFAULT(null),
  COMMENT_TEXT text,
  DATA_STATE integer DEFAULT(0),
  POSTED_AT varchar DEFAULT(null),
  COMMENT_ID varchar,
  COMMENT_TYPE integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS USER_HIGHLIGHT (
  KEY_ID integer PRIMARY KEY,
  USER_ID varchar NOT NULL,
  BOOK_ID varchar NOT NULL,
  READING_ID varchar NOT NULL,
  HIGHLIGHT_ID varchar NOT NULL,
  ANNOTATION text,
  COMMENTS_COUNT integer DEFAULT('(0)'),
  CONTENT text,
  HIGHLIGHTED_AT varchar,
  LIKES_COUNT integer DEFAULT('(0)'),
  MARK_CFI varchar,
  MARK_TEXT text,
  MARK_TEXT_BEFORE text,
  MARK_TEXT_AFTER text,
  MARK_SPINE integer DEFAULT('(0)'),
  PERMALINK_ID varchar,
  PERMALINK_URL varchar,
  POSITION float DEFAULT('(0)'),
  DATA_TYPE varchar,
  UPLOAD_ACTION integer DEFAULT('(null)')
);

CREATE TABLE IF NOT EXISTS USER_HILITES (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(0),
  USER_ID varchar,
  BOOK_ID varchar,
  READING_ID varchar,
  HILITE_ID varchar,
  ANNOTATION text,
  COMMENTS_COUNT integer DEFAULT(0),
  CONTENT text,
  HIGHLIGHTED_AT varchar,
  LIKES_COUNT integer DEFAULT(0),
  MARK_CFI varchar,
  MARK_TEXT text,
  MARK_TEXT_BEFORE text,
  MARK_TEXT_AFTER text,
  MARK_SPINE integer DEFAULT(0),
  PERMALINK_ID varchar,
  PERMALINK_URL varchar,
  POSITION float DEFAULT(0),
  DATA_TYPE varchar,
  UPDATE_MARK integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS USER_OPTION (
  USER_ID varchar,
  LIBRARY_FILTER varchar,
  LIBRARY_ORDER varchar,
  READER_FONT_SIZE integer DEFAULT(0),
  READER_FONT_TYPE varchar,
  READER_VIEW_TYPE integer DEFAULT(0),
  READER_VIEW_LAYOUT integer DEFAULT(0),
  READER_THEME integer DEFAULT(0),
  LIBRARY_FILTER_TAG varchar,
  LIBRARY_FILTER_SECTION integer DEFAULT(0),
  LIBRARY_FILTER_ROW integer DEFAULT(0),
  FIRST_SYNC integer DEFAULT(0),
  LAST_SYNC varchar,
  IS_FOREVER bool,
  FOREVER_SET_ID varchar,
  READER_BRIGHTNESS float DEFAULT(0),
  READER_LINE_HEIGHT integer DEFAULT(0),
  TIPS_LIBRARY_VERSION integer DEFAULT(0),
  TIPS_LIBRARY_STATE integer DEFAULT(0),
  TIPS_READER_VERSION integer DEFAULT(0),
  TIPS_READER_STATE integer DEFAULT(0)
);

CREATE TABLE IF NOT EXISTS USER_READERS (
  KEY_ID integer PRIMARY KEY NOT NULL DEFAULT(0),
  USER_ID varchar,
  BOOK_ID varchar,
  START_TIME varchar,
  CLOSE_TIME varchar,
  IS_LANDSCAPE integer,
  H_SPINE_INDEX integer,
  H_PAGE_INDEX integer,
  H_SPINE_OFFSET float,
  V_SPINE_INDEX integer,
  V_PAGE_INDEX integer,
  V_SPINE_OFFSET float,
  READER_LAYOUT integer DEFAULT(null),
  UPDATE_FLAG integer,
  ELAPSED_SECONDS integer DEFAULT(0),
  SPINE_INDEX integer DEFAULT(0),
  PAGE_INDEX integer DEFAULT(0),
  SPINE_OFFSET float DEFAULT(0),
  FONT_SIZE integer DEFAULT(0),
  LINE_HEIGHT integer DEFAULT(0),
  FONT_TYPE varchar,
  WRITING_MODE integer DEFAULT(0),
  PAGINATION varchar,
  PAGE_VERSION varchar
);

CREATE TABLE IF NOT EXISTS USER_READING (
  KEY_ID integer PRIMARY KEY,
  USER_ID varchar NOT NULL,
  BOOK_ID varchar NOT NULL,
  READING_ID varchar NOT NULL,
  STATE varchar,
  PRIVATE varchar,
  
  STARTED_AT varchar,
  TOUCHED_AT varchar,
  ENDED_AT varchar,
  DURATION float DEFAULT('0.0'),
  PROGRESS float DEFAULT('0.0'),
  PERMALINK_URL varchar,
  COMMENTS_COUNT integer DEFAULT('0'),
  HIGHLIGHTS_COUNT integer DEFAULT('0'),
  POSITION float,
  POSITION_UPDATED_AT varchar,
  LOCATION_CFI varchar,
  AVERAGE_PERIOD_TIME float DEFAULT('0.0'),
  CLOSING_REMARK text DEFAULT('0'),
  ESTIMATED_TIME_LEFT float DEFAULT('0.0'),
  RECOMMENDED integer DEFAULT('0'),
  UPLOAD_ACTION integer DEFAULT('0'),
  RATING integer DEFAULT('0')
);

CREATE TABLE IF NOT EXISTS USER_TAGS (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(1),
  USER_ID varchar,
  TAG_ID varchar,
  NAME varchar,
  CREATED_TIME varchar,
  BOOKS varchar,
  COUNT integer DEFAULT(0),
  DATA_STATE integer DEFAULT(0)
);
CREATE TABLE IF NOT EXISTS APP_ERROR (
  KEY_ID integer PRIMARY KEY UNIQUE NOT NULL DEFAULT(1),
  ERROR_CODE varchar,
  ERROR_MESSAGE text,
  ERROR_LOCATION varchar,
  ERROR_DATETIME varchar,
  USER_ID varchar,
  ERROR_TYPE integer DEFAULT(0),
  DATA_STATE integer DEFAULT(0)
);








