var moo = {
	bookCss:[],
	data: {
		element: {
		},
		pagination: { 
			
			// 基本分頁功能
			deviceWidth: 0,
			deviceHeight: 0,
			scrollWidth: 0,
			scrollHeight: 0,
			deviceRatio:0,
			singleColumn_page: 0,
			doubleColumn_page: 0,

			columnRatio: 0,
			
			singleColumn_gap: 20,
			doubleColumn_gap: 40,
			
			scrollPrevChapter: 0,
			scrollNextChapter: 0,

			position: 0,

			SINGLE_COLUMN: 0,
			DOUBLE_COLUMN: 1,
			SCROLL_VIEW: 2,
			SINGLE_COLUMN_HALF: 3,

			READING_MODE: 0,
			CALCULATING_MODE: 1,
			CALCULATING_MODE_TEMP: 2,
			CALCULATING_MODE_TEMP_INSERT: 201,
			CALCULATING_MODE_TEMP_APPEND: 202,
			CALCULATING_MODE_PAGINATION_DONE: 3,
			CALCULATING_MODE_GET_ID_POSITION: 4,
			CALCULATING_MODE_GET_NEXT_CFI: 5,
			MAIN_WEB_VIEW: 5,
			JUMP_TO_CFI: 600,
			JUMP_TO_ID: 601,
			JUMP_TO_COLUMN_OFFSET: 602,
			JUMP_TO_START: 603,
			JUMP_TO_END: 604,
			TEMP: 605,
			TEMP_JUMP_TO_CFI: 605,
			TEMP_JUMP_TO_ID: 606,
			TEMP_JUMP_TO_COLUMN_OFFSET: 607,
			TEMP_JUMP_TO_START: 608,
			TEMP_JUMP_TO_END: 609,
			SCROLL_TO_CFI: 700,
			SCROLL_TO_ID: 701,
			SCROLL_TO_TOP: 702,
			SCROLL_TO_END: 703,
			SCROLL_TO_PERCENTAGE: 704
		},
		readerInfo:{

			json: '{"font_size":16, reader_layout":0, "function_mode": 0, "offset":0, "theme":0 ,"cfi":false}',
			device: 0,
			theme: 0,
			page_start_position: 0,
			font_size: 0,
			reader_layout: 0,
			function_mode: 0,
			offset: 0,
			get_cfi: false,
			jump_cfi: "",
			jump_id: "",
			bookmarks:[]
		}
	},

	paginationManager: function(JSONText){
		
		mooCFI.initialize();

		var pagination = moo.data.pagination;
		var readerInfo = moo.data.readerInfo;
		var jsonObject = JSON.parse(JSONText);

		readerInfo.device              = jsonObject.device;
		readerInfo.page_start_position = jsonObject.page_start_position;
		readerInfo.font_size	       = jsonObject.font_size;
		readerInfo.reader_layout       = jsonObject.reader_layout;
		readerInfo.function_mode       = jsonObject.function_mode;
		readerInfo.offset 		       = jsonObject.offset;
		readerInfo.theme 		       = jsonObject.theme;
		readerInfo.get_cfi             = jsonObject.get_cfi;
		readerInfo.bookmarks           = jsonObject.bookmarks;
		readerInfo.highlights          = jsonObject.highlights;
		readerInfo.jump_cfi		       = jsonObject.jump_cfi;
		readerInfo.jump_id		       = jsonObject.jump_id;
		
		if (readerInfo.device == 0){
			pagination.singleColumn_gap = 20;
			pagination.doubleColumn_gap = 40;
		}else{
			pagination.singleColumn_gap = 40;
			pagination.doubleColumn_gap = 80;
		}

		moo.setTheme();
		moo.setFontSize();
		moo.initAudioTag();

		var meta = document.createElement("meta");
		meta.setAttribute('content',"width=device-width, initial-scale=1.0, maximum-scale=1, minimum-scale=1, user-scalable=no");
		meta.setAttribute('name',"viewport");
		document.getElementsByTagName("head")[0].appendChild(meta);

		switch(readerInfo.reader_layout){
			
			case pagination.SINGLE_COLUMN:

				window.onscroll = function(){
					mooCFI.GetBookmarkCFI();
					mooCFI.GetNextBookmarkCFI();
					//console.log("maina->scrollLeft:"+document.body.scrollLeft);
				}
				
				moo.singleColumn();
				
				if(readerInfo.function_mode > pagination.MAIN_WEB_VIEW){
					
					moo.initHref();
					moo.addFlag();
					
					var columnPosition;

					if(readerInfo.function_mode < pagination.TEMP){		

						//-PAGINATION MODE
						var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
						Android.bookmarkPosition(bookmarkPositionJson);

						if(readerInfo.function_mode == pagination.JUMP_TO_CFI){
							columnPosition = mooCFI.GetCFIPosition(readerInfo.reader_layout,readerInfo.jump_cfi);
							if(columnPosition >= 1){
								columnPosition-=1;
							}
						}else if(readerInfo.function_mode == pagination.JUMP_TO_ID){
							columnPosition = mooCFI.GetIdPosition(readerInfo.reader_layout,readerInfo.jump_id);
							if(columnPosition >= 1){
								columnPosition-=1;
							}
						}else if(readerInfo.function_mode == pagination.JUMP_TO_COLUMN_OFFSET){
							columnPosition = readerInfo.offset;
						}else if(readerInfo.function_mode == pagination.JUMP_TO_START){
							columnPosition = 0;
						}else if(readerInfo.function_mode == pagination.JUMP_TO_END){
							columnPosition = 0;
						}

					}else{

						//-TEMP MODE
						moo.getPaginationInfo();

						if(readerInfo.function_mode == pagination.TEMP_JUMP_TO_CFI){
							columnPosition = mooCFI.GetCFIPosition(readerInfo.reader_layout,readerInfo.jump_cfi);
							if(columnPosition >= 1){
								columnPosition-=1;
							}
						}else if(readerInfo.function_mode == pagination.TEMP_JUMP_TO_ID){
							columnPosition = mooCFI.GetIdPosition(readerInfo.reader_layout,readerInfo.jump_id);
							if(columnPosition >= 1){
								columnPosition-=1;	
							}
						}else if(readerInfo.function_mode == pagination.TEMP_JUMP_TO_COLUMN_OFFSET){
							columnPosition = readerInfo.offset;
						}else if(readerInfo.function_mode == pagination.TEMP_JUMP_TO_END){
							columnPosition = pagination.singleColumn_page - 1;
						}
					}

					mooHighLight.showHighlightsInAndroidWebView(readerInfo.highlights);

					Android.jumpToOffset(columnPosition);
					Android.webView1Done();
					
					if(readerInfo.get_cfi){
						mooCFI.GetBookmarkCFI();
						mooCFI.GetNextBookmarkCFI();
					}
				}else{
					moo.getPaginationInfo();
				}
				break;

			case pagination.DOUBLE_COLUMN:

				window.onscroll = function(){
					mooCFI.GetBookmarkCFI();
					mooCFI.GetNextBookmarkCFI();
				}
				
				moo.doubleColumn();
				
				if(readerInfo.function_mode > pagination.MAIN_WEB_VIEW){
					
					moo.initHref();
					moo.addFlag();

					var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
					
					Android.bookmarkPosition(bookmarkPositionJson);
					mooHighLight.showHighlightsInAndroidWebView(readerInfo.highlights);

					var columnPosition;

					if(readerInfo.function_mode == pagination.JUMP_TO_CFI){
						
						columnPosition = mooCFI.GetCFIPosition(readerInfo.reader_layout,readerInfo.jump_cfi);
						
						if(columnPosition >= 1){
							columnPosition-=1;
						}
						columnPosition = moo.checkDoubleColumnPosition(columnPosition);
						
					}else if(readerInfo.function_mode == pagination.JUMP_TO_ID){
						
						columnPosition = mooCFI.GetIdPosition(readerInfo.reader_layout,readerInfo.jump_id);
						
						if(columnPosition >= 1){
							columnPosition-=1;
						}
						columnPosition = moo.checkDoubleColumnPosition(columnPosition);

					}else if(readerInfo.function_mode == pagination.JUMP_TO_COLUMN_OFFSET){
						columnPosition = readerInfo.offset;
					}else if(readerInfo.function_mode == pagination.JUMP_TO_START){
						columnPosition = 0;
					}else if(readerInfo.function_mode == pagination.JUMP_TO_END){
						columnPosition = 0;
					}

					
					Android.jumpToOffset(columnPosition);
					Android.webView1Done();

					if(readerInfo.get_cfi){
						mooCFI.GetBookmarkCFI();
						mooCFI.GetNextBookmarkCFI();
					}
				}else{
					moo.getPaginationInfo();
				}
				break;

			case pagination.SCROLL_VIEW:
				//scroll view
				moo.initialize();
				moo.scaleImageForScroll();
				moo.getContentHeight();
				moo.initHref();
				moo.addFlag();
				mooHighLight.showHighlightsInAndroidWebView(readerInfo.highlights);
				moo.getScrollCFI();

				var position;

				if(readerInfo.function_mode == pagination.SCROLL_TO_CFI){
					position = mooCFI.GetCFIPosition(readerInfo.reader_layout,readerInfo.jump_cfi);
				}else if(readerInfo.function_mode == pagination.SCROLL_TO_ID){
					position = mooCFI.GetIdPosition(readerInfo.reader_layout,readerInfo.jump_id);
				}else if(readerInfo.function_mode == pagination.SCROLL_TO_TOP){
					position = 0;
				}else if(readerInfo.function_mode == pagination.SCROLL_TO_END){
					position = moo.getScrollHeight()-window.innerHeight;
					if(position < 0){
						position = 0
					}
				}else if(readerInfo.function_mode == pagination.SCROLL_TO_PERCENTAGE){
					position = moo.getScrollHeight()*readerInfo.offset;
				}
				
				if(position >= 10){
					position -= 10;
				}

				var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);

				Android.bookmarkPositionForScroll(bookmarkPositionJson);
				Android.scrollToPosition(position,moo.getScrollHeight());

				if(moo.getScrollHeight() <= window.innerHeight){
					//往上滑時，就要顯示出切換動畫
					Android.overScrollSwitch(true);
				}else{
					Android.overScrollSwitch(false);
				}
				
				Android.webView1Done();

				break;

			case pagination.SINGLE_COLUMN_HALF:
				moo.singleColumn_halfWebView();
				if(readerInfo.function_mode == pagination.READING_MODE){
					moo.initHref();
					moo.addFlag();
					mooHighLight.showHighlightsInAndroidWebView(readerInfo.highlights);
					Android.webView2Done();
				}
				break;

			default:
				break;
			}
	},

	initialize: function(){
		var pagination = this.data.pagination;
		document.documentElement.style.opacity = "1";
		document.body.style.opacity = "1";
		pagination.deviceWidth  = document.documentElement.offsetWidth || document.body.offsetWidth;
		pagination.deviceHeight = document.documentElement.clientHeight || document.body.clientHeight; //捲動模式抓到的會是文件長度
		console.log("maina->screen:"+pagination.deviceWidth);
	},

	getContentHeight: function(){
		var pagination = this.data.pagination;
		pagination.deviceWidth  = document.documentElement.offsetWidth || document.body.offsetWidth;
		pagination.deviceHeight = document.documentElement.clientHeight || document.body.clientHeight;	
	},

	getScrollHeight: function(){
		
		var body = document.body;
   		var html = document.documentElement;

		var height = Math.max( body.scrollHeight, body.offsetHeight,
			html.clientHeight, html.scrollHeight, html.offsetHeight);

		return height;
	},

	initHref: function(){
		var href = document.querySelectorAll("[href]");
		for(var i = 0;i<=href.length-1;i++){
			if(href[i].className.indexOf("footnote")>-1 || (href[i].getAttribute("href").indexOf("#")>-1 && href[i].getAttribute("href").indexOf("xhtml") == -1)){
				var element = href[i];
				element.onclick = function(e){
					var element = e.target;
					if(element.nodeName != "A"){
						element = element.parentNode;
					}
                	if(element.getAttribute("epub:type")=="noteref"){
						// console.log("pop up !!!");
						var id = element.getAttribute("href");
						var content = document.getElementById(id).textContent;
						Android.popupFootnote(content);
					}else{
						var id = element.getAttribute("href");
						// console.log("Jump"+id)
						Android.jumpToFootnoteId(id);
					}
            	};
            	href[i].setAttribute("href",href[i].getAttribute("href").split("#")[1]);
//            	 console.log(href[i].getAttribute("href"));
				//href[i].setAttribute("onClick","return false");
			}
		}
	},

	checkImage: function(pointX,pointY){
	console.log("checkImage");
		var element = document.elementFromPoint(pointX,pointY);
		console.log("checkImage"+element);
		var nodeName = element.nodeName.toUpperCase();
		if(nodeName === "IMG"){
			var Result = element.getAttribute("src");
			Android.getImageSource(Result);
		}
        if(nodeName === "IMAGE"){
            var Result = element.getAttribute("xlink:href");
            Android.getImageSource(Result);
        }

	},

	onClick: function(pointX, pointY) {
	    var element = document.elementFromPoint(pointX,pointY);
            console.log("checkImage"+element);

        if (element.onclick) {
        }

        var nodeName = element.nodeName.toUpperCase();
        console.log("nodeName: " + nodeName);
        if(nodeName === "IMG" || nodeName === "IMAGE" ){
            var Result = element.getAttribute("src");
            Android.getImageSource(Result);
            return;
        }

        if (nodeName === "AUDIO") {
            return;
        }
	},

	checkElement: function(pointX,pointY){

		var element = document.elementFromPoint(pointX,pointY);
		// console.log(element.nodeName);
		// console.log(element.parentNode.nodeName);
		if(element.nodeName == "A" || element.parentNode.nodeName == "A"){
			if(element.nodeName != "A"){
				element = element.parentNode;
			}
			if (element.className.indexOf("footnote")>-1 || (element.getAttribute("href").indexOf("#")>-1 && element.getAttribute("href").indexOf("xhtml") == -1)){
				if(element.getAttribute("epub:type")=="noteref"){
					// console.log("pop up !!!");
					var id = element.getAttribute("href").split("#")[1];
					// console.log(element.getAttribute("href").split("#")[1])
					var content = document.getElementById(id).textContent;
					Android.popupFootnote(content);
				}else{
					var id = element.getAttribute("href").split("#")[1];
					// console.log("id====="+id);
					var footnote = document.getElementById(id);
					var IdPoition   = mooCFI.GetIdPosition(moo.data.readerInfo.reader_layout,id);
					// console.log(footnote);
					// console.log(IdPoition);
					Android.jumpToFootnoteId(id);
				}
			}
		}
	},

	checkElement2: function(element){

		//var element = document.elementFromPoint(pointX,pointY);
		// console.log(element.nodeName);
		// console.log(element.parentNode.nodeName);
		if(element.nodeName == "A" || element.parentNode.nodeName == "A"){
			if(element.nodeName != "A"){
				element = element.parentNode;
			}
			if (element.className.indexOf("footnote")>-1 || (element.getAttribute("href").indexOf("#")>-1 && element.getAttribute("href").indexOf("xhtml") == -1)){
				if(element.getAttribute("epub:type")=="noteref"){
					// console.log("pop up !!!");
					var id = element.getAttribute("href").split("#")[1];
					// console.log(element.getAttribute("href").split("#")[1])
					var content = document.getElementById(id).textContent;
					Android.popupFootnote(content);
				}else{
					var id = element.getAttribute("href").split("#")[1];
					// console.log("id====="+id);
					var footnote = document.getElementById(id);
					var IdPoition   = mooCFI.GetIdPosition(moo.data.readerInfo.reader_layout,id);
					// console.log(footnote);
					// console.log(IdPoition);
					Android.jumpToFootnoteId(id);
				}
			}
		}
	},

	addFlag: function(){
		var flagHead = document.createElement("div");
		var poketballHead = document.createElement("span");
		flagHead.id = "flagHead";
		poketballHead.id = "poketballHead";
		//poketballHead.src = "file:///android_asset/pagination/img/mark.png";
		//poketballHead.width = "100%";
		//poketballHead.height = "100%";
		document.body.appendChild(flagHead);
		document.getElementById("flagHead").appendChild(poketballHead);
		var flagTail = document.createElement("div");
		var poketballTail = document.createElement("span");
		flagTail.id = "flagTail";
		poketballTail.id = "poketballTail";
		//poketballTail.src = "file:///android_asset/pagination/img/mark.png";
		//poketballTail.width = "100%";
		//poketballTail.height = "100%";
		document.body.appendChild(flagTail);
		document.getElementById("flagTail").appendChild(poketballTail);
	},

	// 若有調整字體，須直接觸發重新調整分頁機制
	setFontSize: function(){

        var readerInfo = this.data.readerInfo;
		var body = document.documentElement.style || document.body.style;
    	body.fontSize = readerInfo.font_size +'%';
   },

   setFontSizeFromAndroid: function(fontSize){
   		var body = document.documentElement.style || document.body.style;
   		console.log('body',body);
    	body.fontSize = fontSize +'%';
    	console.log('body.fontSize',body.fontSize);

    	
    },

   setTheme: function(){
    	var readerInfo = this.data.readerInfo;
    	var className = document.body.className;
    	switch (readerInfo.theme){    		
    		case 0:
    			document.body.className = className + "";
    			break;
    		case 1:
    			document.body.className = className + " sepia";
    			break;
    		case 2:
    			document.body.className = className + " night";
    			break;
    		default:
    			break;
    	}
    },

    setThemeFromAndroid: function(theme){
    	var readerInfo = this.data.readerInfo;
    	var className = document.body.className.replace(' sepia','').replace(' night','');
    	switch (theme){    		
    		case 0:
    			document.body.className = className + "";
    			break;
    		case 1:

    			document.body.className = className + " sepia";
    			break;
    		case 2:
    			document.body.className = className + " night";
    			break;
    		default:
    			break;
    	}
    },

	addHighlightFlag: function(){

		var flagHead = document.createElement("div");
		var poketballHead = document.createElement("img");
		flagHead.id = "flagHead";
		poketballHead.id = "poketballHead";
		poketballHead.src = "./pagination/img/poketball.png";
		poketballHead.width = "100%";
		poketballHead.height = "100%";
		document.body.appendChild(flagHead);
		document.getElementById("flagHead").appendChild(poketballHead);
		var flagTail = document.createElement("div");
		var poketballTail = document.createElement("img");
		flagTail.id = "flagTail";
		poketballTail.id = "poketballTail";
		poketballTail.src = "./pagination/img/poketball.png";
		poketballTail.width = "100%";
		poketballTail.height = "100%";
		document.body.appendChild(flagTail);
		document.getElementById("flagTail").appendChild(poketballTail);

		document.onkeydown=function()
		{
		 return false;
		}
	},

	scaleImage: function(){
       var pagination = this.data.pagination;
       var img = document.getElementsByTagName('img');
       var width = pagination.columnWidth-50;
       var height = pagination.deviceHeight-20-80;

       for(var i = 0 ; i <= img.length-1 ; i++){
           var imgRatio = img[i].clientWidth/img[i].clientHeight;
           if(imgRatio>pagination.columnRatio && img[i].clientWidth>(pagination.columnWidth-50)){
               img[i].setAttribute('width',""+width+"px");
               img[i].setAttribute('height','auto');
           }else if(imgRatio<pagination.columnRatio && img[i].clientHeight>(pagination.deviceHeight-80)){
               img[i].setAttribute('height',""+height+"px");
               img[i].setAttribute('width','auto');
           }
       }
   },

   scaleImageForScroll: function(){
       var pagination = this.data.pagination;
       var img = document.getElementsByTagName('img');
       var width = pagination.deviceWidth-60;
       var height = window.innerHeight-20-70;
      
       for(var i = 0 ; i <= img.length-1 ; i++){
           var imgRatio = img[i].clientWidth/img[i].clientHeight;
      
           if(imgRatio>pagination.columnRatio && img[i].clientWidth>(pagination.deviceWidth-60)){
               img[i].setAttribute('width',""+width+"px");
               img[i].setAttribute('height','auto');
           }else if(imgRatio<pagination.columnRatio && img[i].clientHeight>(window.innerHeight-70)){
               img[i].setAttribute('height',""+height+"px");
               img[i].setAttribute('width','auto');
           }
       }
   },

   initAudioTag: function() {

   		var audioTag = document.getElementsByTagName('audio');
		
		var handler = function(e) {
			var source = audio.getElementsByTagName("source");
			if(source[0]){
				window.location.href = "audio-"+ e.type + "://" + source[0].getAttribute("src");
			}else{
				window.location.href = "audio-"+ e.type + "://";
			}
		}

		for(var i = 0 ; i <= audioTag.length-1 ; i++){
			var audio = audioTag[i];
			audio.addEventListener('play',handler,false);
			audio.addEventListener('pause',handler,false);
			audio.addEventListener('seeking',handler,false);
			audio.addEventListener('seeked',handler,false);
			audio.addEventListener('volumechange',handler,false);
		}
   },

	singleColumn: function(){
	
		moo.initialize();
		var pagination = this.data.pagination;
		var readerInfo = this.data.readerInfo;
	
		pagination.columnWidth = (pagination.deviceWidth-pagination.singleColumn_gap*2);
		pagination.columnRatio = pagination.columnWidth/pagination.deviceHeight;
		
		// document.body.setAttribute('style','overflow-y: -webkit-paged-x;overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:' +pagination.singleColumn_gap+'px;');
		//chrome 46 : overflow-y: -webkit-paged-x; 會掛掉
		
		//document.body.setAttribute('style','overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:' +pagination.singleColumn_gap+'px;');
		
		moo.scaleImage();
		pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
		
		if(pagination.deviceWidth != pagination.scrollWidth){
			document.body.style.overflow = 'auto';
			document.body.style.width = pagination.scrollWidth;
			document.body.style.paddingRight = pagination.singleColumn_gap;
			document.body.style.paddingLeft = pagination.singleColumn_gap;
			pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
		}else{
			document.body.style.overflow = 'auto';
			document.body.style.width = pagination.columnWidth;
			document.body.style.paddingRight = pagination.singleColumn_gap;
			document.body.style.paddingLeft = pagination.singleColumn_gap;
			pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
		}
	},

	getScrollWidth: function(){
		var scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
	},

	doubleColumn: function(){

		moo.initialize();
		var readerInfo = this.data.readerInfo;
		var pagination = this.data.pagination;

		pagination.columnWidth = (pagination.deviceWidth-3*pagination.doubleColumn_gap)/2;
		pagination.columnRatio = pagination.columnWidth/pagination.deviceHeight;
		
		//<1310 document.body.setAttribute('style','overflow-y: -webkit-paged-x;overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:'+pagination.doubleColumn_gap+'px;');
		//document.body.setAttribute('style','overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:'+pagination.doubleColumn_gap+'px;');
		

		moo.scaleImage();
		pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
		

		if(pagination.deviceWidth != pagination.scrollWidth){
			document.body.style.overflow = 'auto';
			document.body.style.width = pagination.scrollWidth;
			// document.body.style.paddingRight = pagination.doubleColumn_gap;
			document.body.style.paddingRight = pagination.doubleColumn_gap*2+pagination.columnWidth;
			document.body.style.paddingLeft = pagination.doubleColumn_gap;
			pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
		}else{
			document.body.style.overflow = 'auto';
			document.body.style.width = pagination.columnWidth*2+pagination.doubleColumn_gap;
			// document.body.style.paddingRight = pagination.doubleColumn_gap;
			document.body.style.paddingRight = pagination.doubleColumn_gap*2+pagination.columnWidth;
			document.body.style.paddingLeft = pagination.doubleColumn_gap;
			pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
		}
	},

	checkDoubleColumnPosition: function(columnPosition){

		var readerInfo = this.data.readerInfo;

		if(readerInfo.page_start_position == 0){
			if(columnPosition > 0 && columnPosition % 2 != 0){
				columnPosition -= 1;
			}
		}else if(readerInfo.page_start_position == 1){
			if(columnPosition > 0 && columnPosition % 2 == 0){
				columnPosition -= 1;
			}
		}

		return columnPosition;
	},

	singleColumn_halfWebView: function(){

		moo.initialize();
		var pagination = this.data.pagination;
		var readerInfo = moo.data.readerInfo;

		pagination.columnWidth = (pagination.deviceWidth-pagination.singleColumn_gap*2);
		pagination.columnRatio = pagination.columnWidth/pagination.deviceHeight;

		if(readerInfo.function_mode == pagination.READING_MODE){

					pagination.columnWidth = (pagination.deviceWidth-pagination.singleColumn_gap-pagination.doubleColumn_gap);
					//<1310document.body.setAttribute('style','overflow-y: -webkit-paged-x;overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:'+pagination.doubleColumn_gap+'px;');
					//document.body.setAttribute('style','overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:'+pagination.doubleColumn_gap+'px;');
				
					moo.scaleImage();
					pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;

					if(pagination.deviceWidth != pagination.scrollWidth){
						document.body.style.overflow = 'auto';
						document.body.style.width = pagination.scrollWidth;
						document.body.style.paddingRight = pagination.doubleColumn_gap;
						document.body.style.paddingLeft = pagination.doubleColumn_gap;
						document.body.style.left = -pagination.doubleColumn_gap/2;
						pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
					}else{
						document.body.style.overflow = 'auto';
						document.body.style.width = pagination.columnWidth;
						document.body.style.paddingRight = pagination.doubleColumn_gap;
						document.body.style.paddingLeft = pagination.doubleColumn_gap;
						document.body.style.left = -pagination.doubleColumn_gap/2;
						pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
					}
					
				}else{
					pagination.columnWidth = (pagination.deviceWidth-pagination.singleColumn_gap-pagination.doubleColumn_gap);
					//<1310 document.body.setAttribute('style','overflow-y: -webkit-paged-x;overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:' +pagination.doubleColumn_gap+'px;');
					//document.body.setAttribute('style','overflow-x: hidden;-webkit-column-width:'+pagination.columnWidth+'px;width:'+pagination.columnWidth+'px;height:'+(pagination.deviceHeight-80)+'px;-webkit-column-gap:' +pagination.doubleColumn_gap+'px;');
					
					moo.scaleImage();
					pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
					
					if(pagination.deviceWidth != pagination.scrollWidth){
						document.body.style.overflow = 'auto';
						document.body.style.width = pagination.scrollWidth;
						document.body.style.paddingRight = pagination.doubleColumn_gap;
						document.body.style.paddingLeft = pagination.doubleColumn_gap;
						pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
					}else{
						document.body.style.overflow = 'auto';
						document.body.style.width = pagination.columnWidth;
						document.body.style.paddingRight = pagination.doubleColumn_gap;
						document.body.style.paddingLeft = pagination.doubleColumn_gap;
						pagination.scrollWidth = document.documentElement.scrollWidth || document.body.scrollWidth;
					}	
					//Time Out
					moo.getPaginationInfo();
				}
	},

	getPaginationInfo: function(){

		var pagination = this.data.pagination;
		var readerInfo = this.data.readerInfo;
		var column;
	
		switch(readerInfo.reader_layout){		
			case pagination.SINGLE_COLUMN:
				pagination.singleColumn_page = (pagination.scrollWidth)/(pagination.deviceWidth-pagination.singleColumn_gap);
				break;
			case pagination.DOUBLE_COLUMN:
				break;
			case pagination.SCROLL_VIEW:
				break;
			case pagination.SINGLE_COLUMN_HALF:
				pagination.singleColumn_page = (pagination.scrollWidth-pagination.doubleColumn_gap)/(pagination.deviceWidth-pagination.singleColumn_gap);
				break;
			default:
				break;
		}	    
		
		//雙欄欄數
		pagination.doubleColumn_page = ((pagination.scrollWidth)/(pagination.deviceWidth-pagination.doubleColumn_gap))*2;
	
		switch(readerInfo.function_mode){

				case pagination.CALCULATING_MODE :
					// Pagination
					var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
					var highlightPositionJson = mooCFI.GetAllHighlightsPosition(readerInfo.reader_layout,readerInfo.highlights);
					Android.spineInfo(pagination.singleColumn_page,bookmarkPositionJson,highlightPositionJson);
					break;
				case pagination.CALCULATING_MODE_TEMP :
					// Temp Pagination
					var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
					var highlightPositionJson = mooCFI.GetAllHighlightsPosition(readerInfo.reader_layout,readerInfo.highlights);
					var CFIPosition = mooCFI.GetCFIPosition(readerInfo.reader_layout,readerInfo.jump_cfi);
					var IdPoition   = mooCFI.GetIdPosition(readerInfo.reader_layout,readerInfo.jump_id);
					Android.tempSpineInfo(pagination.singleColumn_page,bookmarkPositionJson,highlightPositionJson,CFIPosition,IdPoition);
					break;
				case pagination.CALCULATING_MODE_TEMP_INSERT :
					// Insert Temp Pagination
					var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
					var highlightPositionJson = mooCFI.GetAllHighlightsPosition(readerInfo.reader_layout,readerInfo.highlights);
					Android.insertTempSpineInfo(pagination.singleColumn_page,bookmarkPositionJson,highlightPositionJson);
					break;
				case pagination.CALCULATING_MODE_TEMP_APPEND :
					// Append Temp Pagination
					var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
					var highlightPositionJson = mooCFI.GetAllHighlightsPosition(readerInfo.reader_layout,readerInfo.highlights);
					Android.appendTempSpineInfo(pagination.singleColumn_page,bookmarkPositionJson,highlightPositionJson);
					break;
				case pagination.CALCULATING_MODE_PAGINATION_DONE :
					// Pagination Done Get CFI
					var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
					var highlightPositionJson = mooCFI.GetAllHighlightsPosition(readerInfo.reader_layout,readerInfo.highlights);
					var CFIPosition = mooCFI.GetCFIPosition(readerInfo.reader_layout,readerInfo.jump_cfi);
					Android.getCFIInfo(bookmarkPositionJson,highlightPositionJson,CFIPosition);	
					break;
				case pagination.CALCULATING_MODE_GET_ID_POSITION :
					var IdPoition = mooCFI.GetIdPosition(readerInfo.reader_layout,readerInfo.jump_id);
					Android.getIdInfo(IdPoition);
					break;
				default:
					break;
				}

		if(readerInfo.function_mode >= 605 && readerInfo.function_mode <= 609){
			//-TEMP MODE
			var bookmarkPositionJson = mooCFI.GetAllBookmarksPosition(readerInfo.reader_layout,readerInfo.bookmarks);
			var highlightPositionJson = mooCFI.GetAllHighlightsPosition(readerInfo.reader_layout,readerInfo.highlights);
			Android.currentSpineInfoForTemp(pagination.singleColumn_page,bookmarkPositionJson,highlightPositionJson);
		}
	},

	jumpToOffset: function(){
		
		var pagination = moo.data.pagination;
		var readerInfo = moo.data.readerInfo;
		
		switch(readerInfo.reader_layout){

			case pagination.SINGLE_COLUMN:
				//單欄頁數
				pagination.position = -(readerInfo.offset*(pagination.deviceWidth-pagination.singleColumn_gap));
				if(pagination.position != 0){				
				}
				// Android.jumpTo(-pagination.position);
				Android.jumpToOffset(readerInfo.offset);
				console.log("maina offset column:"+readerInfo.offset+"/position:"+(-pagination.position)+"/Device:"+pagination.deviceWidth+"/gap:"+pagination.singleColumn_gap);
				break;
			case pagination.DOUBLE_COLUMN:
				//雙欄欄數
				pagination.position = -(readerInfo.offset*(pagination.deviceWidth-pagination.doubleColumn_gap))/2;
				if(pagination.position != 0){
				}
				// Android.jumpTo(-pagination.position);
				Android.jumpToOffset(readerInfo.offset);
				console.log("maina offset column:"+readerInfo.offset+"/position:"+(-pagination.position)+"/Device:"+pagination.deviceWidth+"/gap:"+pagination.singleColumn_gap);
				break;
			case pagination.SCROLL_VIEW:
				// jump to scroll position
				break;
			default:
				break;
		}
		
	},

	getScrollCFI: function(){
		mooCFI.GetBookmarkCFI();
		mooCFI.GetScrollNextBookmarkCFI();	
	},

	countColumn: function(layout,position){

       var pagination = this.data.pagination;
       
       if(position != -1){
	       switch(layout){
	           case 0:
	           	   var pageWidth = (pagination.deviceWidth-pagination.singleColumn_gap);
	               var column = Math.ceil(position/pageWidth);
	           	   break;
	           case 1:
	               var pageWidth = (pagination.deviceWidth-pagination.doubleColumn_gap)/2;	             
	               var column = Math.ceil(position/pageWidth);
	               break;
	           case 3:
	               var pageWidth = (pagination.deviceWidth-pagination.singleColumn_gap);
	               var column = Math.ceil(position/pageWidth);
	               break;
	           case 2:
	               break;
	           default:
	               break;
	       }
   		}else{
   			var column = -1;
   		}
       return column;
   },

	setScrollHeight: function(){
       var pagination = this.data.pagination;
       pagination.scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
       // console.log(pagination.scrollHeight,pagination.deviceHeight)
       this.countScrollPage();
   },

   countScrollPage: function(){
       var pagination = this.data.pagination;
       pagination.scroll_page = Math.ceil(pagination.scrollHeight/pagination.deviceHeight)
   },

	init: function(){
	}
}