var mooCFI = {
	readerCFI: {
		node:null, 
		type:0, 
		offset:0, 
		index:0, 
		parentcfi:"", 
		cfi:"", 
		text:"", 
		huid:"", 
		classname:"", 
		typeid:"", 
		pageoffset:0,
		$FoundNode:""
	},
	bookCFI: {
		node:null, 
		type:0, 
		offset:0, 
		index:0, 
		parentcfi:"", 
		cfi:"", 
		text:"", 
		huid:"", 
		classname:"", 
		typeid:"", 
		pageoffset:0,
		$FoundNode:""
	},
	$Unknown: '{UNKNOWN}',
	$Bookbody: '',
	$Readerbody: '',
	$TextOffset: '',
	$DataFound: '',
	supportFn:{
		_CreateCFINodeInfo: function(){
			return {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0} ;
		},
		_RemoveAllReadmooTags: function(BodyNode) {
			var supportFn = mooCFI.supportFn;

			var NodeList = $(BodyNode).find("span").filter(function(){			
				return $(this).data("huid") != undefined ; 
			})
			supportFn._RemoveReadmooNodeList(NodeList) ;
		},
		_ResetDOMTreeNodesCFI: function(ParentNode, ParentCFI) {
			var supportFn = mooCFI.supportFn;

			var BaseIndex = 0 ;
			var CFIIndex = 0 ;
			$.each(ParentNode.childNodes, function(index){
				if (this.nodeType == 1) {
					CFIIndex = (BaseIndex+1)*2 ;
					BaseIndex++ ;
					this.dataset.cfi = ParentCFI + "/" + CFIIndex ;
					supportFn._ResetDOMTreeNodesCFI(this, this.dataset.cfi) ;
				}
			})
		},
		_RemoveReadmooNodeList: function(NodeList) {
			$.each(NodeList, function(index){
				NodeParent=this.parentNode ;
				if ($(this).text().length==0) {
					$(this).remove();
				} else {
					$(this.childNodes[0]).unwrap();
				}
				NodeParent.normalize();							
			})		
		},
		_ParseBookNodeCFI: function(NodeCFI){//將原始的BookCFI解析
			var readerCFI = mooCFI.readerCFI;
			var bookCFI = mooCFI.bookCFI;
			var supportFn = mooCFI.supportFn;
			// var Result = _CreateCFINodeInfo() ;
			var CutPos = NodeCFI.indexOf(":");
			if (CutPos < 0 ) {//找不到該字串時會回傳-1
				mooCFI.$DataFound = false ;
				bookCFI.$FoundNode = null ;
				supportFn._GetElementNodeByCFIInReaderbody(document.body, NodeCFI) ;
				readerCFI.node = mooCFI.readerCFI.$FoundNode ;
				readerCFI.parentcfi = supportFn._GetPathByDeleteLastOne(NodeCFI) ;
				readerCFI.cfi = NodeCFI ;
				readerCFI.type = 1 ;
				readerCFI.cfi = NodeCFI ;				
				return readerCFI ;
			} else {
				bookCFI.offset = parseInt(NodeCFI.substring(CutPos+1, NodeCFI.length), 10) ;//取得最後文字的offset
				var CFIPath = NodeCFI.substring(0, CutPos);//扣除文字nodeOffset
				bookCFI.index = parseInt(supportFn._GetLastPath(CFIPath), 10) ;//取得最後/後方的TextNode位置
				bookCFI.parentcfi = supportFn._GetPathByDeleteLastOne(CFIPath) ;//清除最後的cfi(childCfi)得到parentCfi
				bookCFI.type = 3 ;
			}
			bookCFI.cfi = NodeCFI ;
			return bookCFI ;
		},
		_GetLastPath: function(PathString) {
			var PathList = PathString.split("/");
			return PathList[PathList.length-1] ;
		},
		_GetPathByDeleteLastOne: function(PathString){
			var CutPos = PathString.length - 1 ;
			var Result = "" ;
			for(var Index=CutPos; Index>=0; Index--){
				if (PathString.substr(Index,1)== "/") {
					Result = PathString.substring(0, Index); 
					break ;
				}
			}
			return Result ;
		},
		_GetTextNodeCFIIndex: function(TextNode){
			var BaseIndex = 0 ;
			var CFIIndex = 0 ;
			var Result = 0 ;
			/*$.each(TextNode.parentNode.childNodes, function(index){			
				if (this.nodeType == 3) {
					CFIIndex = (BaseIndex*2)+1 ;
					BaseIndex++ ;
					if (this.isSameNode(TextNode)) {
						Result = CFIIndex ;						
						return false ;
					}
				}
			})*/
			
			for(var i = 0; i<=TextNode.parentNode.childNodes.length-1;i++){
				var that = TextNode.parentNode.childNodes[i];
				if (that.nodeType == 3) {
					CFIIndex = (BaseIndex*2)+1 ;
					BaseIndex++ ;
					if (that.isSameNode(TextNode)) {
						Result = CFIIndex ;
						return Result ;
					}
				}
			}
			return Result ;
		},
		_GetElementNodeByCFI: function(ParentNode, ElementCFI){
			var supportFn = mooCFI.supportFn;
			var bookCFI = mooCFI.bookCFI;

			if (ElementCFI == "/4") {
				bookCFI.$FoundNode = ParentNode ;
				return ;
			}
			/*$.each(ParentNode.childNodes, function(index){
				if (this.nodeType == 1) {
					if (this.dataset.cfi == ElementCFI) {						
						bookCFI.$FoundNode = this ;//將FoundNode指向為該cfi元素
						return false ;
					}
					supportFn._GetElementNodeByCFI(this, ElementCFI) ;
				}
			});*/
			for(var i = 0 ; i<=ParentNode.childNodes.length-1 ; i++){
				var that = ParentNode.childNodes[i];
				if (that.nodeType == 1) {
					if (that.dataset.cfi == ElementCFI) {						
						bookCFI.$FoundNode = that ;//將FoundNode指向為該cfi元素
						break;
					}
					supportFn._GetElementNodeByCFI(that, ElementCFI) ;
				}
			}
		},
		_GetElementNodeByCFIInReaderbody: function(ParentNode, ElementCFI){
			var supportFn = mooCFI.supportFn;
			var readerCFI = mooCFI.readerCFI;

			if (ElementCFI == "/4") {
				mooCFI.readerCFI.$FoundNode = ParentNode ;
				return ;
			}
			/*$.each(ParentNode.childNodes, function(index){
				if (this.nodeType == 1) {
					if (this.dataset.cfi == ElementCFI) {						
						mooCFI.readerCFI.$FoundNode = this ;//將FoundNode指向為該cfi元素
						return false ;
					}
					supportFn._GetElementNodeByCFIInReaderbody(this, ElementCFI) ;
				}
			});*/
			for(var i = 0 ; i <= ParentNode.childNodes.length-1 ; i++){
				var that = ParentNode.childNodes[i];
				if (that.nodeType == 1) {
					if (that.dataset.cfi == ElementCFI) {						
						mooCFI.readerCFI.$FoundNode = that ;//將FoundNode指向為該cfi元素
						break;
					}
					supportFn._GetElementNodeByCFIInReaderbody(that, ElementCFI) ;
				}
			}
		},
		_GetTextNodeFromParentNode: function(ParentNode, NodeIndex){//取得該段落的文字內容
			var BaseIndex = 0 ;
			var CFIIndex = 0 ;
			var Result = null ;
			/*$.each(ParentNode.childNodes, function(index){
				if (this.nodeType == 3) {
					CFIIndex = BaseIndex*2 + 1 ;
					if (CFIIndex == NodeIndex ) {
						Result = this ;
						return false ;
					}
					BaseIndex++ ;				
				}
			})*/
			for(var i = 0;i<=ParentNode.childNodes.length-1;i++){
				var that = ParentNode.childNodes[i];
				if (that.nodeType == 3) {
					CFIIndex = BaseIndex*2 + 1 ;
					if (CFIIndex == NodeIndex ) {
						Result = that ;
						break;
					}
					BaseIndex++ ;				
				}
			}
			return Result ;
		},
		_GetNodeTextOffsetAtDocumentBody: function(ParentNode, TextNode){//取得再原始的整個body內為第幾個字
			var supportFn = mooCFI.supportFn;
			
			/*$.each(ParentNode.childNodes, function(index){
				if (this.nodeType == 3) {					
					if (this.isSameNode(TextNode)) {
						mooCFI.$TextOffset = mooCFI.$TextOffset;
						mooCFI.$DataFound = true ;
						return false;
					}
					if (this.nodeValue == TextNode.nodeValue) {						
					}

					mooCFI.$TextOffset = mooCFI.$TextOffset + this.nodeValue.length ;
				}
				if (this.nodeType == 1) {
					supportFn._GetNodeTextOffsetAtDocumentBody(this, TextNode) ;
					if (mooCFI.$DataFound) {
						return false;
					}
				}
			});*/
			
			for(var i = 0; i<=ParentNode.childNodes.length-1 ; i++){
				var that = ParentNode.childNodes[i];
				if (that.nodeType == 3) {					
					if (that.isSameNode(TextNode)) {
						mooCFI.$TextOffset = mooCFI.$TextOffset;
						mooCFI.$DataFound = true ;
						break;
					}
					if (that.nodeValue == TextNode.nodeValue) {						
					}

					mooCFI.$TextOffset = mooCFI.$TextOffset + that.nodeValue.length ;
				}
				if (that.nodeType == 1) {
					supportFn._GetNodeTextOffsetAtDocumentBody(that, TextNode) ;
					if (mooCFI.$DataFound) {
						break;
					}
				}
			}			
		},
		_GetCFIInfoAtTextOffset: function(ParentNode){//比對用cfi，將文字對應回最初的dom位置
			var supportFn = mooCFI.supportFn;
			var bookCFI = mooCFI.bookCFI;

			// 以遞迴方式，取得在起始 ParentNode 下，位在第 $TextOffset 個字的位置
			// 是哪一個 TextNode，並取得其實際的 CFI
			var TextNodeLength = 0 ;
			var BaseIndex = 0 ;
			var CFIIndex = 0 ;
			var Result = "" ;
			/*$.each(ParentNode.childNodes, function(index){
				if (this.nodeType == 3) {
					CFIIndex = BaseIndex * 2 + 1 ;
					if(this.nodeValue.length){
						TextNodeLength = this.nodeValue.length ;
					}else{
						TextNodeLength = 0;
					}
					if (TextNodeLength < mooCFI.$TextOffset) { 
						mooCFI.$TextOffset = mooCFI.$TextOffset - TextNodeLength ;
					} else {
						mooCFI.$DataFound = true ;

						bookCFI.node = this ;
						bookCFI.type = 3 ;
						bookCFI.index = CFIIndex ;
						bookCFI.offset = mooCFI.$TextOffset ;
						bookCFI.text = this.nodeValue ;
						bookCFI.parentcfi = this.parentNode.dataset.cfi ;
						bookCFI.cfi = this.parentNode.dataset.cfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						Result = bookCFI.parentcfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;						
						return false ;
					}
					BaseIndex++ ;
				}
				if (this.nodeType == 1) {
					supportFn._GetBookCFIInfoAtTextOffset(this) ;
					if (mooCFI.$DataFound) {

						return false ;
					}
				}
			})*/
			for(var i = 0; i<=ParentNode.childNodes.length-1; i++){
				var that = ParentNode.childNodes[i];
				if (that.nodeType == 3) {
					CFIIndex = BaseIndex * 2 + 1 ;
					if(that.nodeValue.length){
						TextNodeLength = that.nodeValue.length ;
					}else{
						TextNodeLength = 0;
					}
					if (TextNodeLength < mooCFI.$TextOffset) { 
						mooCFI.$TextOffset = mooCFI.$TextOffset - TextNodeLength ;
					} else {
						mooCFI.$DataFound = true ;

						bookCFI.node = that ;
						bookCFI.type = 3 ;
						bookCFI.index = CFIIndex ;
						bookCFI.offset = mooCFI.$TextOffset ;
						bookCFI.text = that.nodeValue ;
						bookCFI.parentcfi = that.parentNode.dataset.cfi ;
						bookCFI.cfi = that.parentNode.dataset.cfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						Result = bookCFI.parentcfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;						
						//return false ;
						break;
					}
					BaseIndex++ ;
				}
				if (that.nodeType == 1) {
					supportFn._GetBookCFIInfoAtTextOffset(that) ;
					if (mooCFI.$DataFound) {

						//return false ;
						break;
					}
				}
			}
			return Result ;
		},
		_GetBookCFIInfoAtTextOffset: function(ReaderParent){
			var supportFn = mooCFI.supportFn;
			var bookCFI = mooCFI.bookCFI;
			// 以遞迴方式，取得在起始 ParentNode 下，位在第 $TextOffset 個字的位置
			// 是哪一個 TextNode，並取得其實際的 CFI
			var TextNodeLength = 0 ;
			var BaseIndex = 0 ;
			var CFIIndex = 0 ;
			var Result = "" ;
			/*$.each(ReaderParent.childNodes, function(index){
				if (this.nodeType == 3) {
					CFIIndex = BaseIndex * 2 + 1 ;
					if(this.nodeValue.length){
						TextNodeLength = this.nodeValue.length ;
					}else{
						TextNodeLength = 0;
					}
					if (TextNodeLength < mooCFI.$TextOffset) { 
						mooCFI.$TextOffset = mooCFI.$TextOffset - TextNodeLength ;
					} else {
						mooCFI.$DataFound = true ;
						bookCFI.node = this ;
						bookCFI.type = 3 ;
						bookCFI.index = CFIIndex ;
						bookCFI.offset = mooCFI.$TextOffset ;
						bookCFI.text = this.nodeValue ;
						bookCFI.parentcfi = this.parentNode.dataset.cfi ;
						bookCFI.cfi = this.parentNode.dataset.cfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						Result = bookCFI.parentcfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						return false ;
					}
					BaseIndex++ ;
				}
				if (this.nodeType == 1) {
					supportFn._GetBookCFIInfoAtTextOffset(this) ;
					if (mooCFI.$DataFound) {
						return false ;
					}
				}
			})*/
			for(var i = 0; i<=ReaderParent.childNodes.length-1; i++){
				var that = ReaderParent.childNodes[i];
				if (that.nodeType == 3) {
					CFIIndex = BaseIndex * 2 + 1 ;
					if(that.nodeValue.length){
						TextNodeLength = that.nodeValue.length ;
					}else{
						TextNodeLength = 0;
					}
					if (TextNodeLength < mooCFI.$TextOffset) { 
						mooCFI.$TextOffset = mooCFI.$TextOffset - TextNodeLength ;
					} else {
						mooCFI.$DataFound = true ;
						bookCFI.node = that ;
						bookCFI.type = 3 ;
						bookCFI.index = CFIIndex ;
						bookCFI.offset = mooCFI.$TextOffset ;
						bookCFI.text = that.nodeValue ;
						bookCFI.parentcfi = that.parentNode.dataset.cfi ;
						bookCFI.cfi = that.parentNode.dataset.cfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						Result = bookCFI.parentcfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						//return false ;
						break;
					}
					BaseIndex++ ;
				}
				if (that.nodeType == 1) {
					supportFn._GetBookCFIInfoAtTextOffset(that) ;
					if (mooCFI.$DataFound) {
						//return false ;
						break;
					}
				}
			}
			return Result ;
		},
		_GetReaderCFIInfoAtTextOffset: function(ReaderParent){
			var supportFn = mooCFI.supportFn;
			var readerCFI = mooCFI.readerCFI;
			// 以遞迴方式，取得在起始 ParentNode 下，位在第 $TextOffset 個字的位置
			// 是哪一個 TextNode，並取得其實際的 CFI
			var TextNodeLength = 0 ;
			var BaseIndex = 0 ;
			var CFIIndex = 0 ;
			var Result = "" ;
			/*$.each(ReaderParent.childNodes, function(index){
				if (this.nodeType == 3) {
					CFIIndex = BaseIndex * 2 + 1 ;
					if(this.nodeValue.length){
						TextNodeLength = this.nodeValue.length ;
					}else{
						TextNodeLength = 0;
					}
					if (TextNodeLength < mooCFI.$TextOffset) { 
						mooCFI.$TextOffset = mooCFI.$TextOffset - TextNodeLength ;
					} else {
						mooCFI.$DataFound = true ;
						readerCFI.node = this ;
						readerCFI.type = 3 ;
						readerCFI.index = CFIIndex ;
						readerCFI.offset = mooCFI.$TextOffset ;
						readerCFI.text = this.nodeValue ;
						readerCFI.parentcfi = this.parentNode.dataset.cfi ;
						readerCFI.cfi = this.parentNode.dataset.cfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						//Result = readerCFI.parentcfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						return false ;
					}
					BaseIndex++ ;
				}
				if (this.nodeType == 1) {
					supportFn._GetReaderCFIInfoAtTextOffset(this) ;
					if (mooCFI.$DataFound) {
						return false ;
					}
				}
			})*/
			if(ReaderParent==null){
				return false;
			}
			for(var i = 0; i<=ReaderParent.childNodes.length-1; i++){
				var that = ReaderParent.childNodes[i];
				if (that.nodeType == 3) {
					CFIIndex = BaseIndex * 2 + 1 ;
					if(that.nodeValue.length){
						TextNodeLength = that.nodeValue.length ;
					}else{
						TextNodeLength = 0;
					}
					if (TextNodeLength < mooCFI.$TextOffset) { 
						mooCFI.$TextOffset = mooCFI.$TextOffset - TextNodeLength ;
					} else {
						mooCFI.$DataFound = true ;
						readerCFI.node = that ;
						readerCFI.type = 3 ;
						readerCFI.index = CFIIndex ;
						readerCFI.offset = mooCFI.$TextOffset ;
						readerCFI.text = that.nodeValue ;
						readerCFI.parentcfi = that.parentNode.dataset.cfi ;
						readerCFI.cfi = that.parentNode.dataset.cfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						//Result = readerCFI.parentcfi + "/" + CFIIndex + ":" + mooCFI.$TextOffset ;
						//return false ;
						break;
					}
					BaseIndex++ ;
				}
				if (that.nodeType == 1) {
					supportFn._GetReaderCFIInfoAtTextOffset(that) ;
					if (mooCFI.$DataFound) {
						//return false ;
						break;
					}
				}
			}
			return readerCFI ;
		},
		_GetBookmarkNodeInfo: function(PointX, PointY){
			// console.log("cfi:::"+PointX+","+ PointY);
			try{
				var supportFn = mooCFI.supportFn;
				var readerCFI = mooCFI.readerCFI;

				var PointedRange = document.caretRangeFromPoint(PointX, PointY) ;
				// 關於 document.caretRangeFromPoint() 回傳的值：
				// 當點擊在 <img> 時，會根據 <img> 是否「完全可見?」以及其是否有 Sibling Node 等狀況而會有不同的判斷與回傳值。
				// console.log('CFI:::' + PointedRange.startContainer.nodeName);
				if (PointedRange == undefined) {
					return mooCFI.$Unknown ;//中止並回傳{Unknow}
				}
				if (PointedRange.startContainer.nodeType != 3) {//PointedRange.startContainer可以取得該物件為何					
					if(PointedRange.startContainer.nodeName.toLowerCase()=='body'){
						readerCFI.cfi = document.body.childNodes[PointedRange.startOffset].dataset.cfi;
						readerCFI.$FoundNode = document.body.childNodes[PointedRange.startOffset];
						console.log(readerCFI.cfi);
					}else{
						if(PointedRange.startContainer.firstChild.nodeType == 3){
							readerCFI.cfi = PointedRange.startContainer.dataset.cfi; 
							readerCFI.$FoundNode = PointedRange.startContainer;
						}else{
							readerCFI.cfi = PointedRange.startContainer.firstChild.dataset.cfi;
							readerCFI.$FoundNode = PointedRange.startContainer.firstChild; 
						}
						
						console.log(readerCFI.cfi);
					}					
					return readerCFI ;//中止並回傳{Unknow}
				}
				readerCFI.node = PointedRange.startContainer ;//取得為字段落
				readerCFI.offset = PointedRange.startOffset ;//取得段落起始點
				readerCFI.type = PointedRange.startContainer.nodeType;//取得元素type
				readerCFI.index = supportFn._GetTextNodeCFIIndex(readerCFI.node);//當type == 3才會執行
				readerCFI.cfi = readerCFI.node.parentNode.dataset.cfi + "/" + readerCFI.index + ":" + readerCFI.offset ;				
				PointedRange.detach();
				return readerCFI ;
			}catch(e){
				return mooCFI.$Unknown ;
			}
		},
		_GetBookmarkCFI: function(){
			var supportFn = mooCFI.supportFn;
			var pagination = moo.data.pagination;
			var readerInfo = moo.data.readerInfo;

			var point;

			if(readerInfo.reader_layout == pagination.SINGLE_COLUMN || readerInfo.reader_layout == pagination.SCROLL_VIEW){
				point = 30;
			}else if(readerInfo.reader_layout == pagination.DOUBLE_COLUMN){
				point = 90;
			}

		    document.body.style.webkitUserSelect='auto';
		    
			var PointedInfo = supportFn._GetBookmarkNodeInfo(point, 0);
		    document.body.style.webkitUserSelect='none';
			if (PointedInfo === mooCFI.$Unknown) {
			    document.body.style.webkitUserSelect='auto';
				PointedInfo = supportFn._GetBookmarkNodeInfo(point, 30);
			    document.body.style.webkitUserSelect='none';
				if (PointedInfo === mooCFI.$Unknown) {				
					return mooCFI.$Unknown ;
				} else {
					return supportFn._ConvertReaderCFIToBookCFIInfoBookmark();//readerCFI.cfi				
				}
			} else {
				return supportFn._ConvertReaderCFIToBookCFIInfoBookmark();//readerCFI.cfi
			}
		},
		_GetNextBookmarkCFI: function(){
			
			var supportFn = mooCFI.supportFn;
			var pagination = moo.data.pagination;
			var readerInfo = moo.data.readerInfo;

			var point;

			if(readerInfo.reader_layout == pagination.SINGLE_COLUMN || readerInfo.reader_layout == pagination.SCROLL_VIEW){
				point = 30;
			}else if(readerInfo.reader_layout == pagination.DOUBLE_COLUMN){
				point = 90;
			}

		    document.body.style.webkitUserSelect='auto';
	
			var PointedInfo = supportFn._GetBookmarkNodeInfo((pagination.deviceWidth-point), pagination.deviceHeight - 80);	

		    document.body.style.webkitUserSelect='none';
			if (PointedInfo === mooCFI.$Unknown) {
			    document.body.style.webkitUserSelect='auto';
				PointedInfo = supportFn._GetBookmarkNodeInfo((pagination.deviceWidth-point), pagination.deviceHeight - 110);								
			    document.body.style.webkitUserSelect='none';
				if (PointedInfo === mooCFI.$Unknown) {				
					return mooCFI.$Unknown ;
				} else {
					return supportFn._ConvertReaderCFIToBookCFIInfoBookmark();//readerCFI.cfi				
				}
			} else {
				return supportFn._ConvertReaderCFIToBookCFIInfoBookmark();//readerCFI.cfi
			}
		},

		_GetScreenCFI: function(x,y){
			var supportFn = mooCFI.supportFn;
			var pagination = moo.data.pagination;

		    document.body.style.webkitUserSelect='auto';
			// var PointedInfo = supportFn._GetBookmarkNodeInfo(30, 0);
			// var PointedInfo = supportFn._GetBookmarkNodeInfo((window.scrollX+pagination.deviceWidth-30), pagination.deviceHeight);	
			var PointedInfo = supportFn._GetBookmarkNodeInfo(x,y);	

		    document.body.style.webkitUserSelect='none';
			if (PointedInfo === mooCFI.$Unknown) {
			    document.body.style.webkitUserSelect='auto';
				// PointedInfo = supportFn._GetBookmarkNodeInfo(30, 30);
				// PointedInfo = supportFn._GetBookmarkNodeInfo((window.scrollX+pagination.deviceWidth-30), pagination.deviceHeight - 30);
				PointedInfo = supportFn._GetBookmarkNodeInfo(x, y - 30);								
			    document.body.style.webkitUserSelect='none';
				if (PointedInfo === mooCFI.$Unknown) {				
					return mooCFI.$Unknown ;
				} else {
					return supportFn._ConvertReaderCFIToBookCFIInfoBookmark();//readerCFI.cfi				
				}
			} else {
				return supportFn._ConvertReaderCFIToBookCFIInfoBookmark();//readerCFI.cfi
			}
		},

		_ConvertReaderCFIToBookCFIInfoBookmark: function(){
			try{
				var supportFn = mooCFI.supportFn;
				var bookCFI = mooCFI.bookCFI;
				var readerCFI = mooCFI.readerCFI;

				// Reader CFI：Parent 在 Book Body 裡不一定存在
				// var ReaderCFI = ReaderCFI;
				var ReaderCFI_cfi = readerCFI.cfi;
				var CutPos = ReaderCFI_cfi.indexOf(":");
				if (CutPos < 0 ) {//找不到該字串時會回傳-1
					// _GetElementNodeByCFI(document.body, Reader_CFI) ;
					bookCFI.node = readerCFI.$FoundNode ;
					// mooCFI.$originCFI.parentcfi = supportFn._GetPathByDeleteLastOne(NodeCFI) ;
					bookCFI.cfi = ReaderCFI_cfi ;
					bookCFI.type = 1 ;					
					return bookCFI;
				} else {
					var CFIPath = ReaderCFI_cfi.substring(0, CutPos);//扣除文字nodeOffset
					bookCFI.offset = readerCFI.offset;//取得最後文字的offset X
					// bookCFI.index = readerCFI.index;//取得最後/後方的TextNode位置 X
					bookCFI.parentcfi = supportFn._GetPathByDeleteLastOne(CFIPath) ;//清除最後的cfi(childCfi)得到parentCfi
					bookCFI.type = 3 ;
					// bookCFI.cfi = ReaderCFI_cfi; //X					
					supportFn._GetElementNodeByCFI(document.body, bookCFI.parentcfi) ;//取得該頁第一個元素並存成$FoundNode					
				}				
				// $DataFound = false ;
				// $FoundNode = null ;
				// 遞迴
				if (bookCFI.$FoundNode === null) {
					return bookCFI.$Unknown ;
				}
				var ReaderParent = bookCFI.$FoundNode ;				
				var ReaderTextNode = supportFn._GetTextNodeFromParentNode(ReaderParent, readerCFI.index) ;//取得該元素內的textNode				
				mooCFI.$TextOffset = 0 ;
				mooCFI.$DataFound = false ;
				supportFn._GetNodeTextOffsetAtDocumentBody(document.body, ReaderTextNode) ;//取得在整個body內為第幾個字				

				mooCFI.$TextOffset = mooCFI.$TextOffset + bookCFI.offset + 1 ;//到前一個element為止的offset再加上自己再整個段落內的offset，在偏移到下個文字				
				mooCFI.$DataFound = false ;
				// $BookBody = _GetBookBody() ;//複製一個新的乾淨的dom
				supportFn._GetCFIInfoAtTextOffset(mooCFI.$Bookbody) ;
				return bookCFI ;
			}catch(e){
				// $DebugValue = $DebugValue + e.message + ";" + ReaderCFI + ";" ;
				return mooCFI.$Unknown ;
			}
		},	
		 _GetReaderNodeRectByCFI: function(BookCFI){
		 	var supportFn = mooCFI.supportFn;
			var AnchorObject = supportFn._ConvertBookCFIToReaderCFIInfo(BookCFI, false);
			var AnchorRect = null ;
			if (!AnchorObject) {
				return false;
			};
			if (AnchorObject.type == 1) {
				if(AnchorObject.node){
					AnchorRect = AnchorObject.node.getBoundingClientRect() ;
				}else{
					AnchorRect = {
						left: -1,
						top:-1
					}

					return AnchorRect;
				}
				//$DebugValue = AnchorRect.left + ";" + AnchorRect.top ;				
			} else {
				AnchorRect = supportFn._GetTextNodeRect(AnchorObject) ;				
				//$DebugValue = $DebugValue + ";TEXTNODE" ;
			}
			return AnchorRect ;
		},
		_GetTextNodeRect: function(AnchorObject){
			var SpanElement = document.createElement('span') ;
			var NodeRect = null ;
			var CurrentNode = AnchorObject.node ;
			var Result = 0 ;
			SpanElement.innerHTML = "群" ; // 不要用括弧（「」、[]）等符號，因為會造成避頭點的位移現象
			
			try{
				if (AnchorObject.offset == 0) {
					CurrentNode.parentNode.insertBefore(SpanElement, CurrentNode) ;
					NodeRect = SpanElement.getBoundingClientRect();
					CurrentNode.parentNode.removeChild(SpanElement);
					CurrentNode.parentNode.normalize() ;
					//$DebugValue = "OFFSET=0" + ";" + NodeRect.left + ";" + NodeRect.top ;
					return NodeRect ;
				} 
				
				var BeforeText = "" ;
				var AfterText = "" ;
				var BeforeNode = null ;
				var AfterNode = null ;

				BeforeText = CurrentNode.nodeValue.substr(0,AnchorObject.offset);
				AfterText = CurrentNode.nodeValue.substr(AnchorObject.offset, CurrentNode.nodeValue.length);
				BeforeNode = document.createTextNode(BeforeText) ;
				AfterNode = document.createTextNode(AfterText) ;
				CurrentNode.parentNode.insertBefore(BeforeNode, CurrentNode);
				CurrentNode.parentNode.insertBefore(SpanElement, CurrentNode) ;
				CurrentNode.parentNode.insertBefore(AfterNode, CurrentNode);
				NodeRect = SpanElement.getBoundingClientRect();
				CurrentNode.parentNode.removeChild(AfterNode);
				CurrentNode.parentNode.removeChild(SpanElement);
				CurrentNode.parentNode.removeChild(BeforeNode);
				CurrentNode.parentNode.normalize() ;
			}catch(e){
				return false;
			}
			//$DebugValue = NodeRect.left + ";" + NodeRect.top ;
			return NodeRect ;
		},
		_ConvertBookCFIToReaderCFIInfo: function(BookCFI, CFIOnly){
			var readerCFI = mooCFI.readerCFI;
			// var bookCFI = mooCFI.bookCFI;
			var supportFn = mooCFI.supportFn;
			// Book CFI：Parent cfi 在 Reader Body 裏一定存在，所差的只是 text offset
			// 所以先取得起始 Parent Node，再取得第 offset 個字的所在 子（孫） Text Node
			var Result;
			var BookCFIInfo = supportFn._ParseBookNodeCFI(BookCFI) ;
			//mooCFI.readerCFI = BookCFIInfo;
			if (BookCFIInfo.type != 1) {
				mooCFI.$DataFound = false ;
				readerCFI.$FoundNode = null ;
				// 遞迴				
				supportFn._GetElementNodeByCFIInReaderbody(mooCFI.$Readerbody, BookCFIInfo.parentcfi) ;
				var ReaderParent = readerCFI.$FoundNode ;				
				mooCFI.$TextOffset = BookCFIInfo.offset ;
				mooCFI.$DataFound = false ;
				// $FoundNode = _CreateCFINodeInfo() ;
				// 遞迴
				BookCFIInfo = supportFn._GetReaderCFIInfoAtTextOffset(ReaderParent) ;				
			}
			if (CFIOnly) {
				Result = BookCFIInfo.cfi ;
			} else {				
				Result = BookCFIInfo ;				
			}
			return Result ;
		}
	},

	initialize: function(){
		var supportFn = mooCFI.supportFn;
		this.$Bookbody = document.body.cloneNode(true) ;
		// this.GetBookbody();
	},

	GetBookbody: function(){
		var supportFn = mooCFI.supportFn;
		this.$Bookbody = document.body.cloneNode(true) ;
		supportFn._RemoveAllReadmooTags(this.$Bookbody);
		this.$Bookbody.normalize() ;
		supportFn._ResetDOMTreeNodesCFI(this.$Bookbody, "/4") ;		
	},

	GetBookmarkCFI: function(){
		
		// 取得左上角->西欸幅埃
		var supportFn = mooCFI.supportFn;
		mooCFI.bookCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		mooCFI.readerCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		
		var Result;
		var BookmarkObject = supportFn._GetBookmarkCFI();
		if(BookmarkObject === mooCFI.$Unknown){			
			return mooCFI.$Unknown;
		}
		Result = {
               "cfi": BookmarkObject.cfi,
               "text": BookmarkObject.text,
               "parentcfi": BookmarkObject.node.parentNode.dataset.cfi
           };
        Result = JSON.stringify(Result);
        
        Android.getCurrentCFI(Result);	    
	  	return Result ; 
	},

	GetNextBookmarkCFI: function(){
		
		// 取得右下角->西欸幅埃
		var supportFn = mooCFI.supportFn;
		mooCFI.bookCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		mooCFI.readerCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		
		var Result;
		var BookmarkObject = supportFn._GetNextBookmarkCFI();
		if(BookmarkObject === mooCFI.$Unknown){			
			return mooCFI.$Unknown;
		}
		Result = {
               "cfi": BookmarkObject.cfi,
               "text": BookmarkObject.text,
               "parentcfi": BookmarkObject.node.parentNode.dataset.cfi
           };
        Result = JSON.stringify(Result);
        Android.getNextCFI(Result);	    
	  	return Result ; 
	},

	GetScrollNextBookmarkCFI: function(){
		
		// 取得右下角->西欸幅埃
		var pagination = moo.data.pagination;
		var supportFn = mooCFI.supportFn;
		mooCFI.bookCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		mooCFI.readerCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		
		var Result;
		var BookmarkObject = supportFn._GetScreenCFI(pagination.deviceWidth-30,window.innerHeight);
		if(BookmarkObject === mooCFI.$Unknown){			
			return mooCFI.$Unknown;
		}
		Result = {
               "cfi": BookmarkObject.cfi,
               "text": BookmarkObject.text,
               "parentcfi": BookmarkObject.node.parentNode.dataset.cfi
           };
        Result = JSON.stringify(Result);
        Android.getNextCFI(Result);	    
	  	return Result ; 
	},

	GetOffsetByNodeCFI: function(bookCFI, layout){//取得該點cfi的xy位置
		console.log("bookCFI====="+bookCFI);
		var supportFn = mooCFI.supportFn;
		mooCFI.bookCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		mooCFI.readerCFI = {node:null, type:0, offset:0, index:0, parentcfi:"", cfi:"", text:"", huid:"", classname:"", typeid:"", pageoffset:0,$FoundNode:""}
		mooCFI.$Readerbody = document.body;
		//var Result = $OK ;
		AnchorRect = supportFn._GetReaderNodeRectByCFI(bookCFI) ;
		console.log("AnchorRect.left====="+AnchorRect.left+"/"+layout);
		if(!AnchorRect){
			return -1;
		}
		if (layout != 2) {
			Result = AnchorRect.left ;
		} else {
			Result = AnchorRect.top ;
		}
		return Result ;
	},

	GetAllBookmarksPosition: function(layout,bookmarksArray){
		var Result = {};
        var position = [];
        var column = [];
        var bookmarks = [];
        for(var i = 0; i <= bookmarksArray.length-1; i++){        	
            position[i]  = mooCFI.GetOffsetByNodeCFI(bookmarksArray[i].cfi,layout);
            column[i]    = moo.countColumn(layout,position[i]);
            if(layout != 2){
            	bookmarks[i] = {id: bookmarksArray[i].id, position: column[i]};
            }else{
            	bookmarks[i] = {id: bookmarksArray[i].id, position: position[i]};
            }
        }
        Result.bookmarks = bookmarks;
        Result = JSON.stringify(Result);
        return Result;
	},

	GetAllHighlightsPosition: function(layout,highlightsArray){
		var Result = {};
        var position = [];
        var column = [];
        var highlights = [];
        for(var i = 0; i <= highlightsArray.length-1; i++){        	
            position[i]  = mooCFI.GetOffsetByNodeCFI(highlightsArray[i].cfi,layout);
            column[i]    = moo.countColumn(layout,position[i]);
            highlights[i] = {id: highlightsArray[i].id, position: column[i]}
        }
        Result.highlights = highlights;
        Result = JSON.stringify(Result);
        return Result;
	},

	GetCFIPosition: function(layout,CFIString){
        var position;
        var column;
        var bookmarks;

        if(CFIString == ""){
        	column = -1;
        }else{
        	position  = mooCFI.GetOffsetByNodeCFI(CFIString,layout);
        	if(layout != 2){
        		//單、雙欄
        		column = moo.countColumn(layout,position);
        	}else{
        		//捲動位置
        		return position;
        	}
    	}
        return column;
	},

	GetIdPosition: function(layout,Id){
		var Result;
		var column;
		var Id;
		var position;
		
		if(Id == ""){
			column = -1;
		}else{
			Id = document.getElementById(""+Id+"");
	    	position = Id.getBoundingClientRect();
			if (layout != 2) {
				Result = position.left ;
			} else {
				Result = position.top ;
				return Result;
			}
			column = moo.countColumn(layout,Result);
		}
		return column;
	},
	init: function(){
		this.initialize();
	}
}

