var mediaPlatform = {};

mediaPlatform.getMPHeight = function() {
    var height = document.getElementById('js_article').scrollHeight;
    return height;
};

mediaPlatform.getMPInfo = function() {
    var title;
    if (msg_title) {
        title = msg_title;
    }
    else {
        title = document.getElementsByTagName('h1')[0].innerHTML.toString();
    }
    var thumbUrl;
    if (msg_cdn_url) {
        thumbUrl = msg_cdn_url;
    }
    else {
        thumbUrl = document.getElementsByTagName('img')[0].src.toString();
    }
    var account;
    if (nickname) {
        account = nickname;
    }
    if (!title) {title = "";}
    if (!thumbUrl) {thumbUrl= "";}
    if (!account) {account = "";}

    var info = {
        "title": title,
        "thumbUrl": thumbUrl,
        "account": account,
    }
    return info;
};

mediaPlatform.getMPInfoStr = function() {
    return JSON.stringify(mediaPlatform.getMPInfo());
};

// 这里的做法是为了非独立图片（下方有内容）可以保持跟内容12px的距离
mediaPlatform.handleImageBlank = function() {
    var imgs = document.getElementsByTagName('img');
    for (var i = 0; i < imgs.length; i++) {
        var nextNode = imgs[i].nextSibling;
        var preNode = imgs[i].previousSibling;

        // 只处理上方有空行的情况，下方有空行经常会跟图片的说明文字连用，尝试修改会导致样式错乱
        if (preNode && preNode.nodeName.toLowerCase() == 'br') {
            // 处理图片上面有个br，但是br不能自定义高度，所以直接去掉重新加margin
            if (preNode.style) {
                preNode.style.display = "none";
            }
            imgs[i].style.marginTop = '12px';
        } else if (preNode && preNode.nodeType == 3) {
            // 处理图片跟上面文字在同一个p里面，但是没有br隔开
            imgs[i].style.marginTop = '12px';
        }
    }
};

// 干掉p>br的情况的margin-top
mediaPlatform.updateBlankHeight = function() {
    var blanks = document.getElementsByTagName('br');
    for (var i = blanks.length - 1; i >= 0; i--) {
        var parentNode = blanks[i].parentNode;
        if (parentNode.nodeName.toLowerCase() == "p" && parentNode.childNodes.length == 1) {
            parentNode.style.height = '20px';
            parentNode.style.minHeight = '0em';
        }
    }
};

mediaPlatform.registerImageOnLoadEvent = function() {
    var imgs = document.getElementsByTagName('img');
    for (var i = 0; i < imgs.length; i++) {
        var oldOnLoad = imgs[i].onload
        imgs[i].onload = function(args){
            if(oldOnLoad != null && (typeof oldOnLoad == "function")){
                oldOnLoad.apply(this, args)
            }
            this.style.visibility = "visible"
        }
    }
}

// 观察到部分公众号文章首评的懒加载图片无法正常显示，这是由于 scroll 事件没有触发导致的
//（怀疑是在 rangy-classapplier 引入后产生了混合反应，但在 Android 上确是好的）。
// 这里的解决办法是手动触发一次 scroll 事件，但由于我们的 webview 其实是完整高度的，
// 本身并不能滚动，所以这样做也不会产生抖动或者其他副作用。
// update 2019/5/8， android 现在会内部滚动，不能调用这个
mediaPlatform.protectLazyLoad = function() {
    window.scrollTo(0, 1);
};

mediaPlatform.init = function() {
    mediaPlatform.updateBlankHeight();
    mediaPlatform.handleImageBlank();
    if(/(Android)/i.test(navigator.userAgent)){
        mediaPlatform.registerImageOnLoadEvent()
    }else{
        mediaPlatform.protectLazyLoad();
    }
};

mediaPlatform.init();

// 用于在退出公众号文章的时候暂停视频播放
// 由于腾讯视频是通过 iFrame 内嵌的，没有办法直接操作，我们用刷新 iFrame 的方式实现停止播放的效果
function pauseMedia() {
    pauseCurrentAudio();
    pauseCurrentVideo();
}

function pauseCurrentAudio() {
    var audios = document.querySelectorAll('audio');
    for (var i = 0; i < audios.length; i++) {
        var audio = audios[i];
        audio.pause();
    }
}

function pauseCurrentVideo() {
    var iframes = document.querySelectorAll('iframe');
    for (var i = 0; i < iframes.length; i++) {
        var oldFrame = iframes[i];
        oldFrame.src = oldFrame.src;
    }
}