    var mpArticle = {};
    /**
     * 根据 Finder 的信息生成最终的页面。
     */
    mpArticle.insertArticle(articleString, title) = function() {
        var articleContentWrapper = document.createElement('div');
        articleContentWrapper.innerHTML = articleString;
        createPageFromNode(articleContentWrapper, title);
        wereadBridge.handleWithRichEditor("realHtmlContent",{"param":this._cookedArticle.cloneNode(true).outerHTML},"","");
    }

    var MaximumWidthOfImageOrVideoExtendingBeyondTextContainer = 1050;

    /**
     * 计算是否能在保持图片宽高比不变的情况下，把图片全宽展示，而不会过高。
     */
    function canLayOutContentMaintainingAspectRatioBeyondTextColumn() {
        const limit = 700;
        if (window.innerHeight >= limit) {
            return true;
        }
        const ratio = 1.25;
        return (window.innerWidth / window.innerHeight) <= ratio;
    }

    /**
     * 计算需要补多少负边距，使得图片能全宽展示。
     */
    function leadingMarginAndPaddingAppliedToElementFromAncestors(element) {
        var currentElement = element.parentElement;
        for (var result = 0; currentElement && !currentElement.classList.contains('page'); currentElement = currentElement.parentElement) {
            var style = getComputedStyle(currentElement);
            result += parseFloat(style['-webkit-padding-start']) + parseFloat(style['-webkit-margin-start']);
        }
        return result;
    }

    function extendElementBeyondTextColumn(element, t, n) {
        element.classList.add('extendsBeyondTextColumn');
        element.style.setProperty('width', t + 'px');
        element.style.setProperty('margin-left', (n - t) / 2 - leadingMarginAndPaddingAppliedToElementFromAncestors(element) + 'px');
        element.style.setProperty('margin-right', (n - t) / 2 - leadingMarginAndPaddingAppliedToElementFromAncestors(element) + 'px');
    }

    function stopExtendingElementBeyondTextColumn(element) {
        element.classList.remove('extendsBeyondTextColumn');
        element.style.removeProperty('width');
        element.style.removeProperty('margin-left');
        element.style.removeProperty('margin-right');
    }

    /**
     * 页面宽度。
     */
    function textColumnWidthInPoints() {
        return parseFloat(getComputedStyle(document.querySelector('#article .page')).width);
    }

    /**
     * 计算图片和视频能否全宽显示。
     */
    function setImageOrVideoShouldLayOutBeyondTextColumnIfAppropriate(element, t) {
        if (t && !element.closest('blockquote, table, .float')) {
            var pageWidth = textColumnWidthInPoints();
            var elementWidth = parseFloat(element.getAttribute('width'));
            var naturalWidth = element.naturalWidth ? element.naturalWidth : element.getAttribute('data-w');
            naturalWidth = naturalWidth ? naturalWidth : 0;
            var actualWidth = isNaN(elementWidth) ? naturalWidth : elementWidth;

            var maximumWidth = Math.min(actualWidth, Math.min(MaximumWidthOfImageOrVideoExtendingBeyondTextContainer, document.getElementById("article").getBoundingClientRect().width));
            if (maximumWidth > pageWidth) {
                return void extendElementBeyondTextColumn(element, maximumWidth, pageWidth);
            }
        }
        stopExtendingElementBeyondTextColumn(element);
    }

    function createPageFromNode(contentNode, title) {
        // 创建页面容器
        var pageElement = document.createElement('div');
        pageElement.className = 'page';


        // 创建标题
        var titleElement = document.createElement('h1');
        titleElement.className = 'title';
        titleElement.textContent = title;
        pageElement.appendChild(titleElement);
        document.title = mainInfo.displayTitle;


        // 把传入的内容拷贝到页面容器
        while (contentNode.firstChild) {
            pageElement.appendChild(contentNode.firstChild);
        }

        // 去掉因空容器产生的空行
        var mainParagraph = pageElement.querySelectorAll('p');
        for (var i = 0; i < mainParagraph.length; i++) {
            var paragraph = mainParagraph[i];
            var hasMediaChildren = paragraph.querySelectorAll('img, iframe').length > 0;
            if (paragraph.innerText.trim() === '' && paragraph.offsetHeight === 0 && !hasMediaChildren) {
                paragraph.remove();
            }
        }

        // 处理音频
        var audioElements = pageElement.querySelectorAll('audio');
        console.log(audioElements);
        for (var i = 0; i < audioElements.length; i++) {
            var audioElement = audioElements[i];
            var audioPlayer = document.createElement('div');
            audioPlayer.classList.add('audio');
            audioPlayer.innerText = '有个音频';
            audioElement.parentNode.appendChild(audioPlayer);
        }

        // 页面容器插入展示的 HTML 结构中
        var articleNode = document.getElementById('article');
        articleNode.appendChild(pageElement);

        // 遍历所有图片，加入样式优化
        var imgList = pageElement.querySelectorAll('img');
        for (var i = 0; i < imgList.length; ++i) {
            if (imgList[i].getAttribute('data-w')) {
                setImageOrVideoShouldLayOutBeyondTextColumnIfAppropriate(imgList[i], canLayOutContentMaintainingAspectRatioBeyondTextColumn());
            } else {
                imgList[i].onload = function (imgElement) {
                    var imgTarget = imgElement.target;
                    setImageOrVideoShouldLayOutBeyondTextColumnIfAppropriate(imgTarget, canLayOutContentMaintainingAspectRatioBeyondTextColumn());
                    imgTarget.onload = null;
                };
            }
        }
    }
