package moai.scroller;

import android.view.animation.Interpolator;

public class SinInterpolater implements Interpolator{
	
	private static final float AMPLITUDE_MANIPULATE = (float) (Math.PI / 2.0f);
	
	private static float coefficient = 0.4f;
	
	public static float sinInterpolation(float input) {
		//float result = sin(PI / 2 *( input ^ 0.3))
		return (float) Math.sin(AMPLITUDE_MANIPULATE * (Math.pow(input, coefficient)));
	}
	
	@Override
	public float getInterpolation(float input) {
		return sinInterpolation(input);
	}
}
