package moai.scroller.effector.subscreen;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.Shader.TileMode;

import moai.scroller.MScroller;
import moai.scroller.ScreenScroller;

public class PaperEffector extends MSubScreenEffector {
    public static float sDensity = 1.0f;
    public static int dip2px(float dipVlue) {
        return (int) (dipVlue * sDensity + 0.5f);
    }

    private final static int SHADOW_WIDTH = dip2px(7);
	private int mCornerX = 0; // 拖拽点对应的页脚
	private int mCornerY = 0;
	private Path mPath0 = new Path();
	private Path mPath1 = new Path();

	PointF mTouch = new PointF(); // 拖拽点
	PointF mBezierStart1 = new PointF(); // 贝塞尔曲线起始点
	PointF mBezierControl1 = new PointF(); // 贝塞尔曲线控制点
	PointF mBeziervertex1 = new PointF(); // 贝塞尔曲线顶点
	PointF mBezierEnd1 = new PointF(); // 贝塞尔曲线结束点

	PointF mBezierStart2 = new PointF(); // 另一条贝塞尔曲线
	PointF mBezierControl2 = new PointF();
	PointF mBeziervertex2 = new PointF();
	PointF mBezierEnd2 = new PointF();

	float mMiddleX;
	float mMiddleY;
	float mDegrees;
	float mTouchToCornerDis;
	ColorMatrixColorFilter mColorMatrixFilter;
	Matrix mMatrix;
	float[] mMatrixArray = { 0, 0, 0, 0, 0, 0, 0, 0, 1.0f };

	boolean mIsRTandLB; 
	float mMaxLength;
	int[] mBackShadowColors;
	int[] mFrontShadowColors;
	float mFlyingProgress;
	boolean mIsflying;
	int mDeltaY;
	int mDeltaX;
	int mTargetX;
	float mLastOffsetY;
	
	Matrix mBackShadowMatrix = new Matrix();
	Paint mTestPaint = new Paint();
	Paint mTestPaint1 = new Paint();
	Paint mTestPaint2 = new Paint();
	Paint mTestPaint3 = new Paint();
	Paint mTestPaint4 = new Paint();
	private Paint mPaint;
	
	public PaperEffector() {
		mReverse = true;
		
		ColorMatrix cm = new ColorMatrix();
		float array[] = { 0.55f, 0, 0, 0, 80.0f, 0, 0.55f, 0, 0, 80.0f, 0, 0,
				0.55f, 0, 80.0f, 0, 0, 0, 0.2f, 0 };
		cm.set(array);
		mColorMatrixFilter = new ColorMatrixColorFilter(cm);
		mMatrix = new Matrix();
		
		mPaint = new Paint();
		mPaint.setStyle(Paint.Style.FILL);
	}
	
	@Override
	protected void onAttach(SubScreenContainer container,
			ScreenScroller scroller) {
		super.onAttach(container, scroller);
		LinearGradient lg1 = new LinearGradient(0,0,0,-SHADOW_WIDTH,  
                new int[]{0x3F000000, Color.TRANSPARENT},  
                null,TileMode.CLAMP);
		LinearGradient lg2 = new LinearGradient(mWidth,0,mWidth + SHADOW_WIDTH,0,  
                new int[]{0x3F000000, Color.TRANSPARENT},  
                null,TileMode.CLAMP);
		LinearGradient lg3 = new LinearGradient(0,mHeight,0,mHeight + SHADOW_WIDTH,  
                new int[]{0x3F000000, Color.TRANSPARENT},  
                null,TileMode.CLAMP);
		
		LinearGradient lg4 = new LinearGradient(0,0,-1,0,  
                new int[]{0x7F000000, Color.TRANSPARENT},  
                null,TileMode.CLAMP);
		
		LinearGradient lg5 = new LinearGradient(0,0,1,0,  
                new int[]{0x7F000000, Color.TRANSPARENT},  
                null,TileMode.CLAMP);
		
		mTestPaint.setShader(lg1);
		mTestPaint1.setShader(lg2);
		mTestPaint2.setShader(lg3);
		mTestPaint3.setShader(lg4);
		mTestPaint4.setShader(lg5);
		
//		mMaxLength = (float) Math.hypot(mWidth, mHeight);
		mMaxLength = mWidth / 3;
	}

	@Override
	protected boolean onDrawScreen(Canvas canvas, int screen, int offset,
			boolean first, float flyingProgress, int deltaY, int flyDir) {
		if (first) {
			mFlyingProgress = flyingProgress;
			mCornerX = mWidth + mScroll;
			mTouch.x = mWidth + mScroll + offset;
			if (flyingProgress != 0) {
				if (!mIsflying) {
					mIsflying = true;
					mDeltaY = (int) (mTouch.y - mCornerY);
				}
				float persent = 1f - flyingProgress;
				deltaY = (int) (persent * mDeltaY);
				if (flyDir == MScroller.DIR_END) {
					// 往后翻
					mTargetX = mCornerX - mWidth * 2;
					if (mDeltaX == 0) {
						mDeltaX = (int) (mTouch.x - mTargetX);
					}
				} else {
					// 向前翻
					mTargetX = mCornerX;
					if (mDeltaX == 0) {
						mDeltaX = (int) (mTouch.x - mCornerX);
					}
				}
				mTouch.x = persent * mDeltaX + mTargetX;
				mLastOffsetY = deltaY;
			} else {
				mIsflying = false;
				mDeltaX = 0;
//				mTouch.x = mWidth + mScroll + offset * 2;
				deltaY += mLastOffsetY;
			}
			if (deltaY > 0) {
				mTouch.y = deltaY;
				mCornerY = 0;
				mIsRTandLB = true;
			} else if (deltaY < 0) {
				mTouch.y = mHeight + deltaY;
				mCornerY = mHeight;
				mIsRTandLB = false;
			} else {
				mTouch.y = mHeight - 1;
				mCornerY = mHeight;
				mIsRTandLB = false;
			}
			calcPoints();
			clipPageArea(canvas);
//			Log.i("wuziyi", "mTouch.x" + mTouch.x);
			canvas.translate(mScroll, 0);
		} else {
			canvas.translate(mScroll, 0);
		}
		return true;
	}
	
	private void clipPageArea(Canvas canvas) {
		mPath0.reset();
		mPath0.moveTo(mBezierStart1.x, mBezierStart1.y);
		mPath0.quadTo(mBezierControl1.x, mBezierControl1.y, mBezierEnd1.x,
				mBezierEnd1.y);
		mPath0.lineTo(mTouch.x, mTouch.y);
		mPath0.lineTo(mBezierEnd2.x, mBezierEnd2.y);
		mPath0.quadTo(mBezierControl2.x, mBezierControl2.y, mBezierStart2.x,
				mBezierStart2.y);
		mPath0.lineTo(mCornerX, mCornerY);
		mPath0.close();

		canvas.clipPath(mPath0, Region.Op.XOR);
	}

	/**
	 * 绘制翻起页背面
	 */
	private void clipPageBackArea(Canvas canvas, int screen) {
//		int i = (int) (mBezierStart1.x + mBezierControl1.x) / 2;
//		float f1 = Math.abs(i - mBezierControl1.x);
//		int i1 = (int) (mBezierStart2.y + mBezierControl2.y) / 2;
//		float f2 = Math.abs(i1 - mBezierControl2.y);
//		float f3 = Math.min(f1, f2);
		mPath1.reset();
		mPath1.moveTo(mBeziervertex2.x, mBeziervertex2.y);
		mPath1.lineTo(mBeziervertex1.x, mBeziervertex1.y);
		mPath1.lineTo(mBezierEnd1.x, mBezierEnd1.y);
		mPath1.lineTo(mTouch.x, mTouch.y);
		mPath1.lineTo(mBezierEnd2.x, mBezierEnd2.y);
		mPath1.close();
		int saveCount = canvas.save();
		canvas.clipPath(mPath0);
		
		int saveCount2 = canvas.save();
		canvas.clipPath(mPath1, Region.Op.INTERSECT);
		canvas.translate(mScroll, 0);
		
		Bitmap bitmap = mContainer.getChildCache(screen);
		if (bitmap != null) {
			mPaint.setColorFilter(mColorMatrixFilter);
			
			float dis = (float) Math.hypot(mCornerX - mBezierControl1.x,
					mBezierControl2.y - mCornerY);
			float f8 = (mCornerX - mBezierControl1.x) / dis;
			float f9 = (mBezierControl2.y - mCornerY) / dis;
			mMatrixArray[0] = 1 - 2 * f9 * f9;
			mMatrixArray[1] = 2 * f8 * f9;
			mMatrixArray[3] = mMatrixArray[1];
			mMatrixArray[4] = 1 - 2 * f8 * f8;
			mMatrix.reset();
			mMatrix.setValues(mMatrixArray);
			mMatrix.preTranslate(-mBezierControl1.x + mScroll, -mBezierControl1.y);
			mMatrix.postTranslate(mBezierControl1.x - mScroll, mBezierControl1.y);
			canvas.drawColor(Color.WHITE);
			canvas.drawBitmap(bitmap, mMatrix, mPaint);
//			canvas.setMatrix(mMatrix);
//			mContainer.drawScreen(canvas, screen);
//			canvas.setMatrix(null);
			mPaint.setColorFilter(null);
		}
		
		mBackShadowMatrix.reset();
		if (mIsRTandLB) {
			mDegrees = -(float) Math.toDegrees(Math.atan2(mCornerX - mBezierControl1.x, mBezierControl2.y - mCornerY));
			mBackShadowMatrix.setRotate(mDegrees, 0, 0);
		} else {
			mDegrees = (float) Math.toDegrees(Math.atan2(mCornerX - mBezierControl1.x, mCornerY - mBezierControl2.y));
			mBackShadowMatrix.setRotate(mDegrees, 0, mHeight);
		}
		
		mBackShadowMatrix.preScale(Math.min(mMaxLength, mTouchToCornerDis / 4), 1f);
		mBackShadowMatrix.postTranslate(mBezierControl1.x - mCornerX + mWidth, 0);
		mTestPaint3.getShader().setLocalMatrix(mBackShadowMatrix);
		canvas.drawRect(0, 0, mWidth, mHeight, mTestPaint3);
		
		
		canvas.restoreToCount(saveCount2);
		mPath1.reset();
		mPath1.moveTo(mBezierStart1.x, mBezierStart1.y);
		mPath1.lineTo(mBeziervertex1.x, mBeziervertex1.y);
		mPath1.lineTo(mBeziervertex2.x, mBeziervertex2.y);
		mPath1.lineTo(mBezierStart2.x, mBezierStart2.y);
		mPath1.lineTo(mCornerX, mCornerY);
		mPath1.close();
		canvas.clipPath(mPath1, Region.Op.INTERSECT);
		canvas.translate(mScroll, 0);
		mBackShadowMatrix.postTranslate(mBezierStart1.x - mBezierControl1.x, 0);
		mTestPaint4.getShader().setLocalMatrix(mBackShadowMatrix);
		canvas.drawRect(0, 0, mWidth, mHeight, mTestPaint4);
		
		canvas.restoreToCount(saveCount);

	}

	/**
	 * 计算拖拽点对应的拖拽脚
	 */
	private void calcCornerXY(float x, float y) {
		if (x <= mWidth / 2)
			mCornerX = 0;
		else
			mCornerX = mWidth;
		if (y <= mHeight / 2)
			mCornerY = 0;
		else
			mCornerY = mHeight;
		if ((mCornerX == 0 && mCornerY == mHeight)
				|| (mCornerX == mWidth && mCornerY == 0))
			mIsRTandLB = true;
		else
			mIsRTandLB = false;
	}

	/**
	 * 求解直线P1P2和直线P3P4的交点坐标
	 */
	public PointF getCross(PointF P1, PointF P2, PointF P3, PointF P4) {
		PointF CrossP = new PointF();
		// 二元函数通式： y=ax+b
		float a1 = (P2.y - P1.y) / (P2.x - P1.x);
		float b1 = ((P1.x * P2.y) - (P2.x * P1.y)) / (P1.x - P2.x);

		float a2 = (P4.y - P3.y) / (P4.x - P3.x);
		float b2 = ((P3.x * P4.y) - (P4.x * P3.y)) / (P3.x - P4.x);
		CrossP.x = (b2 - b1) / (a1 - a2);
		CrossP.y = a1 * CrossP.x + b1;
		return CrossP;
	}

	private void calcPoints() {
		mMiddleX = (mTouch.x + mCornerX) / 2;
		mMiddleY = (mTouch.y + mCornerY) / 2;
		mBezierControl1.x = mMiddleX - (mCornerY - mMiddleY)
				* (mCornerY - mMiddleY) / (mCornerX - mMiddleX);
		mBezierControl1.y = mCornerY;
		mBezierControl2.x = mCornerX;
		mBezierControl2.y = mMiddleY - (mCornerX - mMiddleX)
				* (mCornerX - mMiddleX) / (mCornerY - mMiddleY);

		mBezierStart1.x = mBezierControl1.x - (mCornerX - mBezierControl1.x)
				/ 2;
		mBezierStart1.y = mCornerY;

		// 控制卷曲的顶点
		int scroll = Math.abs(mScroll);
		if (!mIsflying && (mTouch.x - scroll > -mWidth && mTouch.x - scroll < mWidth)) {
			if (mBezierStart1.x - scroll < 0 || mBezierStart1.x - scroll > mWidth) {
				if (mBezierStart1.x - scroll < 0) {
					mBezierStart1.x = mWidth - mBezierStart1.x + scroll;
//					Log.i("wuziyi", "mBezierStart1.x:" + mBezierStart1.x);
				}
				float f1 = Math.abs(mCornerX - mTouch.x);
				float f2 = mWidth * f1 / mBezierStart1.x;
				mTouch.x = Math.abs(mCornerX - f2);

				float f3 = Math.abs(mCornerX - mTouch.x)
						* Math.abs(mCornerY - mTouch.y) / f1;
				mTouch.y = Math.abs(mCornerY - f3);

				mMiddleX = (mTouch.x + mCornerX) / 2;
				mMiddleY = (mTouch.y + mCornerY) / 2;

				mBezierControl1.x = mMiddleX - (mCornerY - mMiddleY)
						* (mCornerY - mMiddleY) / (mCornerX - mMiddleX);
				mBezierControl1.y = mCornerY;

				mBezierControl2.x = mCornerX;
				mBezierControl2.y = mMiddleY - (mCornerX - mMiddleX)
						* (mCornerX - mMiddleX) / (mCornerY - mMiddleY);
				mBezierStart1.x = mBezierControl1.x
						- (mCornerX - mBezierControl1.x) / 2;
			}
		}
		mBezierStart2.x = mCornerX;
		mBezierStart2.y = mBezierControl2.y - (mCornerY - mBezierControl2.y)
				/ 2;

		mTouchToCornerDis = (float) Math.hypot((mTouch.x - mCornerX),
				(mTouch.y - mCornerY));

		mBezierEnd1 = getCross(mTouch, mBezierControl1, mBezierStart1,
				mBezierStart2);
		mBezierEnd2 = getCross(mTouch, mBezierControl2, mBezierStart1,
				mBezierStart2);

		/*
		 * mBeziervertex1.x 推导
		 * ((mBezierStart1.x+mBezierEnd1.x)/2+mBezierControl1.x)/2 化简等价于
		 * (mBezierStart1.x+ 2*mBezierControl1.x+mBezierEnd1.x) / 4
		 */
		mBeziervertex1.x = (mBezierStart1.x + 2 * mBezierControl1.x + mBezierEnd1.x) / 4;
		mBeziervertex1.y = (2 * mBezierControl1.y + mBezierStart1.y + mBezierEnd1.y) / 4;
		mBeziervertex2.x = (mBezierStart2.x + 2 * mBezierControl2.x + mBezierEnd2.x) / 4;
		mBeziervertex2.y = (2 * mBezierControl2.y + mBezierStart2.y + mBezierEnd2.y) / 4;
	}

	@Override
	protected boolean afterDrawContainer(Canvas canvas, int screen, int offset,
			boolean first, float flyingProgress, int deltaY) {
		if (first) {
			clipPageBackArea(canvas, screen);
			drawShadow(canvas);
		}
		return true;
	}

	private void drawShadow(Canvas canvas) {
		int save = canvas.save();
		canvas.clipPath(mPath0, Region.Op.XOR);
		
		double degree;
		if (mIsRTandLB) {
			degree = Math.PI
					/ 4
					- Math.atan2(mBezierControl1.y - mTouch.y, mTouch.x
							- mBezierControl1.x);
		} else {
			degree = Math.PI
					/ 4
					- Math.atan2(mTouch.y - mBezierControl1.y, mTouch.x
							- mBezierControl1.x);
		}
		double d1 = (float) SHADOW_WIDTH * 1.414 * Math.cos(degree);
		double d2 = (float) SHADOW_WIDTH * 1.414 * Math.sin(degree);
		float x = (float) (mTouch.x + d1);
		float y;
		if (mIsRTandLB) {
			y = (float) (mTouch.y + d2);
		} else {
			y = (float) (mTouch.y - d2);
		}
		
		Shader shader = mTestPaint.getShader();
		shader.setLocalMatrix(mMatrix);
		shader = mTestPaint1.getShader();
		shader.setLocalMatrix(mMatrix);
		shader = mTestPaint2.getShader();
		shader.setLocalMatrix(mMatrix);
		
		int save2 = canvas.save();
		mPath1.reset();
		mPath1.moveTo(x, y);
		mPath1.lineTo(mTouch.x, mTouch.y);
		mPath1.lineTo(mBezierControl1.x, mBezierControl1.y);
		mPath1.lineTo(mBezierStart1.x, mBezierStart1.y);
		mPath1.close();
		canvas.clipPath(mPath1, Region.Op.INTERSECT);
		canvas.translate(mScroll, 0);
		
//			RectF rectF = new RectF(0,0,mWidth,mHeight);
//			RectF rectF1 = new RectF(0, 0, mWidth, mHeight);
//			RectF rectF1 = new RectF(100,100,500,500);
		
		if (mIsRTandLB) {
			canvas.drawRect(0,0,mWidth,mHeight, mTestPaint);
		} else {
			canvas.drawRect(0,0,mWidth,mHeight, mTestPaint2);
		}
		canvas.restoreToCount(save2);
		
		mPath1.reset();
		mPath1.moveTo(x, y);
		mPath1.lineTo(mTouch.x, mTouch.y);
		mPath1.lineTo(mBezierControl2.x, mBezierControl2.y);
		mPath1.lineTo(mBezierStart2.x, mBezierStart2.y);
		mPath1.close();
		canvas.clipPath(mPath1, Region.Op.INTERSECT);
		canvas.translate(mScroll, 0);
		
		canvas.drawRect(0,0,mWidth,mHeight, mTestPaint1);
		
		canvas.restoreToCount(save);
	}

	@Override
	protected void onScrollFinish() {
		mIsflying = false;
		mDeltaX = 0;
		mDeltaY = 0;
//		mTouch.x = mWidth + mScroll;
	}
	
	@Override
	protected boolean autoScrollToEdgeByDir() {
		return true;
	}

}
