package moai.scroller.effector.subscreen;

import android.graphics.Canvas;

import moai.scroller.ScreenScroller;

class RollEffector extends MSubScreenEffector {
	float mAngleRatio;
	float mDistanceRatio;

	@Override
	protected boolean onDrawScreen(Canvas canvas, int screen, int offset, boolean first, float flyingProgress, int deltaY, int flyDir) {
		final float angle = offset * mAngleRatio;
		final float dist = offset * mDistanceRatio;
		if (mOrientation == ScreenScroller.HORIZONTAL) {
			canvas.translate(mScroll + dist + mCenterX, mCenterY);
			canvas.rotate(angle);
			canvas.translate(-mCenterX, -mCenterY);
		} else {
			canvas.translate(mCenterX, mScroll + dist + mCenterY);
			canvas.rotate(angle);
			canvas.translate(-mCenterX, -mCenterY);
		}
		return true;
	}

	@Override
	public void onSizeChanged() {
		super.onSizeChanged();
		mAngleRatio = 180.0f / mScreenSize;
		mDistanceRatio = (float) Math.hypot(mWidth, mHeight) / mScreenSize;
	}

	@Override
	protected boolean afterDrawContainer(Canvas canvas, int screen, int offset,
			boolean first, float flyingProgress, int deltaY) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected void onScrollFinish() {
		// TODO Auto-generated method stub
		
	}

}
