package moai.scroller.effector.subscreen;

import android.graphics.Canvas;

import moai.scroller.ScreenScroller;
import moai.scroller.ScreenScrollerEffector;
import moai.scroller.ScreenScrollerListener;
import moai.scroller.effector.IEffectorIds;

/**
 * 只绘制当前两屏的特效类
 * 
 * @author ericziyiwu
 * 
 */
public class SubScreenEffector implements ScreenScrollerEffector {

	/** 低质量绘图 */
	public final static int DRAW_QUALITY_LOW = 0;
	/** 中等质量绘图 */
	public final static int DRAW_QUALITY_MID = 1;
	/** 高等质量绘图 */
	public final static int DRAW_QUALITY_HIGH = 2;

	SubScreenContainer mContainer;
	ScreenScroller mScroller;
	MSubScreenEffector mEffector;
	MSubScreenEffector[] mRandomEffectors;
	int mCurrentIndex;
	int mType;
	int mScreenSize;
	int mOrientation;
	int mQuality;
	int mGap;

	public SubScreenEffector(ScreenScroller scroller) {
		assert scroller != null; // 如果为null也就没任何意义了
		mScroller = scroller;
		mScroller.setEffector(this);
		
	}

	@Override
	public boolean onDraw(Canvas canvas) {
		final int extraX = mGap * 2;
		int curOffset = mScroller.getCurrentScreenOffset();
		int screenSize = mScroller.getScreenSize();
		float flyingProgress = mScroller.getInterpolationFlingProgress();
		int deltaY = mScroller.getTouchDeltaY();
		int flyDir = mScroller.getFlyDirection();
		int offset = curOffset;
		if (offset > 0) {
			offset -= screenSize;
		}

		final int screenA = mScroller.getDrawingScreenA();
		final int screenB = mScroller.getDrawingScreenB();
		if (offset == 0 && mScroller.getCurrentDepth() == 0) {
			MSubScreenEffector.drawView(mContainer, mScroller, canvas, screenA, offset + extraX);
		} else if (mEffector == null) {
			MSubScreenEffector.drawView(mContainer, mScroller, canvas, screenA, offset + extraX);
			MSubScreenEffector.drawView(mContainer, mScroller, canvas, screenB, offset + extraX	+ screenSize);
		} else {
			mEffector.onScrollChanged(mScroller.getScroll() + extraX, curOffset);
			if (mEffector.toReverse()) {
				mEffector.drawView(canvas, screenB, offset + screenSize, false, flyingProgress, deltaY, flyDir);
				mEffector.drawView(canvas, screenA, offset, true, flyingProgress, deltaY, flyDir);
			} else {
				mEffector.drawView(canvas, screenA, offset, true, flyingProgress, deltaY, flyDir);
				mEffector.drawView(canvas, screenB, offset + screenSize, false, flyingProgress, deltaY, flyDir);
				
			}
		}
		return true;
	}

	@Override
	public void setType(int type) {
//		MSubScreenEffector oldEffector = mEffector;
//		if (type <= IEffectorIds.EFFECTOR_TYPE_RANDOM) {
//			if (mRandomEffectors == null) {
//				mRandomEffectors = new MSubScreenEffector[] { new BounceEffector(),
//						new BulldozeEffector(), new CuboidInsideEffector(),
//						new CuboidOutsideEffector(), new FlipEffector(), // not
//																			// contain
//																			// Flip2Effector
//						new RollEffector(), new WaveEffector(), new WindmillEffector(), };
//				mCurrentIndex = -1;
//			}
			mType = type;
//			int index = (int) (Math.random() * mRandomEffectors.length);
//			if (index == mCurrentIndex) {
//				index = (index + 1) % mRandomEffectors.length;
//			}
//			mEffector = mRandomEffectors[index];
//			mCurrentIndex = index;
//		} else if (mType == type) {
//			return;
//		} else {
//			mType = type;
//			mRandomEffectors = null;
//			switch (type) {
//				case IEffectorIds.EFFECTOR_TYPE_BOUNCE :
//					mEffector = new BounceEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_BULLDOZE :
//					mEffector = new BulldozeEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_CUBOID1 :
//					mEffector = new CuboidInsideEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_CUBOID2 :
//					mEffector = new CuboidOutsideEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_FLIP :
//					mEffector = new FlipEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_FLIP2 :
//					mEffector = new Flip2Effector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_ROLL :
//					mEffector = new RollEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_WAVE :
//					mEffector = new WaveEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_WAVE_FLIP :
//					mEffector = new WaveFlipEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_CARD_FLIP:
//					mEffector = new CardScaleEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_WINDMILL :
//					mEffector = new WindmillEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_STACK :
//					mEffector = new StackEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_CROSSFADE:
//					mEffector = new CrossFadeEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_FLYIN:
//					mEffector = new FlyinEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_PAGETURN:
//					mEffector = new PageTurnEffector();
//					break;
//				case IEffectorIds.EFFECTOR_TYPE_CURVE:
//					mEffector = new CurveEffector();
//					break;
//				default :
//					mEffector = null;
//					break;
//			}
//		}
//		if (oldEffector != mEffector) {
//			if (oldEffector != null) {
//				oldEffector.onDetach();
//			}
//			if (mEffector != null) {
//				mEffector.setDrawQuality(mQuality);
//				mEffector.onAttach(mContainer, mScroller);
//			} else {
//				mScroller.setOvershootPercent(100);
//			}
//		}
	}

	@Override
	public void updateRandomEffect() {
		if (mType == IEffectorIds.EFFECTOR_TYPE_RANDOM) {
			setType(IEffectorIds.EFFECTOR_TYPE_RANDOM);
		}
	}

	@Override
	public void onSizeChanged(int w, int h, int orientation) {
		mOrientation = mScroller.getOrientation();
		mScreenSize = mScroller.getScreenSize();
		if (mEffector != null) {
			mEffector.onSizeChanged();
		}
	}

	@Override
	public int getMaxOvershootPercent() {
		return mEffector == null ? 100 : mEffector.getMaxOvershootPercent();
	}

	@Override
	public void onAttach(ScreenScrollerListener container) {
		if (container != null && container instanceof SubScreenContainer) {
			ScreenScroller scroller = container.getScreenScroller();
			mContainer = (SubScreenContainer) container;
			if (scroller == null) {
				throw new IllegalArgumentException("Container has no ScreenScroller.");
			} else if (mScroller != scroller) {
				mScroller = scroller;
				mOrientation = mScroller.getOrientation();
				mScreenSize = mScroller.getScreenSize();
				int oldType = mType;
				mType = IEffectorIds.EFFECTOR_TYPE_DEFAULT;
				mEffector = null;
				setType(oldType);
			}
		} else {
			throw new IllegalArgumentException(
					"container is not an instance of SubScreenEffector.SubScreenContainer");
		}

	}

	@Override
	public void onDetach() {
		mContainer = null;
		mScroller = null;
		// mRandomEffectors = null;
		if (mEffector != null) {
			mEffector.onDetach();
		}

	}

	@Override
	public void setDrawQuality(int quality) {
		mQuality = quality;
		if (mEffector != null) {
			mEffector.setDrawQuality(quality);
		}

	}

	@Override
	public void recycle() {
		mRandomEffectors = null;
	}

	@Override
	public void setScreenGap(int gap) {
		mGap = gap;
	}
	
	public void setEffoctor(MSubScreenEffector effector) {
		MSubScreenEffector oldEffector = mEffector;
		mEffector = effector;
		if (oldEffector != mEffector) {
			if (oldEffector != null) {
				oldEffector.onDetach();
			}
			if (mEffector != null) {
				mEffector.setDrawQuality(mQuality);
				mEffector.onAttach(mContainer, mScroller);
			}
		}
	}

	@Override
	public void onScrollFinish() {
		if (mEffector != null) {
			mEffector.onScrollFinish();
		}
	}

	@Override
	public boolean autoScrollToEdgeByDir() {
		if (mEffector != null) {
			return mEffector.autoScrollToEdgeByDir();
		}
		return false;
	}

}
