package com.funshion.statistic;

import java.util.Map.Entry;
import android.app.IntentService;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;

public class StatisticService extends IntentService {
    private static final String EXTRA_SERVICE = "service";
    private static final String EXTRA_FUNC    = "func";
    private static final String EXTRA_COUNT   = "count";
    private static final String EXTRA_VALUES  = "values";

    private StatisticDatabase mDatabase;

    public StatisticService() {
        super("Statistic");
    }

    @Override
    public void onCreate() {
        super.onCreate();
        mDatabase = new StatisticDatabase(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mDatabase.close();
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        if (intent != null) {
            final int count = intent.getIntExtra(EXTRA_COUNT, 1);
            storeStatistic(intent);

            if (mDatabase.getCount() >= count && FunUtils.isNetworkConnected(this)) {
                FunUtils.reportStatistics(this, mDatabase.getWritableDatabase());
            }
        }
    }

    public static void report(Context context, String serviceName, String funcName, ContentValues values) {
        report(context, serviceName, funcName, values, 1);
    }

    public static void report(Context context, String serviceName, String funcName, ContentValues values, int reportCount) {
        final Intent service = new Intent(context, StatisticService.class);
        service.putExtra(EXTRA_SERVICE, serviceName);
        service.putExtra(EXTRA_FUNC, funcName);
        service.putExtra(EXTRA_VALUES, values);
        service.putExtra(EXTRA_COUNT, reportCount);
        context.startService(service);
    }

    private void storeStatistic(Intent intent) {
        final String serviceName = intent.getStringExtra(EXTRA_SERVICE);
        final String funcName = intent.getStringExtra(EXTRA_FUNC);
        final ContentValues initialValues = intent.getParcelableExtra(EXTRA_VALUES);
        initialValues.remove("mac");

        if (TextUtils.isEmpty(serviceName) || TextUtils.isEmpty(funcName) || initialValues == null || initialValues.size() <= 0) {
            return;
        }

        final StringBuilder data = new StringBuilder();
        for (Entry<String, Object> entry : initialValues.valueSet()) {
            FunUtils.appendValue(data, entry.getKey(), entry.getValue());
        }

        final ContentValues values = new ContentValues();
        values.put("_date", System.currentTimeMillis());
        values.put("service", serviceName);
        values.put("func", funcName);
        values.put("_data", data.toString());
        mDatabase.getWritableDatabase().insert("statistics", null, values);
    }

    private static final class StatisticDatabase extends SQLiteOpenHelper {
        public StatisticDatabase(Context context) {
            super(context, "statistic.db", null, 1);
        }

        public final int getCount() {
            final SQLiteStatement prog = getWritableDatabase().compileStatement("SELECT COUNT(*) FROM statistics");
            try {
                return (int)prog.simpleQueryForLong();
            } finally {
                prog.close();
            }
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE IF NOT EXISTS statistics (" +
                    "_date INTEGER PRIMARY KEY," +
                    "service TEXT," +
                    "func TEXT," +
                    "_data TEXT)");
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}
