(function() {
  var interface = require('wap/interface');

  interface.login = function(params, callback) {
    var utils = require('wap/utils');
    var client_id = utils.getUrlParams().client_id || 1024;

    var options = {
      client_id: client_id,
      v: 0,
      ru: 'http://wap.sogou.com'
    };

    callback = callback || noop;

    $.extend(options, params);

    return $.ajax({
      url: '/wap/login',
      type: 'post',
      data: options,
      dataType: 'json',
      error: function() {
        return callback(false, {
          'statusText': '登录失败'
        });
      },
      success: function(data) {
        if (data && !+data.status) {
          // 拦截到登录请求返回成功，在这里发消息
          var loginSuccess
            = 'loginSuccess://'
              + encodeURIComponent(JSON.stringify(data.data));

          window.location = loginSuccess;

          // 注释掉下面这行，可阻止跳转
          // return callback(true, data.data);
        }
        else {
          return callback(false, data);
        }
      }
    });
  }

  interface.smsCodeLogin = function(params, callback) {
    var utils = require('wap/utils');
    var client_id = utils.getUrlParams().client_id || 1024;

    var options = {
      client_id: client_id,
      v: 0,
      ru: 'http://wap.sogou.com'
    };

    callback = callback || noop;

    $.extend(options, params);

    return $.ajax({
      url: '/wap/smsCode/login',
      type: 'post',
      data: options,
      dataType: 'json',
      error: function() {
        return callback(false, {
          'statusText': '登录失败'
        });
      },
      success: function(data) {
        if (data && !+data.status) {
          // 拦截到登录请求返回成功，在这里发消息
          var loginSuccess
            = 'loginSuccess://'
              + encodeURIComponent(JSON.stringify(data.data));

          window.location = loginSuccess;

          // 注释掉下面这行，可阻止跳转
          // return callback(true, data.data);
        }
        else {
          return callback(false, data);
        }
      }
    });
  }

  interface.register = function(params, callback) {
    var utils = require('wap/utils');
    var client_id = utils.getUrlParams().client_id || 1024;

    var options = {
      client_id: client_id,
      v: 0,
      ru: 'http://wap.sogou.com'
    };
    callback = callback || noop;

    $.extend(options, params);
    $.ajax({
      url: '/wap/reguser',
      type: 'post',
      data: options,
      dataType: 'json',
      success: function(data) {

        if ('string' === typeof data) {
          try {
            data = JSON.parse(data);
          } catch (e) {
            data = {
              status: 1,
              statusText: '格式错误'
            };
          }
        }

        if (data && !+data.status) {
          // 拦截到登录请求返回成功，在这里发消息
          var loginSuccess
            = 'loginSuccess://'
              + encodeURIComponent(JSON.stringify(data.data));
          // alert(JSON.stringify(data.data));
          window.location = loginSuccess;

          // 注释掉下面这行，可阻止跳转
          // return callback(true, data.data);
        }
        else {
          return callback(false, data);
        }
      },
      error: function() {
        return callback(false, {
          'statusText': '注册失败'
        });
      }
    });
  }
})();

 // JavaScript Document
function backBtnClick() {
    
    if (location.pathname == '/wap/index') {
        
        var url = "sgpassportscheme://appName?invokeMethodName=objcMethod&paramA=123";
        invokeObjc(url);
    };
    if (location.pathname == '/wap/reg' || location.pathname == '/wap/findpwd') {
        
        var url = "gobackscheme://appName1?invokeMethodName=objcMethod&paramB=1234";
        invokeObjc(url);
    };
}
 
 function invokeObjc(url) {
    var iframe;
    iframe = document.createElement("iframe");
    iframe.setAttribute("src", url);
    document.body.appendChild(iframe);
    iframe.parentNode.removeChild(iframe);
}
