

function cgMoreClick() {
    window.location = 'cmd://nav/cgMore?from=button';
}

//更新按钮高亮
var skipUpdateCgNavSection = false;
function initCgNavBar()
{
    document.getElementById('cgType').style.display = 'none';
    var navitems = document.getElementsByClassName('cgNavSection');
    for (var i = 0; i < navitems.length; i++) {
        navitems[i].addEventListener('click', cgNavSectionClick, false);
    }

    var navBar = document.getElementById('cgNavBar');
    var navRect = navBar.getBoundingClientRect();
    if (gPlatform == 'android') {
        //保证fixed后，仍然是原始大小
        navBar.style.width = navRect.width + 'px'; 
        window.addEventListener("resize", function() {
            navBar.style.width = document.body.getBoundingClientRect().width - 24 + 'px'; 
        });
    }
    document.addEventListener("scroll",  function() { 
        if (gPlatform == 'android') {
            //android 不支持sticky
            if (window.pageYOffset >= navRect.top) {
                navBar.classList.add('fixSticky');            
                document.getElementById('cgNavBarHolder').style.height = navRect.height + 'px';
            } else {
                navBar.classList.remove('fixSticky');            
                document.getElementById('cgNavBarHolder').style.height = 0;
            }
        }
        if (skipUpdateCgNavSection) return;
        var navitems = document.getElementsByClassName('cgNavSection');
        var foundHighlight = false;
        for (var i = navitems.length; i > 0; i--) { 
            var el = navitems[i - 1];
            if (foundHighlight || document.getElementById('cgNavSection' + i).getBoundingClientRect().top > 160)
            {            
                navitems[i - 1].classList.remove('hover');
                navitems[i - 1].style.backgroundColor = 'transparent';
            }
            else if (!foundHighlight)
            {          
                el.classList.add('hover');
                el.style.backgroundColor = getComputedStyle(el).borderColor;
                foundHighlight = true;
            }
        } 
    }, false);
}

//变位时态跳转
function cgNavSectionClick(event)
{
    event.preventDefault();    
    var navitems = document.getElementsByClassName('cgNavSection');
    for (var i = navitems.length; i > 0; i--) { 
        var el = navitems[i - 1];
        el.classList.remove('hover');
        el.style.backgroundColor = 'transparent';        
    }
    event.target.classList.add('hover');
    event.target.style.backgroundColor = getComputedStyle(event.target).borderColor;
    var targetElId = event.target.href.split('#')[1]
    var targetEl = document.getElementById(targetElId);
    skipUpdateCgNavSection = true;

    var navRect = document.getElementById('cgNavBar').getBoundingClientRect();
    //调整放大字体后的比例
    var zoomRatio = document.body.getBoundingClientRect().width / (navRect.width + 20);
    var distance = zoomRatio * (targetEl.offsetTop - navRect.height - 5);
    if (gPlatform == 'ios'){
        distance -= 18;
    }
    smoothScrollTo(document.body, distance , 300);       
    setTimeout(function() {
        skipUpdateCgNavSection = false;
    }, 5000);
}


var eudic_shouldIgnoreDomReadyEvent = false;
var eudic_currentScrollSection = -1;
// DicHtmlExplain::generateInjectScript 内生成的方法
function eudic_injectScriptDidFinish() {
    setTimeout(function(){
        try {
            eudic_injectOnlineScriptDidFinish();
            // EUDIC-8988 部分词库由于依赖 window.onload() ,在展开后未调用该方法，导致词库内的方法无法正常使用
            if (window.onload) {
                window.onload();
            }
            // EUDIC-9938 还有依赖 load 监听的
            window.document.dispatchEvent(new Event("load", {  bubbles: true,  cancelable: true}));
            // EUDIC-10027 还有依赖 DOMContentLoaded 监听的
            eudic_shouldIgnoreDomReadyEvent = true;
            window.document.dispatchEvent(new Event("DOMContentLoaded", {  bubbles: true,  cancelable: true}));
            setTimeout(function(){
                eudic_shouldIgnoreDomReadyEvent = false;
            }, 1000);
        } catch (error) {

        }
    },100);
}

// 在线词库插入后的后续执行方法
function eudic_injectOnlineScriptDidFinish() {
    try {
        mdxAddNightMode();
    } catch (error) {

    }
}

//检查某个section是否在滚动后显示
function eudic_isScrolledIntoView(el)
{
    if (!el){
        return false;
    }
    var rect = el.getBoundingClientRect();
    var elemTop = rect.top;
    var elemBottom = rect.bottom;
    var isVisible = elemTop < window.innerHeight && elemBottom >= 0;
    return isVisible;
}

function eudic_checkScrollSection(reverse)
{
    var expWrapList = document.querySelectorAll('.explain_wrap,.explain_wrap_styleless');
    if (reverse) {
        for (var i = expWrapList.length; i >= 0; i--){
            var expItem = expWrapList[i];
            if (eudic_innerCheckScrollSectionAction(expItem)){
                return i;
            }
        }
    }else{
        for (var i = 0; i < expWrapList.length; i++){
            var expItem = expWrapList[i];
            if (eudic_innerCheckScrollSectionAction(expItem)){
                if (expItem.id !== 'expCustomNote'){
                    return i;
                }
            }
        }
    }
    return -1;
}

function eudic_innerCheckScrollSectionAction(expItem) {
    var isVisible = eudic_isScrolledIntoView(expItem);
    if (isVisible){
        var childItemId = expItem.id + 'child';
        var thisEle = document.getElementById(childItemId);
        if (thisEle && thisEle.style.display !== 'none'){
            return true;
        }
    }
    return false;
}

function eudic_clickThumbnailCommand() {
    window.location='cmd://dict/thumbnail_click';
}

function SetInnerHTML(elName, _html, append) {
    if(_html.indexOf('<script') != -1) {
        lazyContainScriptHtml(elName, _html);
    } else {
        if (append)
        {
            var existEl = document.getElementById(elName);
            if (existEl)
            {
                _html = existEl.innerHTML + _html;
            }
        }
        document.getElementById(elName).innerHTML = _html;
    }
}

function SetOuterHTML(elName, _html) {
    document.getElementById(elName).outerHTML = _html;
}

function lazyContainScriptHtml (elName, html) {
    // 从<script开始匹配 忽略其他属性如type="" 取所有不含scr= 直到> .*?</script>
    html = html.replace('</script>\'','</__script__>\'').replace('</script>"', '</__script__>"');
    var matchScript = html.match(/<script(?=\s|>)(?!(?:[^>=]|=(['"])(?:(?!\1).)*\1)*?src=['"])[^>]*>.*?<script.*?<\/script>/ig);
    //如果 script 里嵌套了一个 document.write，而里面又有一个 script 时，即使是 innerHTML 也无法正确解析
    //而且由于是此时是延迟加载，文档已经被关闭了，一旦词库里的 document.write 被执行会导致整个页面被清空。
    //因此一旦读到 document.write，就移除这段 <script>

    //原始的 DOM，既有src又有内容
    var domScriptList = [];
    //原始的 DOMString
    var originScriptList = [];
    if(matchScript != null) {
        for(var i = 0, l = matchScript.length; i < l; i++) {
            // 如果 script 里嵌套了一个 document.write，而里面又有一个 script 时，即使是 innerHTML 也无法正确解析
            // 此时需要将内嵌的字符串版 script 加入必要的分隔符
            var matchScriptItem = matchScript[i];

            // EUDIC-9937 如果查出 </script> 标签并非在匹配的最后一处，那么重新把 </script> 替换一次
            // 否则会导致中间存在的 script 结束标签被清空
            var lastScriptIndex = matchScriptItem.indexOf('</script>');
            if (lastScriptIndex !== matchScriptItem.length - '</script>'.length){
                matchScriptItem = matchScriptItem.replace('</script>', '</__script__>');
            }
            matchScriptItem = matchScriptItem.replace('</__script__>', '<\\/__script__>');
            html = html.replace(matchScriptItem, matchScriptItem.replace('<\/script>', '')+ '<\\/script>');

            var innerScript = html.match(/<script(?=\s|>)(?!(?:[^>=]|=(['"])(?:(?!\1).)*\1)*?src=['"])[^>]*>.*?<\/script>/ig);
            if(innerScript != null) {
                for(var j = 0, jl = innerScript.length; j < jl; j++) {
                    if(innerScript[j].indexOf('document.write(') != -1) {

                        //新的懒加载处理逻辑
                        //根据新 template，先创建一份，查看是否存在src，如果存在，直接创建，这样能直接忽略掉里面附带的document.write内容，如果不存在，直接就不处理
                        //https://caniuse.com/#feat=template 主流移动端都支持，但保险起见还是用trycatch包裹
                        try {
                            var template = document.createElement('template');
                            html = html.trim();
                            template.innerHTML = innerScript[j];
                            var templateScript = template.content.firstChild;
                            if (templateScript.src && templateScript.src.length > 0){
                                domScriptList.push(templateScript);
                            }
                        } catch (error) {

                        }
                        originScriptList.push(innerScript[j]);

                        // //原有懒加载处理逻辑
                        // var lastkBracket = checkBracket(innerScript[j]);
                        // if(lastkBracket) {
                        //     var formatScript = innerScript[j].substring(innerScript[j].indexOf('document.write(')+15, lastkBracket+2);
                        //     html = html.replace('document.write('+ formatScript, '');
                        //     var formatScript = formatScript.replace('<\\/script>', '<\/script>');
                        //     formatScript = formatScript.substring(1, formatScript.length-3);
                        //     html += formatScript;
                        // }
                    }
                }
            }
        }
    }

    //将带 documentWrite 的 domString 全部移除
    if (originScriptList.length > 0){
        for (var i = 0; i < originScriptList.length; i++){
            var originScript = originScriptList[i];
            html = html.replace(originScript,'');
        }
    }

    html = html.replace('</__script__>','</script>');
    var rootElement = document.getElementById(elName);
    rootElement.innerHTML = html;

    //插入被遗漏掉的 domScript，只保留src，移除内容
    if (domScriptList.length > 0){
        for (var i = 0; i < domScriptList.length; i++){
            var element = domScriptList[i];
            rootElement.appendChild(element);
        }
    }
}

function checkBracket(str) {
    var bracket = [], index = 0;
    var str= str ||'';
    for(var i=0; i < str.length; i++){
        if(str.charAt(i)=="("){
            bracket.push('(');
        } else if(str.charAt(i)==")"){
            bracket.pop();
            if(bracket.length == 0) {
                index = i;
            }
        }
    }
    return index;
}

//note support
//skipImage 桌面版图片样式不同，需要单独处理
function setCustomNoteChild(noteString, skipImage) {
    var regex = /<!--meta files ([\S\s]+) -->/g
    var subst = '';
    var result0 = noteString.replace(regex, subst);
    var fontStyle = ''
    try {
        var jsonStr = noteString.match(regex)[0];
        jsonStr = jsonStr.replace('<!--meta files', '');
        jsonStr = jsonStr.replace('-->', '');
        jsonStr = jsonStr.trim();
        var json = JSON.parse(jsonStr);
        if (json.font_style){
            fontStyle = json.font_style;
        }
    } catch (error) {

    }
    var horDiv = document.getElementById('customeHorizonal');
    if (!horDiv) {
        horDiv = document.createElement('div');
        horDiv.id = "customeHorizonal";
        horDiv.className = "customeHorizonal";
        noteEl = document.getElementById('expCustomNotechild');
        noteEl.appendChild(horDiv);
    }
    var noteDiv = document.getElementById('customeNoteText');
    if (!noteDiv) {
        noteDiv = document.createElement('div');
        noteDiv.id = "customeNoteText";
        noteDiv.className = "customeNoteText";
        horDiv.appendChild(noteDiv);
    }
    noteDiv.style.fontWeight = 'normal';
    noteDiv.innerHTML = result0;

    if (regex.test(noteString)) {
        regex.lastIndex = 0;
        var result1 = regex.exec(noteString);
        var mediaString = result1[1];
        insertRichMedia(mediaString, skipImage);
    }
}

function insertRichMedia(mediaString, skipImage) {
    var files = JSON.parse(mediaString);
    var noteEl = document.getElementById('expCustomNotechild');
    if (!skipImage && files.image_list != undefined && files.image_list.length > 0) {
        var horDiv = document.getElementById('customeHorizonal');
        var container = document.getElementById('customeNoteImageContainer');
        if (!container) {
            container = document.createElement('div');
            container.id = 'customeNoteImageContainer';
            container.className = 'customeNoteImageContainer';
            horDiv.appendChild(container);
        }

        var imgsEl = document.getElementById('customeNoteImage');
        if (!imgsEl)
        {
            imgsEl = new Image(100,75);
            imgsEl.id = 'customeNoteImage';
            imgsEl.className = 'customeNoteImage';
            container.appendChild(imgsEl);
            imgsEl.onclick = function() {
                window.location.href = "cmd://showNoteImages";
            }
        }
        var countDiv = document.getElementById('customeNoteImageNumber');
        if (!countDiv) {
            countDiv = document.createElement('div');
            countDiv.id = 'customeNoteImageNumber';
            countDiv.className = 'customeNoteImageNumber';
            container.appendChild(countDiv);
        }
        countDiv.innerText = '共' + files.image_list.length + '张';
        if (files.image_list[0].thumb !== "")
        {
            src = files.image_list[0].thumb;
            //这里是为了帮助iOS能拦截笔记图片，进而做缓存
            if (navigator.userAgent.match(/(iPhone|iPod|iPad);?/i)) {
                src = src.replace('http://', 'eudic-http://');
                src = src.replace('https://', 'eudic-https://');
                src = src.replace('file://', 'eudic-file://');
            }
            if (src.indexOf('?') === -1) {
                imgsEl.src = src + '?needpreload=true';
            } else {
                imgsEl.src = src + '&needpreload=true';
            }

        }
    }

    if (files.voice_list != undefined && files.voice_list.length > 0) {
        var voiceDiv = document.getElementById('customeNoteVoices');
        if (!voiceDiv)
        {
            voiceDiv = document.createElement('div');
            voiceDiv.id = 'customeNoteVoices';
            voiceDiv.className = 'customeNoteVoices';
            noteEl.appendChild(voiceDiv);
        }

        var count = 0;
        if (document.getElementsByClassName("customeNoteSingleVoice")) {
            count = document.getElementsByClassName("customeNoteSingleVoice").length;
        }

        var audio = document.getElementById('noteAudio');
        if (!audio) {
            audio = document.createElement('audio');
            audio.id = 'noteAudio';
            voiceDiv.appendChild(audio);
        }

        for (var i = 0; i < files.voice_list.length; i++) {
            if (files.voice_list[i].url !== "" && i >= count)
            {
                voDiv = document.createElement("div");
                voDiv.setAttribute("onclick","notePlayVoice(this)")
                voDiv.id = "customeNoteSingleVoice-" + i;
                voDiv.className = "customeNoteSingleVoice";
                voDiv.setAttribute('data-url', files.voice_list[i].url);
                voiceDiv.appendChild(voDiv);
                durDiv = document.createElement("div");
                durDiv.className = "customeNoteSingleVoiceDuration";
                durDiv.innerText = files.voice_list[i].duration + '’’';
                imgDiv = new Image(20, 20);
                imgDiv.className = 'customeNoteSingleVoiceImg';
                imgDiv.src = "record_voice_3.png";
                voDiv.appendChild(durDiv);
                voDiv.appendChild(imgDiv);
            }
        }
    }
}
function notePlayVoice(e){
    var vs = document.getElementsByClassName('customeNoteSingleVoice');
    for (var i=0; i<vs.length; i++) {
        var t = vs[i];
        if (t.timers) {
            var imgDom = t.getElementsByClassName("customeNoteSingleVoiceImg")[0];
            imgDom.setAttribute("src", "record_voice_3.png");
            clearInterval(t.timers);
            t.timers = null;
        }
    }

    var audio = document.getElementById('noteAudio');
    audio.src = e.getAttribute('data-url');
    audio.pause();
    audio.play();
    noteVoiceAnimate(e,audio);
}

function noteVoiceAnimate(tag, audio) {
    var _self = tag;
    var imgDom = tag.getElementsByClassName("customeNoteSingleVoiceImg")[0];
    var index = 1;
    tag.timers = setInterval(function () {
        imgDom.setAttribute("src", "record_voice_" + index + ".png");
        index++;
        if (index > 3) {
            index = 1;
        }
        if (audio.paused) {
            imgDom.setAttribute("src", "record_voice_3.png");
            clearInterval(_self.timers);
            _self.timers = null;
        }
    }, 500);
}

function getLastTranslationResult() {
    var transEls = document.getElementsByClassName('transResult')
    if (transEls && transEls.length > 0)
    {
        return transEls[0].innerText
    }
}
//fastclick
(function(){function d(o,k){var p;k=k||{};this.trackingClick=false;this.trackingClickStart=0;this.targetElement=null;this.touchStartX=0;this.touchStartY=0;this.lastTouchIdentifier=0;this.touchBoundary=k.touchBoundary||10;this.layer=o;this.tapDelay=k.tapDelay||200;this.tapTimeout=k.tapTimeout||700;if(d.notNeeded(o)){return;}function q(l,i){return function(){return l.apply(i,arguments);};}var j=["onMouse","onClick","onTouchStart","onTouchMove","onTouchEnd","onTouchCancel"];var n=this;for(var m=0,h=j.length;m<h;m++){n[j[m]]=q(n[j[m]],n);}if(b){o.addEventListener("mouseover",this.onMouse,true);o.addEventListener("mousedown",this.onMouse,true);o.addEventListener("mouseup",this.onMouse,true);}o.addEventListener("click",this.onClick,true);o.addEventListener("touchstart",this.onTouchStart,false);o.addEventListener("touchmove",this.onTouchMove,false);o.addEventListener("touchend",this.onTouchEnd,false);o.addEventListener("touchcancel",this.onTouchCancel,false);if(!Event.prototype.stopImmediatePropagation){o.removeEventListener=function(l,s,i){var r=Node.prototype.removeEventListener;if(l==="click"){r.call(o,l,s.hijacked||s,i);}else{r.call(o,l,s,i);}};o.addEventListener=function(r,s,l){var i=Node.prototype.addEventListener;if(r==="click"){i.call(o,r,s.hijacked||(s.hijacked=function(t){if(!t.propagationStopped){s(t);}}),l);}else{i.call(o,r,s,l);}};}if(typeof o.onclick==="function"){p=o.onclick;o.addEventListener("click",function(i){p(i);},false);o.onclick=null;}}var c=navigator.userAgent.indexOf("Windows Phone")>=0;var b=navigator.userAgent.indexOf("Android")>0&&!c;var g=/iP(ad|hone|od)/.test(navigator.userAgent)&&!c;var e=g&&(/OS 4_\d(_\d)?/).test(navigator.userAgent);var f=g&&(/OS [6-7]_\d/).test(navigator.userAgent);var a=navigator.userAgent.indexOf("BB10")>0;d.prototype.needsClick=function(h){switch(h.nodeName.toLowerCase()){case"button":case"select":case"textarea":if(h.disabled){return true;}break;case"input":if((g&&h.type==="file")||h.disabled){return true;}break;case"label":case"iframe":case"video":return true;}return(/\bneedsclick\b/).test(h.className);};d.prototype.needsFocus=function(h){switch(h.nodeName.toLowerCase()){case"textarea":return true;case"select":return !b;case"input":switch(h.type){case"button":case"checkbox":case"file":case"image":case"radio":case"submit":return false;}return !h.disabled&&!h.readOnly;default:return(/\bneedsfocus\b/).test(h.className);}};d.prototype.sendClick=function(i,j){var h,k;if(document.activeElement&&document.activeElement!==i){document.activeElement.blur();}k=j.changedTouches[0];h=document.createEvent("MouseEvents");h.initMouseEvent(this.determineEventType(i),true,true,window,1,k.screenX,k.screenY,k.clientX,k.clientY,false,false,false,false,0,null);h.forwardedTouchEvent=true;i.dispatchEvent(h);};d.prototype.determineEventType=function(h){if(b&&h.tagName.toLowerCase()==="select"){return"mousedown";}return"click";};d.prototype.focus=function(h){var i;if(g&&h.setSelectionRange&&h.type.indexOf("date")!==0&&h.type!=="time"&&h.type!=="month"){i=h.value.length;h.setSelectionRange(i,i);}else{h.focus();}};d.prototype.updateScrollParent=function(i){var j,h;j=i.fastClickScrollParent;if(!j||!j.contains(i)){h=i;do{if(h.scrollHeight>h.offsetHeight){j=h;i.fastClickScrollParent=h;break;}h=h.parentElement;}while(h);}if(j){j.fastClickLastScrollTop=j.scrollTop;}};d.prototype.getTargetElementFromEventTarget=function(h){if(h.nodeType===Node.TEXT_NODE){return h.parentNode;}return h;};d.prototype.onTouchStart=function(j){var h,k,i;if(j.targetTouches.length>1){return true;}h=this.getTargetElementFromEventTarget(j.target);k=j.targetTouches[0];if(g){i=window.getSelection();if(i.rangeCount&&!i.isCollapsed){return true;}if(!e){if(k.identifier&&k.identifier===this.lastTouchIdentifier){j.preventDefault();return false;}this.lastTouchIdentifier=k.identifier;this.updateScrollParent(h);}}this.trackingClick=true;this.trackingClickStart=j.timeStamp;this.targetElement=h;this.touchStartX=k.pageX;this.touchStartY=k.pageY;if((j.timeStamp-this.lastClickTime)<this.tapDelay){j.preventDefault();}return true;};d.prototype.touchHasMoved=function(h){var j=h.changedTouches[0],i=this.touchBoundary;if(Math.abs(j.pageX-this.touchStartX)>i||Math.abs(j.pageY-this.touchStartY)>i){return true;}return false;};d.prototype.onTouchMove=function(h){if(!this.trackingClick){return true;}if(this.targetElement!==this.getTargetElementFromEventTarget(h.target)||this.touchHasMoved(h)){this.trackingClick=false;this.targetElement=null;}return true;};d.prototype.findControl=function(h){if(h.control!==undefined){return h.control;}if(h.htmlFor){return document.getElementById(h.htmlFor);}return h.querySelector("button, input:not([type=hidden]), keygen, meter, output, progress, select, textarea");};d.prototype.onTouchEnd=function(j){var l,k,i,n,m,h=this.targetElement;if(!this.trackingClick){return true;}if((j.timeStamp-this.lastClickTime)<this.tapDelay){this.cancelNextClick=true;return true;}if((j.timeStamp-this.trackingClickStart)>this.tapTimeout){return true;}this.cancelNextClick=false;this.lastClickTime=j.timeStamp;k=this.trackingClickStart;this.trackingClick=false;this.trackingClickStart=0;if(f){m=j.changedTouches[0];h=document.elementFromPoint(m.pageX-window.pageXOffset,m.pageY-window.pageYOffset)||h;h.fastClickScrollParent=this.targetElement.fastClickScrollParent;}i=h.tagName.toLowerCase();if(i==="label"){l=this.findControl(h);if(l){this.focus(h);if(b){return false;}h=l;}}else{if(this.needsFocus(h)){if((j.timeStamp-k)>100||(g&&window.top!==window&&i==="input")){this.targetElement=null;return false;}this.focus(h);this.sendClick(h,j);if(!g||i!=="select"){this.targetElement=null;j.preventDefault();}return false;}}if(g&&!e){n=h.fastClickScrollParent;if(n&&n.fastClickLastScrollTop!==n.scrollTop){return true;}}if(!this.needsClick(h)){j.preventDefault();this.sendClick(h,j);}return false;};d.prototype.onTouchCancel=function(){this.trackingClick=false;this.targetElement=null;};d.prototype.onMouse=function(h){if(!this.targetElement){return true;}if(h.forwardedTouchEvent){return true;}if(!h.cancelable){return true;}if(!this.needsClick(this.targetElement)||this.cancelNextClick){if(h.stopImmediatePropagation){h.stopImmediatePropagation();}else{h.propagationStopped=true;}h.stopPropagation();h.preventDefault();return false;}return true;};d.prototype.onClick=function(h){var i;if(this.trackingClick){this.targetElement=null;this.trackingClick=false;return true;}if(h.target.type==="submit"&&h.detail===0){return true;}i=this.onMouse(h);if(!i){this.targetElement=null;}return i;};d.prototype.destroy=function(){var h=this.layer;if(b){h.removeEventListener("mouseover",this.onMouse,true);h.removeEventListener("mousedown",this.onMouse,true);h.removeEventListener("mouseup",this.onMouse,true);}h.removeEventListener("click",this.onClick,true);h.removeEventListener("touchstart",this.onTouchStart,false);h.removeEventListener("touchmove",this.onTouchMove,false);h.removeEventListener("touchend",this.onTouchEnd,false);h.removeEventListener("touchcancel",this.onTouchCancel,false);};d.notNeeded=function(i){var h;var l;var k;var j;if(typeof window.ontouchstart==="undefined"){return true;}l=+(/Chrome\/([0-9]+)/.exec(navigator.userAgent)||[,0])[1];if(l){if(b){h=document.querySelector("meta[name=viewport]");if(h){if(h.content.indexOf("user-scalable=no")!==-1){return true;}if(l>31&&document.documentElement.scrollWidth<=window.outerWidth){return true;}}}else{return true;}}if(a){k=navigator.userAgent.match(/Version\/([0-9]*)\.([0-9]*)/);if(k[1]>=10&&k[2]>=3){h=document.querySelector("meta[name=viewport]");if(h){if(h.content.indexOf("user-scalable=no")!==-1){return true;}if(document.documentElement.scrollWidth<=window.outerWidth){return true;}}}}if(i.style.msTouchAction==="none"||i.style.touchAction==="manipulation"){return true;}j=+(/Firefox\/([0-9]+)/.exec(navigator.userAgent)||[,0])[1];if(j>=27){h=document.querySelector("meta[name=viewport]");if(h&&(h.content.indexOf("user-scalable=no")!==-1||document.documentElement.scrollWidth<=window.outerWidth)){return true;}}if(i.style.touchAction==="none"||i.style.touchAction==="manipulation"){return true;}return false;};d.attach=function(i,h){return new d(i,h);};if(typeof define==="function"&&typeof define.amd==="object"&&define.amd){define(function(){return d;});}else{if(typeof module!=="undefined"&&module.exports){module.exports=d.attach;module.exports.FastClick=d;}else{window.FastClick=d;}}}());


/* 高亮标记代码 开始 */
var highlightId = "data-uuid";
var highlightName = 'eudic-annotation';
var highlightNightColor = '#454545';

//高亮 选中区域
function strikeSelection(color) {
    if (typeof window.getSelection !== 'undefined') {
        var selection = window.getSelection();
        if (selection.rangeCount === 0) {
            return;
        }

        var range = selection.getRangeAt(0);
        if (!isValidHighlightRange(range)) {
            return '__RANGE_ERROR__';
        }
        else {
            var customParentNode = eudic_getSelectionParentCustomNode(selection);
            var d = new Date();
            var timeStamp = d.getTime().toString();
            var comment = new Object();
            comment.text = selection.toString();
            var selTxt = hpath(range.startContainer) + '|' + range.startOffset + '|' + hpath(range.endContainer) + '|' + range.endOffset
                 + '|' + color + '|' + highlightId +'=' + timeStamp + '|' + JSON.stringify(comment);
            selTxt = selTxt.replace(/(\/EUDIC\[.*?\])/g,'')
            if (gPlatform == 'ios') {
                document.getElementById('viewport').setAttribute('content', 'initial-scale=1.0, minimum-scale=1.0,  maximum-scale=1.0, shrink-to-fit=no');
            } else if (gPlatform == 'android') {
                window.location.href = 'cmd://highLightRange?' + selTxt;
            }
            document.designMode = 'on';
            document.execCommand('strikeThrough', false, '');
            //如果设置过id，这里恢复
            if (customParentNode){
                customParentNode.id = '';
            }
            document.designMode = 'off';
            if (gPlatform == 'ios') {
                document.getElementById('viewport').setAttribute('content', 'initial-scale=1.0, minimum-scale=1.0, shrink-to-fit=no');
            }
            if (gPlatform != 'android') {
                selection.removeAllRanges();
            }
            setStrikeAttribute(timeStamp, color);
            return selTxt;
        }
    }
}

function isValidHighlightRange(range)
{
    if (range != null) {
        var ancNode = range.commonAncestorContainer;
        if (ancNode && !(/body/i).test(ancNode.tagName) && !(/expBody/i).test(ancNode.id) && !(/revMainContent/i).test(ancNode.id)) {
            return true;
        }
    }
    return false;
}

//记录已经恢复成功的高亮data-uuid
var restoredSection = [];
function restoreHighLight(selectionDetailsList, sectionId) {
    if (selectionDetailsList != null) {
        //更新老版本高亮颜色
        selectionDetailsList = selectionDetailsList.replace(/#fdf2a0/gi, '#FFFF00');
        selectionDetailsList = selectionDetailsList.replace(/(\/EUDIC\[.*?\])/g,'');
        selectionDetailsList = selectionDetailsList.split('$');
        var i = 0;
        if (gPlatform == 'ios') {
            document.getElementById('viewport').setAttribute('content', 'initial-scale=1.0, minimum-scale=1.0,  maximum-scale=1.0, shrink-to-fit=no');
        }
        document.designMode = 'on';
        for (i = 0; i < selectionDetailsList.length; i++) {
            if (sectionId !== '' && sectionId.indexOf('null') == -1 && selectionDetailsList[i].indexOf(sectionId) == -1)
            {
                continue;
            }
            var selectionDetails = selectionDetailsList[i].split('|');
            if (typeof window.getSelection != 'undefined' && selectionDetails.length > 3) {
                try {
                    var selectionDataUuid = '';
                    if (selectionDetails.length > 6) {
                        selectionDataUuid = selectionDetails[5].match(/data-uuid=(\w+)/)[1];
                    }
                    //跳过已经还原的项目
                    if (selectionDataUuid.length > 0 && restoredSection.indexOf(selectionDataUuid) >= 0){
                        continue;
                    }
                    var selection = window.getSelection();
                    selection.removeAllRanges();

                    var range = document.createRange();
                    var startSingleNode = document.evaluate(selectionDetails[0], document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
                    var startSelectionLength = Number(selectionDetails[1]);
                    if (startSingleNode && startSelectionLength > startSingleNode.length){
                        startSelectionLength = startSingleNode.length;
                    }
                    if (startSingleNode){
                        range.setStart(startSingleNode, startSelectionLength);
                    }else{
                        console.log('高亮恢复错误，原因: startSingleNode 不存在');
                    }
                    var endSingleNode = document.evaluate(selectionDetails[2], document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
                    var endSelectionLength = Number(selectionDetails[3]);
                    if (endSingleNode && endSelectionLength > endSingleNode.length){
                        endSelectionLength = endSingleNode.length;
                    }
                    if (endSingleNode){
                        range.setEnd(endSingleNode, endSelectionLength);
                    }else{
                        console.log('高亮恢复错误，原因: endSingleNode 不存在');
                    }

                    //由于EUDIC-10409，部分词库做标记前设置了无法选中，导致了 selection 无法选中指定位置，一般用户做了标记时，都是词库内的js让用户可以选择了才做上去的
                    //这里强制先允许选中，标记完成后再恢复
                    var hasModifyAncestor = false;
                    if (range.commonAncestorContainer instanceof HTMLElement){
                        var rangeStyle = window.getComputedStyle(range.commonAncestorContainer)
                        if (rangeStyle.webkitUserSelect === 'none' || rangeStyle.userSelect === 'none' || rangeStyle.msUserSelect === 'none'){
                            range.commonAncestorContainer.style.setProperty('-webkit-user-select', 'auto', 'important');
                            range.commonAncestorContainer.style.setProperty('-moz-user-select', 'auto', 'important');
                            range.commonAncestorContainer.style.setProperty('-ms-user-select', 'auto', 'important');
                            range.commonAncestorContainer.style.setProperty('user-select', 'auto', 'important');
                            hasModifyAncestor = true;
                        }
                    }

                    selection.addRange(range);
                    //做删除线之前，拿到parentNode并加上id
                    var customParentNode = eudic_getSelectionParentCustomNode(selection);
                    document.execCommand('strikeThrough', false, '');
                    //如果设置过id，这里恢复
                    if (customParentNode){
                        customParentNode.id = '';
                    }
                    selection.removeAllRanges();

                    if (hasModifyAncestor){
                        range.commonAncestorContainer.style.removeProperty('-webkit-user-select');
                        range.commonAncestorContainer.style.removeProperty('-moz-user-select');
                        range.commonAncestorContainer.style.removeProperty('-ms-user-select');
                        range.commonAncestorContainer.style.removeProperty('user-select');
                    }

                    if (selectionDetails.length > 6) {
                        var timeStamp = selectionDataUuid;
                        if (selectionDetails[6].match('"has_comment":true')) {//定死字段
                            setStrikeAttribute(timeStamp, selectionDetails[4], 'true');
                        } else {
                            setStrikeAttribute(timeStamp, selectionDetails[4]);
                        }
                    } else {//向后兼容
                        setStrikeAttribute(i, selectionDetails[4]);
                    }
                } catch (e) {
                    console.log('高亮错误' + e);
                }
            }
        }
    }
    document.designMode = 'off';
    if (gPlatform == 'ios') {
        document.getElementById('viewport').setAttribute('content', 'initial-scale=1.0, minimum-scale=1.0, shrink-to-fit=no');
    }
    var allStrikeList = document.getElementsByClassName('eudic-annotation-class');
    for (var i = 0; i < allStrikeList.length; i++){
        var strikeItem = allStrikeList[i];
        var dataUuid = strikeItem.getAttribute('data-uuid');
        if (dataUuid && dataUuid.length > 0){
            restoredSection.push(dataUuid);
        }
    }
}

//EUDIC-9947 在给没有指定id或class的 <span> 做删除线时，会把当前这个 span 直接删除，导致后面做的高亮位置都不正确，这里强制给span指定一个id，并返回
function eudic_getSelectionParentCustomNode(selection){
    var customParentNode = undefined;
    //在给没有指定id或class的 <span> 做删除线时，会把当前这个 span 直接删除，导致后面做的高亮位置都不正确，这里强制给span指定一个id
    if (selection.anchorNode && selection.anchorNode.parentNode && (selection.anchorNode.parentNode instanceof HTMLSpanElement)){
        customParentNode = selection.anchorNode.parentNode;
        if (customParentNode.id.length === 0 && customParentNode.className.length === 0){
            //名字无所谓，只要有属性就不会被删除线删除
            customParentNode.id = 'eudic_span_' + new Date().getTime();
        }else{
            customParentNode = undefined;
        }
    }
    return customParentNode;
}

function hpath(node, currentPath) {
    currentPath = currentPath || '';
    if (node.className == 'explain_wrap' || node.className == 'explain_wrap_styleless')
        return '//DIV[@id=\"' + node.id + '\"]/' + currentPath;
    switch (node.nodeType) {
        case 3:
        case 4:
            return hpath(node.parentNode, 'text()[' + (document.evaluate('preceding-sibling::text()', node, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null).snapshotLength + 1) + ']');
        case 1:
            try {
                var preceding = document.evaluate('preceding-sibling::' + node.nodeName, node, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
            return hpath(node.parentNode, node.nodeName + '[' + (preceding.snapshotLength + 1) + ']' + (currentPath ? '/' + currentPath : ''));
            } catch (error) {
                
            }
            return ''
        case 9:
            return '/' + currentPath;
        default:
            return '';
    }
}

//修改 选中区域内，所有标记的颜色
function changeStrikeSelection(color) {
    var tags = getSelectedElements();
    var timestamps = [];
    if (tags.length == 1) {
        var oneTag = tags[0];
        while(oneTag) {
            if (oneTag.getAttribute('name') === highlightName) {
                var sign = oneTag.getAttribute(highlightId);
                timestamps.push(sign);
                setStrikeColor(sign, color);
                break;
            } else {
                oneTag = oneTag.parentElement;
            }
        }
    } else {
        for (var i = 0, el; el = tags[i]; i++) {
            if (el.getAttribute('name')) {
                var sign = el.getAttribute(highlightId);
                timestamps.push(sign);
                setStrikeColor(sign, color);
            }
        }
    }
    return timestamps.toString();
}

//修改 指定标记的dom节点 的颜色
function setStrikeColor(timeStamp, color) {
    var tags = document.getElementsByName(highlightName)
    for (var i = 0; i < tags.length; i++) {
        var tag = tags[i];
        if (tag.getAttribute(highlightId) === timeStamp) {
            setStrikeColorStyle(tag, color);
             if (hasClass(tag.nextSibling, 'strikeComment')) {
                tag.nextSibling.style.color = RGBColor(tag.style.backgroundColor).toStrikeCommentColor();
            }
        }
    }
    return tags;
}

//设置 未带标识的strike标签 的标志，及颜色。
function setStrikeAttribute(timeStamp, color, hasComment) {
    var tags = document.getElementsByTagName('strike');
    var lasttag = null;
    for (var i = 0; i < tags.length; i++) {
        var tag = tags[i];
        tag.className = 'eudic-annotation-class';
        if (tag.getAttribute('name') === null) {
            tag.setAttribute('name', highlightName);
            tag.setAttribute(highlightId, timeStamp);
            setStrikeColorStyle(tag, color);
        }
        if (tag.getAttribute(highlightId) === timeStamp) {
        	lasttag = tag;
        }
    }
    if (lasttag) {
    	setStrikeCommentStyle(lasttag, hasComment);
    }
    return tags;
}

//修改 特定标记 的颜色，以及标注状态
function changeStrikeAtrribute(timeStamp, color, hasComment) {
    var tags = document.getElementsByName(highlightName);
    var lasttag = null;
    for (var i = 0; i < tags.length; i++) {
        var tag = tags[i];
        if (tag.getAttribute(highlightId) === timeStamp) {
            setStrikeColorStyle(tag, color);
            lasttag = tag;
        }
    }
    if (lasttag) {
        setStrikeCommentStyle(lasttag, hasComment);
    }
    return tags;
}

function setStrikeColorStyle (tag, color) {
    if ((typeof(color) !== undefined) && (color !== 'default')) { //oc 传递参数只有字符串,default就不改动
        var theme = document.body.className;
        tag.style.backgroundColor = color;
        if (theme && (theme.indexOf('night') >= 0 || theme.indexOf('black') >=0))
        {
            tag.style.color = highlightNightColor;
        }
    }
}

function setStrikeCommentStyle (tag, hasComment) {
    var nextSibling = tag.nextSibling || tag;
    if (hasComment == null || hasComment === 'false'|| hasComment === '0') {
        if (hasClass(nextSibling, 'strikeComment'))
        {
            var el = nextSibling;
            el.parentNode.removeChild(el);
        }
    } else {
        if (!hasClass(nextSibling, 'strikeComment')) {
            var commentIcon = document.createElement('span');
            commentIcon.className = 'icon-web-comment-icon strikeComment';
            commentIcon.style.color = RGBColor(tag.style.backgroundColor).toStrikeCommentColor();
            commentIcon.addEventListener('click', function() {window.location = 'cmd://highlight/comment/' + tag.getAttribute(highlightId);})

            if (nextSibling === tag) {
                tag.parentNode.appendChild(commentIcon);
            } else {
                tag.parentNode.insertBefore(commentIcon, tag.nextSibling);
            }
        }
    }
}

//移除 选中内所有的标记
function removeSeletedStrike() {
    var tags = getSelectedElements();
    var timestamps = [];

    if (tags.length == 1) {
        //当只有一个时，一直往上遍历父节点，查找到有标记的父节点，再进行删除操作。
        //否则会有部分标签，比如button标签，无法直接查找到。
        var oneTag = tags[0];
        while(oneTag) {
            if (oneTag.getAttribute('name') === highlightName) {
                var sign = oneTag.getAttribute(highlightId);
                timestamps.push(sign);
                removeStrike(sign);
                break;
            } else {
                oneTag = oneTag.parentElement;
            }
        }
    } else {
        for (var i = 0, el; el = tags[i]; i++) {
            if (el.getAttribute('name')) {
                var sign = el.getAttribute(highlightId);
                timestamps.push(sign);
                removeStrike(sign);
            }
        }
    }
    return timestamps.toString();
}

//返回所有选中区域的dom
function getSelectedElements() {
    // http://stackoverflow.com/questions/4220478/get-all-dom-block-elements-for-selected-texts
    var selection = window.getSelection();
    if (selection.rangeCount === 0) {
        return [];
    }
    var range = selection.getRangeAt(0);
    var commonDiv = range.commonAncestorContainer;
    if (commonDiv.childNodes.length == 0) {
        return [commonDiv.parentElement];
    }

    var allWithinRangeParent = commonDiv.getElementsByTagName("*");
    var allSelected = [];
    for (var i = 0, el; el = allWithinRangeParent[i]; i++) {
        // The second parameter says to include the element
        // even if it's not fully selected
        if (selection.containsNode(el, true)) {
            allSelected.push(el);
        }
    }
    var list = [];
    for (node in allSelected) {
        if (allSelected[node].childElementCount > 0) {;}
        else {
            list.push(allSelected[node]);
        }
    }
    return list;
}

function selectedInCustomNote() {
    var list = getSelectedElements()
    for (var i=0, el; el = list[i]; i++) {
        var parentE = el;
        while (parentE.parentElement.nodeName != 'BODY') {
            if (parentE.getAttribute('id') === 'expCustomNote') {
                return true;
            }
            parentE = parentE.parentElement;
        }
    }
    return false;
}

//移除 含有对应标志dom节点
function removeStrike(sign) {
    var tags = document.getElementsByName(highlightName)
    var index = 0;
    while (index < tags.length){
        var newTag = tags[index];
        //在词典中，某些tag一旦replace，那么tags的就会移除一个tag，导致遗漏一个查找。此时不增加index。
        if (newTag.getAttribute(highlightId) === sign || sign == 'all') {
            setStrikeCommentStyle(newTag, 'false');
            if (newTag.childElementCount > 0){
                removeSelf(newTag);
            }
            else if ( typeof(newTag.replaceWith) === 'undefined') {
                removeSelf(newTag);
            } else {
                newTag.replaceWith(newTag.innerText);
            }
        } else {
            index ++;
        }
    }
    return tags;
}

//查询 是否含有高亮内容
function hasHighlight() {
    var tags = getSelectedElements();
    for (var i = 0, el; el = tags[i]; i++) {
        var timestamp = getParentHighlightId(el);
        if (timestamp.length > 0) {
            return timestamp;
        }
    }
    return '';
}

function getParentHighlightId(tag) {
    while(tag) {
        if (tag.getAttribute('name') === highlightName) {
            return tag.getAttribute(highlightId);
        } else {
            tag = tag.parentElement;
        }
    }
    return '';
}

//删除 自身节点，保留子节点。
function removeSelf(node) {
    while (node.firstChild) {
        node.parentNode.insertBefore(node.firstChild, node);
    }
    node.parentNode.removeChild(node);
}

//返回 选中区域rect
function getRangeRect() {
    if (typeof window.getSelection != 'undefined') {
        var selection = window.getSelection();
        var range = selection.getRangeAt(0);
        if (range != null) {
            var node = document.getElementById("expBody");
            if (node == null){
                node = document.getElementById("revMainContent");
            }
            var zoomRatio = document.body.getBoundingClientRect().width / node.getBoundingClientRect().width;
            var offset = range.getBoundingClientRect();
            var rect = {
            top: zoomRatio * (offset.boundingTop || offset.top),
            left: zoomRatio * (offset.boundingLeft || offset.left),
            width: zoomRatio * (range.boundingWidth || offset.width),
            height: zoomRatio * (range.boundingHeight || offset.height),
            }
            window.location.href = 'cmd://highlight/rect/' + JSON.stringify(rect);
            return "{{" + rect.left + "," + rect.top + "}, {" + rect.width + "," + rect.height + "}}"
        }
    }
}

//监听选中区域变化
function selectChangeFun() {
    var t = selectedText();
    if (!!t) {
        if (gPlatform === 'android') {
            window.TextSelection.textChanged(t);
        }
        var highlightId = hasHighlight();
        if (highlightId.length > 0) {
            window.location.href = 'cmd://highlight/select/' + highlightId;
        } else {
            window.location.href = 'cmd://highlight/select/none';
        }
    }
    else if (gPlatform === 'ios')
    {
        window.location.href = 'cmd://highlight/select/noselection';
    }
}

function selectedText() {
    return window.getSelection().toString();
}
/* 高亮标记代码 结束 */

// nightmode

if (!String.prototype.startsWith) {
    String.prototype.startsWith = function(search, pos) {
        return this.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
    };
}
if (!String.prototype.endsWith) {
    String.prototype.endsWith = function(search, this_len) {
        if (this_len === undefined || this_len > this.length) {
            this_len = this.length;
        }
        return this.substring(this_len - search.length, this_len) === search;
    };
}
if (!String.prototype.trim) {
    String.prototype.trim = function () {
      return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
    };
}
if (!Array.prototype.find) {
    Object.defineProperty(Array.prototype, 'find', {
      value: function(predicate) {
       // 1. Let O be ? ToObject(this value).
        if (this == null) {
          throw new TypeError('"this" is null or not defined');
        }

        var o = Object(this);

        // 2. Let len be ? ToLength(? Get(O, "length")).
        var len = o.length >>> 0;

        // 3. If IsCallable(predicate) is false, throw a TypeError exception.
        if (typeof predicate !== 'function') {
          throw new TypeError('predicate must be a function');
        }

        // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
        var thisArg = arguments[1];

        // 5. Let k be 0.
        var k = 0;

        // 6. Repeat, while k < len
        while (k < len) {
          // a. Let Pk be ! ToString(k).
          // b. Let kValue be ? Get(O, Pk).
          // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
          // d. If testResult is true, return kValue.
          var kValue = o[k];
          if (predicate.call(thisArg, kValue, k, o)) {
            return kValue;
          }
          // e. Increase k by 1.
          k++;
        }

        // 7. Return undefined.
        return undefined;
      },
      configurable: true,
      writable: true
    });
  }
var knownColors = {
    aliceblue: 0xf0f8ff,
    antiquewhite: 0xfaebd7,
    aqua: 0x00ffff,
    aquamarine: 0x7fffd4,
    azure: 0xf0ffff,
    beige: 0xf5f5dc,
    bisque: 0xffe4c4,
    black: 0x000000,
    initial: 0x000000,
    blanchedalmond: 0xffebcd,
    blue: 0x0000ff,
    blueviolet: 0x8a2be2,
    brown: 0xa52a2a,
    burlywood: 0xdeb887,
    cadetblue: 0x5f9ea0,
    chartreuse: 0x7fff00,
    chocolate: 0xd2691e,
    coral: 0xff7f50,
    cornflowerblue: 0x6495ed,
    cornsilk: 0xfff8dc,
    crimson: 0xdc143c,
    cyan: 0x00ffff,
    darkblue: 0x00008b,
    darkcyan: 0x008b8b,
    darkgoldenrod: 0xb8860b,
    darkgray: 0xa9a9a9,
    darkgrey: 0xa9a9a9,
    darkgreen: 0x006400,
    darkkhaki: 0xbdb76b,
    darkmagenta: 0x8b008b,
    darkolivegreen: 0x556b2f,
    darkorange: 0xff8c00,
    darkorchid: 0x9932cc,
    darkred: 0x8b0000,
    darksalmon: 0xe9967a,
    darkseagreen: 0x8fbc8f,
    darkslateblue: 0x483d8b,
    darkslategray: 0x2f4f4f,
    darkslategrey: 0x2f4f4f,
    darkturquoise: 0x00ced1,
    darkviolet: 0x9400d3,
    deeppink: 0xff1493,
    deepskyblue: 0x00bfff,
    dimgray: 0x696969,
    dimgrey: 0x696969,
    dodgerblue: 0x1e90ff,
    firebrick: 0xb22222,
    floralwhite: 0xfffaf0,
    forestgreen: 0x228b22,
    fuchsia: 0xff00ff,
    gainsboro: 0xdcdcdc,
    ghostwhite: 0xf8f8ff,
    gold: 0xffd700,
    goldenrod: 0xdaa520,
    gray: 0x808080,
    grey: 0x808080,
    green: 0x008000,
    greenyellow: 0xadff2f,
    honeydew: 0xf0fff0,
    hotpink: 0xff69b4,
    indianred: 0xcd5c5c,
    indigo: 0x4b0082,
    ivory: 0xfffff0,
    khaki: 0xf0e68c,
    lavender: 0xe6e6fa,
    lavenderblush: 0xfff0f5,
    lawngreen: 0x7cfc00,
    lemonchiffon: 0xfffacd,
    lightblue: 0xadd8e6,
    lightcoral: 0xf08080,
    lightcyan: 0xe0ffff,
    lightgoldenrodyellow: 0xfafad2,
    lightgray: 0xd3d3d3,
    lightgrey: 0xd3d3d3,
    lightgreen: 0x90ee90,
    lightpink: 0xffb6c1,
    lightsalmon: 0xffa07a,
    lightseagreen: 0x20b2aa,
    lightskyblue: 0x87cefa,
    lightslategray: 0x778899,
    lightslategrey: 0x778899,
    lightsteelblue: 0xb0c4de,
    lightyellow: 0xffffe0,
    lime: 0x00ff00,
    limegreen: 0x32cd32,
    linen: 0xfaf0e6,
    magenta: 0xff00ff,
    maroon: 0x800000,
    mediumaquamarine: 0x66cdaa,
    mediumblue: 0x0000cd,
    mediumorchid: 0xba55d3,
    mediumpurple: 0x9370db,
    mediumseagreen: 0x3cb371,
    mediumslateblue: 0x7b68ee,
    mediumspringgreen: 0x00fa9a,
    mediumturquoise: 0x48d1cc,
    mediumvioletred: 0xc71585,
    midnightblue: 0x191970,
    mintcream: 0xf5fffa,
    mistyrose: 0xffe4e1,
    moccasin: 0xffe4b5,
    navajowhite: 0xffdead,
    navy: 0x000080,
    oldlace: 0xfdf5e6,
    olive: 0x808000,
    olivedrab: 0x6b8e23,
    orange: 0xffa500,
    orangered: 0xff4500,
    orchid: 0xda70d6,
    palegoldenrod: 0xeee8aa,
    palegreen: 0x98fb98,
    paleturquoise: 0xafeeee,
    palevioletred: 0xdb7093,
    papayawhip: 0xffefd5,
    peachpuff: 0xffdab9,
    peru: 0xcd853f,
    pink: 0xffc0cb,
    plum: 0xdda0dd,
    powderblue: 0xb0e0e6,
    purple: 0x800080,
    rebeccapurple: 0x663399,
    red: 0xff0000,
    rosybrown: 0xbc8f8f,
    royalblue: 0x4169e1,
    saddlebrown: 0x8b4513,
    salmon: 0xfa8072,
    sandybrown: 0xf4a460,
    seagreen: 0x2e8b57,
    seashell: 0xfff5ee,
    sienna: 0xa0522d,
    silver: 0xc0c0c0,
    skyblue: 0x87ceeb,
    slateblue: 0x6a5acd,
    slategray: 0x708090,
    slategrey: 0x708090,
    snow: 0xfffafa,
    springgreen: 0x00ff7f,
    steelblue: 0x4682b4,
    tan: 0xd2b48c,
    teal: 0x008080,
    thistle: 0xd8bfd8,
    tomato: 0xff6347,
    turquoise: 0x40e0d0,
    violet: 0xee82ee,
    wheat: 0xf5deb3,
    white: 0xffffff,
    whitesmoke: 0xf5f5f5,
    yellow: 0xffff00,
    yellowgreen: 0x9acd32,
};

var systemColors = {
    ActiveBorder: 0x3b99fc,
    ActiveCaption: 0x000000,
    AppWorkspace: 0xaaaaaa,
    Background: 0x6363ce,
    ButtonFace: 0xffffff,
    ButtonHighlight: 0xe9e9e9,
    ButtonShadow: 0x9fa09f,
    ButtonText: 0x000000,
    CaptionText: 0x000000,
    GrayText: 0x7f7f7f,
    Highlight: 0xb2d7ff,
    HighlightText: 0x000000,
    InactiveBorder: 0xffffff,
    InactiveCaption: 0xffffff,
    InactiveCaptionText: 0x000000,
    InfoBackground: 0xfbfcc5,
    InfoText: 0x000000,
    Menu: 0xf6f6f6,
    MenuText: 0xffffff,
    Scrollbar: 0xaaaaaa,
    ThreeDDarkShadow: 0x000000,
    ThreeDFace: 0xc0c0c0,
    ThreeDHighlight: 0xffffff,
    ThreeDLightShadow: 0xffffff,
    ThreeDShadow: 0x000000,
    Window: 0xececec,
    WindowFrame: 0xaaaaaa,
    WindowText: 0x000000,
    '-webkit-focus-ring-color': 0xe59700
}

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

function hslToRGB(_ref) {
    var h = _ref.h,
        s = _ref.s,
        l = _ref.l,
        a = _ref.a;

    if (a === undefined) {
        a = 1;
    }
    if (s === 0) {
        var _map = [l, l, l].map(function (x) {
            return Math.round(x * 255);
        }),
            _map2 = _slicedToArray(_map, 3),
            r = _map2[0],
            b = _map2[1],
            g = _map2[2];

        return { r: r, g: g, b: b, a: a };
    }
    var c = (1 - Math.abs(2 * l - 1)) * s;
    var x = c * (1 - Math.abs(h / 60 % 2 - 1));
    var m = l - c / 2;

    var _map3 = (h < 60 ? [c, x, 0] : h < 120 ? [x, c, 0] : h < 180 ? [0, c, x] : h < 240 ? [0, x, c] : h < 300 ? [x, 0, c] : [c, 0, x]).map(function (n) {
        return Math.round((n + m) * 255);
    }),
        _map4 = _slicedToArray(_map3, 3),
        r = _map4[0],
        g = _map4[1],
        b = _map4[2];

    return { r: r, g: g, b: b, a: a };
}
var rgbMatch = /^rgba?\([^\(\)]+\)$/;
var hslMatch = /^hsla?\([^\(\)]+\)$/;
var hexMatch = /^#[0-9a-f]+$/i;
function parseColor($color) {
    var c = $color.trim().toLowerCase();
    if (c.match(rgbMatch)) {
        return parseRGB(c);
    }
    if (c.match(hslMatch)) {
        return parseHSL(c);
    }
    if (c.match(hexMatch)) {
        return parseHex(c);
    }
    if (knownColors[c] !== undefined) {
        return getColorByName(c);
    }
    if (systemColors[c] !== undefined) {
        return getSystemColor(c);
    }
    return { r: 255, g: 255, b: 255, a: 0 };
}
function objectEntries( obj ){
    var ownProps = Object.keys( obj ),
        i = ownProps.length,
        resArray = new Array(i); // preallocate the Array
    while (i--)
      resArray[i] = [ownProps[i], obj[ownProps[i]]];

    return resArray;
}
function getNumbersFromString(str, splitter, range, units) {
    var raw = str.split(splitter).filter(function (x) {
        return x;
    });
    var unitsList = objectEntries(units);
    var numbers = raw.map(function (r) {
        return r.trim();
    }).map(function (r, i) {
        var n = void 0;
        var unit = unitsList.find(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 1),
                u = _ref3[0];

            return r.endsWith(u);
        });
        if (unit) {
            n = parseFloat(r.substring(0, r.length - unit[0].length)) / unit[1] * range[i];
        } else {
            n = parseFloat(r);
        }
        if (range[i] > 1) {
            return Math.round(n);
        }
        return n;
    });
    return numbers;
}
var rgbSplitter = /rgba?|\(|\)|\/|,|\s/ig;
var rgbRange = [255, 255, 255, 1];
var rgbUnits = { '%': 100 };
function parseRGB($rgb) {
    var _getNumbersFromString = getNumbersFromString($rgb, rgbSplitter, rgbRange, rgbUnits),
        _getNumbersFromString2 = _slicedToArray(_getNumbersFromString, 4),
        r = _getNumbersFromString2[0],
        g = _getNumbersFromString2[1],
        b = _getNumbersFromString2[2],
        _getNumbersFromString3 = _getNumbersFromString2[3],
        a = _getNumbersFromString3 === undefined ? 1 : _getNumbersFromString3;

    return { r: r, g: g, b: b, a: a };
}
var hslSplitter = /hsla?|\(|\)|\/|,|\s/ig;
var hslRange = [360, 1, 1, 1];
var hslUnits = { '%': 100, 'deg': 360, 'rad': 2 * Math.PI, 'turn': 1 };
function parseHSL($hsl) {
    var _getNumbersFromString4 = getNumbersFromString($hsl, hslSplitter, hslRange, hslUnits),
        _getNumbersFromString5 = _slicedToArray(_getNumbersFromString4, 4),
        h = _getNumbersFromString5[0],
        s = _getNumbersFromString5[1],
        l = _getNumbersFromString5[2],
        _getNumbersFromString6 = _getNumbersFromString5[3],
        a = _getNumbersFromString6 === undefined ? 1 : _getNumbersFromString6;

    return hslToRGB({ h: h, s: s, l: l, a: a });
}
function parseHex($hex) {
    var h = $hex.substring(1);
    switch (h.length) {
        case 3:
        case 4:
            {
                var _map5 = [0, 1, 2].map(function (i) {
                    return parseInt('' + h[i] + h[i], 16);
                }),
                    _map6 = _slicedToArray(_map5, 3),
                    r = _map6[0],
                    g = _map6[1],
                    b = _map6[2];

                var a = h.length === 3 ? 1 : parseInt('' + h[3] + h[3], 16) / 255;
                return { r: r, g: g, b: b, a: a };
            }
        case 6:
        case 8:
            {
                var _map7 = [0, 2, 4].map(function (i) {
                    return parseInt(h.substring(i, i + 2), 16);
                }),
                    _map8 = _slicedToArray(_map7, 3),
                    r = _map8[0],
                    g = _map8[1],
                    b = _map8[2];

                var a = h.length === 6 ? 1 : parseInt(h.substring(6, 8), 16) / 255;
                return { r: r, g: g, b: b, a: a };
            }
    }
    return { r: 255, g: 255, b: 255, a: 0 };
}

function getColorByName($color) {
    var n = knownColors[$color];
    return {
        r: (n >> 16) & 255,
        g: (n >> 8) & 255,
        b: (n >> 0) & 255,
        a: 1
    };
}
function getSystemColor($color) {
    var n = systemColors[$color];
    return {
        r: (n >> 16) & 255,
        g: (n >> 8) & 255,
        b: (n >> 0) & 255,
        a: 1
    };
}

function getInverseColor(colorString){
    var red, green, blue;
    var result = parseColor(colorString);
    red = 255 - result.r;
    green = 255 - result.g;
    blue = 255 - result.b;
    return 'rgb(' + red.toString() + ',' + green.toString() + ',' + blue.toString() + ')';
}

function getFormatColor(colorString){
    var red, green, blue;
    var result = parseColor(colorString);
    red = result.r;
    green = result.g;
    blue = result.b;
    return 'rgb(' + red.toString() + ',' + green.toString() + ',' + blue.toString() + ')';
}
//反色，并指定是否使用alpha，目前只有背景色会使用alpha，否则一些词库（EUDIC-12022）会看不清。其他文本还是用写死的0.8
function getInverseAlphaColor(colorString, useAlpha){
    var red, green, blue, alpha;
    var result = parseColor(colorString);
    red = 255 - result.r;
    green = 255 - result.g;
    blue = 255 - result.b;
    alpha = result.a;
    if (!useAlpha){
        alpha = 0.8
    }
    // 稍微变暗一些 太暗也看不清了
    return 'rgba(' + red.toString() + ',' + green.toString() + ',' + blue.toString() + ',' + alpha.toString() + ')';
}

function getInverseColorIgnoreAlpha(colorString){
    var result = parseRGB(colorString);
    return 'rgb(' + result.r.toString() + ',' + result.g.toString() + ',' + result.b.toString() + ')';
    return getInverseColor(colorString);
}

//EUDIC-11614, EUDIC-11794将附加在body或html上的全局style重新补充回来
//移除代码位于c++的 LibMdx.cpp 的 "_remove "
function eudic_appendCompactRemovedBodyStyle() {
    //需要添加的rules
    var needAddRuleProperties = ['font-size', 'font-family', 'color', 'line-height'];
    //先拿到所有需要补充的rules
    var needAppendRules = [];
    for (var i = 0; i < document.styleSheets.length; i++){
        var styleSheetItem = document.styleSheets[i];
        try {
            for (var j = 0; j < styleSheetItem.rules.length; j++){
                var styleRuleItem = styleSheetItem.rules[j];
                if (styleRuleItem instanceof CSSStyleRule){
                    var trimSelectorText = styleRuleItem.selectorText.trim();
                    if (trimSelectorText.endsWith('eudic_compact_remove')){
                        needAppendRules.push(styleRuleItem);
                    }
                }
            }
        } catch (error) {
            console.log('cors error = ' + error)
        }
    }
    //根据rules里的selector，找到对应的dom
    for (var i = 0; i < needAppendRules.length; i++){
        var styleRuleItem = needAppendRules[i];
        //这么写是为了vscode能够识别出类型
        if (styleRuleItem instanceof CSSStyleRule){
            var removeEndSelector = styleRuleItem.selectorText.replace(new RegExp('eudic_compact_remove$'), '');
            var existStyleId = 'eudic_compact_style' + removeEndSelector;
            var existStyle = document.getElementById(existStyleId);
            if (existStyle){
                continue;
            }
            existStyle = document.createElement('style');
            existStyle.id = existStyleId;
            if (existStyle instanceof HTMLStyleElement){
                for (var j = 0; j < needAddRuleProperties.length; j ++){
                    //利用style来拿到所有需要的样式
                    var needAddProperty = needAddRuleProperties[j];
                    var propertyValue = styleRuleItem.style.getPropertyValue(needAddProperty);
                    var priority = styleRuleItem.style.getPropertyPriority(needAddProperty);
                    if (propertyValue.length > 0){
                        //这里不可以给 priority 为 !important，否则后续反色会失效
                        existStyle.style.setProperty(needAddProperty, propertyValue);
                    }
                }
                //利用添加的style，把cssText固化到html中，然后就能删除style属性
                var cssText = removeEndSelector + '{ ' + existStyle.style.cssText + ' }';
                existStyle.style.cssText = '';
                existStyle.removeAttribute('style');
                existStyle.innerHTML = cssText;
                document.head.appendChild(existStyle);
            }
        }
    }
}

function mdxAddNightMode(){
    //这里放置一些前置操作，与反色无关
    try {
        eudic_appendCompactRemovedBodyStyle();
    } catch (error) {

    }

    var currentClassName = document.getElementsByTagName('body')[0].className;
    if (currentClassName !== 'night' && currentClassName !== 'black'){
        return;
    }

    function checkStyleRuleValid(style){
        return style.length > 0 && style !== 'inherit' && style !== 'initial' && style !== 'transparent' && style.toLowerCase() !== 'currentcolor'
    }
    //保证笔记内容的内部颜色设置正确
    var annoList = document.getElementsByClassName('eudic-annotation-class');
    for (var i = 0; i < annoList.length; i++){
        var annoItem = annoList[i];
        if (annoItem.tagName.toLowerCase() === 'strike'){
            annoItem.style.color = highlightNightColor;
        }
    }
    //仅根据当前的sheet做处理，否则有些词库会无限循环
    //styleSheets并不是 Array
    var currentStyleSheets = [];
    for (var z = 0; z < document.styleSheets.length; z++){
        currentStyleSheets.push(document.styleSheets[z]);
    }
    //有可能多个link的css地址是完全一样的，如果处理过，就忽略掉
    var parsedLinkAddress = [];
    var allStyleless = document.getElementsByClassName('explain_wrap_styleless');
    var explainElementArray;
    try {
        explainElementArray = Array.from(allStyleless);
    } catch (error) {
        explainElementArray = allStyleless;
    }
    //添加一些官方词库，但需要反色处理的
    if (explainElementArray.push){
        var needReverseDict = [
            'ID1017', //拉鲁斯法法词典增强版,
            'ID1018', //chambers francais 英法词典
            'ID1019' //chambers francais 法英词典
        ]
        for (var d = 0; d < needReverseDict.length; d++){
            var reverseId = needReverseDict[d];
            var dictDOM = document.getElementById(reverseId);
            if (dictDOM){
                explainElementArray.push(dictDOM);
            }
        }
    }
    var needIgnoreBgColorList = [
        '1293531079', //象形9000
    ];
    for (var i = 0; i < explainElementArray.length; i++){
        var expItem = explainElementArray[i];
        //如果添加过处理后的css 直接忽略掉
        if (expItem.getElementsByClassName('eudic_custom_night').length > 0){
            continue;
        }
        var links = expItem.getElementsByTagName('link');

        //无论是否有 link，都需要处理内嵌样式，因为有些词库是既有css，又会带内嵌样式的
        //处理内嵌的style
        //主要是算出style 然后再写死，就可以忽略掉词库原本的style
        var allDOM = expItem.getElementsByTagName('*');
        for (var j = 0; j < allDOM.length; j++){
            var currentDOM = allDOM[j];
            var parentDictChildItem = currentDOM.closest('div[id^="ID"], div[id$="child"]');
            if (parentDictChildItem && parentDictChildItem.id){
                var dictItemId = parentDictChildItem.id.replace('ID', '');
                dictItemId = dictItemId.replace('child', '');
                if (needIgnoreBgColorList.indexOf(dictItemId) >= 0){
                    continue;
                }
            }
            //之前处理过了，忽略，同时也不处理词库头，因为词库头是软件自己带了夜间色的
            //部分词库带SVG，不支持设置className，此时应该忽略，而不是抛异常导致无法继续
            try {
                if (currentDOM.className.indexOf('eudic_custom_fixed_style') !== -1 || currentDOM.className.indexOf('expHead') !== -1 || currentDOM.parentNode.className.indexOf('expHead') !== -1){
                    continue;
                }
            } catch (error) {
            }
            //部分解释块自带背景色，需要单独做反色处理。但不能处理笔迹。笔迹的特征是只有一个class且class名为eudic-annotation-class
            if (currentDOM.className !== 'eudic-annotation-class' && currentDOM.style && currentDOM.style.backgroundColor && currentDOM.style.backgroundColor.length > 0 &&
                currentDOM.className.indexOf('eudic_custom_fixed_background_style') === -1 &&
                currentDOM.style.backgroundColor !== 'initial' && currentDOM.style.backgroundColor !== 'currentColor') {
                var tempColor = getInverseColor(currentDOM.style.backgroundColor);
                currentDOM.style.backgroundColor = tempColor;
                currentDOM.className += ' eudic_custom_fixed_background_style';
            }
            var currentComputedStyle = window.getComputedStyle(currentDOM);
            var needModifyClass = true;
            if (currentDOM.className !== 'eudic-annotation-class' && currentComputedStyle.color !== undefined && currentComputedStyle.color.length > 0 && currentDOM.className !== 'eudic-annotation-class'){
                var tempColor = getInverseColor(currentComputedStyle.color);
                // 父节点处理过了，忽略。判断依据就是正好相反(一般就是一个p里套一个b或者i)
                var tempInverseColor = getFormatColor(tempColor);
                var parentInverseColor = getFormatColor(getInverseColor(window.getComputedStyle(currentDOM.parentNode).color));
                var tempInverseColorObj = parseColor(tempInverseColor);
                var parentInverseColorObj = parseColor(parentInverseColor);
                var absRed = Math.abs(tempInverseColorObj.r - parentInverseColorObj.r);
                var absBlue = Math.abs(tempInverseColorObj.b - parentInverseColorObj.b);
                var absGreen = Math.abs(tempInverseColorObj.g - parentInverseColorObj.g);
                //色差小于30，就认为颜色是接近的
                var isNearColor = absRed < 30 && absBlue < 30 && absGreen < 30;

                if (currentDOM.parentNode.style.color !== undefined && (tempInverseColor === parentInverseColor || isNearColor)){
                    needModifyClass = false;
                }
                if (needModifyClass){
                    currentDOM.setAttribute('eudic_origin_color', currentDOM.style.color);
                    currentDOM.style.color = getInverseAlphaColor(currentComputedStyle.color);
                    currentDOM.className += ' eudic_custom_fixed_style';
                }
            }
            try {
                currentDOM.className = currentDOM.className.trim();
            } catch (error) {
            }
        }

        //没有link，说明没有外部css，此时是内嵌style
        if (links.length === 0){
            var innerStyles = expItem.getElementsByTagName('style');
            if (innerStyles.length === 0){ //也没有内嵌style 说明可能是写死的style
                //处理写死style的，只有当读取一个Node时，该Node有style值才使用
                var allDOM = expItem.getElementsByTagName('*');
                for (var j = 0; j < allDOM.length; j++){
                    var currentDOM = allDOM[j];
                    //之前处理过了，忽略
                    try {
                        if (currentDOM.className.indexOf('eudic-annotation-class') !== -1 || currentDOM.className.indexOf('eudic_custom_fixed_style') !== -1 || currentDOM.className.indexOf('eudic_custom_style') !== -1 || currentDOM.className.indexOf('eudic_custom_color') !== -1){
                            continue;
                        }
                    } catch (error) {
                    }
                    if (currentDOM.style.color.length > 0){
                        currentDOM.style.color = getInverseAlphaColor(currentDOM.style.color);
                        currentDOM.className += ' eudic_custom_style'
                    }
                    if (currentDOM.color !== undefined && currentDOM.color.length > 0){
                        currentDOM.style.color = getInverseAlphaColor(currentDOM.color);
                        currentDOM.className += ' eudic_custom_color'
                    }
                    try {
                        currentDOM.className = currentDOM.className.trim();
                    } catch (error) {
                    }
                }
            }
            continue;
        }
        //处理外部css
        for (var j = 0; j < links.length; j++){
            var linkItem = links[j];
            var linkAddress = linkItem.href;
            if (parsedLinkAddress.indexOf(linkAddress) > -1){
                continue;
            }
            parsedLinkAddress.push(linkAddress);
            for (var k = 0; k < currentStyleSheets.length; k++){
                var styleSheet = currentStyleSheets[k];
                // 找到当前第三方词库使用的css，开始转换
                if (linkAddress === styleSheet.href){

                    //哪些css选择器里是带颜色的？
                    var selectorArray = [];
                    var colorArray = [];

                    //开始遍历styleSheets的rules
                    try {
                        for (var m = 0; m < styleSheet.rules.length; m++){
                            var currentStyleDeclaration = styleSheet.rules[m].style;
                            if (currentStyleDeclaration === undefined){
                                continue;
                            }

                            var ruleString = '\r\n{\r\n';
                            var containsColor = false;

                            if (checkStyleRuleValid(currentStyleDeclaration['color'])){
                                var reverseColor = 'color: ' + getInverseAlphaColor(currentStyleDeclaration['color']) + '!important;';
                                ruleString = ruleString + reverseColor + '\r\n';
                                containsColor = true;
                            }

                            //带背景图时 不做处理
                            if (currentStyleDeclaration['background-image'].length === 0 || currentStyleDeclaration['background-image'] === 'initial'){
                                if (checkStyleRuleValid(currentStyleDeclaration['background'])){
                                    var color = getInverseAlphaColor(currentStyleDeclaration['background'], true) + '!important;';
                                    //如果背景色是纯黑色 直接忽略
                                    if (color.startsWith('rgb(0,0,0)') || color.startsWith('rgba(0,0,0')){
                                        color = 'transparent !important;';
                                    }
                                    var reverseColor = 'background: ' + color;
                                    ruleString = ruleString + reverseColor + '\r\n';
                                    containsColor = true;
                                }
                                else if (checkStyleRuleValid(currentStyleDeclaration['background-color'])){
                                    var color = getInverseAlphaColor(currentStyleDeclaration['background-color'], true) + '!important;';
                                    //如果背景色是纯黑色 直接忽略
                                    if (color.startsWith('rgb(0,0,0)') || color.startsWith('rgba(0,0,0')){
                                        color = 'transparent !important;';
                                    }
                                    var reverseColor = 'background: ' + color;
                                    ruleString = ruleString + reverseColor + '\r\n';
                                    containsColor = true;
                                }
                            }

                            if (containsColor){
                                ruleString = ruleString + '\r\n}\r\n';
                                colorArray.push(ruleString);
                                selectorArray.push(styleSheet.rules[m].selectorText);
                            }
                        }
                    } catch (error) {
                        console.log('cors error = ' + error)
                    }

                    //将重新制作好的css写入
                    var cssArray = [];

                    for (var p = 0; p < selectorArray.length; p++){
                        var selectorString = selectorArray[p];
                        //不能有body前缀 否则该css会失效
                        if (selectorString.startsWith('body')){
                            selectorString = selectorString.substring(4);
                        }
                        var thisRule = '.' + currentClassName + ' ' + selectorString + colorArray[p];
                        cssArray.push(thisRule);
                    }

                    var finalCssString = cssArray.join('\r\n');
                    var finalStyle = document.createElement('style');
                    finalStyle.className = 'eudic_custom_night'
                    finalStyle.type = 'text/css';
                    finalStyle.innerHTML = finalCssString;
                    var eudicExpDiv = expItem.getElementsByClassName('expDiv')[0];
                    if (!eudicExpDiv)
                    {
                        eudicExpDiv = expItem.getElementsByClassName('eudicExpDiv')[0];
                    }
                    eudicExpDiv.appendChild(finalStyle);
                }
            }
        }
    }
}

function mdxRemoveNightMode(){

    //移除标记的内部色
    var annoList = document.getElementsByClassName('eudic-annotation-class');
    for (var i = 0; i < annoList.length; i++){
        var annoItem = annoList[i];
        if (annoItem.tagName.toLowerCase() === 'strike'){
            annoItem.style.color = '';
        }
    }

    //第一步 移除所有自定义class
    var elements = document.getElementsByClassName('eudic_custom_night');
    while(elements.length > 0){
        elements[0].parentNode.removeChild(elements[0]);
    }

    //第二步，再次反色回去
    var allDOM = document.getElementsByTagName('*');
    for (var i = 0; i < allDOM.length; i++){
        var currentDOM = allDOM[i];
        if (currentDOM.className.indexOf !== undefined){
            //没反色过 忽略 因为class有可能原来就有，所以不能用ByClassName
            if (currentDOM.className.indexOf('eudic_custom_style') === -1 && currentDOM.className.indexOf('eudic_custom_color') === -1 && currentDOM.className.indexOf('eudic_custom_fixed_style') === -1 && currentDOM.className.indexOf('eudic_custom_fixed_background_style') === -1){
                continue;
            }
            //原来有背景色，需要重新反色回去
            if (currentDOM.className.indexOf('eudic_custom_fixed_background_style') !== -1){
                var tempColor = getInverseColor(currentDOM.style.backgroundColor);
                currentDOM.style.backgroundColor = tempColor;
            }
            //是内嵌style
            if (currentDOM.className.indexOf('eudic_custom_fixed_style') !== -1){
                var originColor = currentDOM.getAttribute('eudic_origin_color');
                currentDOM.style.color = originColor;
            }else{
                //因为必须写到style里才会起效，所以恢复时，需要按是style还是color分别恢复
                //说明当时改的是 style 那么就写回style
                if (currentDOM.className.indexOf('eudic_custom_style') !== -1){
                    currentDOM.style.color = getInverseColorIgnoreAlpha(currentDOM.style.color);
                }
                //说明当时改的是 color 那么就写回color，同时要把style里的color给去掉
                if (currentDOM.className.indexOf('eudic_custom_color') !== -1){
                    currentDOM.color = getInverseColorIgnoreAlpha(currentDOM.style.color);
                    currentDOM.style.color = '';
                }
            }
        }
        //可能不是String
        if (currentDOM.className.replace !== undefined){
            currentDOM.className = currentDOM.className.replace('eudic_custom_style', '');
            currentDOM.className = currentDOM.className.replace('eudic_custom_color', '');
            currentDOM.className = currentDOM.className.replace('eudic_custom_fixed_style', '');
            currentDOM.className = currentDOM.className.replace('eudic_custom_fixed_background_style', '');
        }
        if (currentDOM.className.trim !== undefined){
            currentDOM.className = currentDOM.className.trim();
        }
    }
}

function changeExplainStyle(style){
    document.body.className = style;
    mdxRemoveNightMode();
    if (style === 'night' || style === 'black'){
        mdxAddNightMode();
    }
}

function smoothScrollTo(element, to, duration) {
    var start = element.scrollTop,
        change = to - start,
        increment = 20;

    var animateScroll = function(elapsedTime) {        
        elapsedTime += increment;
        var position = easeInOut(elapsedTime, start, change, duration);                        
        element.scrollTop = position; 
        if (elapsedTime < duration) {
            setTimeout(function() {
                animateScroll(elapsedTime);
            }, increment);
        }
    };

    animateScroll(0);
}

function easeInOut(currentTime, start, change, duration) {
    currentTime /= duration / 2;
    if (currentTime < 1) {
        return change / 2 * currentTime * currentTime + start;
    }
    currentTime -= 1;
    return -change / 2 * (currentTime * (currentTime - 2) - 1) + start;
}

function hasClass(element, cls) {
    if (element === null) return false;
    if (!element.className) return false;
    return (' ' + element.className + ' ').indexOf(' ' + cls + ' ') > -1;
}

//颜色转换相关
function RGBColor(color_string)
{
    this.ok = false;

    // strip any leading #
    if (color_string.charAt(0) == '#') { // remove # if any
        color_string = color_string.substr(1,6);
    }

    color_string = color_string.replace(/ /g,'');
    color_string = color_string.toLowerCase();
 
    // array of color definition objects
    var color_defs = [
        {
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            example: ['rgb(123, 234, 45)', 'rgb(255,234,245)'],
            process: function (bits){
                return [
                    parseInt(bits[1]),
                    parseInt(bits[2]),
                    parseInt(bits[3])
                ];
            }
        },
        {
            re: /^(\w{2})(\w{2})(\w{2})$/,
            example: ['#00ff00', '336699'],
            process: function (bits){
                return [
                    parseInt(bits[1], 16),
                    parseInt(bits[2], 16),
                    parseInt(bits[3], 16)
                ];
            }
        },
        {
            re: /^(\w{1})(\w{1})(\w{1})$/,
            example: ['#fb0', 'f0f'],
            process: function (bits){
                return [
                    parseInt(bits[1] + bits[1], 16),
                    parseInt(bits[2] + bits[2], 16),
                    parseInt(bits[3] + bits[3], 16)
                ];
            }
        }
    ];

    // search through the definitions to find a match
    for (var i = 0; i < color_defs.length; i++) {
        var re = color_defs[i].re;
        var processor = color_defs[i].process;
        var bits = re.exec(color_string);
        if (bits) {
            channels = processor(bits);
            this.r = channels[0];
            this.g = channels[1];
            this.b = channels[2];
            this.ok = true;
        }
    }

    // validate/cleanup values
    this.r = (this.r < 0 || isNaN(this.r)) ? 0 : ((this.r > 255) ? 255 : this.r);
    this.g = (this.g < 0 || isNaN(this.g)) ? 0 : ((this.g > 255) ? 255 : this.g);
    this.b = (this.b < 0 || isNaN(this.b)) ? 0 : ((this.b > 255) ? 255 : this.b);

    // some getters
    this.toRGB = function () {
        return 'rgb(' + this.r + ', ' + this.g + ', ' + this.b + ')';
    }
    this.toHex = function () {
        var r = this.r.toString(16);
        var g = this.g.toString(16);
        var b = this.b.toString(16);
        if (r.length == 1) r = '0' + r;
        if (g.length == 1) g = '0' + g;
        if (b.length == 1) b = '0' + b;
        return '#' + r + g + b;
    }

    this.toHsv = function () {
        return RGBtoHSV(this.r, this.g, this.b);
    }

    //高亮笔记中使用，动态计算批注标示的颜色
    this.toStrikeCommentColor = function() {
        var hsl = toHsv();
        var newColor = HSVtoRGB(hsl.h, 0.84, 0.87);
        this.r = newColor.r; this.g = newColor.g; this.b = newColor.b;
        return toHex();
    }
    function HSVtoRGB(h, s, v) {
        var r, g, b, i, f, p, q, t;
        if (arguments.length === 1) {
            s = h.s, v = h.v, h = h.h;
        }
        i = Math.floor(h * 6);
        f = h * 6 - i;
        p = v * (1 - s);
        q = v * (1 - f * s);
        t = v * (1 - (1 - f) * s);
        switch (i % 6) {
            case 0: r = v, g = t, b = p; break;
            case 1: r = q, g = v, b = p; break;
            case 2: r = p, g = v, b = t; break;
            case 3: r = p, g = q, b = v; break;
            case 4: r = t, g = p, b = v; break;
            case 5: r = v, g = p, b = q; break;
        }
        return {
            r: Math.round(r * 255),
            g: Math.round(g * 255),
            b: Math.round(b * 255)
        };
    }
    
    function RGBtoHSV(r, g, b) {
        if (arguments.length === 1) {
            g = r.g, b = r.b, r = r.r;
        }
        var max = Math.max(r, g, b), min = Math.min(r, g, b),
            d = max - min,
            h,
            s = (max === 0 ? 0 : d / max),
            v = max / 255;

        switch (max) {
            case min: h = 0; break;
            case r: h = (g - b) + d * (g < b ? 6: 0); h /= 6 * d; break;
            case g: h = (b - r) + d * 2; h /= 6 * d; break;
            case b: h = (r - g) + d * 4; h /= 6 * d; break;
        }

        return {
            h: h,
            s: s,
            v: v
        };
    }
 
    return this;
}
/*Liju发音*/
function getcmd(cmdName, node) {
    var data = node.getAttribute('data'),
        source = node.getAttribute('source'),
        type = node.getAttribute('type'),
        media, cmd;
    cmd = 'cmd://' + cmdName + '?data=' + data + '&source=' + source + '&type=' + type;
    if (cmdName == 'play_ting') {
        media = node.getAttribute('media');
        cmd += '&media=' + media;
    }
    window.location = cmd;
}

function init_sound(divid) {
    var node = document.getElementById(divid);
    var lines = node.getElementsByClassName('line'),
        line, lineText = '', iconsText = '', vnode, voice, isTingSpeak = false;
    for (var i = 0; i < lines.length; i++) {
        line = lines[i];
        lineText = line.innerHTML;

        if (line.parentNode.getElementsByClassName('liju_icons').length > 0)
        {
            continue;
        }
        var iconsDiv = document.createElement('span');
        iconsDiv.className = 'liju_icons';
        line.parentNode.appendChild(iconsDiv);
        iconsText = iconsDiv.innerHTML;

        vnode = line.parentNode.getElementsByClassName('ljid');
        if (vnode.length > 0) {
            //常用例句库
            vnode = vnode[0];
            voice = vnode.getAttribute('voice');
            if (!voice) {
                //普通机器发音
                iconsText += '<div class="voiceBox btn_liju_pronounce" onclick="sound(this.parentNode);"><span class="voiceTxt">发音</span></div>';
            } else {
                //真人发音（真人 / 慢速）
                iconsDiv.innerHTML = + iconsText + "</span>";
                if (/normal_voice/.test(voice)) {
                    iconsText += '<div class="voiceBox btn_liju_pronounce" onclick="soundHuman(this.parentNode);"><span class="voiceTxt">真人</span></div>';
                }
                if (/slow_voice/.test(voice)) {
                    iconsText += '<div class="voiceBox btn_liju_pronounce" onclick="soundHumanSlow(this.parentNode);"><span class="voiceTxt">慢速</span></div>';
                }
            }
            if (gPlatform != 'android_wear')
            {
                //跟读
                var voiceEvalFun = 'voiceEval(this.parentNode);';
                if (voice)
                {
                    voiceEvalFun = 'voiceEval(this.parentNode, \'human_normal\');';
                }
                iconsText += '<div class="voiceBox btn_liju_read" onclick="' + voiceEvalFun + '"><span class="voiceTxt">跟读</span></div>';
                //更多菜单
                iconsText += '<div class="moreMenu" onclick="lijuMoreFunc(this.parentNode);"><img src="style/default/liju_more.png" /></div>';
            }
        } else {
            //原声例句库代码
            isTingSpeak = true;
        }

        iconsDiv.innerHTML = iconsText;
        line.innerHTML = lineText;
    }
    if (isTingSpeak)
    {
        var hasMore = document.getElementById('liju_ting_loadmore'); //服务器返回的，是否还有更多例句的标记
        var showMoreBtn = document.getElementById('liju_ting_loadmore_container');
        if (showMoreBtn)
        {
            var page = parseInt(showMoreBtn.getAttribute('page')) + 1;
            showMoreBtn.setAttribute('page', page);
            var pos = showMoreBtn.getAttribute('pos')
            if (hasMore  || (page <= 2 && lines.length >= 10))
            {
                if (hasMore) hasMore.remove();
                var showMoreLine = '<span class="onlineDictManager" onclick="document.location=\'cmd://load_more?dict=liju_ting&page=' + String(page) + '&pos=' + pos + '\'">点击查看更多</span>';
                showMoreBtn.innerHTML = showMoreLine;
                showMoreBtn.style.display = 'flex';
            }
            else
            {
                //如果没有更多 则直接删除更多按钮
                showMoreBtn.style.display = 'none';
            }
        }
    }
    else //Dict Liju
    {
        var hasMore = document.getElementById('liju_dict_loadmore'); //服务器返回的，是否还有更多例句的标记
        var showMoreBtn = document.getElementById('liju_dict_loadmore_container');
        var pos = showMoreBtn.getAttribute('pos')
        if (showMoreBtn)
        {
            var page = parseInt(showMoreBtn.getAttribute('page')) + 1;
            if (hasMore || (page <= 2 && lines.length >= 10))
            {
                if (hasMore) hasMore.remove();
                showMoreBtn.setAttribute('page', page);
                var showMoreLine = '<span class="onlineDictManager" onclick="document.location=\'cmd://load_more?dict=liju_dict&page=' + String(page) + '&pos=' + pos + '\'">点击查看更多</span>';
                showMoreBtn.innerHTML = showMoreLine;
                showMoreBtn.style.display = 'flex';
            }
            else
            {
                //如果没有更多 则直接删除更多按钮
                showMoreBtn.style.display = 'none';
            }
        }

        return;
    }

    // 原声例句 dom
    var allLjItem = node.querySelectorAll('.lj_item');
    for (var i = 0; i < allLjItem.length; i++) {
        var ljItem = allLjItem[i];
        var channelBox = ljItem.getElementsByClassName("channel")[0];
        var line = ljItem.getElementsByClassName("line")[0];
        //发音 dom
        line.innerHTML += '<div><div class="btn_ting_pronounce" onclick="sound(this);"></div></div>';
        line.outerHTML = '<span class="liju_index">' + parseInt(i + 1) + '.</span>' + line.outerHTML;
        if (gPlatform != 'android_wear') {
            //频道dom 和 更多菜单dom
            channelBox.innerHTML += '<div class="moreMenu" onclick="lijuMoreFunc(this.childNodes[0]);"><img src="style/default/liju_more.png" /></div>';
        }

    }
    if (!node.classList.contains('explain_wrap'))
    {
        //兼容服务器返回的和客户端读取的不同接口
        var childs = node.getElementsByClassName('explain_wrap');
        if (childs.length > 0)
        {
            node = childs[0];
        }
    }
    if (node.classList.contains('explain_wrap')) {
        node.addEventListener('click', function(e) {
            if (e.target.className == 'channel_title') {
                sound(e.target, 'ting');
            }
        }, false);
    }
}


function lijuMoreFunc(target) {
    var cmdData = getLijuData(target, null);
    window.location = 'cmd://liju_more' + cmdData;
}

function voiceEval(target, flag) {
    var cmdData = getLijuData(target, flag);
    window.location = 'cmd://dict/eval_record_word' + cmdData;
}

function soundHuman(target) {
    sound(target, 'human_normal');
}

function soundHumanSlow(target) {
    sound(target, 'human_slow');
}
function getLijuData(target, flag) {
    var dataNode = target.parentNode.parentNode.parentNode;
    if (flag && flag == 'ting') {
        dataNode = target.parentNode.parentNode;
    }
    var channel_title = '';
    var explain = '';
    //ting liju
    var data = dataNode.getAttribute('data'),
        source = dataNode.getAttribute('source'),
        type = dataNode.getAttribute('type'),
        media = dataNode.getAttribute('media');
    if (!data) {
        //dict liju
        data = target.parentNode.getElementsByClassName("line")[0].innerText;
        data = encodeURIComponent(data);
        source = target.parentNode.getElementsByClassName("ljid")[0].getAttribute('source');
        if (!source)
        {
            source = target.parentNode.getElementsByClassName("ljid")[0].getAttribute('data');
        }
        explain = target.parentNode.getElementsByClassName('exp')[0].innerText;
        type = 'dict';
    }else{
        channel_title = dataNode.getElementsByClassName('channel_title')[0].innerText;
        explain = dataNode.getElementsByClassName('exp')[0].innerText;
    }
    var cmdData = '?data=' + data + '&source=' + source + '&type=' + type;
    if (media !== null) {
        cmdData += '&media=' + media;
    }
    if (flag != null) {
        cmdData += '&voice=' + flag;
    }
    if (channel_title.length > 0){
        cmdData += '&channel_title=' + channel_title;
    }
    if (explain.length > 0){
        cmdData += '&exp=' + explain;
    }
    return cmdData;
}
function sound(target, flag) {
    var cmdData = getLijuData(target, flag);
    if (flag && flag == 'ting') {
        window.location = 'cmd://play_ting' + cmdData;
    }
    else {
        window.location = 'cmd://speak_liju' + cmdData;
    }
}

function switchPos(target, type, pos)
{
    //切换前 需要先清除之前的内容
    var ljNode = document.getElementById('lj_ting');
    if (type == 'dict')
    {
        ljNode = document.getElementById('more_liju_dict');
    }
    if (ljNode) ljNode.innerHTML = '';
    var loadMore = document.getElementById('liju_' + type + '_loadmore_container');
    if (loadMore)
    {
        loadMore.setAttribute('pos', pos);
        loadMore.setAttribute('page', 1);
    }
    window.location = 'cmd://load_more?dict=liju_' + type + '&page=1&pos=' + pos;

	//设置高亮
	var ulNodes = target.parentNode.parentNode;
	for (var i = 0; i < ulNodes.childNodes.length; i++) {
		ulNodes.childNodes[i].classList.remove('active');
	}
	target.parentNode.classList.add('active');
}
var dict_banner_height = 20;
var gPlatform = 'android_wear';
function init_padbanner() {
    //让pad版本的banner始终在顶部
    var el = document.getElementById('dic_banner');
    el.style.position='fixed';
    el.style.top='0';
    document.body.style.marginTop = '45px';
    dict_banner_height = 45;
    isPad = true;
}
function log(text) {
    var div = document.getElementById('log');
    if (!div) {
        div = document.createElement('div');
        div.id = 'log';
        div.style.backgroundColor = '#ccc';
        div.style.position = 'fixed';
        div.style.left = '1px';
        div.style.top = '120px';
        div.style.zIndex = '30';
        document.body.appendChild(div);
    }
    div.innerHTML = div.innerHTML + '<br/>' + text;
}

function init_dicpage() {
    //fixed top banner
    var item = document.getElementById('leftBtn');
    if (item != null)
        item.addEventListener('touchend', popViewBtnClick, false);

    item = document.getElementById('rightBtn');
    if (item != null)
        item.addEventListener('touchend', dicMoreClick, false);

    item = document.getElementById('navBackBtn');
    if (item != null)
        item.addEventListener('touchend', navBackwardClick, false);

    item = document.getElementById('navForwardBtn');
    if (item != null)
        item.addEventListener('touchend', navForwardClick, false);

    item = document.getElementById('spkBtn');
    if (item != null)
        item.addEventListener('touchend', function() {}, false);

    initTouchJump();
    addAndroidActiveSupport();
    mdxAddNightMode();
}

function init_cgpage() {
    //fixed top banner
    item = document.getElementById('leftBtn_cg');
    if (item != null)
        item.addEventListener('touchend', popViewBtnClick, false);
    item = document.getElementById('rightBtn_cg');
    if (item != null)
        item.addEventListener('touchend', cgMoreClick, false);
    item = document.getElementById('navBackBtn_cg');
    if (item != null)
        item.addEventListener('touchend', navBackwardClick, false);

    item = document.getElementById('navForwardBtn_cg');
    if (item != null)
        item.addEventListener('touchend', navForwardClick, false);

    item = document.getElementById('spkBtn');
    if (item != null)
        item.addEventListener('touchend', function() {}, false);

    initTouchJump();
    addAndroidActiveSupport();
}

function initTouchJump() {
    window.touchJumpEnabled = true;
    window.touchDetected = false;
    document.body.addEventListener('touchstart', function(e) {
        window.touchDetected = true;
        window.touchJump = true;
        window.touchJumpStartTime = e.timeStamp;
        window.touchJumpClientX = e.touches[0].clientX;
        window.touchJumpClientY = e.touches[0].clientY;
    }, false);

    document.body.addEventListener('touchmove', function(e) {
        window.touchJump = false;
    }, false);

    document.addEventListener('selectionchange', selectChangeFun, false);

    document.body.addEventListener('touchend', function(e) {
        if (window.touchJumpEnabled && window.touchJump && e.timeStamp - window.touchJumpStartTime < 500) {
            nodeCliked(e.target);
        }
    }, false);

    //      document.body.addEventListener('click', function(e) {
    //  //touch事件在pad上面第一次加载时候不会被调用，所以再加一个click事件
    //  loginfo(e.clientX);
    //  if (!window.touchDetected) {
    //      window.touchJumpClientX = e.clientX;
    //      window.touchJumpClientY = e.clientY;
    //      nodeCliked(e.target);
    //  };
    // });
}

//支持安卓链接选择
function longClickSelect() {
    var selection = window.getSelection();
    var range = document.caretRangeFromPoint(window.touchJumpClientX, window.touchJumpClientY);
    range.expand("word");
    selection.removeAllRanges();
    selection.addRange(range);
}

function nodeCliked(el) {
    if (el == document.body || el.nodeName == 'A') return;
    if (el.nodeName == 'IMG')
    {
        if (el.width > 100 && el.height > 100) {
            //单击图片查词
            var imgList = [];
            var imginfo = {};
            imginfo['imgurl'] = el.src;
            imginfo['imgAlt'] = '';
            imginfo['cmd'] = el.src;
            imgList.push(imginfo);
            window.htmlutil.showWikiImages(JSON.stringify(imgList), '');
        }
        return;
    }
    eu_walk(el);
    var s1 = document.elementFromPoint(window.touchJumpClientX, window.touchJumpClientY);
    if (s1.nodeName.toLowerCase() == 'eudic' && s1.parentNode.className != 'channel_title') {
        eu_click(s1.innerHTML);
    }
    eu_unWalk(el);
}

//android 不支持div:active 需要添加一个fakeactive
function addAndroidActiveSupport() {
    var elements = document.getElementsByClassName("button");
    for (var i = 0; i < elements.length; i++) {
        var elm = elements[i];
        elm.addEventListener("touchstart", function() {
            addClass(this, "fake-active");
        }, false);
        elm.addEventListener("touchmove", function() {
            removeClass(this, "fake-active");
        }, false);
        elm.addEventListener("touchend", function() {
            removeClass(this, "fake-active");
        }, false);
        elm.addEventListener("touchcancel", function() {
            removeClass(this, "fake-active");
        }, false);
    }
}

function addClass(ele, cls) {
    if (!this.hasClass(ele, cls)) ele.className += " " + cls;
}

function removeClass(ele, cls) {
    if (hasClass(ele, cls)) {
        var reg = new RegExp("(\\s|^)" + cls + "(\\s|$)");
        ele.className = ele.className.replace(reg, " ");
    }
}

function popViewBtnClick() {
    window.location = 'cmd://nav/popView';
}

function navBackwardClick() {
    window.location = 'cmd://nav/hisBackward';
}

function navForwardClick() {
    window.location = 'cmd://nav/hisForward';
}

function backTransClick() {
    window.location = 'cmd://nav/backFromTrans';
}

function dicMoreClick() {
    arguments[0].preventDefault();
    if (this.innerHTML != '显示变位')
        window.location = 'cmd://nav/dicMore';
}

function spkBtnClick() {
    window.location = 'cmd://Speak';
}

function starMoreClick() {
    var el = document.getElementById('J_menu_star');
    toggleStarView(el);
}

function isSameParent(n1, n2) {
    return (n1.parentNode == n2.parentNode);
}

function initThumbnailHeight() {
    var thumbDiv = document.getElementById("word-thumbnail-image");
    if(thumbDiv) {
        var thumbImg = thumbDiv.getElementsByTagName('img');
        if(thumbImg[0]) {
            var expDiv = thumbDiv.parentNode.getElementsByClassName('eudicExpDiv');
            if(expDiv[0]) {
                var expDivStyle = expDiv[0].currentStyle ? expDiv[0].currentStyle : window.getComputedStyle(expDiv[0], null);
                var expDivHeight = parseInt(expDivStyle.height);
                if(expDivHeight < 105) {
                    expDiv[0].style.minHeight = '105px';
                }
            }
        }
    }
}
function getScrollTop(){
　　var scrollTop = 0, bodyScrollTop = 0, documentScrollTop = 0;
　　if(document.body){
　　　　bodyScrollTop = document.body.scrollTop;
　　}
　　if(document.documentElement){
　　　　documentScrollTop = document.documentElement.scrollTop;
　　}
　　scrollTop = (bodyScrollTop - documentScrollTop > 0) ? bodyScrollTop : documentScrollTop;
　　return scrollTop;
}
function getScrollHeight(){
　　var scrollHeight = 0, bodyScrollHeight = 0, documentScrollHeight = 0;
　　if(document.body){
　　　　bodyScrollHeight = document.body.scrollHeight;
　　}
　　if(document.documentElement){
　　　　documentScrollHeight = document.documentElement.scrollHeight;
　　}
　　scrollHeight = (bodyScrollHeight - documentScrollHeight > 0) ? bodyScrollHeight : documentScrollHeight;
　　return scrollHeight;
}
function getWindowHeight(){
　　var windowHeight = 0;
　　if(document.compatMode == "CSS1Compat"){
　　　　windowHeight = document.documentElement.clientHeight;
　　}else{
　　　　windowHeight = document.body.clientHeight;
　　}
　　return windowHeight;
}

function customNote() {
    var note = document.getElementById('customNote');
    note.onclick = function(ev) {
        if(ev.target.id != 'doEditNote') {
            toggleExpDiv('expCustomNotechild',this);
        } else {
             window.location.href = 'cmd://doEditNote';
        }
    }
}

function eudic_tiku_answer(obj) {
    var curParent = obj.parentNode,
        flag = curParent.getAttribute('data-hasAnswered');
    if(flag == 0) {
        var data = curParent.getAttribute('data-trueAnswer'),
        allAnswer = curParent.getElementsByTagName('li');
        for(var i = 0, l = allAnswer.length; i < l; i++) {
            allAnswer[i].index = i;
        }
        if(allAnswer[data - 1]) {
            allAnswer[data - 1].setAttribute('class', 'correct');
        }
        if((data - 1) == obj.index) {
            obj.setAttribute('class', 'correct clickThis');
        } else {
            obj.setAttribute('class', 'error clickThis');
        }
        curParent.setAttribute('data-hasAnswered', '1');
    }
};

function jumpToNextSection() {
    var expWrap = document.querySelectorAll('.explain_wrap,.explain_wrap_styleless');
    var tempSectionIndex = eudic_currentScrollSection;
    if (tempSectionIndex < 0){
        tempSectionIndex = 0;
    }
    var expItem = expWrap[tempSectionIndex];
    //检查【当前位置】是否正在显示。如不显示，则将【计算位置】覆盖【当前位置】
    if (!eudic_isScrolledIntoView(expItem)){
        eudic_currentScrollSection = eudic_checkScrollSection(false);
    }
    var preSection = eudic_currentScrollSection;
    var winDom = document.body || document.documentElement;
    var winScrollTop = getScrollTop() + 1; //向下偏移一些距离
    var expWrap = document.getElementsByClassName('eudicExpHead'), expWrapScroll = [], len = expWrap.length;
        if(expWrap[0]) {
        for(var i = 0; i < len; i++) {
            var thisScrollTop = expWrap[i].offsetTop - 1;
            expWrapScroll.push(thisScrollTop);
            if(winScrollTop >= thisScrollTop) {
                eudic_currentScrollSection = i;
            }
        }
    }
    if (eudic_currentScrollSection <= preSection) {
        //处理没有展开的词典, 进行以下操作
        //此时文档总体高度
        var winOfHeight = getScrollHeight() + 1;
        //屏幕显示区域高度
        var clientHeight = getWindowHeight();
        //是否触底
        if((winScrollTop + clientHeight) >= winOfHeight - 5) {
        //触底，eudic_currentScrollSection + 1
            eudic_currentScrollSection = preSection + 1;
        } else {
            eudic_currentScrollSection++;
        }
    } else {
        eudic_currentScrollSection++;
    }

    if (eudic_currentScrollSection >= len) {
        eudic_currentScrollSection = len - 1;
    }
    if (eudic_currentScrollSection >= 0) {
        var expDiv = expWrap[eudic_currentScrollSection].parentNode.getElementsByClassName('eudicExpDiv');
        if (expDiv.length > 0) {
            expandExpDiv(expDiv[0], true);
        }
    } else {
        var expDiv = expWrap[0].parentNode.getElementsByClassName('eudicExpDiv');
        expandExpDiv(expDiv[0], true);
        eudic_currentScrollSection = -1;
    }
}

function jumpToPreviousSection() {
    var expWrap = document.querySelectorAll('.explain_wrap,.explain_wrap_styleless');
    var tempSectionIndex = eudic_currentScrollSection;
    if (tempSectionIndex < 0){
        tempSectionIndex = 0;
    }
    var expItem = expWrap[tempSectionIndex];
    //检查【当前位置】是否正在显示。如不显示，则将【计算位置】覆盖【当前位置】
    if (!eudic_isScrolledIntoView(expItem)){
        eudic_currentScrollSection = eudic_checkScrollSection(false);
    }
    var preSection = eudic_currentScrollSection;
    var winDom = document.body || document.documentElement;
    var winScrollTop = getScrollTop();
    var expWrap = document.getElementsByClassName('eudicExpHead'), len = expWrap.length;
    var expWrapScroll = [];
    for(var i = 0; i < len; i++) {
        var thisScrollTop = expWrap[i].offsetTop;
        expWrapScroll.push(thisScrollTop);
    }
    for(var i = len; i >= 0; --i) {
        if (winScrollTop >= expWrapScroll[i] || i == 0) {
            eudic_currentScrollSection = i;
            break;
        }
    }
    if(eudic_currentScrollSection >= preSection) {
        eudic_currentScrollSection = preSection - 1;
    }
    else {
        i--;
    }

    if(eudic_currentScrollSection >= 0) {
        var expDiv = expWrap[eudic_currentScrollSection].parentNode.getElementsByClassName('eudicExpDiv');
        if (expDiv.length > 0) {
            expandExpDiv(expDiv[0], true);
        }
    } else {
        winDom.scrollTop = 0;
        eudic_currentScrollSection = -1;
    }
}

function scrollToCurrSection(thisDiv) {
    var winDom = document.body || document.documentElement,curScrollHeight;
    var parentDiv = thisDiv.parentNode;
    if((parentDiv && parentDiv.className == 'explain_wrap') || (parentDiv && parentDiv.className == 'explain_wrap_styleless')) {
        parentDiv.scrollIntoView(true);
        curScrollHeight = winDom.scrollTop;
        winDom.scrollTop = curScrollHeight;
    } else {
        thisDiv.scrollIntoView(true);
        curScrollHeight = winDom.scrollTop;
        winDom.scrollTop = curScrollHeight - 60;
    }
}

function toggleExpDiv(divName, sender, expScroll, expandOnly) {
    var evt = window.event;
    var thisDiv = document.getElementById(divName),
        thisDivParentId = thisDiv.parentNode.id;
    if (thisDiv == null) return;
    var isShowState = thisDiv.currentStyle ? thisDiv.currentStyle : window.getComputedStyle(thisDiv, null);
    if (isShowState.display == 'none') {
        if(!evt || evt.target.className != 'editNote'){
            if(expScroll) {
                expandExpDiv(thisDiv, true);
            } else {
                expandExpDiv(thisDiv, false, false);
            }
        }
    } else if (!expandOnly) {
        if(!evt || evt.target.className != 'editNote') {
            collapseExpDiv(thisDiv);
        }
    } else {
        if(expScroll) {
            scrollToCurrSection(thisDiv);
        }
    };
}

function expandExpDiv(thisDiv, scrollToSection, skipLazyLoad)
{
    if (!thisDiv) return;
    var thumbDiv = document.getElementById("word-thumbnail-image");
    var arrow = thisDiv.parentNode.getElementsByClassName('arrow');
    if (thisDiv.childNodes.length == 0 && !skipLazyLoad && thisDiv.id.indexOf('CustomNote') < 0)
    {
        var divName = thisDiv.id;
        window.location.href = 'cmd://dict/expand?libid=' + divName.replace('child', '') +'&scrollToSection='+ scrollToSection;
    } else {
        thisDiv.style.display = 'block';
        if (thumbDiv) {
           if (isSameParent(thumbDiv, thisDiv)) {
                 thumbDiv.style.display = 'block';
            }
        }
        if(scrollToSection) {
            scrollToCurrSection(thisDiv);
        }
    }
    if(arrow[1]) {
        arrow[0].className = 'arrow arrSideDown';
        arrow[1].className = 'arrow arrDown';
    }
}

function collapseExpDiv(thisDiv) {
    if (!thisDiv) return;
    var thumbDiv = document.getElementById("word-thumbnail-image");
    var arrow = thisDiv.parentNode.getElementsByClassName('arrow');
    thisDiv.style.display = 'none';
    if (thumbDiv) {
        if (isSameParent(thumbDiv, thisDiv)) {
             thumbDiv.style.display = 'none';
        }
    }
    if(arrow[1]) {
        arrow[0].className = 'arrow arrSideUp';
        arrow[1].className = 'arrow arrUp';
    }
}
function toggleExpDivAll()
{
    var firstElStatus = null;
    firstElStatus = toggleExpDivAllByName("explain_wrap", firstElStatus);
    toggleExpDivAllByName("explain_wrap_styleless", firstElStatus);
}

function expandExpDivAll()
{
    var firstElStatus = null;
    firstElStatus = toggleExpDivAllByName("explain_wrap", firstElStatus, "expand");
    toggleExpDivAllByName("explain_wrap_styleless", firstElStatus, "collapse");
}

// type: expand 强制展开 collapse 强制缩起
function toggleExpDivAllByName(className, firstElStatus, type)
{
    var nodes= document.getElementsByClassName(className);

    for(var i=0;i<nodes.length;i++)
    {
        var thisId = nodes[i].id;
        var thisEl = document.getElementById(thisId);
        var thisElChild = document.getElementById(thisId + "child");
        if (thisElChild != null) {
            if(firstElStatus == null)
            {
                firstElStatus = thisElChild.style.display;
                if (type === "expand")
                {
                    firstElStatus = "none";
                }
                else if (type === "collapse") {
                    firstElStatus = "block";
                }
            }

            if(thisElChild != null)
            {
                if (firstElStatus == "none") {
                    if (thisElChild.style.display == firstElStatus) {
                        toggleExpDiv(thisId + "child", thisEl);
                    }
                }
                else {
                    if (thisElChild.style.display == '' || thisElChild.style.display == firstElStatus) {
                        toggleExpDiv(thisId + "child", thisEl);
                    }
                }
            }
        }
    }
    return firstElStatus;
}

function getExpandState() {
    var arr = [];
    var expWrap = document.getElementsByClassName('eudicExpDiv');
    if(expWrap[0]) {
        for(var i = 0, l = expWrap.length; i < l; i++) {
            var thisElChild = expWrap[i];
            if(thisElChild) {
                var iStyle = thisElChild.currentStyle ? thisElChild.currentStyle : window.getComputedStyle(thisElChild, null);
                if (iStyle.display == 'block')
                {
                    arr.push(thisElChild.id);
                }
            }
        }
    }
    return arr.toString();
}

function restoreExpandState(arry) {
    var arr = arry.split(',');
    var expWrap = document.getElementsByClassName('eudicExpDiv');
    if(expWrap[0]) {
        for(var i = 0; i < expWrap.length; i++) {
            var thisId = expWrap[i].id;
            var isExpand = false;
            for( var j = 0,k = arr.length; j < k; j++) {
                if(arr[j] == thisId) {
                    isExpand = true;
                }
            }
            if (isExpand)
            {
                expandExpDiv(expWrap[i]);
            }
            else
            {
                collapseExpDiv(expWrap[i]);
            }
        }
    }
}

//切换到打印模式（如果enable 为false，则关闭打印模式）
function switchPrintLayout(word, enable) {
    if (enable) {
        expandExpDivAll();
        document.getElementById('eudicJStarView').style.display = 'none';
        document.getElementById('ONLINE_DICT_LIST').style.display = 'none';
        var titleHtml = '<div id="print_title"><center><b>' + word + '</b></center></div>';
        document.body.innerHTML = titleHtml + document.body.innerHTML;
    }
    else {
        document.getElementById('eudicJStarView').style.display = "block";
        document.getElementById('ONLINE_DICT_LIST').style.display = 'block';
        document.getElementById('print_title').remove();
    }
}
//function clearHighLight()
//{
//  document.execCommand("SelectAll");
//  document.designMode = 'on';
//  document.execCommand('backcolor', false, 'transparent');
//  document.designMode = 'off';
//  window.getSelection().removeAllRanges();
//}

function getElementTop(elem) {
    yPos = elem.offsetTop;
    tempEl = elem.offsetParent;

    while (tempEl != null) {
        yPos += tempEl.offsetTop;
        tempEl = tempEl.offsetParent;
    }

    return yPos;
}

function getElementLeft(elem) {
    xPos = elem.offsetLeft;
    tempEl = elem.offsetParent;

    while (tempEl != null) {
        xPos += tempEl.offsetLeft;
        tempEl = tempEl.offsetParent;
    }
    return xPos;
}
var gHighLightedElements;
var curHighlightId;

function highlight(rootnode, pattern, keepold) {
    if (!keepold) {
        removeHighlight();
    }
    curHighlightId = -1;
    gHighLightedElements = new Array;

    //highlight
    var nodelist = new Array();
    var upattern = pattern.toUpperCase();
    nodelist.push(rootnode);
    while (nodelist.length > 0) {
        var pos;
        var node = nodelist.shift();
        if (node.nodeType == 3) {
            pos = node.data.toUpperCase().indexOf(upattern);
            if (pos >= 0) {
                var spannode = document.createElement('span');
                spannode.className = 'highlight';
                m = node.splitText(pos);
                e = m.splitText(upattern.length);
                mclone = m.cloneNode(true);
                spannode.appendChild(mclone);
                m.parentNode.replaceChild(spannode, m);
                gHighLightedElements.push(spannode);
                nodelist.unshift(e);
            };
        } else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
            for (var i = node.childNodes.length - 1; i >= 0; i--) {
                nodelist.unshift(node.childNodes[i]);
            };
        }
    }
    return gHighLightedElements.length;
}

function removeHighlight() {
    var nodelist = document.getElementsByTagName('span');
    for (var i = nodelist.length - 1; i >= 0; i--) {
        var node = nodelist[i];
        if (node.className == 'highlight' || node.className == 'cur-highlight') {
            with(node.parentNode) {
                replaceChild(node.firstChild, node);
                normalize();
            }
        };
    };
}

function scrollToHighlight(step) {
    if (gHighLightedElements.length == 0)
        return;

    index = curHighlightId + step;

    if (index >= gHighLightedElements.length)
        index = 0;
    else if (index < 0)
        index = gHighLightedElements.length + index;

    var e = gHighLightedElements[index];
    makeVisible(e);
    e.scrollIntoView(true);
    window.scrollBy(0, -80);

    if (curHighlightId != -1)
        gHighLightedElements[curHighlightId].className = "highlight";
    setCurHighlight(e);
    curHighlightId = index;
}

function setCurHighlight(e) {
    e.className = "cur-highlight";
}

//确保要查询的节点是可见的
function makeVisible(e)
{
    if (e == document)
        return;

    var style = window.getComputedStyle(e);
    if (style.display == 'none') {
        e.style.display = 'block';
    }

    if (style.visibility == 'hidden') {
        e.style.visibility = 'visible';
    }
    makeVisible(e.parentNode);
}

function xreplace(checkMe, toberep, repwith) {
    var temp = checkMe;
    var i = temp.indexOf(toberep);
    while (i > -1) {
        temp = temp.replace(toberep, repwith);
        i = temp.indexOf(toberep, i + 1);
    }
    return temp;
}

function lazyExpandExpDiv(divName, scrollToSection)
{
    var thisDiv = document.getElementById(divName);
    expandExpDiv(thisDiv, scrollToSection, true);
    lazyloadScript(thisDiv);
}

function createNewScript(targetDom, script) {
    var newScript = document.createElement('script');
    newScript.type = "text/javascript";
    if(script.src) {
        newScript.src = script.getAttribute('src');
    } else {
        newScript.innerHTML = script.innerText;
    }
    targetDom.appendChild(newScript);
}

function lazyloadScript(targetDom) {
    var scripts = targetDom.getElementsByTagName('script');
    if(scripts.length > 0) {
        for(var i = 0, l = scripts.length; i < l; i++) {
            createNewScript(targetDom, scripts[i]);
        }
    }
}

var _eudic_node_count = 0;

function eu_click(word) {
    window.location.href = 'dic://' + word;
}

function eu_isAlpha(c) {
    if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c == '\'') || (c > 200 && c < 300)) {
        return true;
    } else {
        switch (c) {
            case 'ù':
            case 'ç':
            case 'œ':
            case 'æ':
            case 'à':
            case 'â':
            case 'ï':
            case 'é':
            case 'è':
            case 'ê':
            case 'ë':
            case 'î':
            case 'ô':
            case 'ö':
            case 'ü':
            case 'û':
            case 'ä':
            case 'ß':
            case '\'':
            case '’':
            case 'ñ':
            case 'á':
            case 'í':
            case 'ú':
            case 'ó':
                return true;
            default:
                return false;
        }
    }
}


function eu_processNode(node) {
    var parentNode = node.parentNode;
    if (!can_walkin(node)) return;

    var str = node.nodeValue.toLowerCase();
    if (str && str.length > 0) {
        var headPos = 0;
        while (headPos < str.length) {
            var tailPos = headPos;
            while (tailPos < str.length && !eu_isAlpha(str.charAt(tailPos))) tailPos++;

            if (tailPos > headPos) {
                parentNode.insertBefore(document.createTextNode(str.substr(headPos, tailPos - headPos)), node);
                headPos = tailPos;
            }

            while (tailPos < str.length && eu_isAlpha(str.charAt(tailPos))) tailPos++;

            if (tailPos > headPos) {
                var word = node.nodeValue.substr(headPos, tailPos - headPos);
                var link = document.createElement("EUDIC");
                link.appendChild(document.createTextNode(word));
                parentNode.insertBefore(link, node);
                headPos = tailPos;
            }
        }

        parentNode.removeChild(node);
    }
}

function eu_unWalk(parentNode) {
    var tagName = "eudic";
    _eudic_node_count = 0;
    var a = [];
    for (var i = 0; i < parentNode.childNodes.length; i++) {
        a.push(parentNode.childNodes[i]);
        if (parentNode.childNodes[i].childNodes != null)
        {
            eu_unWalk(parentNode.childNodes[i]);
        }
    }
    var t1 = [],
        t2 = [],
        meetFlag = false;
    for (var i = 0; i < a.length; i++) {
        if (a[i].nodeType == 3) {
            t1.push(a[i]);
            t2.push(a[i].nodeValue);
        } else if (a[i].nodeName.toLowerCase() == tagName) {
            t1.push(a[i]);
            t2.push(a[i].innerHTML);
        } else {
            if (t1.length > 0) {
                var par = t1[0].parentNode;
                try {
                    par.insertBefore(document.createTextNode(t2.join('')), t1[0]);

                    for (var j = 0; j < t1.length; j++) {
                        par.removeChild(t1[j]);
                    }
                } catch (e) {}
            }
            t1 = [];
            t2 = [];
            if (a[i].childNodes.length > 0) {
                revertMark(tagName, a[i]);
            }
        }
        if (i == a.length - 1 && t1.length) {
            var par = t1[0].parentNode;
            try {
                par.insertBefore(document.createTextNode(t2.join('')), t1[0]);
                for (var j = 0; j < t1.length; j++) {
                    par.removeChild(t1[j]);
                }
            } catch (e) {}
        }
    }
}

function revertMark(node){

}


function eu_walk(node) {
    if (node.childNodes.length == 0) {
        if (node.nodeType == 3) eu_processNode(node);
    } else if (node.onclick) {} else {
        node = node.firstChild;
        while (node) {
            if (_eudic_node_count++ >= 1000)
                return;

            var nextSibling = node.nextSibling;
            if (can_walkin(node)) {
                eu_walk(node);
            }
            node = nextSibling;
        }
    }
}

function can_walkin(node) {
    if (can_walkin_tag(node, 'a', true) && can_walkin_tag(node, 'button', true) && can_walkin_tag(node, 'eudic', false) && (!node.id || node.id != "headWord")) {
        return true
    }
    return false;
}

function can_walkin_tag(node, tag, searchParent) {
    if (node.nodeName.toLowerCase() == tag) {
        return false;
    }
    if (!searchParent) {
        return true;
    }
    var parentNode = node.parentNode;
    for (var i = 0; i < 5; i++) {
        if (parentNode == null) {
            break;
        }
        if (parentNode.nodeName.toLowerCase() == tag) {
            return false;
        }
        parentNode = parentNode.parentNode;
    }
    return true;
}

function setup_wiki() {
    $("#logo").click(function() {
        $("#nav").toggle();
    })

    $("h2.section_heading").click(function() {
        //var section_idx = parseInt($(this).get(0).id.replace( /section_(\d+)/, "$1" ));
        //wm_toggle_section( section_idx );
        wm_toggle_section($(this));
    })

    $("a").click(function() {
        var link = $(this).get(0)
        if (link.hash.indexOf("#") == 0) {
            wm_reveal_for_hash(link.hash)
        }
    })

    if (document.location.hash.indexOf("#") == 0) {
        wm_reveal_for_hash(document.location.hash)
    }

    updateOrientation();

    decode = $("#searchField");
    decode.val(unescape(decode.val()));
    decode = $("title");
    decode.html(unescape(decode.html()));
}


function wm_reveal_for_hash(hash) {
    var targetel = $(hash)
    if (targetel) {
        var parentdiv = targetel.parents("div.content_block")
        if (parentdiv.length > 0 && !parentdiv.is(':visible')) {
            var section_idx = parseInt(parentdiv.get(0).id.replace(/content_(\d+)/, "$1"));
            wm_toggle_section(section_idx)
        }
    }
}

function wm_toggle_section(section_item) {
    section_item.children("button.show").toggle();
    section_item.children("button.hide").toggle();

    section_item.next().toggle();
    section_item.next().next().toggle();
    //$("div#content_" + section_id).toggle()
    //$("div#anchor_" + section_id).toggle()
}

function rev_init() {
    document.getElementById("revBanner").style.opacity = 1;
    initTouchJump();
}

function rev_initWithExp() {
    rev_init();
    document.getElementById('revHideMainContent').style.display = 'none';
    document.getElementById('revMainContent').style.opacity = 1;
}

function rev_showexp() {
    document.getElementById('revHideMainContent').style.display = 'none';
    document.getElementById('revMainContent').style.opacity = 1;
    document.location = 'cmd://recite/showexp';
}

function rev_hideexp() {
    document.getElementById("revHideMainContent").style.display = "block";
    document.getElementById("revHideMainContent").style.opacity = 1;
    document.getElementById("revMainContent").style.opacity = 0;
}

function rev_showblock() {
    document.getElementById("revHideMainContent").style.opacity = 1;
}

function setStudyFlag(f, showTips) {
    var catel = document.getElementById('eudicStudyCatPicker');
    var eudicJStarView = document.getElementById('eudicJStarView');
    var outerdiv = document.getElementById('studyCategoryLp');
    var eudicJLevelChooseSuccessTips = document.getElementById('eudicJLevelChooseSuccessTips');
    if (f > 0) {
        catel.style.display = "inline-block";
        if(eudicJStarView) {
            eudicJStarView.style.display = 'block';
        }
        if (outerdiv != null) outerdiv.style.display = "block";
    } else {
        catel.style.display = "none";
        if(eudicJStarView) {
            eudicJStarView.style.display = 'none';
        }
        if (outerdiv != null) outerdiv.style.display = "none";
    }
    if(eudicJLevelChooseSuccessTips && showTips && f > 0) {
        eudicJLevelChooseSuccessTips.style.display = 'block';
        setTimeout(function() {
            eudicJLevelChooseSuccessTips.style.display = 'none';
        }, 500);
    }
    for (i = 1; i <= 5; i++) {
        var starel = document.getElementById('eudicStudyPicker' + i);
        if (i <= f) {
            starel.className = 'eudicStudyPicker active';
        } else {
            starel.className = 'eudicStudyPicker';
        }
    }
}

function loginfo(info) {
    var el = document.getElementById('eudicLoginfo');
    el.innerText = el.innerText + " " + info;
}

function log(text) {
    var log = document.getElementById('log');
    if (!log) {
        log = document.createElement('div');
        log.id = 'log';
        log.style.backgroundColor = '#ccc';
        log.style.position = 'fixed';
        log.style.left = '1px';
        log.style.top = '120px';
        log.style.zIndex = '30';
        document.body.appendChild(log)
    };
    log.innerHTML = log.innerHTML + text + '<br/>'
}

function hpath(node, currentPath) {
    currentPath = currentPath || '';
    if (node.className == 'explain_wrap' || node.className == 'explain_wrap_styleless') return '//DIV[@id=\"' + node.id + '\"]/' + currentPath;
    switch (node.nodeType) {
        case 3:
        case 4:
            return hpath(node.parentNode, 'text()[' + (document.evaluate('preceding-sibling::text()', node, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null).snapshotLength + 1) + ']');
        case 1:
            return hpath(node.parentNode, node.nodeName + '[' + (document.evaluate('preceding-sibling::' + node.nodeName, node, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null).snapshotLength + 1) + ']' + (currentPath ? '/' + currentPath : ''));
        case 9:
            return '/' + currentPath;
        default:
            return '';
    }
}

function highlightRange() {
    var selection = document.getSelection();
    var range = selection.getRangeAt(0);
    if (range) {
        var start = range.startOffset,
            end = range.endOffset;
        var selTxt = hpath(range.startContainer) + '|' + start + '|' + hpath(range.endContainer) + '|' + end + '|' + '#FFFF00';
        document.designMode = 'on';
        document.execCommand('backcolor', false, '#FFFF00');
        document.designMode = 'off';
        selection.removeAllRanges();
        range.detach();
        window.location.href = 'cmd://highLightRange?' + selTxt;
    }
}

function restoreHighlightRange(highlightRange) {
    if (highlightRange) {
        highlightRange = highlightRange.split('$');
        document.designMode = 'on';
        for (var i = 0, l = highlightRange.length; i < l; i++) {
            var selectionDetails = highlightRange[i].split('|');
            if (typeof document.getSelection != 'undefined' && selectionDetails.length > 3) {
                var selection = document.getSelection();
                selection.removeAllRanges();
                try {
                    var range = document.createRange();
                    range.setStart(document.evaluate(selectionDetails[0], document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue, Number(selectionDetails[1]));
                    range.setEnd(document.evaluate(selectionDetails[2], document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue, Number(selectionDetails[3]));
                    selection.addRange(range);
                    document.execCommand('backcolor', false, selectionDetails[4]);
                    selection.removeAllRanges();
                } catch (e) {}
            }
        }
    }
    document.designMode = 'off';
}

function processWikiDict() {
 /* 图片点击方法 */
    var lang = document.getElementsByClassName("wiki-content");
    for (var j = 0; j < lang.length; j++) {
        var imgLangNow = lang[j].getElementsByClassName('image-wrap');
        if (imgLangNow) {
            for (var idx = 0, len = imgLangNow.length; idx < len ; idx++) {
                var eachImg = imgLangNow[idx].getElementsByTagName('img')[0];
                eachImg.setAttribute('lang', lang[j].getAttribute('lang'));
                eachImg.onclick = function (ev) {
                    var imgSrc = this.getAttribute('src');
                    var thislang = this.getAttribute('lang');
                    var imgName = imgSrc.substring(imgSrc.lastIndexOf('/') + 1);
                    window.location.href = 'cmd://wiki/image/' + thislang + "/" + imgName;
                }
            }
        }
    }
}

function getWikiDictImg() {
 /* 图片列表方法 */
    var imgList = [];
    var lang = document.getElementsByClassName("wiki-content");
    for (var j = 0; j < lang.length; j++) {
        var imgLangNow = lang[j].getElementsByClassName('image-wrap');
        if (imgLangNow) {
            for (var i = 0, len = imgLangNow.length; i < len ; i++) {
                var imginfo = {};
                var imgAlt = '';
                var eachImg = imgLangNow[i].getElementsByTagName('img')[0];
                var imgSrc = eachImg.getAttribute('src');
                if (eachImg.getAttribute('alt')) {
                    imgAlt = eachImg.getAttribute('alt');
                } else {
                    imgAlt = '';
                }
                var imgName = imgSrc.substring(imgSrc.lastIndexOf('/') + 1);
                imginfo['cmd'] = "cmd://wiki/image/" + lang[j].getAttribute('lang') + "/" + imgName;
                imginfo['imgurl'] = imgSrc;
                imginfo['imgAlt'] = imgAlt;
                imgList.push(imginfo);
            }
        }
    }
    return JSON.stringify(imgList);
}